/*
 * Decompiled with CFR 0.152.
 */
package oracle.arbori.util;

import java.text.MessageFormat;
import java.util.List;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;

public interface DbObjNames {
    public static String handleMixedCase(String name) {
        return DbObjNames.handleMixedCase(name, true);
    }

    public static String handleMixedCase(String name, boolean unquote) {
        if (name == null) {
            return null;
        }
        List<LexerToken> out = Lexer.parse(name, true);
        StringBuilder ret = new StringBuilder();
        for (LexerToken t : out) {
            String s = t.content;
            if (t.type == Token.DQUOTED_STRING) {
                if (unquote && 1 < s.length()) {
                    s = s.substring(1, s.length() - 1);
                }
            } else {
                s = s.toUpperCase();
            }
            ret.append(s);
        }
        return ret.toString();
    }

    public static String addDoubleQuote(String s) {
        return DbObjNames.quoteIdentifier(s, '\"');
    }

    public static String quoteIdentifier(String s, char quoteChar) {
        String quoteString = String.valueOf(quoteChar);
        if (s == null) {
            return null;
        }
        boolean quote = false;
        String legitimateChars = "$#_";
        if (!s.startsWith(quoteString) && !quote) {
            char[] chars = new char[s.length()];
            s.getChars(0, chars.length, chars, 0);
            if (chars.length > 0 && '0' <= chars[0] && chars[0] <= '9') {
                quote = true;
            } else {
                for (char c : chars) {
                    if (legitimateChars.indexOf(c) >= 0 || c >= '0' && ('9' >= c || c >= 'A') && 'Z' >= c) continue;
                    quote = true;
                    break;
                }
            }
        }
        if (s.startsWith("_") || s.startsWith("$") || s.startsWith("#")) {
            quote = true;
        }
        return quote ? MessageFormat.format("{0}{1}{0}", quoteString, s) : s;
    }

    public static String shortenIdentifier(String id, List<String> uniqueIds, int idSize) {
        if (uniqueIds == null) {
            if (id.length() <= idSize) {
                return id;
            }
            return id.substring(0, idSize);
        }
        String candiId = id;
        Object newId = id;
        int suffix = 1;
        if (id.length() <= idSize) {
            if (!uniqueIds.contains(id)) {
                uniqueIds.add(id);
                return id;
            }
            while (((String)newId).length() <= idSize) {
                if (uniqueIds.contains(newId = candiId + ++suffix)) continue;
                uniqueIds.add((String)newId);
                return newId;
            }
        } else {
            newId = candiId.substring(0, idSize);
            if (!uniqueIds.contains(newId)) {
                uniqueIds.add((String)newId);
                return newId;
            }
        }
        while (Integer.toString(suffix).length() <= idSize) {
            newId = candiId.substring(0, idSize - Integer.toString(++suffix).length());
            if (uniqueIds.contains(newId = (String)newId + suffix)) continue;
            uniqueIds.add((String)newId);
            return newId;
        }
        return id;
    }

    public static enum CLEAN_TYPE {
        OFF,
        TRANSFORM30,
        TRANSFORM128,
        QUOTE30,
        QUOTE128,
        UNIQUE;

    }
}

