/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client.pki;

import com.oracle.bmc.http.client.pki.OpenSslPbeSecretKeyGenerator;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

class OpenSslPbeSecretKeyFactory {
    private final MessageDigest digest;

    OpenSslPbeSecretKeyFactory() {
        this(OpenSslPbeSecretKeyFactory.digest("MD5"));
    }

    OpenSslPbeSecretKeyFactory(MessageDigest digest) {
        this.digest = digest;
    }

    private static MessageDigest digest(String algorithmName) {
        try {
            return MessageDigest.getInstance(algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    Key generateSecret(PBEKeySpec pbeSpec) throws InvalidKeySpecException {
        OpenSslPbeSecretKeyGenerator generator = OpenSslPbeSecretKeyGenerator.builder().password(pbeSpec.getPassword()).salt(pbeSpec.getSalt()).keyLength(pbeSpec.getKeyLength()).build();
        byte[] keyBytes = generator.generate();
        return new SecretKeySpec(keyBytes, "OpenSSLPBKDF");
    }
}

