/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.awrash.command;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.function.BiConsumer;
import oracle.dbtools.extension.awrash.command.Mode;
import oracle.dbtools.extension.awrash.core.AWREngine;
import oracle.dbtools.extension.awrash.exception.NoPrivilegesAvailableException;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Node;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.TransformContext;

public class CreateReportAction
implements BiConsumer<ScriptRunnerContext, Connection> {
    private final Mode mode;
    private final String beginSnapId;
    private final String endSnapId;

    CreateReportAction(Node rawValue, TransformContext context, Environment environment) {
        boolean MODE_INDEX = true;
        int BEGIN_SNAP_ID_INDEX = 2;
        int END_SNAP_ID_INDEX = 3;
        this.mode = this.extractMode(rawValue, 1);
        this.beginSnapId = this.extractValue(rawValue, 2);
        this.endSnapId = this.extractValue(rawValue, 3);
    }

    @Override
    public void accept(ScriptRunnerContext context, Connection connection) {
        AWREngine awrEngine = new AWREngine(context, connection);
        try {
            awrEngine.createReport(this.beginSnapId, this.endSnapId, this.mode);
        }
        catch (IllegalArgumentException | SQLException | NoPrivilegesAvailableException e) {
            context.writeln(e.getMessage());
        }
    }

    private Mode extractMode(Node rawValue, int index) {
        String modeValue = this.extractValue(rawValue, index);
        if (null != modeValue) {
            try {
                return Mode.valueOf(modeValue.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return Mode.HTML;
    }

    private String extractValue(Node rawValue, int index) {
        List childNodes = rawValue.getChildNodes();
        if (index < childNodes.size()) {
            List list;
            Object value = ((Node)childNodes.get(index)).getValue();
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof List && !(list = (List)value).isEmpty() && list.get(0) instanceof String) {
                return (String)list.get(0);
            }
        }
        return null;
    }
}

