/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.diff;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.arbori.util.Service;
import oracle.dbtools.extension.project.diff.ColProperties;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;

public abstract class ParseDiff {
    public Map<String, String> add = new TreeMap<String, String>();
    public Map<String, String> modify = new TreeMap<String, String>();
    public List<String> delete = new LinkedList<String>();
    public Map<String, String> rename = new TreeMap<String, String>();

    public ParseDiff(List<ParseNode> dl1, Parsed t1, List<ParseNode> dl2, Parsed t2) {
        int i1 = 0;
        int i2 = 0;
        while (i1 < dl1.size() && i2 < dl2.size()) {
            ColProperties cp2;
            String def2;
            String def1 = t1.content(dl1.get(i1));
            if (LexerToken.equals((String)def1, (String)(def2 = t2.content(dl2.get(i2))))) {
                ++i1;
                ++i2;
                continue;
            }
            ColProperties cp1 = new ColProperties(t1, dl1.get(i1));
            if (ColProperties.sameName(cp1, cp2 = new ColProperties(t2, dl2.get(i2)))) {
                if (cp1.type != null && (cp1.type.contains("ANSI_supported_datatypes") || cp1.type.contains("Oracle_built_in_datatypes"))) {
                    this.modify.put(((LexerToken)t1.getSrc().get((int)(dl1.get((int)i1).from + this.nameIndex()))).content, new ColProperties(t2, dl2.get(i2)).reduce(cp1));
                } else {
                    this.addDelete(dl1, t1, dl2, t2, i1, i2, i1 + 1, i2 + 1);
                }
                ++i1;
                ++i2;
                continue;
            }
            if (ColProperties.sameType(cp1, cp2) && ColProperties.sameConstraint(cp1, cp2)) {
                this.rename.put(((LexerToken)t1.getSrc().get((int)(dl1.get((int)i1).from + this.nameIndex()))).content, ((LexerToken)t2.getSrc().get((int)(dl2.get((int)i2).from + this.nameIndex()))).content);
                ++i1;
                ++i2;
                continue;
            }
            long xy = this.match(dl1, t1, dl2, t2, i1, i2);
            if (xy < 0L) break;
            int j1 = Service.lX((long)xy);
            int j2 = Service.lY((long)xy);
            this.addDelete(dl1, t1, dl2, t2, i1, i2, j1, j2);
            i1 = j1;
            i2 = j2;
        }
        this.addDelete(dl1, t1, dl2, t2, i1, i2, dl1.size(), dl2.size());
    }

    void addDelete(List<ParseNode> dl1, Parsed t1, List<ParseNode> dl2, Parsed t2, int i1, int i2, int j1, int j2) {
        int i;
        for (i = i1; i < j1; ++i) {
            this.delete.add(((LexerToken)t1.getSrc().get((int)(dl1.get((int)i).from + this.nameIndex()))).content);
        }
        for (i = i2; i < j2; ++i) {
            ColProperties cp1 = null;
            if (i1 < dl1.size()) {
                cp1 = new ColProperties(t1, dl1.get(i1));
            }
            this.add.put(((LexerToken)t2.getSrc().get((int)(dl2.get((int)i).from + this.nameIndex()))).content, new ColProperties(t2, dl2.get(i)).reduce(cp1));
        }
    }

    long match(List<ParseNode> dl1, Parsed t1, List<ParseNode> dl2, Parsed t2, int i1, int i2) {
        int si2 = i2;
        while (i1 < dl1.size() && i2 < dl2.size()) {
            ColProperties cp2;
            String def2;
            String def1 = t1.content(dl1.get(i1));
            if (LexerToken.equals((String)def1, (String)(def2 = t2.content(dl2.get(i2))))) {
                return Service.lPair((int)i1, (int)i2);
            }
            ColProperties cp1 = new ColProperties(t1, dl1.get(i1));
            if (ColProperties.sameType(cp1, cp2 = new ColProperties(t2, dl2.get(i2))) && ColProperties.sameConstraint(cp1, cp2)) {
                return Service.lPair((int)i1, (int)i2);
            }
            if (ColProperties.sameName(cp1, cp2)) {
                return Service.lPair((int)i1, (int)i2);
            }
            if (++i2 != dl2.size()) continue;
            i2 = si2;
            ++i1;
        }
        return -1L;
    }

    public abstract int nameIndex();
}

