/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.utils;

import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.core.connections.ConnectionIdentifiers;
import oracle.dbtools.core.connections.api.Connections;
import oracle.dbtools.core.connections.storage.ConnectionDefinition;
import oracle.dbtools.core.connections.storage.ConnectionStorage;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Property;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.PropertyValues;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.NamedConnectionProperty;

public class NamedConnections {
    static ConnectionStorage fileSystem = ConnectionStorage.instance();
    private static final Map<String, Connections.Identifier> names = new HashMap<String, Connections.Identifier>();
    private static final Map<Connections.Identifier, ConnectionDefinition> connectionDefinitions = new HashMap<Connections.Identifier, ConnectionDefinition>();

    public static Map<String, Connections.Identifier> listNamedConnections() {
        fileSystem.listConnectionDirectories().forEach(id -> NamedConnections.loadConnection(id, fileSystem));
        return names;
    }

    public static String getCurrentConnectionName() {
        ConnectionContext connectionContext = (ConnectionContext)ProjectConfig.getCurrentContext().getService(ConnectionContext.class);
        PropertyValues propertyValues = connectionContext.getCurrentPropertyValues();
        return (String)propertyValues.getValueOf((Property)NamedConnectionProperty.NAME);
    }

    private static void loadConnection(String identifier, ConnectionStorage fileSystem) {
        Connections.Identifier ci = ConnectionIdentifiers.createIdentifier((CharSequence)identifier);
        ConnectionDefinition def = fileSystem.loadConnection(identifier);
        connectionDefinitions.put(ci, def);
        String connName = def.getConnectionName();
        names.put(connName, ci);
    }
}

