/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.export;

import java.nio.file.Path;
import java.sql.Connection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import oracle.dbtools.extension.project.commands.Interfaces.CommandInterface;
import oracle.dbtools.extension.project.commands.ProjectMessages;
import oracle.dbtools.extension.project.commands.export.Export;
import oracle.dbtools.extension.project.commands.export.ExportMessages;
import oracle.dbtools.extension.project.commands.export.Report;
import oracle.dbtools.extension.project.commands.handler.ProjectOptions;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.messages.GeneralMessages;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.extension.project.core.utils.ProjectUtils;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.util.SpinningWheel;
import oracle.jdbc.OracleDatabaseException;

public class ExportCommand
implements CommandInterface {
    private final boolean debug = false;
    private final boolean traceQueries = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand parsedCommand) {
        try {
            ProjectConfig.setupDebugVerbose(parsedCommand);
            Path root = ProjectUtils.getProjectRootFolder();
            if (root == null) {
                Report.writeln(ctx, ExportMessages.getString("EXPORT_PROJECT_NOT_IDENTIFIED"));
                return;
            }
            boolean priorIsInteruptible = ctx.isInterruptible();
            ctx.setInterruptible(true);
            List objects = Objects.requireNonNullElse((LinkedList)parsedCommand.getOptionValue((Id)ProjectOptions.Options.OBJECTS), new LinkedList());
            List schemas = Objects.requireNonNullElse((LinkedList)parsedCommand.getOptionValue((Id)ProjectOptions.Options.SCHEMAS), new LinkedList());
            Integer threads = Objects.requireNonNullElse((Integer)parsedCommand.getOptionValue((Id)ProjectOptions.Options.THREADS), 5);
            boolean list = parsedCommand.isFlagSet((Id)ProjectOptions.Options.LIST);
            GeneralMessages.debugMessage(ProjectMessages.format("PROJECT_EXPORT", list, objects, schemas, threads, ProjectConfig.isDebug(), ProjectConfig.isVerbose()));
            ctx.getOutputStream().flush();
            new Export(ctx, schemas, objects, threads, list).export();
        }
        catch (Throwable t) {
            Throwable cause = t.getCause();
            if (cause instanceof OracleDatabaseException) {
                OracleDatabaseException ode = (OracleDatabaseException)cause;
                String message = "*** Failed to run " + ode.getSql() + "\n";
                String msg = ode.getMessage();
                int nlPos = msg.indexOf("\n");
                if (0 < nlPos) {
                    msg = msg.substring(0, nlPos);
                }
                message = message + "*** " + msg;
                Report.error(ctx, message);
            } else {
                Report.error(ctx, t, "");
            }
        }
        finally {
            SpinningWheel.stop();
            try {
                ctx.getOutputStream().flush();
            }
            catch (Exception exception) {}
            try {
                Thread.sleep(SpinningWheel.step);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static boolean isRdbmsDiffProject() {
        List<String> configSchemas = ProjectSettings.getSettingAsList("schemas");
        return configSchemas.contains("SYS$UMF");
    }
}

