/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.export;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import oracle.arbori.util.DbObjNames;
import oracle.arbori.util.DictionaryViews;
import oracle.arbori.util.Pair;
import oracle.dbtools.app.SqlRecognizer;
import oracle.dbtools.extension.project.commands.export.DbmsMetadata;
import oracle.dbtools.extension.project.commands.export.Filters;
import oracle.dbtools.extension.project.commands.export.TransitiveClosure;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.messages.GeneralMessages;
import org.apache.commons.io.FileUtils;

public class DbObj
implements Comparable {
    private static final String MATERIALIZED_VIEW = "MATERIALIZED_VIEW";
    String owner;
    String name;
    String type;
    String line;
    String fileName = null;

    public DbObj(String owner, String name, String type) {
        this(owner, name, type, null);
    }

    public DbObj(String owner, String name, String type, String line) {
        this.owner = DbObjNames.handleMixedCase((String)owner);
        this.name = DbObjNames.handleMixedCase((String)name);
        if (line == null) {
            this.owner = owner;
            this.name = name;
        }
        if ("OBJECT_GRANTS_AS_GRANTOR".equals(this.name) && line != null) {
            String object_grants = "/object_grants/";
            int from = line.indexOf("/object_grants/" + "/object_grants/".length());
            int to = line.indexOf(".sql", from);
            if (0 < from && 0 < to && to < line.length()) {
                this.name = line.substring(from, to).toUpperCase();
            }
        }
        this.type = type.toUpperCase();
        this.line = line;
        this.fileName = this.name;
    }

    public static List<DbObj> order(Map<DbObj, String> input, Connection conn) throws Exception {
        List<DbObj> all = DbObj.order(input.keySet(), conn);
        LinkedList<DbObj> create = new LinkedList<DbObj>();
        LinkedList<DbObj> drop = new LinkedList<DbObj>();
        LinkedList<DbObj> alter = new LinkedList<DbObj>();
        for (DbObj obj : all) {
            if (input.get(obj).equalsIgnoreCase("create")) {
                create.add(obj);
                continue;
            }
            if (input.get(obj).equalsIgnoreCase("drop")) {
                drop.add(obj);
                continue;
            }
            alter.add(obj);
        }
        LinkedList<DbObj> ret = new LinkedList<DbObj>();
        Iterator iterator = drop.descendingIterator();
        while (iterator.hasNext()) {
            ret.add((DbObj)iterator.next());
        }
        ret.addAll(create);
        ret.addAll(alter);
        return ret;
    }

    public static List<DbObj> order(Collection<DbObj> input, Connection conn) throws Exception {
        List<DbObj> sorted = DbObj.sort(input);
        LinkedList<DbObj> ret = new LinkedList<DbObj>();
        HashSet<String> schemas = new HashSet<String>();
        for (DbObj obj : sorted) {
            if ("OBJECT_GRANT".equals(obj.type)) continue;
            schemas.add(obj.owner);
        }
        Object query = "select * from (SELECT OWNER          ,\nNAME                       ,\nTYPE                       ,\nREFERENCED_OWNER           ,\nREFERENCED_NAME            ,\nREFERENCED_TYPE            ,\nREFERENCED_LINK_NAME       ,\nDEPENDENCY_TYPE            ,\n'ALL_DEPENDENCIES' EXPORT_TYPE from sys.all_dependencies) all_dependencies \n";
        HashMap<String, String> tmpFilters = new HashMap<String, String>();
        List<String> cs = Filters.addSchemas(schemas);
        for (String filter : cs) {
            tmpFilters.put(filter, " object owners");
        }
        query = Filters.apply((String)query, tmpFilters);
        query = new DictionaryViews(conn).translate((String)query);
        GeneralMessages.debugMessage("/* Query ALL_DEPENDENCIES: */\n" + (String)query);
        LinkedList<Pair<DbObj, DbObj>> links = new LinkedList<Pair<DbObj, DbObj>>();
        if (((String)query).indexOf("owner") < 0) {
            query = (String)query + " and owner = '" + conn.getSchema().toUpperCase() + "' -- current connection \n";
        }
        long t1 = System.currentTimeMillis();
        if (conn.isValid(5000) && !conn.isClosed()) {
            try (Statement stmt = conn.createStatement();
                 Iterator<DbObj> rs = stmt.executeQuery((String)query);){
                GeneralMessages.debugMessage("Elapsed = " + (System.currentTimeMillis() - t1) / 1000L + "s");
                while (rs.next()) {
                    String rName = rs.getString("REFERENCED_NAME");
                    String name = rs.getString("NAME");
                    String rOwner = rs.getString("REFERENCED_OWNER");
                    String owner = rs.getString("OWNER");
                    String rType = DbmsMetadata.toMetadataTypeName(rs.getString("REFERENCED_TYPE"));
                    String type = DbmsMetadata.toMetadataTypeName(rs.getString("TYPE"));
                    DbObj rObj = new DbObj(rOwner, rName, rType);
                    DbObj obj = new DbObj(owner, name, type);
                    if (name.equals(rName) && owner.equals(rOwner) && MATERIALIZED_VIEW.equals(type) && "TABLE".equals(rType)) continue;
                    if ("TABLE".equals(rType) && DbObj.isMV(sorted, rOwner, rName)) {
                        rObj = new DbObj(rOwner, rName, MATERIALIZED_VIEW);
                    }
                    links.add((Pair<DbObj, DbObj>)new Pair((Object)rObj, (Object)obj));
                }
            }
        }
        LinkedList<DbObj> remove = new LinkedList<DbObj>();
        for (DbObj o : sorted) {
            if (!"OBJECT_GRANT".equals(o.type)) continue;
            String OWNER = o.owner;
            String TYPE = "GRANT";
            String NAME = o.name;
            int i = o.name.indexOf(".") + 1;
            int j = o.name.indexOf(".", i);
            if (0 < i && 0 < j) {
                OWNER = o.name.substring(i, j);
                i = o.name.indexOf(".", j) + 1;
                j = o.name.indexOf(".", i);
                TYPE = o.name.substring(i, j);
                i = o.name.indexOf(".", j) + 1;
                NAME = o.name.substring(i);
            }
            if (input.contains(new DbObj(OWNER, NAME, TYPE))) continue;
            ret.add(o);
            remove.add(o);
        }
        for (DbObj o : sorted) {
            if (!"SEQUENCE".equals(o.type)) continue;
            ret.add(o);
            remove.add(o);
        }
        sorted.removeAll(remove);
        TransitiveClosure order = TransitiveClosure.getInstance(links);
        for (DbObj o : order.order()) {
            String line = DbObj.getLineFromDbObj(sorted, o.name, o.owner, o.type);
            DbObj obj = new DbObj(o.owner, o.name, o.type, line);
            if (!sorted.contains(obj)) continue;
            ret.add(obj);
            sorted.remove(obj);
        }
        remove = new LinkedList();
        for (DbObj o : sorted) {
            if (!"TABLE".equals(o.type)) continue;
            ret.add(o);
            remove.add(o);
        }
        for (DbObj o : sorted) {
            if (!"COMMENT".equals(o.type)) continue;
            ret.add(o);
            remove.add(o);
        }
        for (DbObj o : sorted) {
            if (!MATERIALIZED_VIEW.equals(o.type)) continue;
            ret.add(o);
            remove.add(o);
        }
        for (DbObj o : sorted) {
            if (!"MATERIALIZED_VIEW_LOG".equals(o.type)) continue;
            boolean handled = false;
            Path projectRoot = ProjectConfig.getCurrentWorkingProjectRoot();
            if (projectRoot == null) {
                projectRoot = Path.of(System.getProperty("user.dir"), new String[0]);
            }
            Path databasePath = Paths.get(projectRoot.toString(), "src", "database");
            String currSchema = ProjectConfig.getCurrentContext().getCurrentConnection().getSchema();
            Path mvLogPath = Paths.get(databasePath.toString(), currSchema.toLowerCase(), "materialized_view_logs", o.name.toLowerCase() + ".sql");
            if (mvLogPath.toFile().exists()) {
                String mvLogContent = FileUtils.readFileToString((File)mvLogPath.toFile(), (Charset)StandardCharsets.UTF_8);
                String masterObj = (String)new SqlRecognizer(mvLogContent).getReferencedTypes().get(0);
                for (int i = 0; i < ret.size(); ++i) {
                    if (!((DbObj)ret.get((int)i)).name.equals(masterObj.toUpperCase())) continue;
                    ret.add(i + 1, o);
                    remove.add(o);
                    handled = true;
                    break;
                }
            }
            if (handled) continue;
            ret.add(o);
            remove.add(o);
        }
        for (DbObj o : sorted) {
            if (!"INDEX".equals(o.type)) continue;
            ret.add(o);
            remove.add(o);
        }
        for (DbObj o : sorted) {
            if (!"PACKAGE_SPEC".equals(o.type)) continue;
            ret.add(o);
            remove.add(o);
        }
        for (DbObj o : sorted) {
            if (!"TYPE_SPEC".equals(o.type)) continue;
            ret.add(o);
            remove.add(o);
        }
        for (DbObj o : sorted) {
            if (!"SYNONYM".equals(o.type)) continue;
            ret.add(o);
            remove.add(o);
        }
        for (DbObj o : sorted) {
            if (!"AQ_QUEUE_TABLE".equals(o.type)) continue;
            ret.add(o);
            remove.add(o);
        }
        sorted.removeAll(remove);
        ret.addAll(sorted);
        return ret;
    }

    public static List<DbObj> sort(Collection<DbObj> input) {
        LinkedList<DbObj> ret = new LinkedList<DbObj>(input);
        ret.sort(new Comparator<DbObj>(){

            @Override
            public int compare(DbObj s1, DbObj s2) {
                return s1.compareTo(s2);
            }
        });
        return ret;
    }

    private static boolean isMV(List<DbObj> input, String rOwner, String rName) {
        for (DbObj o : input) {
            if (!o.name.equals(rName) || !o.owner.equals(rOwner) || !o.type.equals(MATERIALIZED_VIEW)) continue;
            return true;
        }
        return false;
    }

    private static String getLineFromDbObj(List<DbObj> input, String name, String owner, String type) {
        for (DbObj obj : input) {
            if (!obj.name.equals(name) || !obj.owner.equals(owner) || !obj.type.equals(type)) continue;
            return obj.line;
        }
        return null;
    }

    public static String qualifiedName(String owner, String name, String type) {
        return new DbObj(owner, name, type).toString();
    }

    public String toString() {
        return this.type + "  " + this.owner + "." + this.name;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public int compareTo(Object o) {
        DbObj cmp = (DbObj)o;
        String owner1 = this.owner;
        String type1 = this.type;
        String name1 = this.name;
        String owner2 = cmp.owner;
        String type2 = cmp.type;
        String name2 = cmp.name;
        if ("OBJECT_GRANT".equals(type1) && !"OBJECT_GRANT".equals(type2)) {
            return 1;
        }
        if (!"OBJECT_GRANT".equals(type1) && "OBJECT_GRANT".equals(type2)) {
            return -1;
        }
        int ret = owner1.compareTo(owner2);
        if (ret != 0) {
            return ret;
        }
        ret = type1.compareTo(type2);
        if (ret != 0) {
            return ret;
        }
        return name1.compareTo(name2);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static void main(String[] args) throws Exception {
        Connection conn = DriverManager.getConnection("jdbc:oracle:thin:@dbtools-dev.oraclecorp.com:2323/DB23P", "export_test", "oracle");
        HashMap<DbObj, String> input = new HashMap<DbObj, String>();
        input.put(new DbObj("EXPORT_TEST", "PURE_ENV", "MLE_ENV"), "drop");
        input.put(new DbObj("EXPORT_TEST", "HELLOWORLD", "PROCEDURE"), "drop");
        input.put(new DbObj("EXPORT_TEST", "PURE_MOD", "MLE_MODULE"), "drop");
        System.out.println(DbObj.order(input, conn));
    }

    @Generated
    public String getOwner() {
        return this.owner;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getLine() {
        return this.line;
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setLine(String line) {
        this.line = line;
    }

    @Generated
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

