/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.export;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.extension.project.commands.export.Export;
import oracle.dbtools.extension.project.commands.export.Filters;
import oracle.dbtools.extension.project.commands.export.Report;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.util.SpinningWheel;

public class DDL {
    String query;
    Export export;
    ScriptRunnerContext ctx;

    public DDL(String query, Export export) {
        this.query = query;
        this.export = export;
        this.ctx = export.ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> generate(String type, Map<String, String> ret, Set<String> tables) throws Exception {
        if (ret == null) {
            ret = new HashMap<String, String>();
        }
        ScriptExecutor sqlcl = (ScriptExecutor)this.ctx.getProperty("runner");
        this.query = Filters.apply(this.query, this.export.filters);
        this.query = this.export.dictViews.translate(this.query);
        Report.debug(this.ctx, "\n" + this.query);
        long t1 = System.currentTimeMillis();
        SpinningWheel.start((ScriptRunnerContext)this.ctx);
        boolean firstRow = true;
        try (Statement stmt = this.ctx.getCurrentConnection().createStatement();
             ResultSet rs = stmt.executeQuery(this.query);){
            while (rs.next()) {
                if (sqlcl != null && sqlcl.getInterrupted()) {
                    this.export.cancelExport();
                    Map<String, String> map = null;
                    return map;
                }
                String owner = rs.getString("owner");
                String name = rs.getString("name");
                String qualifiedName = owner + "." + name;
                if (tables != null && !tables.contains(qualifiedName)) continue;
                String ddl = rs.getString("ddl");
                if (type != null) {
                    Report.verbose(this.ctx, qualifiedName);
                }
                if (this.export.listOnly && !ProjectConfig.isVerbose()) {
                    Report cfr_ignored_0 = this.export.report;
                    Report.writeln(this.ctx, qualifiedName);
                    continue;
                }
                Object tmp = ret.get(qualifiedName);
                if (tmp == null) {
                    tmp = "";
                }
                tmp = (String)tmp + ddl + "\n";
                ret.put(qualifiedName, (String)tmp);
            }
        }
        finally {
            Report.debug(this.ctx, "Elapsed = " + (System.currentTimeMillis() - t1) / 1000L + "s");
        }
        return ret;
    }
}

