/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.config;

import com.google.common.base.Throwables;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.extension.project.commands.Interfaces.CommandInterface;
import oracle.dbtools.extension.project.commands.ProjectMessages;
import oracle.dbtools.extension.project.commands.handler.ProjectOptions;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.exceptions.ProjectExistsException;
import oracle.dbtools.extension.project.core.messages.GeneralMessages;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.extension.project.core.settings.Settings;
import oracle.dbtools.extension.project.core.utils.ProjectUtils;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ConfigCommand
implements CommandInterface {
    @Override
    public void run(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand parsedCommand) {
        ProjectConfig.setupDebugVerbose(parsedCommand);
        boolean list = parsedCommand.isFlagSet((Id)ProjectOptions.Options.LIST);
        String name = (String)parsedCommand.getOptionValue((Id)ProjectOptions.Options.NAME);
        boolean verbose = parsedCommand.isFlagSet((Id)ProjectOptions.Options.VERBOSE);
        try {
            ProjectUtils.getProjectRootFolder();
            LinkedHashMap<String, Object> publicSettings = new LinkedHashMap<String, Object>(ProjectSettings.getUserConfigMap());
            if (list) {
                if (name != null) {
                    LinkedHashMap<String, Object> matchingSettings = ProjectUtils.getMatchingSettings(new LinkedList<String>(publicSettings.keySet()), name);
                    if (!matchingSettings.isEmpty()) {
                        this.printSettings(matchingSettings, verbose);
                    } else {
                        ProjectConfig.getCurrentContext().writeln("No matching settings for " + name);
                    }
                } else {
                    this.printSettings(publicSettings, verbose);
                }
            }
        }
        catch (ProjectExistsException e) {
            GeneralMessages.errorMessage(ProjectMessages.format("PROJECT_ERROR", e.getLocalizedMessage()));
            GeneralMessages.debugMessage(Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    private void printSettings(LinkedHashMap<String, Object> settings, boolean verbose) {
        try {
            ArrayList<String> header = new ArrayList<String>();
            header.add("SETTING NAME");
            header.add("VALUE");
            if (verbose) {
                header.add("DEFAULT VALUE");
                header.add("DESCRIPTION");
            }
            ArrayList<List<String>> table = new ArrayList<List<String>>();
            table.add(header);
            settings.forEach((k, v) -> {
                Settings set;
                ArrayList<String> row = new ArrayList<String>();
                row.add((String)k);
                if (v == null) {
                    row.add("");
                } else {
                    row.add(v.toString());
                }
                if (verbose && (set = ProjectSettings.getSystemConfigMap().get(k)) != null) {
                    row.add(set.getDefaultVal());
                    row.add(set.getDescription());
                }
                table.add(row);
            });
            ProjectUtils.printTable(table);
        }
        catch (Exception e) {
            ProjectConfig.ctx.writeln(ProjectMessages.format("PRINTING_SETTINGS_AS_TABLE_FAILED", e.getLocalizedMessage()));
            GeneralMessages.debugMessage(Throwables.getStackTraceAsString((Throwable)e));
        }
    }
}

