/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.modeler;

import java.sql.Connection;
import oracle.dbtools.jdv.JDVUtil;
import oracle.dbtools.modeler.SdnRequestWrapper;

public class SdnBridge {
    public static final String TYPE_OF_OBJECT = "typeOfObject";
    public static final String OBJECT_OWNER = "objectOwner";
    public static final String OBJECT_NAME = "objectName";
    public static final String OBJECTS_DETAILS_QUERY = "OBJECTS_DETAILS_QUERY";
    public static final String OBJECTS_DETAILS_RESULT = "OBJECTS_DETAILS_RESULT";
    public static final String CT_JSON = "application/json";
    public static final String CT_TEXT = "text/plain";

    public static void processRequest(Connection connection, SdnRequestWrapper wrapper) throws Exception {
        String method = wrapper.getMethod();
        if (method != null) {
            switch (method) {
                case "PUT": {
                    SdnBridge.processPutRequest(connection, wrapper);
                    break;
                }
                case "POST": {
                    SdnBridge.processPostRequest(connection, wrapper);
                    break;
                }
                case "GET": {
                    SdnBridge.processGetRequest(connection, wrapper);
                    break;
                }
                default: {
                    wrapper.setStatusCode(501);
                    return;
                }
            }
        }
    }

    static void processGetRequest(Connection connection, SdnRequestWrapper wrapper) {
    }

    static void processPostRequest(Connection connection, SdnRequestWrapper wrapper) throws Exception {
        String typeOfObject = wrapper.getProperty(TYPE_OF_OBJECT);
        if (OBJECTS_DETAILS_QUERY.equals(typeOfObject)) {
            String result = JDVUtil.getObjectDetailsQueryResult(connection, wrapper.getRequestBody());
            if ("{}".equals(result)) {
                wrapper.setStatusCode(404);
                wrapper.setResponseBody("Object not found or not authorized");
                wrapper.setResponseContentType(CT_TEXT);
            } else {
                wrapper.setStatusCode(200);
                wrapper.setResponseBody(result);
                wrapper.setResponseContentType(CT_JSON);
            }
        }
    }

    static void processPutRequest(Connection connection, SdnRequestWrapper wrapper) {
    }
}

