/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.scheduling;

import oracle.dbtools.crest.model.scheduling.SchedulerJob;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;

public class SchedulerChainRule
extends SchedulerObject {
    @Override
    public void initPropsList() {
        this.propsList.add("OWNER");
        this.propsList.add("CHAIN_NAME");
        this.propsList.add("RULE_OWNER");
        this.propsList.add("RULE_NAME");
        this.propsList.add("CONDITION");
        this.propsList.add("ACTION");
        this.propsList.add("COMMENTS");
    }

    @Override
    public void initDataTypes() {
        this.dataTypes.put("OWNER", "VARCHAR2");
        this.dataTypes.put("CHAIN_NAME", "VARCHAR2");
        this.dataTypes.put("RULE_OWNER", "VARCHAR2");
        this.dataTypes.put("RULE_NAME", "VARCHAR2");
        this.dataTypes.put("CONDITION", "NUMBER");
        this.dataTypes.put("ACTION", "NUMBER");
        this.dataTypes.put("COMMENTS", "VARCHAR2");
    }

    @Override
    public String getName() {
        return this.getProperty("RULE_NAME");
    }

    @Override
    public boolean isMinimumDefined() {
        String value = this.getProperty("CHAIN_NAME");
        if (value == null || value.isEmpty()) {
            return false;
        }
        value = this.getProperty("CONDITION");
        if (value == null || value.isEmpty()) {
            return false;
        }
        value = this.getProperty("ACTION");
        return value != null && !value.isEmpty();
    }

    public void convertLoggingLevel() {
        String nval;
        String val = this.getProperty("LOGGING_LEVEL");
        if (val != null && !val.isEmpty() && !val.toUpperCase().startsWith(SchedulerJob.DBMS_SCHEDULER_LOGGING_PREFIX) && (nval = SchedulerJob.LOGIING_MAP.get(val)) != null) {
            this.setProperty("LOGGING_LEVEL", nval);
        }
    }

    @Override
    public void validate() {
        this.convertLoggingLevel();
    }
}

