/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v9i;

import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ClusterOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.LobStorageOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.RollbackSegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxySetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UserOraclev9i;

public class SnapshotOraclev9i
extends SnapshotOracle {
    public SnapshotOraclev9i(StorageDesign storage) {
        super(storage);
    }

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public void copy(SnapshotOracle snapShot) {
        if (snapShot instanceof SnapshotOraclev9i) {
            this.copy(snapShot.getStorageDesign(), (SnapshotOraclev9i)snapShot);
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        SnapshotOraclev9i snapShot = null;
        StorageObject stObject = (StorageObject)((StorageDesignOraclev9i)targetDesign).getSnapshotSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                snapShot = (SnapshotOraclev9i)stObject;
            }
        } else {
            snapShot = (SnapshotOraclev9i)((StorageDesignOraclev9i)targetDesign).getSnapshotSet().createSnapshot();
        }
        this.copy(targetDesign, snapShot);
    }

    private void copy(StorageDesign targetDesign, SnapshotOraclev9i snapShot) {
        if (snapShot != null) {
            SegmentOracle sourceIndexSegment;
            snapShot.setName(this.getName());
            snapShot.setNameHasQuotes(this.getNameHasQuotes());
            snapShot.setAlias(this.getAlias());
            snapShot.setSubquery(this.getSubquery());
            if (this.getPartitionList() != null) {
                PartitionListOraclev9i partList = (PartitionListOraclev9i)((StorageDesignOraclev9i)targetDesign).getPartitionListSet().getByName(this.getPartitionList().getName());
                if (partList == null) {
                    PartitionListOraclev9i newList = (PartitionListOraclev9i)((StorageDesignOraclev9i)targetDesign).getPartitionListSet().createPartitionList();
                    newList.setName(this.getPartitionList().getName());
                    newList.setRawObject(true);
                    snapShot.setPartitionList(newList);
                } else {
                    snapShot.setPartitionList(partList);
                }
            }
            for (PartitionOraclev9i partition : this.getPartitions()) {
                PartitionOraclev9i part = (PartitionOraclev9i)((StorageDesignOraclev9i)targetDesign).getPartitionSet().getByName(partition.getName());
                if (part == null) {
                    PartitionOraclev9i newPart = (PartitionOraclev9i)((StorageDesignOraclev9i)targetDesign).getPartitionSet().createPartition();
                    newPart.setName(partition.getName());
                    newPart.setPartitionList(snapShot.getPartitionList());
                    newPart.setRawObject(true);
                    ((StorageDesignOraclev9i)targetDesign).getPartitionSet().add(newPart);
                    snapShot.addPartFromDesign(((StorageDesignOraclev9i)targetDesign).getPartitionSet());
                    continue;
                }
                part.setPartitionList(snapShot.getPartitionList());
                ((StorageDesignOraclev9i)targetDesign).getPartitionSet().add(part);
                snapShot.addPartFromDesign(((StorageDesignOraclev9i)targetDesign).getPartitionSet());
            }
            for (LobStorageOraclev9i lobStorage : this.getLobs()) {
                LobStorageOraclev9i targetLobStorage = (LobStorageOraclev9i)((StorageDesignOraclev9i)targetDesign).getLobStorageSet().getByName(lobStorage.getName());
                if (targetLobStorage == null) {
                    LobStorageOraclev9i newStorage = (LobStorageOraclev9i)((StorageDesignOraclev9i)targetDesign).getLobStorageSet().createLobStorage();
                    newStorage.setName(lobStorage.getName());
                    newStorage.setRawObject(true);
                    newStorage.setSnapshot(snapShot);
                    ((StorageDesignOraclev9i)targetDesign).getLobStorageSet().add(newStorage);
                    snapShot.getLobs().add(newStorage);
                    continue;
                }
                targetLobStorage.setSnapshot(snapShot);
                ((StorageDesignOraclev9i)targetDesign).getLobStorageSet().add(targetLobStorage);
                snapShot.getLobs().add(targetLobStorage);
            }
            if (this.getUser() != null) {
                UserOraclev9i user = (UserOraclev9i)((StorageDesignOraclev9i)targetDesign).getUserSet().getByName(this.getUser().getName());
                if (user == null) {
                    UserOraclev9i newUser = (UserOraclev9i)((StorageDesignOraclev9i)targetDesign).getUserSet().createUser();
                    newUser.setName(this.getUser().getName());
                    newUser.setRawObject(true);
                    snapShot.setUser(newUser);
                } else {
                    snapShot.setUser(user);
                }
            }
            if (this.getLobStorage() != null) {
                LobStorageOraclev9i targetLobs = (LobStorageOraclev9i)((StorageDesignOraclev9i)targetDesign).getLobStorageSet().getByName(this.getLobStorage().getName());
                if (targetLobs == null) {
                    LobStorageOraclev9i newLobs = (LobStorageOraclev9i)((StorageDesignOraclev9i)targetDesign).getLobStorageSet().createLobStorage();
                    newLobs.setName(this.getLobStorage().getName());
                    newLobs.setRawObject(true);
                    snapShot.setLobStorage(newLobs);
                } else {
                    snapShot.setLobStorage(targetLobs);
                }
            }
            snapShot.setPartitioned(this.getPartitioned());
            if (this.getCluster() != null) {
                ClusterOraclev9i cluster = (ClusterOraclev9i)((StorageDesignOraclev9i)targetDesign).getClusterSet().getByName(this.getCluster().getName());
                if (cluster == null) {
                    ClusterOraclev9i newCluster = (ClusterOraclev9i)((StorageDesignOraclev9i)targetDesign).getClusterSet().createCluster();
                    newCluster.setName(this.getCluster().getName());
                    newCluster.setRawObject(true);
                    snapShot.setCluster(newCluster);
                } else {
                    snapShot.setCluster(cluster);
                }
            }
            if (this.getTablespace() != null) {
                TableSpaceOraclev9i tableSpace = (TableSpaceOraclev9i)((StorageDesignOraclev9i)targetDesign).getTableSpaceSet().getByName(this.getTablespace().getName());
                if (tableSpace == null) {
                    TableSpaceOraclev9i newTableSpace = (TableSpaceOraclev9i)((StorageDesignOraclev9i)targetDesign).getTableSpaceSet().createTableSpace();
                    newTableSpace.setName(this.getTablespace().getName());
                    newTableSpace.setRawObject(true);
                    snapShot.setTablespace(newTableSpace);
                } else {
                    snapShot.setTablespace(tableSpace);
                }
            }
            snapShot.setLogging(this.getLogging());
            SegmentOracle sourceSegment = this.getSegment();
            if (sourceSegment != null) {
                SegmentOracle targetSegment = sourceSegment.getCopy(targetDesign);
                snapShot.setSegment(targetSegment);
            }
            snapShot.setParalelClause(this.getParalelClause());
            snapShot.setDegree(this.getDegree());
            snapShot.setBuild(this.getBuild());
            if (this.getOnPrebuildTable() != null) {
                TableProxyOraclev9i table = (TableProxyOraclev9i)((TableProxySetOraclev9i)((StorageDesignOraclev9i)targetDesign).getTableProxySet()).getByName(this.getOnPrebuildTable().getName());
                if (table == null) {
                    TableProxyOraclev9i newTable = (TableProxyOraclev9i)((TableProxySetOraclev9i)((StorageDesignOraclev9i)targetDesign).getTableProxySet()).createProxy(this.getOnPrebuildTable().getObject());
                    newTable.setName(this.getOnPrebuildTable().getName());
                    newTable.setRawObject(true);
                    snapShot.setOnPrebuildTable(newTable);
                } else {
                    snapShot.setOnPrebuildTable(table);
                }
            }
            snapShot.setReducedPrecision(this.getReducedPrecision());
            snapShot.setForUpdate(this.getForUpdate());
            snapShot.setQueryRewrite(this.getQueryRewrite());
            snapShot.setUseIndex(this.getUseIndex());
            if (this.getIndexTablespace() != null) {
                TableSpaceOraclev9i tableSpace = (TableSpaceOraclev9i)((StorageDesignOraclev9i)targetDesign).getTableSpaceSet().getByName(this.getIndexTablespace().getName());
                if (tableSpace == null) {
                    TableSpaceOraclev9i newTableSpace = (TableSpaceOraclev9i)((StorageDesignOraclev9i)targetDesign).getTableSpaceSet().createTableSpace();
                    newTableSpace.setName(this.getIndexTablespace().getName());
                    newTableSpace.setRawObject(true);
                    snapShot.setIndexTablespace(newTableSpace);
                } else {
                    snapShot.setIndexTablespace(tableSpace);
                }
            }
            if ((sourceIndexSegment = this.getIndexSegment()) != null) {
                SegmentOracle targetIndexSegment = sourceIndexSegment.getCopy(targetDesign);
                snapShot.setIndexSegment(targetIndexSegment);
            }
            snapShot.setCache(this.getCache());
            snapShot.setRefresh(this.getRefresh());
            snapShot.setRefreshType(this.getRefreshType());
            snapShot.setAction(this.getAction());
            snapShot.setStartDate(this.getStartDate());
            snapShot.setNextDate(this.getNextDate());
            snapShot.setWith(this.getWith());
            snapShot.setDefaultSegment(this.getDefaultSegment());
            snapShot.setSegmentType(this.getSegmentType());
            if (this.getRollbackSegment() != null) {
                RollbackSegmentOraclev9i rollBackSeg = (RollbackSegmentOraclev9i)((StorageDesignOraclev9i)targetDesign).getRollbackSegmentSet().getByName(this.getRollbackSegment().getName());
                if (rollBackSeg == null) {
                    RollbackSegmentOraclev9i newRollBackSeg = (RollbackSegmentOraclev9i)((StorageDesignOraclev9i)targetDesign).getRollbackSegmentSet().createRollbackSegment();
                    newRollBackSeg.setName(this.getRollbackSegment().getName());
                    newRollBackSeg.setRawObject(true);
                    snapShot.setRollbackSegment(newRollBackSeg);
                } else {
                    snapShot.setRollbackSegment(rollBackSeg);
                }
            }
            snapShot.setComment(this.getComment());
            snapShot.setCommentInRdbms(this.getCommentInRdbms());
            snapShot.setRawObject(false);
        }
    }
}

