/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.OwnedObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.CopyInSD_RelatedObjectsWrapper;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public abstract class PlSqlSourceStorageObjectOracle
extends AbstractStorageObjectOracle
implements PropertiesPropagator,
OwnedObjectOracle {
    private static final String SPACE = " ";
    private static final String EMPTY_BODY = " AS \n\nEND;";
    private static final String WORD_SEPARATORS_REGEXP = "[\t\r\n]";
    public static final String CREATE_OR_REPLACE = "CREATE OR REPLACE ";
    protected UserOracle owner;
    private String ownerName = "";
    protected String source;
    protected boolean propertiesSet;
    protected List propertyWrapperList = null;
    private static final Logger LOGGER = new Logger(PlSqlSourceStorageObjectOracle.class);

    public PlSqlSourceStorageObjectOracle(StorageDesign storageDesign, String id, String name) {
        this.id = id;
        this.name = name;
        this.setStorageDesign(storageDesign);
    }

    public void initSource() {
        StringBuilder source = new StringBuilder();
        source.append(CREATE_OR_REPLACE);
        source.append(this.getTypeName().toUpperCase());
        source.append(SPACE);
        String ownerAndName = this.owner == null ? this.name : new StringBuffer(this.owner.getLongName()).append('.').append(this.name).toString();
        source.append(this.getStorageDesign().getFormatedName(ownerAndName));
        source.append(EMPTY_BODY);
        this.setSource(source.toString());
    }

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public void showPropertyDialogOnNew() {
        super.showPropertyDialogOnNew();
    }

    @Override
    public String getLongName() {
        if (this.getOwner() != null && !"".equals(this.getOwner().getLongName())) {
            return new StringBuffer(this.getOwner().getLongName()).append('.').append(this.name).toString();
        }
        return this.name;
    }

    @Override
    public boolean allowName(String name, boolean isLongName) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet objectSet = this.getObjectSet();
        if (objectSet == null) {
            return true;
        }
        if (!isLongName && this.getOwner() != null) {
            name = this.getOwner().getLongName() + "." + (String)name;
        }
        return !objectSet.containsLongName(this, (String)name);
    }

    public String getSource() {
        this.updateSource();
        return this.source;
    }

    public void setSource(String source) {
        if (this.source == null || !this.source.equals(source)) {
            this.source = source;
            this.setParsedForDependency(false);
        }
    }

    @Override
    public boolean setName(String name) {
        boolean result = true;
        if (!this.name.equals(name) && (result = super.setName(name))) {
            this.updateSource();
        }
        return result;
    }

    public void updateSource() {
        if (this.source != null && !this.getStorageDesign().isLoading()) {
            String oldOwnerAndName;
            int oldOwnerAndNameIndex;
            if (this.source.trim().endsWith(";")) {
                String newName;
                String firstToken;
                int lastSemiColonIndex;
                String between;
                int betweenLength;
                char beforeEnd;
                int lastEndIndex = this.source.lastIndexOf("END ");
                if (this.source.indexOf("end ", lastEndIndex) > -1) {
                    lastEndIndex = this.source.lastIndexOf("end ");
                }
                if (lastEndIndex > 0 && ((beforeEnd = this.source.charAt(lastEndIndex - 1)) == ';' || Character.isWhitespace(beforeEnd)) && (betweenLength = (between = this.source.substring(lastEndIndex + 4, lastSemiColonIndex = this.source.lastIndexOf(59))).trim().length()) > 0 && between.indexOf(59) == -1 && (firstToken = Token.getFirstToken(between.replaceAll(WORD_SEPARATORS_REGEXP, SPACE))).length() == betweenLength && !firstToken.equalsIgnoreCase(newName = this.getStorageDesign().getFormatedName(this.getName()))) {
                    this.source = this.source.substring(0, lastEndIndex + 4) + newName + ";";
                }
            }
            String typeName = this.getTypeName().toUpperCase();
            int typeNameIndex = this.source.toUpperCase().indexOf(typeName);
            if (typeNameIndex > -1 && (oldOwnerAndNameIndex = this.source.indexOf(oldOwnerAndName = this.extractOwnerAndName(this.source), typeNameIndex + typeName.length())) > -1) {
                String newOwnerAndName = this.getLongName();
                this.source = this.source.substring(0, oldOwnerAndNameIndex) + this.getStorageDesign().getFormatedName(newOwnerAndName) + this.source.substring(oldOwnerAndNameIndex + oldOwnerAndName.length());
            }
        }
    }

    private String extractOwnerAndName(String source) {
        String ownerAndName;
        String typeName = this.getTypeName();
        String afterType = Token.getStringAfter(source, typeName);
        if (!(afterType = afterType.replaceAll(WORD_SEPARATORS_REGEXP, SPACE)).startsWith(ownerAndName = Token.getFirstName(afterType, '\"', '\"'))) {
            int ownerAndNameLength = ownerAndName.length();
            if (afterType.length() >= ownerAndNameLength + 2) {
                String tryFourQuotes;
                String tryTwoQuotes = afterType.substring(0, ownerAndNameLength + 2);
                if (tryTwoQuotes.replaceAll("\"", "").equals(ownerAndName)) {
                    ownerAndName = tryTwoQuotes;
                } else if (afterType.length() >= ownerAndNameLength + 4 && (tryFourQuotes = afterType.substring(0, ownerAndNameLength + 4)).replaceAll("\"", "").equals(ownerAndName)) {
                    ownerAndName = tryFourQuotes;
                }
            }
        }
        return ownerAndName;
    }

    @Override
    public void remove(boolean force) {
        super.remove(force);
    }

    @Override
    public void remove() {
        super.remove();
    }

    public void setOwner(UserOracle owner) {
        if (this.owner != owner) {
            this.owner = owner;
            this.updateSource();
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public UserOracle getOwner() {
        return this.owner;
    }

    public String getOwnerName() {
        UserOracle user = this.getOwner();
        if (user != null) {
            return user.getName();
        }
        return this.ownerName;
    }

    public void setOwnerName(String name) {
        this.ownerName = name;
        ModelObject user = this.getStorageDesignOracle().getUserSet().getByName(name);
        if (user != null) {
            this.setOwner((UserOracle)user);
        }
    }

    public abstract String getTypeName();

    @Override
    public void setUser(UserOracle user) {
        this.setOwner(user);
    }

    @Override
    public UserOracle getUser() {
        return this.getOwner();
    }

    @Override
    public boolean isDataObject() {
        return false;
    }

    public List getListOfPermissions() {
        ArrayList<PermissionsOracle> list = new ArrayList<PermissionsOracle>();
        for (PermissionsOracle po : ((StorageDesignOracle)this.getStorageDesign()).getPermissionsSet()) {
            if (po.getFunctionOracle() != this && po.getProc() != this && po.getPackage() != this) continue;
            list.add(po);
        }
        return list;
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("DefaultPropertyDialogOracle.User"), this, "getOwner", "setOwner", UserOracle.class));
            CopyInSD_RelatedObjectsWrapper pwc = this instanceof FunctionOracle ? new CopyInSD_RelatedObjectsWrapper(Messages.getString("DefaultPropertyDialogOracle.Permissions"), this, "getListOfPermissions", "setFunctionOracle", FunctionOracle.class) : (this instanceof StoredProcedureOracle ? new CopyInSD_RelatedObjectsWrapper(Messages.getString("DefaultPropertyDialogOracle.Permissions"), this, "getListOfPermissions", "setProc", StoredProcedureOracle.class) : new CopyInSD_RelatedObjectsWrapper(Messages.getString("DefaultPropertyDialogOracle.Permissions"), this, "getListOfPermissions", "setPackage", PackageOracle.class));
            pwc.addAdditionalProperty("getUser", "setUser", UserOracle.class);
            pwc.addAdditionalProperty("getRole", "setRole", RoleOracle.class);
            this.propertyWrapperList.add(pwc);
        }
        return this.propertyWrapperList;
    }

    protected String getPropertyDialogName(String messageKey) {
        String uiText = Messages.getString(messageKey);
        if (uiText.endsWith(":")) {
            uiText = uiText.substring(0, uiText.length() - 1).trim();
        }
        return uiText;
    }
}

