/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObjectPH_ShortName;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.KeyObjectSet;
import oracle.dbtools.crest.model.design.constraint.TableCheckConstraintListener;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraintEvent;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnSet;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.ExternalTableProperties;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationSet;
import oracle.dbtools.crest.model.design.relational.IdentiyColumnDescription;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.IndexSet;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.ValidTimeDimension;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.util.GUID;

public class Table
extends FKContainer
implements EditableFonts {
    private String abbreviation = "";
    private String adequatelyNormalized = "NO";
    private String expectedVolumes = "0";
    private String growthPercent = "0";
    private String growthType = "Year";
    private String maxVolumes = "9999999";
    private String minVolumes = "0";
    private String normalForm = "Third";
    private boolean oidIsPK = false;
    private String scope;
    private boolean spatialTable = false;
    private String splittedTableID;
    private boolean userDefinedOid = true;
    private boolean allowColumnReorder = true;
    private String redactionPolicyName;
    private String redactionPolicyDefaultExpression;
    private boolean redactionPolicyEnabled = false;
    private boolean redactionPolicyGenerateInDDL = false;
    private boolean isEngineerToRelation = false;
    private boolean existDependencyGenerateInDDl = false;
    private String existDependencyConstraintName;
    private String existDependencyGenerationLevel = "Single statement";
    private boolean includeSchemaNameInQuery = false;
    private boolean incorrectSQL = false;
    private boolean materializedQueryTable = false;
    private boolean onPrebuiltTable = false;
    private boolean parsed = false;
    private String syntaxProvider = "Oracle";
    private String useObjectsOnlyFrom;
    private String userDefinedSQL;
    private boolean validSQL = true;
    private List<ValidTimeDimension> validTimeDimensions;
    private List columnGroups;
    private List spatialDefinitions;
    private List usedObjects;
    private List checkConstraints = new ArrayList();
    private KeyObjectSet allkeys;
    public static final KeyObject[] KEY_PROTOTYPE = new Index[0];
    private List sqlNames = null;
    private List editableFonts = new ArrayList();
    public static String DC_DDL_LEVEL_SINGLE_STATEMENT = "Single statement";
    public static String DC_DDL_LEVEL_DISCRIMINATOR_VALUE = "Discriminator value";
    public static String DC_DDL_LEVEL_COLUMN_LEVEL = "Column";
    public static String[] DC_DDL_GENERATION_LEVELS = new String[]{DC_DDL_LEVEL_SINGLE_STATEMENT, DC_DDL_LEVEL_DISCRIMINATOR_VALUE, DC_DDL_LEVEL_COLUMN_LEVEL};
    private static final Object[] INDEX_ASSOCIATION_PROTO = FKIndexAssociationSet.PROTOTYPE_ARRAY;
    private DesignObjectCollection indSet;
    private DesignObjectCollection pkSet;
    private DesignObjectCollection unSet;
    private DesignObjectCollection fkSet;
    public static final String PK_INDEX = "PK_INDEX.class";
    private DesignObjectCollection indexOnlySet;
    private boolean beingRecreated = false;
    private Map generatedLists = new TreeMap();
    private List oidPKColumns = new ArrayList();
    private TableSpaceOracle tableSpace;
    private boolean logging = true;
    private String organization = "HEAP";
    private IdentiyColumnDescription identiyColumnDescription = null;
    private boolean oracleLogTable = false;
    private boolean rowArchival = false;
    public static final String TYPE_NAME = "Table";
    SnapshotOracle mv = null;
    ExternalTableProperties ext;

    public Table(DesignPart designPart) {
        super(designPart);
        this.validTimeDimensions = new ArrayList<ValidTimeDimension>();
        this.initIndexFilters();
    }

    public void initIndexFilters() {
        this.allkeys = this.getKeySet();
        this.indSet = new DesignObjectCollection();
        this.pkSet = new DesignObjectCollection();
        this.unSet = new DesignObjectCollection();
        this.fkSet = new DesignObjectCollection();
        this.unSet.setParent(this);
        this.pkSet.setParent(this);
        this.indSet.setParent(this);
        this.fkSet.setParent(this);
        this.indSet.setDesign(this.getDesign());
        this.indSet.setName(Messages.getString("Table.Indexes"));
        this.indSet.setParent(this);
        this.fkSet.setDesign(this.getDesign());
        this.fkSet.setName(Messages.getString("Table.ForeignKeys"));
        this.pkSet.setDesign(this.getDesign());
        this.pkSet.setName(Messages.getString("Table.PrimaryKeys"));
        this.unSet.setDesign(this.getDesign());
        this.unSet.setName(Messages.getString("Table.UniqueConstraints"));
        this.fkSet.setParent(this);
        this.allkeys.addSetListener(this);
        if (this.getDesignPart() != null) {
            this.indexOnlySet = ((RelationalDesign)this.getDesignPart()).getIndexOnlyPlaceHolderSet();
        }
        this.indSet.setElementDescriptor(Index.class);
        this.pkSet.setElementDescriptor(PK_INDEX);
        this.unSet.setElementDescriptor(Index.class);
        this.fkSet.setElementDescriptor(FKIndexAssociation.class);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public String getAdequatelyNormalized() {
        return this.adequatelyNormalized;
    }

    public void setAdequatelyNormalized(String adequatelyNormalized) {
        this.adequatelyNormalized = adequatelyNormalized;
    }

    public String getExpectedVolumes() {
        return this.expectedVolumes;
    }

    public void setExpectedVolumes(String expectedVolumes) {
        this.expectedVolumes = expectedVolumes;
    }

    public String getGrowthPercent() {
        return this.growthPercent;
    }

    public void setGrowthPercent(String growthPercent) {
        this.growthPercent = growthPercent;
    }

    public String getGrowthType() {
        return this.growthType;
    }

    public void setGrowthType(String growthType) {
        this.growthType = growthType;
    }

    public String getMaxVolumes() {
        return this.maxVolumes;
    }

    public void setMaxVolumes(String maxVolumes) {
        this.maxVolumes = maxVolumes;
    }

    public String getMinVolumes() {
        return this.minVolumes;
    }

    public void setMinVolumes(String minVolumes) {
        this.minVolumes = minVolumes;
    }

    public String getNormalForm() {
        return this.normalForm;
    }

    public void setNormalForm(String normalForm) {
        this.normalForm = normalForm;
    }

    public boolean isOidIsPK() {
        return this.oidIsPK;
    }

    public void setOidIsPK(boolean oidIsPK) {
        this.oidIsPK = oidIsPK;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean isSpatialTable() {
        return this.spatialTable;
    }

    public void setSpatialTable(boolean spatialTable) {
        this.spatialTable = spatialTable;
    }

    public String getSplittedTableID() {
        return this.splittedTableID;
    }

    public void setSplittedTableID(String splittedTableID) {
        this.splittedTableID = splittedTableID;
    }

    public boolean isUserDefinedOid() {
        return this.userDefinedOid;
    }

    public void setUserDefinedOid(boolean userDefinedOid) {
        this.userDefinedOid = userDefinedOid;
    }

    public boolean isAllowColumnReorder() {
        return this.allowColumnReorder;
    }

    public void setAllowColumnReorder(boolean allowColumnReorder) {
        this.allowColumnReorder = allowColumnReorder;
    }

    public String getRedactionPolicyName() {
        return this.redactionPolicyName;
    }

    public void setRedactionPolicyName(String redactionPolicyName) {
        this.redactionPolicyName = redactionPolicyName;
    }

    public String getRedactionPolicyDefaultExpression() {
        return this.redactionPolicyDefaultExpression;
    }

    public void setRedactionPolicyDefaultExpression(String redactionPolicyDefaultExpression) {
        this.redactionPolicyDefaultExpression = redactionPolicyDefaultExpression;
    }

    public boolean isRedactionPolicyEnabled() {
        return this.redactionPolicyEnabled;
    }

    public void setRedactionPolicyEnabled(boolean redactionPolicyEnabled) {
        this.redactionPolicyEnabled = redactionPolicyEnabled;
    }

    public boolean isRedactionPolicyGenerateInDDL() {
        return this.redactionPolicyGenerateInDDL;
    }

    public void setRedactionPolicyGenerateInDDL(boolean redactionPolicyGenerateInDDL) {
        this.redactionPolicyGenerateInDDL = redactionPolicyGenerateInDDL;
    }

    public boolean isEngineerToRelation() {
        return this.isEngineerToRelation;
    }

    public void setEngineerToRelation(boolean isEngineerToRelation) {
        this.isEngineerToRelation = isEngineerToRelation;
    }

    public boolean isExistDependencyGenerateInDDl() {
        return this.existDependencyGenerateInDDl;
    }

    public void setExistDependencyGenerateInDDl(boolean existDependencyGenerateInDDl) {
        this.existDependencyGenerateInDDl = existDependencyGenerateInDDl;
    }

    public String getExistDependencyConstraintName() {
        return this.existDependencyConstraintName;
    }

    public void setExistDependencyConstraintName(String existDependencyConstraintName) {
        this.existDependencyConstraintName = existDependencyConstraintName;
    }

    public String getExistDependencyGenerationLevel() {
        return this.existDependencyGenerationLevel;
    }

    public void setExistDependencyGenerationLevel(String existDependencyGenerationLevel) {
        this.existDependencyGenerationLevel = existDependencyGenerationLevel;
    }

    public boolean includeSchemaNameInQuery() {
        return this.includeSchemaNameInQuery;
    }

    public void setIncludeSchemaNameInQuery(boolean includeSchemaNameInQuery) {
        this.includeSchemaNameInQuery = includeSchemaNameInQuery;
    }

    @Override
    public boolean isIncorrectSQL() {
        return this.incorrectSQL;
    }

    @Override
    public void setIncorrectSQL(boolean incorrectSQL) {
        this.incorrectSQL = incorrectSQL;
    }

    public boolean isMaterializedQueryTable() {
        return this.materializedQueryTable;
    }

    public void setMaterializedQueryTable(boolean materializedQueryTable) {
        this.materializedQueryTable = materializedQueryTable;
    }

    public boolean isOnPrebuiltTable() {
        return this.onPrebuiltTable;
    }

    public void setOnPrebuiltTable(boolean onPrebuiltTable) {
        this.onPrebuiltTable = onPrebuiltTable;
    }

    @Override
    public boolean isParsed() {
        return this.parsed;
    }

    @Override
    public void setParsed(boolean parsed) {
        this.parsed = parsed;
    }

    @Override
    public String getSyntaxProvider() {
        return this.syntaxProvider;
    }

    @Override
    public void setSyntaxProvider(String syntaxProvider) {
        this.syntaxProvider = syntaxProvider;
    }

    public String getUseObjectsOnlyFrom() {
        return this.useObjectsOnlyFrom;
    }

    public void setUseObjectsOnlyFrom(String useObjectsOnlyFrom) {
        this.useObjectsOnlyFrom = useObjectsOnlyFrom;
    }

    @Override
    public String getUserDefinedSQL() {
        return this.userDefinedSQL;
    }

    @Override
    public void setUserDefinedSQL(String userDefinedSQL) {
        this.userDefinedSQL = userDefinedSQL;
        if (userDefinedSQL != null && !userDefinedSQL.trim().isEmpty()) {
            this.setMaterializedQueryTable(true);
        }
    }

    @Override
    public boolean isValidSQL() {
        return this.validSQL;
    }

    @Override
    public void setValidSQL(boolean validSQL) {
        this.validSQL = validSQL;
    }

    public Index createIndex() {
        Index key = this.createIndex(null);
        return key;
    }

    public Index createIndex(String id) {
        Index key = new Index(this.getDesignPart());
        key.setBackup(this.isBackup());
        key.setObjectID(id);
        this.add(key);
        return key;
    }

    public List getAllInds_FKeyInds() {
        ArrayList<Index> list = new ArrayList<Index>();
        ArrayList<Index> plain = new ArrayList<Index>();
        ArrayList<Index> fk = new ArrayList<Index>();
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            Index index = (Index)it.next();
            if (index.isPK()) {
                list.add(0, index);
                continue;
            }
            if (index.isUnique()) {
                list.add(index);
                continue;
            }
            if (index.isFK()) {
                fk.add(index);
                continue;
            }
            plain.add(index);
        }
        list.addAll(plain);
        list.addAll(fk);
        return list;
    }

    public ColumnGroup createColumnGroup() {
        ColumnGroup columnGroup = new ColumnGroup(null);
        this.addColumnGroup(columnGroup);
        return columnGroup;
    }

    public ColumnGroup createColumnGroup(String name, String id) {
        ColumnGroup columnGroup = new ColumnGroup(null);
        if (id != null) {
            columnGroup.setObjectID(id);
        }
        if (name != null) {
            columnGroup.setName(name);
        }
        return columnGroup;
    }

    public ColumnGroup getColumnGroupByID(String id) {
        for (ColumnGroup cg : this.getColumnGroupsSet()) {
            if (!cg.getObjectID().equals(id)) continue;
            return cg;
        }
        return null;
    }

    public void addColumnGroup(ColumnGroup columnGroup) {
        if (!this.getColumnGroupsSet().contains(columnGroup)) {
            this.getColumnGroupsSet().add(columnGroup);
        }
    }

    public void removeColumnGroup(ColumnGroup columnGroup) {
        this.getColumnGroupsSet().remove(columnGroup);
    }

    public List getColumnGroupsSet() {
        if (this.columnGroups == null) {
            this.columnGroups = new ArrayList();
        }
        return this.columnGroups;
    }

    public SpatialColumnDefObject createSpatialDefinition() {
        SpatialColumnDefObject spd = new SpatialColumnDefObject(this);
        this.getSpatialDefinitions().add(spd);
        return spd;
    }

    public void removeSpatialDefinition(SpatialColumnDefObject spdef) {
        this.getSpatialDefinitions().remove(spdef);
    }

    public SpatialColumnDefObject getSpatialDefinitionByID(String id) {
        for (SpatialColumnDefObject spd : this.getSpatialDefinitions()) {
            if (!spd.getObjectID().equals(id)) continue;
            return spd;
        }
        return null;
    }

    public List getSpatialDefinitions() {
        if (this.spatialDefinitions == null) {
            this.spatialDefinitions = new ArrayList();
        }
        return this.spatialDefinitions;
    }

    public SQLNameHelper createSQLNameHelper() {
        SQLNameHelper sQLNameHelper = new SQLNameHelper();
        this.getUsedObjectsList().add(sQLNameHelper);
        return sQLNameHelper;
    }

    public SQLNameHelper getSQLNameHelperByID(String id) {
        if (id != null) {
            for (SQLNameHelper sh : this.getSQLNames()) {
                if (!id.equalsIgnoreCase(sh.getID())) continue;
                return sh;
            }
        }
        return null;
    }

    public List getUsedObjectsList() {
        if (this.usedObjects == null) {
            this.usedObjects = new ArrayList();
        }
        return this.usedObjects;
    }

    public List getCheckConstraints() {
        return this.checkConstraints;
    }

    public TableLevelConstraint createCheckConstraint() {
        TableLevelConstraint tc = new TableLevelConstraint(this.getDesignPart());
        return tc;
    }

    public TableLevelConstraint createCheckConstraint(String name, String rule) {
        TableLevelConstraint tc = new TableLevelConstraint(this.getDesignPart());
        String ccName = this.createCheckConstraintName(name);
        tc.setName(ccName);
        tc.setRule(rule);
        return tc;
    }

    private String createCheckConstraintName(String name) {
        Object ccName = name;
        String sep = "v";
        int ind = 1;
        while (this.getCheckConstraintByName((String)ccName) != null) {
            ccName = name + sep + ind++;
            if (ind < 100) continue;
        }
        return ccName;
    }

    public void addCheckConstraint(TableLevelConstraint constraint) {
        if (!this.checkConstraints.contains(constraint)) {
            this.checkConstraints.add(constraint);
            constraint.setTable(this);
            TableLevelConstraintEvent event = TableLevelConstraintEvent.TABLE_CHECK_CONSTRAINT_ADDED;
            event.setAffected(constraint);
            this.fireChange(event);
        }
    }

    public void removeCheckConstraint(TableLevelConstraint constraint) {
        if (this.checkConstraints.contains(constraint)) {
            this.checkConstraints.remove(constraint);
            TableLevelConstraintEvent event = TableLevelConstraintEvent.TABLE_CHECK_CONSTRAINT_REMOVED;
            event.setAffected(constraint);
            this.fireChange(event);
        }
    }

    public void clearCheckConstraints() {
        for (TableLevelConstraint constraint : this.checkConstraints) {
            TableLevelConstraintEvent event = TableLevelConstraintEvent.TABLE_CHECK_CONSTRAINT_REMOVED;
            event.setAffected(constraint);
            this.fireChange(event);
        }
        this.checkConstraints.clear();
    }

    public TableLevelConstraint getCheckConstraintByID(String id) {
        for (TableLevelConstraint tc : this.checkConstraints) {
            if (!tc.getID().equals(id)) continue;
            return tc;
        }
        return null;
    }

    public TableLevelConstraint getCheckConstraintByName(String name) {
        for (TableLevelConstraint tc : this.checkConstraints) {
            if (!tc.getName().equalsIgnoreCase(name)) continue;
            return tc;
        }
        return null;
    }

    public TableLevelConstraint getCheckConstraintByImportedID(String importedID) {
        for (TableLevelConstraint tc : this.checkConstraints) {
            if (!tc.getImportedId().equals(importedID)) continue;
            return tc;
        }
        return null;
    }

    protected void fireChange(TableLevelConstraintEvent event) {
        this.setDirty(true);
        this.getChange().setTimeNow();
        for (Object l : this.getListeners()) {
            if (!(l instanceof TableCheckConstraintListener)) continue;
            ((TableCheckConstraintListener)l).changed((TableLevelConstraint)event.getAffected(), event);
        }
    }

    @Override
    public String getLayoutSQL() {
        return "";
    }

    public Index createIndexFK(FKIndexAssociation fkass, String index_id) {
        Index key = (Index)fkass.getLocalFKIndex();
        key.setBackup(this.isBackup());
        fkass.setBackup(this.isBackup());
        key.setObjectID(index_id);
        key.setFKAssociation(fkass);
        this.add(key);
        return key;
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        String querySQL;
        super.changed(object, event);
        if (object instanceof Index) {
            if (event.isType(ObjectChangeEvent.KEY_CHANGED_TO_PK)) {
                if (!this.pkSet.containsPlaceHolderFor(object)) {
                    this.pkSet.add(new ContainerObjectPH_ShortName(this.getDesignPart(), object));
                }
                this.indSet.removePlaceHolderFor(object);
                this.indexOnlySet.removePlaceHolderFor(object);
                this.unSet.removePlaceHolderFor(object);
            } else if (event.isType(ObjectChangeEvent.KEY_CHANGED_NO_PK)) {
                this.pkSet.removePlaceHolderFor(object);
                if (!((Index)object).isUnique()) {
                    this.indSet.add(new ContainerObjectPH_ShortName(this.getDesignPart(), object));
                    if (!this.isBackup()) {
                        this.indexOnlySet.add(new ContainerObjectPlaceHolder(this.getDesignPart(), object));
                    }
                }
            }
            if (event.isType(ObjectChangeEvent.KEY_CHANGED_TO_UNIQUE)) {
                this.indSet.removePlaceHolderFor(object);
                this.indexOnlySet.removePlaceHolderFor(object);
                this.unSet.add(new ContainerObjectPH_ShortName(this.getDesignPart(), object));
            } else if (event.isType(ObjectChangeEvent.KEY_CHANGED_NO_UNIQUE)) {
                if (this.unSet.getNumberOfChildren() > 0) {
                    this.unSet.removePlaceHolderFor(object);
                }
                if (!((Index)object).isPK()) {
                    this.indSet.add(new ContainerObjectPH_ShortName(this.getDesignPart(), object));
                    if (!this.isBackup()) {
                        this.indexOnlySet.add(new ContainerObjectPlaceHolder(this.getDesignPart(), object));
                    }
                }
            }
        } else if (object instanceof FKArc) {
            if (event == ObjectChangeEvent.OBJECT_REMOVED) {
                this.removeArc((FKArc)object);
            }
        } else if (!this.getDesign().isLoading() && (querySQL = this.getUserDefinedSQL()) != null && !querySQL.isEmpty() && (event.isType(ObjectChangeEvent.OBJECT_REMOVED) || event.isType(ObjectChangeEvent.NAME_CHANGED) || event.isType(ObjectChangeEvent.SCHEMA_CHANGED)) && this.sqlNameExists(object.getObjectID())) {
            this.setValidSQL(!this.isSQLNamesChanged());
        }
    }

    @Override
    public FKIndexAssociation[] getFKAssociations() {
        return (FKIndexAssociation[])this.fkList.toArray(INDEX_ASSOCIATION_PROTO);
    }

    @Override
    public KeyObject createIndexFK(FKIndexAssociation fkass) {
        Index key = new Index(this.getDesignPart(), fkass);
        key.setBackup(this.isBackup());
        key.setObjectID(null);
        key.setFKAssociation(fkass);
        this.add(key);
        return key;
    }

    @Override
    protected void clearStructure() {
        this.removeAllKeys();
    }

    @Override
    protected void updateStructure() {
        block6: {
            block5: {
                TypeElement te;
                int i;
                if (!this.isBST()) break block5;
                StructuredType st = this.getBasedOnStructuredType();
                if (st == null || "XMLTYPE".equalsIgnoreCase(st.getName())) break block6;
                List stElems = st.getAllElements();
                ContainedObject[] coar = this.getElements();
                for (i = 0; i < coar.length; ++i) {
                    if (coar[i].isOid() || (te = this.findTypeElement(stElems, coar[i].getStructAttributeID())) != null) continue;
                    coar[i].remove();
                }
                this.addOidColumn();
                this.updateElements(stElems);
                for (i = 0; i < stElems.size(); ++i) {
                    te = (TypeElement)stElems.get(i);
                    ContainedObject co = this.getElementByStructAttributeID(te.getObjectID());
                    if (co == null) continue;
                    this.moveToIndex(co, i + 1);
                }
                break block6;
            }
            ContainedObject[] cols = this.getElements();
            for (int i = 0; i < cols.length; ++i) {
                Column col = (Column)cols[i];
                Datatype colDatatype = col.getDataType();
                if (!(colDatatype instanceof StructuredType) || col.isReference()) continue;
                StructuredType st = (StructuredType)colDatatype;
                List stElems = st.getAllElements();
                Object[] coar = col.getNestedObjects().toArray();
                for (int j = 0; j < coar.length; ++j) {
                    ContainedObject cob = (ContainedObject)coar[j];
                    TypeElement te = this.findTypeElement(stElems, cob.getStructAttributeID());
                    if (te != null) continue;
                    this.removeNestedCOFor(cob);
                    cob.remove();
                    this.nestedElements.remove(cob);
                }
                List telems = ((StructuredType)col.getDataType()).getAllElements();
                for (int j = 0; j < telems.size(); ++j) {
                    this.createColumnAndNestedColumns((TypeElement)telems.get(j), col);
                }
            }
        }
    }

    private void updateElements(List telems) {
        for (int i = 0; i < telems.size(); ++i) {
            TypeElement te = (TypeElement)telems.get(i);
            Column column = (Column)this.getElementByStructAttributeID(te.getObjectID());
            if (column == null) {
                if (this.isBackup()) {
                    column = new Column(this.getDesignPart());
                    column.setName(te.getName());
                } else {
                    column = this.createColumn(te.getName());
                }
                column.setStructAttributeID(te.getObjectID());
                this.addColumn(column);
            }
            this.copyTEtoColumn(te, column);
            if (!(te.getType() instanceof StructuredType) || te.isReference()) continue;
            this.createNestedColumnsOnly(te, column);
        }
    }

    private TypeElement findTypeElement(List list, String id) {
        for (int i = 0; i < list.size(); ++i) {
            TypeElement te = (TypeElement)list.get(i);
            if (!te.getObjectID().equalsIgnoreCase(id)) continue;
            return te;
        }
        return null;
    }

    private void addOidColumn() {
        if (this.getElementsCollection().size() == 0) {
            Column column;
            if (this.isBackup()) {
                column = new Column(this.getDesignPart());
                column.setName("Oid");
            } else {
                column = this.createColumn("Oid");
            }
            column.setOid(true);
            column.setUse((short)3);
            column.setReference(true);
            column.setStructuredType(this.getBasedOnStructuredType());
            this.addColumn(column);
            column.setNullsAllowed(false);
            Index index = this.createIndex();
            index.setPK(true);
            index.add(column);
            index.setName(ApplyNamingStandards.createPK_Name(this.getName(), this.getDesign().getDesignLevelSettings().getNamingStandardRule(), this.getDesignPart().getName(), this.getAbbreviation()));
            index.setOidKey(true);
            this.setUserDefinedOid(true);
        }
    }

    public Column createNestedColumn() {
        Column nestedColumn = this.createColumn(null);
        this.getElementsCollection().remove(nestedColumn);
        this.getNestedElements().add(nestedColumn);
        return nestedColumn;
    }

    public Column createColumn() {
        return this.createColumn(null);
    }

    public Column createColumn(String name) {
        return this.createColumn(name, null);
    }

    @Override
    public void add(ContainedObject object) {
        super.add(object);
        if (!this.isBackup() && this.getDesignObjectSet() != DesignObjectSet.NULL_SET) {
            this.getColumnSet().add(object);
        }
    }

    public Column createColumn(String name, String id) {
        Column column = new Column(this.getDesignPart());
        column.setBackup(this.isBackup());
        column.setDesign(this.getDesign());
        column.setContainer(this);
        if (id != null) {
            column.setObjectID(id);
        }
        this.add(column);
        if (name != null) {
            column.setName(name);
        }
        return column;
    }

    public void addColumn(Column column) {
        column.setDesign(this.getDesign());
        column.setContainer(this);
        this.add(column);
    }

    public ContainedObject createContainedObject(String id) {
        return this.createColumn(null, id);
    }

    public void createColumnAndNestedColumns(TypeElement te, Column parent) {
    }

    private void copyTEtoColumn(TypeElement te, Column column) {
        column.setName(te.getName());
        column.setNameHasQuotes(te.getNameHasQuotes());
        column.setMandatory(te.isMandatory() || column.isMandatory());
    }

    public ColumnSet getColumnSet() {
        return ((RelationalDesign)this.getDesignPart()).getColumnSet();
    }

    @Override
    public DesignObjectSet getContainedSet() {
        return this.getColumnSet();
    }

    public void createNestedColumnsOnly(TypeElement te, Column parent) {
        if (te.getType() instanceof StructuredType && !te.isReference()) {
            StructuredType st = (StructuredType)te.getType();
            TypeElement[] telems = st.getElements();
            for (int i = 0; i < telems.length; ++i) {
                TypeElement tel = telems[i];
                Column nested_column = (Column)this.getElementByStructAttributeID(tel.getObjectID(), parent);
                if (nested_column == null) {
                    nested_column = new Column(this.getDesignPart());
                    nested_column.setName(te.getName());
                    nested_column.setStructAttributeID(tel.getObjectID());
                    nested_column.setParentObject(parent);
                    this.addColumn(nested_column);
                }
                this.copyTEtoColumn(tel, nested_column);
                if (!(tel.getType() instanceof StructuredType) || tel.isReference()) continue;
                this.createNestedColumnsOnly(tel, nested_column);
            }
        } else {
            Column column = (Column)this.getElementByStructAttributeID(te.getObjectID(), parent);
            if (column == null) {
                column = new Column(this.getDesignPart());
                column.setName(te.getName());
                column.setStructAttributeID(te.getObjectID());
                column.setParentObject(parent);
                this.addColumn(column);
            }
            this.copyTEtoColumn(te, column);
        }
    }

    @Override
    public List getSQLNames() {
        if (this.sqlNames == null) {
            this.sqlNames = new ArrayList();
        }
        return this.sqlNames;
    }

    @Override
    public FKIndexAssociation recreateFK(FKIndexAssociation association, KeyObject fkObject, String localIndexId, String deleteRule) {
        association.setDesign(this.getDesign());
        association.setContainerWithKeyObject(this);
        if (!association.isBackupFK() && !this.isBackup()) {
            association.setParent(((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet());
        }
        association.setKeyObject(fkObject);
        association.setDeleteRule(deleteRule);
        if (localIndexId != null) {
            Index localIndex = (Index)this.getKeyObject(localIndexId);
            association.setLocalFKIndex(localIndex);
            localIndex.setFKAssociation(association);
        }
        ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().add(association);
        if (!this.fkList.contains(association)) {
            this.fkList.add(association);
        }
        this.assignLocalID(association);
        this.getDesign().addDesignObject(association);
        if (fkObject != null) {
            this.addToMap(fkObject.getGeneratorID(), association);
        }
        KeyObject key = association.getLocalFKIndex();
        if (!this.fkSet.containsPlaceHolderFor(association)) {
            this.fkSet.add(new DesignObjectPH_ShortName((DesignObject)association));
        }
        this.indSet.removePlaceHolderFor(key);
        this.indexOnlySet.removePlaceHolderFor(key);
        ObjectChangeEvent.FKINDEX_ADDED.setAffected(association);
        this.fireChange(ObjectChangeEvent.FKINDEX_ADDED);
        ObjectChangeEvent.FKINDEX_ADDED.setAffected(null);
        return association;
    }

    protected void addToMap(String generatorID, FKIndexAssociation association) {
        if (generatorID != null) {
            HashSet<FKIndexAssociation> set = (HashSet<FKIndexAssociation>)this.generatedLists.get(generatorID);
            if (set == null) {
                set = new HashSet<FKIndexAssociation>();
                this.generatedLists.put(generatorID, set);
            }
            set.add(association);
        }
    }

    @Override
    public KeyObject createKeyObject(String id) {
        return this.createIndex(id);
    }

    @Override
    protected KeyObjectSet createKeySet() {
        return new IndexSet(this.getDesignPart(), this);
    }

    @Override
    public KeyObject[] getKeyArrayPrototype() {
        return KEY_PROTOTYPE;
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("table id prefix");
    }

    public ValidTimeDimension createValidTimeDimension() {
        return new ValidTimeDimension(this);
    }

    public void addValidTimeDimension(ValidTimeDimension validTimeDimension) {
        if (!this.validTimeDimensions.contains(validTimeDimension)) {
            this.validTimeDimensions.add(validTimeDimension);
            validTimeDimension.setTable(this);
        }
    }

    public void removeValidTimeDimension(ValidTimeDimension validTimeDimension) {
        if (this.validTimeDimensions.contains(validTimeDimension)) {
            this.validTimeDimensions.remove(validTimeDimension);
            validTimeDimension.remove();
        }
    }

    public List<ValidTimeDimension> getValidTimeDimensions() {
        return this.validTimeDimensions;
    }

    public ValidTimeDimension getValidTimeDimensionByID(String id) {
        for (ValidTimeDimension validTimeDimension : this.validTimeDimensions) {
            if (!validTimeDimension.getObjectID().equals(id)) continue;
            return validTimeDimension;
        }
        return null;
    }

    public FKArc getArcForForeignKeys(List fkeys) {
        FKArc arc2 = null;
        for (FKArc arc2 : this.getArcs()) {
            for (Object obj : fkeys) {
                if (!arc2.getFkeys().contains(obj)) continue;
                return arc2;
            }
        }
        return null;
    }

    @Override
    public RelationalDesign getRelationalModel() {
        return (RelationalDesign)this.getDesignPart();
    }

    public void setBeingRecreated(boolean value) {
        this.beingRecreated = value;
    }

    public boolean isBeingRecreated() {
        return this.beingRecreated;
    }

    public List getOidPKColumns() {
        Index pk = (Index)this.getPK();
        if (pk != null) {
            this.oidPKColumns.clear();
            Column oid = (Column)this.getOidElement();
            if (oid != null && pk.contains(oid)) {
                return this.oidPKColumns;
            }
            this.oidPKColumns.addAll(pk.getElementsCollection());
        }
        return this.oidPKColumns;
    }

    public boolean hasNoneTransferableFK() {
        FKIndexAssociation[] fkeys = this.getFKAssociations();
        for (int i = 0; i < fkeys.length; ++i) {
            if (fkeys[i].isTransferable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public FKElement getColumnForDelegate(FKIndexAssociation fk, FKElement delegate) {
        FKElement[] cols = (FKElement[])this.getElementsAndNestedElements();
        for (int i = 0; i < cols.length; ++i) {
            if (!cols[i].isReferingTo(fk, delegate)) continue;
            return cols[i];
        }
        return null;
    }

    @Override
    public FKElement getFKColumn(FKIndexAssociation association, FKElement delegate) {
        FKElement[] columns = (FKElement[])this.getElementsAndNestedElements();
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].isReferingTo(association, delegate)) continue;
            return columns[i];
        }
        return null;
    }

    @Override
    public Column createRefToStructuredType(StructuredType type, FKIndexAssociation fkAss) {
        Column column = new Column(this.getDesignPart());
        column.setDesign(this.getDesign());
        column.setContainer(this);
        column.setPreviousColumn(false);
        column.setUse((short)3);
        column.setReference(true);
        column.setStructuredType(type);
        column.setScopeId(fkAss.getOriginalContainer().getObjectID());
        this.add(column);
        FKElement col = (FKElement)fkAss.getOriginalContainer().getOidElement();
        if (col != null) {
            String generatedFKColumnName = null;
            column.setName(generatedFKColumnName != null ? generatedFKColumnName : col.getName());
            column.addFKAssociation(col, fkAss);
        }
        fkAss.getLocalFKIndex().add(column);
        return column;
    }

    @Override
    public FKElement createColumnFK(FKElement referencedColumn, FKIndexAssociation fkAss) {
        Column column = new Column(this.getDesignPart(), referencedColumn, fkAss);
        FKElement firstReferencedColumn = null;
        if (referencedColumn instanceof ColumnView) {
            firstReferencedColumn = ((ColumnView)referencedColumn).getFirstReferencedColumn();
        }
        if (firstReferencedColumn == null) {
            firstReferencedColumn = referencedColumn;
        }
        column.setDesign(this.getDesign());
        column.setPreviousColumn(false);
        column.setUse(firstReferencedColumn.getUse());
        column.setReference(firstReferencedColumn.isReference());
        column.setDomain(firstReferencedColumn.getDomain());
        column.setLogicalDatatype(firstReferencedColumn.getLogicalDatatype());
        column.setStructuredType(firstReferencedColumn.getStructuredType());
        column.setCollectionType(firstReferencedColumn.getCollectionType());
        column.copyParametersFrom(firstReferencedColumn);
        column.setContainer(this);
        this.add(column);
        column.addFKAssociation(referencedColumn, fkAss);
        fkAss.getLocalFKIndex().add(column);
        return column;
    }

    @Override
    public List<FKIndexAssociation> getFKAssociationsList() {
        return this.fkList;
    }

    @Override
    public void addRecreateFKAssociation(FKIndexAssociation fkAssociation) {
        this.recreateFK(fkAssociation, fkAssociation.getRemoteIndex(), fkAssociation.getLocalFKIndex().getObjectID(), fkAssociation.getDeleteRule());
    }

    @Override
    public FKElement[] getAllFKColumns(FKIndexAssociation fkAssociation) {
        String lnames;
        ArrayList<ContainedObject> fkcolumns = new ArrayList<ContainedObject>();
        FKElement[] columns = (FKElement[])this.getElementsAndNestedElements();
        for (int i = 0; i < columns.length; ++i) {
            FKElement cfk;
            if (!columns[i].isFKColumn() || !(cfk = columns[i]).isPartOfFKIndexAssociation(fkAssociation)) continue;
            fkcolumns.add(columns[i]);
        }
        if (fkcolumns.size() == 0 && (lnames = fkAssociation.getLocalFKColumnNames()) != null && !lnames.isEmpty()) {
            String[] names;
            for (String n : names = lnames.split(",")) {
                ContainedObject el = this.getElementByName(n);
                if (el == null) continue;
                fkcolumns.add(el);
            }
        }
        return fkcolumns.toArray(new FKElement[0]);
    }

    @Override
    public void removeFKAssociationFromList(FKIndexAssociation fkAssociation) {
        this.fkList.remove(fkAssociation);
    }

    @Override
    public List getColumnsDependinOn(FKIndexAssociation fk) {
        ArrayList<Column> list = null;
        for (Column col : this.getElementsCollection()) {
            if (fk != col.getDependOnForeignKey()) continue;
            if (list == null) {
                list = new ArrayList<Column>();
            }
            list.add(col);
        }
        if (list != null) {
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public void resetIdentityColumn() {
        KeyObject pk;
        Column column;
        Iterator it = this.getElementsCollection().iterator();
        ArrayList<Column> list = new ArrayList<Column>();
        while (it.hasNext()) {
            column = (Column)it.next();
            if (column.isIdentityColumn()) {
                return;
            }
            if (!column.isAutoIncrementColumn()) continue;
            list.add(column);
        }
        if (list.size() == 1) {
            column = (Column)list.get(0);
            if (column.isMandatory()) {
                column.setIdentityColumn(true);
                return;
            }
        } else if (list.size() > 1 && (pk = this.getPK()) != null && pk.getElementsCollection().size() == 1) {
            for (Column column2 : list) {
                if (!column2.isPKElement()) continue;
                column2.setIdentityColumn(true);
                return;
            }
        }
    }

    public Index getIndexByName(String indexName) {
        KeyObject[] keys = this.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            Index index = (Index)keys[i];
            if (!index.getName().equals(indexName)) continue;
            return index;
        }
        return null;
    }

    public Index getPlainIndexByName(String indexName) {
        KeyObject[] keys = this.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            Index index = (Index)keys[i];
            if (index.isPK() || index.isUnique() || index.isFK() || !index.getName().equals(indexName)) continue;
            return index;
        }
        return null;
    }

    public Index getIndexByNameAndSchema(String schema, String indexName) {
        if (schema != null && indexName != null && !"".equals(schema)) {
            KeyObject[] keys = this.getKeys();
            for (int i = 0; i < keys.length; ++i) {
                Index index = (Index)keys[i];
                if (!index.getName().equals(indexName) || !schema.equals(index.getSchema())) continue;
                return index;
            }
        }
        return null;
    }

    public void setSpatialDefinitions(List spatialDefinitions) {
        this.spatialDefinitions = spatialDefinitions;
    }

    public void addSpatialDefinition(SpatialColumnDefObject spObject) {
        if (!this.getSpatialDefinitions().contains(spObject)) {
            this.getSpatialDefinitions().add(spObject);
        }
    }

    @Override
    public FKIndexAssociation addFK(KeyObject fkObject) {
        return this.addFK(fkObject, fkObject.getGeneratorID());
    }

    public FKIndexAssociation addFK(KeyObject fkObject, DesignObject generator) {
        return this.addFK(fkObject, generator.getObjectID());
    }

    public FKIndexAssociation addFK(KeyObject fkObject, String generatorID) {
        return this.addFK(fkObject, generatorID, null);
    }

    public FKIndexAssociation addFK(KeyObject fkObject, String generatorID, FKIndexAssociationReference reference) {
        return this.addFK(fkObject, generatorID, reference, null);
    }

    public FKIndexAssociation addFK(KeyObject fkObject, String generatorID, FKIndexAssociationReference reference, FKIndexAssociation originatingFK) {
        FKIndexAssociation association = new FKIndexAssociation(this.getDesignPart(), originatingFK);
        if (reference != null) {
            reference.setObject(association);
        }
        if (!association.isBackupFK()) {
            association.setParent(((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet());
        }
        association.setDesign(this.getDesign());
        this.assignLocalID(association);
        if (!this.isBackup()) {
            this.getDesign().addDesignObject(association);
        }
        association.setKeyObject(fkObject);
        association.setGeneratorID(generatorID);
        association.setDeleteRule(this.getDesign().getSettings().getDefaultFKDeleteRule());
        this.addFKAssociation(association);
        this.addToMap(generatorID, association);
        KeyObject ind = association.getLocalFKIndex();
        if (ind != null) {
            if (generatorID == null) {
                generatorID = "User generated";
            }
            ind.setGeneratorID(generatorID);
        }
        return association;
    }

    public void addFKAssociation(FKIndexAssociation fkAssociation) {
        fkAssociation.setContainerWithKeyObject(this);
        if (!fkAssociation.isBackupFK()) {
            ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().add(fkAssociation);
        }
        if (this.getDesign().isPropagatePKChahges() && !fkAssociation.isBackupFK()) {
            fkAssociation.addAllFKElements();
        }
        this.fkList.add(fkAssociation);
        KeyObject key = fkAssociation.getLocalFKIndex();
        if (!this.fkSet.containsPlaceHolderFor(fkAssociation)) {
            this.fkSet.add(new DesignObjectPH_ShortName((DesignObject)fkAssociation));
        }
        this.indSet.removePlaceHolderFor(key);
        this.indexOnlySet.removePlaceHolderFor(key);
        ObjectChangeEvent.FKINDEX_ADDED.setAffected(fkAssociation);
        this.fireChange(ObjectChangeEvent.FKINDEX_ADDED);
        ObjectChangeEvent.FKINDEX_ADDED.setAffected(null);
    }

    public List getAllowedStrTypeInstances() {
        ArrayList list = new ArrayList();
        this.addStructuredSubTypeInstances(this, list);
        return list;
    }

    private void addStructuredSubTypeInstances(Table table, List list) {
        if (table.getBasedOnStructuredType() != null) {
            list.add(table.getBasedOnStructuredType());
            for (TypeSubstitution ts : table.getSubTypeSubstitutions()) {
                Table child = (Table)ts.getChildContainerObject();
                this.addStructuredSubTypeInstances(child, list);
            }
        }
    }

    public List getAllSubstitutionTables() {
        ArrayList<Table> list = new ArrayList<Table>();
        if (this.hasTypeSubstitutionChildren()) {
            for (TypeSubstitution ts : this.getSubTypeSubstitutions()) {
                Table table = (Table)ts.getChildContainerObject();
                list.add(table);
                list.addAll(table.getAllSubstitutionTables());
            }
        }
        return list;
    }

    public DesignObjectCollection getIndexes() {
        return this.indSet;
    }

    public DesignObjectCollection getPKeys() {
        return this.pkSet;
    }

    public DesignObjectCollection getUKeys() {
        return this.unSet;
    }

    public Column getDiscriminatorColumn() {
        for (Column col : this.getElementsCollection()) {
            if (!col.isDiscriminatorColumn()) continue;
            return col;
        }
        return null;
    }

    @Override
    public Class getContainedClass() {
        return Column.class;
    }

    @Override
    public String getStorageName() throws IOException {
        if (this.storageName == null) {
            this.storageName = new File(this.getDesignPart().getStoragePath(), "table/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        return this.storageName;
    }

    @Override
    protected boolean exposePhysicalProperties() {
        return true;
    }

    public boolean hasVirtualColumn() {
        for (Column col : this.getElementsCollection()) {
            if (!col.isComputed().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean hasFunctionalIndex() {
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            Index ind = (Index)it.next();
            String expr = ind.getIndexExpression();
            if (expr == null || expr.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public int getFKAssociationsCount() {
        return this.fkList.size();
    }

    @Override
    public String getFCObjectType() {
        return TYPE_NAME;
    }

    public List getEditableFonts() {
        return this.editableFonts;
    }

    public FontObject getFontObject(String type) {
        for (FontObject next : this.editableFonts) {
            if (!type.equalsIgnoreCase(next.getType())) continue;
            return next;
        }
        return null;
    }

    @Override
    public List getPK_UKList() {
        ArrayList<Index> list = new ArrayList<Index>();
        Index key = (Index)this.getPK();
        if (key != null) {
            list.add(key);
        }
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            Index index = (Index)it.next();
            if (!index.isUnique()) continue;
            list.add(index);
        }
        return list;
    }

    public List getIndexes_Plain_List() {
        ArrayList<Index> list = new ArrayList<Index>();
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            Index index = (Index)it.next();
            if (index.isUnique() || index.isPK() || index.isFK()) continue;
            list.add(index);
        }
        return list;
    }

    public List getPKandUKConstraints() {
        ArrayList<KeyObject> list = new ArrayList<KeyObject>();
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            KeyObject key = (KeyObject)it.next();
            if (!key.isPK() && !key.isUnique()) continue;
            list.add(key);
        }
        return list;
    }

    public Index getPKorUKWithName(String indexName) {
        if (indexName != null) {
            Iterator it = this.getKeySet().iterator();
            while (it.hasNext()) {
                Index key = (Index)it.next();
                if (!key.isPK() && !key.isUnique() || !indexName.equalsIgnoreCase(key.getName())) continue;
                return key;
            }
        }
        return null;
    }

    public boolean hasColumnOrTableCheckConstraints() {
        if (this.checkConstraints.size() > 0) {
            return true;
        }
        for (Column col : this.getElementsCollection()) {
            String constr = col.getConstraintsText();
            if (constr == null || constr.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public List getConstraintsSupprtedByIndex(Index ind) {
        ArrayList<Index> list = null;
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            Index key = (Index)it.next();
            if (!key.isPK() && !key.isUnique()) continue;
            if (key.getUsingIndex() == ind) {
                if (list == null) {
                    list = new ArrayList<Index>();
                }
                list.add(key);
                continue;
            }
            if (ind == key || key.getUsingIndex() != null || ind.getSupportedConstraint() != key && !ind.canSupportConstraint(ind, key, true)) continue;
            if (list == null) {
                list = new ArrayList();
            }
            list.add(key);
        }
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    public FKIndexAssociation createFK() {
        FKIndexAssociation fk = this.getRelationalModel().createForeignKey();
        fk.setContainerWithKeyObject(this);
        return fk;
    }

    public TableSpaceOracle getTableSpace() {
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof TableProxyOracle) {
            return ((TableProxyOracle)pr).getTableSpace();
        }
        return this.tableSpace;
    }

    public void setTableSpace(TableSpaceOracle tableSpace) {
        this.tableSpace = tableSpace;
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof TableProxyOracle) {
            ((TableProxyOracle)pr).setTableSpace(tableSpace);
        }
    }

    public boolean isLogging() {
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof TableProxyOracle) {
            return "YES".equalsIgnoreCase(((TableProxyOracle)pr).getLogging());
        }
        return this.logging;
    }

    public void setLogging(boolean logging) {
        this.logging = logging;
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof TableProxyOracle) {
            ((TableProxyOracle)pr).setLogging(logging ? "YES" : "NO");
        }
    }

    public String getOrganization() {
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof TableProxyOracle) {
            return ((TableProxyOracle)pr).getOrganization();
        }
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof TableProxyOracle) {
            ((TableProxyOracle)pr).setOrganization(organization);
        }
    }

    @Override
    public void copy(DesignObject desObject) throws IOException {
        this.copy(desObject, null, false);
    }

    @Override
    public void copy(DesignObject desObject, Map copyMap) throws IOException {
        this.copy(desObject, copyMap, false);
    }

    @Override
    public void copy(DesignObject desObject, Map copyMap, boolean remoteObject) throws IOException {
        this.copy(desObject, copyMap, remoteObject, false);
    }

    public void copy(DesignObject desObject, Map copyMap, boolean remoteObject, boolean targetIsRemoteObject) throws IOException {
        Column old;
        boolean revRemote;
        Table table = (Table)desObject;
        HashMap<Column, Column> colMap = new HashMap<Column, Column>();
        super.copy(table);
        boolean bl = revRemote = targetIsRemoteObject && !this.isRemoteObject();
        if (revRemote) {
            this.setRemoteObjectID(table.getObjectID());
            this.setRemoteModelID(table.getRelationalModel().getObjectID());
            this.setRemoteDesignID(this.getDesign().getObjectID());
            this.setRemoteObjectRelativeStorageName(table.getRelativeStorageName());
            this.setDirty(true);
        }
        table.setTypeID(this.getTypeID());
        table.setScope(this.getScope());
        table.setBasedOnStructuredType(this.getBasedOnStructuredType());
        table.setAbbreviation(this.getAbbreviation());
        table.setOidIsPK(this.isOidIsPK());
        table.setAllowTypeSubstitution(this.isAllowTypeSubstitution());
        table.setOnPrebuiltTable(this.isOnPrebuiltTable());
        table.setMaterializedQueryTable(this.isMaterializedQueryTable());
        table.setRowArchival(this.isRowArchival());
        table.setIncludeSchemaNameInQuery(this.includeSchemaNameInQuery());
        table.setUseObjectsOnlyFrom(this.getUseObjectsOnlyFrom());
        table.setSyntaxProvider(this.getSyntaxProvider());
        table.setUserDefinedSQL(this.getUserDefinedSQL());
        table.setParsed(this.isParsed());
        table.setValidSQL(this.isValidSQL());
        table.setIncorrectSQL(this.isIncorrectSQL());
        table.setMinVolumes(this.getMinVolumes());
        table.setExpectedVolumes(this.getExpectedVolumes());
        table.setMaxVolumes(this.getMaxVolumes());
        table.setGrowthPercent(this.getGrowthPercent());
        table.setGrowthType(this.getGrowthType());
        table.setNormalForm(this.getNormalForm());
        table.setAdequatelyNormalized(this.getAdequatelyNormalized());
        table.setEngineerToRelation(this.isEngineerToRelation());
        table.setAllowColumnReorder(this.isAllowColumnReorder());
        if (!this.isBST()) {
            if (remoteObject) {
                ContainedObject[] columns = table.getElements();
                for (int i = columns.length - 1; i >= 0; --i) {
                    ContainedObject rc;
                    ContainedObject column = columns[i];
                    String rcID = column.getRemoteObjectID();
                    if ("".equalsIgnoreCase(rcID) || (rc = this.getElementByID(rcID)) != null) continue;
                    column.remove();
                }
            }
            ContainedObject[] cos = this.getElements();
            for (int i = 0; i < cos.length; ++i) {
                old = (Column)cos[i];
                Column col = (Column)table.getElementByRemoteObjectID(old.getObjectID());
                if (col == null) {
                    col = table.createColumn();
                }
                if (remoteObject) {
                    if (old.isRemoteObject()) {
                        col.setRemoteObjectID(old.getRemoteObjectID());
                    } else {
                        col.setRemoteObjectID(old.getObjectID());
                    }
                }
                if (revRemote) {
                    old.setRemoteObjectID(col.getObjectID());
                }
                old.copy(col, remoteObject, copyMap, true);
                colMap.put(old, col);
                table.moveToIndex(col, i);
            }
        } else {
            ContainedObject[] cos = this.getElements();
            for (int i = 0; i < cos.length; ++i) {
                old = (Column)cos[i];
                if (!old.isOid()) {
                    Column column;
                    String id = old.getStructAttributeID();
                    if (id != null && !"".equals(id)) {
                        DesignObject obj;
                        column = (Column)table.getElementByStructAttributeID(id);
                        if (column == null && copyMap != null && (obj = (DesignObject)copyMap.get(id)) != null) {
                            column = (Column)table.getElementByStructAttributeID(obj.getObjectID());
                        }
                        if (column == null) continue;
                        if (remoteObject) {
                            column.setRemoteObjectID(old.getObjectID());
                        } else {
                            column.setObjectID(old.getObjectID());
                        }
                        if (revRemote) {
                            old.setRemoteObjectID(column.getObjectID());
                        }
                        old.copy(column, remoteObject, copyMap, true);
                        colMap.put(old, column);
                        continue;
                    }
                    if (table.getBasedOnStructuredType() != null) continue;
                    column = (Column)table.getElementByName(old.getName());
                    if (column == null) {
                        column = table.createColumn();
                    }
                    old.copy(column, remoteObject, copyMap, true);
                    colMap.put(old, column);
                    table.moveToIndex(column, i);
                    continue;
                }
                Column column = (Column)table.getOidElement();
                if (column == null) continue;
                if (remoteObject) {
                    column.setRemoteObjectID(old.getObjectID());
                } else {
                    column.setObjectID(old.getObjectID());
                }
                if (revRemote) {
                    old.setRemoteObjectID(column.getObjectID());
                }
                old.copy(column, remoteObject, copyMap, true);
                colMap.put(old, column);
            }
        }
        for (Column old2 : colMap.keySet()) {
            Column col = (Column)colMap.get(old2);
            if (col == null) continue;
            old2.copyDepenDendentColumnDescriptors(col, false, copyMap);
        }
        for (int i = 0; i < this.getKeys().length; ++i) {
            KeyObject key = null;
            KeyObject oldKey = this.getKeys()[i];
            if (oldKey.isFK() && !remoteObject || oldKey instanceof Index && "Foreign Key".equalsIgnoreCase(oldKey.getIndexState())) continue;
            if (oldKey.isOidKey()) {
                key = table.getOidKey();
            }
            if (key == null && (key = (KeyObject)table.getKeySet().getObjectByRemoteObjectID(oldKey.getObjectID())) == null) {
                key = table.createKeyObject();
            }
            if (oldKey.isOidKey() && key != null) {
                key.setOidKey(true);
            }
            oldKey.copy(key);
            if (remoteObject) {
                if (oldKey.isRemoteObject()) {
                    key.setRemoteObjectID(oldKey.getRemoteObjectID());
                } else {
                    key.setRemoteObjectID(oldKey.getObjectID());
                }
            }
            if (revRemote) {
                oldKey.setRemoteObjectID(key.getObjectID());
            }
            key.setContainerObject(table);
            if (oldKey instanceof Index) {
                key.setIndexState(oldKey.getIndexState());
            }
            if (copyMap == null) continue;
            copyMap.put(oldKey.getObjectID(), key);
        }
        for (int i = 0; i < this.getCheckConstraints().size(); ++i) {
            TableLevelConstraint oldTlc = (TableLevelConstraint)this.getCheckConstraints().get(i);
            TableLevelConstraint tlc = table.getCheckConstraintByName(oldTlc.getName());
            if (tlc == null) {
                tlc = table.createCheckConstraint(oldTlc.getName(), oldTlc.getRule());
                tlc.setNotes(oldTlc.getNotes());
                tlc.setComment(oldTlc.getComment());
                tlc.setCommentInRDBMS(oldTlc.getCommentInRDBMS());
                tlc.setGenerateInDDL(oldTlc.getGenerateInDDL());
                tlc.setNameFixed(oldTlc.isNameFixed());
                table.addCheckConstraint(tlc);
            }
            if (copyMap == null) continue;
            copyMap.put(oldTlc.getObjectID(), tlc);
        }
        table.getValidTimeDimensions().clear();
        for (ValidTimeDimension oldVTD : this.getValidTimeDimensions()) {
            ValidTimeDimension newVTD = new ValidTimeDimension(table);
            oldVTD.copy(newVTD, copyMap);
            if (copyMap == null) continue;
            copyMap.put(oldVTD.getObjectID(), newVTD);
        }
        table.setSpatialTable(this.isSpatialTable());
        table.getSpatialDefinitions().clear();
        for (SpatialColumnDefObject spCol : this.getSpatialDefinitions()) {
            SpatialColumnDefObject t_spCol = new SpatialColumnDefObject(table);
            table.addSpatialDefinition(t_spCol);
            spCol.copyTo(t_spCol, copyMap);
        }
        table.setBeforeDrop(this.getBeforeDrop());
        table.setBeforeCreate(this.getBeforeCreate());
        table.setAfterCreate(this.getAfterCreate());
        table.setEndOfScript(this.getEndOfScript());
        table.setShouldGenerateScript(this.getShouldGenerateScript());
        table.getColumnGroupsSet().clear();
        for (ColumnGroup cgOld : this.getColumnGroupsSet()) {
            ColumnGroup cgNew = table.createColumnGroup(cgOld.getName(), null);
            table.getColumnGroupsSet().add(cgNew);
            cgOld.copy(cgNew, copyMap);
        }
        table.setRedactionPolicyName(this.getRedactionPolicyName());
        table.setRedactionPolicyDefaultExpression(this.getRedactionPolicyDefaultExpression());
        table.setRedactionPolicyEnabled(this.isRedactionPolicyEnabled());
        table.setRedactionPolicyGenerateInDDL(this.isRedactionPolicyGenerateInDDL());
        table.setExistDependencyConstraintName(this.getExistDependencyConstraintName());
        table.setExistDependencyGenerateInDDl(this.isExistDependencyGenerateInDDl());
        table.setExistDependencyGenerationLevel(this.getExistDependencyGenerationLevel());
        table.getAdditionalClassificationTypes().clear();
        for (String id : this.getAdditionalClassificationTypes()) {
            table.getAdditionalClassificationTypes().add(id);
        }
        if (this.getDesignPart() == table.getDesignPart()) {
            // empty if block
        }
        table.setORDSEnable(this.isORDSEnable());
        table.setORDSAuth(this.isORDSAuth());
        table.setORDSAlias(this.getORDSAlias());
        table.setTableSpace(this.getTableSpace());
        table.setLogging(this.isLogging());
        table.setOrganization(this.getOrganization());
        table.setOracleLogTable(this.isOracleLogTable());
        IdentiyColumnDescription descr = this.getIdentiyColumnDescription();
        if (descr != null) {
            IdentiyColumnDescription tdescr = table.getIdentiyColumnDescription();
            if (tdescr == null) {
                tdescr = this.createIdentiyColumnDescription();
            }
            descr.copy(tdescr);
            tdescr.resolveColumn();
        }
    }

    public List<FKIndexAssociation> copyForeignKeys(Table table, Map copyMap) throws IOException {
        ArrayList<FKIndexAssociation> list = new ArrayList<FKIndexAssociation>();
        FKIndexAssociation[] fkeys = this.getFKAssociations();
        for (int i = 0; i < fkeys.length; ++i) {
            FKIndexAssociation oldFK = fkeys[i];
            FKIndexAssociation newFK = this.copyForeignKey(table, oldFK, copyMap);
            if (newFK == null) continue;
            list.add(newFK);
        }
        return list;
    }

    public FKIndexAssociation copyForeignKey(Table table, FKIndexAssociation oldFK, Map copyMap) throws IOException {
        boolean copyWithinSameModel;
        FKIndexAssociation newFK = new FKIndexAssociation(table.getDesignPart());
        newFK.setBackup(this.isBackup());
        this.assignLocalID(newFK);
        KeyObject oldLocalIndex = oldFK.getLocalFKIndex();
        Index newLocalIndex = (Index)table.createIndexFK(newFK);
        KeyObject oldRemoteIndex = oldFK.getRemoteIndex();
        KeyObject newRemoteKey = null;
        Object remoteKeyCopy = null;
        boolean bl = copyWithinSameModel = this.getDesignPart() == table.getDesignPart();
        if (oldRemoteIndex != null && copyMap != null) {
            remoteKeyCopy = copyMap.get(oldRemoteIndex.getObjectID());
            if (remoteKeyCopy == null && oldRemoteIndex.isRemoteObject()) {
                remoteKeyCopy = copyMap.get(oldRemoteIndex.getRemoteObjectID());
            }
            if (copyWithinSameModel || remoteKeyCopy != null) {
                newRemoteKey = remoteKeyCopy != null ? (KeyObject)remoteKeyCopy : oldRemoteIndex;
                newFK.setKeyObject(newRemoteKey);
            }
        }
        for (Column oldColumn : oldLocalIndex.getElementsCollection()) {
            FKElement newRefCol;
            Object newCol = copyMap.get(oldColumn.getObjectID());
            FKElement oldRefColumn = oldColumn.getReferencedColumn(oldFK);
            if (remoteKeyCopy != null && oldRefColumn != null) {
                newRefCol = copyMap.get(oldRefColumn.getObjectID());
                if (newRefCol == null) {
                    newRefCol = copyMap.get(oldRefColumn.getRemoteObjectID());
                }
            } else {
                newRefCol = oldRefColumn;
            }
            if (!(newCol instanceof Column) || !(newRefCol instanceof FKElement)) continue;
            Column newColumn = (Column)newCol;
            newColumn.addFKAssociation(newRefCol, newFK);
            newLocalIndex.add(newColumn);
        }
        oldLocalIndex.copy(newLocalIndex);
        table.recreateFK(newFK, newRemoteKey, newLocalIndex.getObjectID(), null);
        oldFK.copy(newFK);
        if (copyWithinSameModel) {
            // empty if block
        }
        newFK.resetEdgeParams();
        if (copyMap != null) {
            copyMap.put(oldFK.getObjectID(), newFK);
        }
        return newFK;
    }

    public List<String> getUsedTablesAndViewsList() {
        String schema = this.getSchema();
        ArrayList<String> list = new ArrayList<String>();
        if (this.sqlNames != null) {
            for (SQLNameHelper helper : this.sqlNames) {
                if (!helper.isContainer()) continue;
                if (schema == null || schema.isEmpty()) {
                    String s = helper.getSchema();
                    if (s != null && !s.isEmpty()) {
                        list.add(s + "." + helper.getTableName());
                        continue;
                    }
                    list.add(helper.getTableName());
                    continue;
                }
                list.add(helper.getTableName());
            }
        }
        return list;
    }

    public IdentiyColumnDescription getIdentiyColumnDescription() {
        if (this.identiyColumnDescription == null) {
            this.identiyColumnDescription = new IdentiyColumnDescription(this);
        }
        this.identiyColumnDescription.setColumn(null);
        for (Column col : this.getElementsCollection()) {
            if (!col.isIdentityColumn()) continue;
            this.identiyColumnDescription.setColumn(col);
            break;
        }
        if (this.identiyColumnDescription.getColumn() != null) {
            return this.identiyColumnDescription;
        }
        return null;
    }

    public void setIdentiyColumnDescription(IdentiyColumnDescription ident) {
        this.identiyColumnDescription = ident;
        if (ident != null && this.identiyColumnDescription.getColumnName() != null && !this.identiyColumnDescription.getColumnName().isEmpty()) {
            this.identiyColumnDescription.setColumn(null);
            this.identiyColumnDescription.setTable(this);
            this.identiyColumnDescription.resolveColumn();
        }
    }

    public IdentiyColumnDescription createIdentiyColumnDescription() {
        if (this.identiyColumnDescription == null) {
            this.identiyColumnDescription = new IdentiyColumnDescription(this);
        }
        return this.identiyColumnDescription;
    }

    public SnapshotOracle getSnapshot() {
        if (this.isMaterializedQueryTable()) {
            RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
            if (pr != null && pr instanceof TableProxyOracle) {
                if (!this.isOnPrebuiltTable()) {
                    this.mv = ((TableProxyOracle)pr).getSnapshot();
                }
                if (this.mv == null) {
                    StorageDesignOracle storageDesign = (StorageDesignOracle)pr.getStorageDesign();
                    this.mv = storageDesign.createSnapshotOracle();
                    this.mv.setImplementedTableProxy((TableProxyOracle)pr);
                    ((TableProxyOracle)pr).setSnapshot(this.mv);
                    this.mv.setName(this.getName());
                    if (this.isOnPrebuiltTable()) {
                        this.mv.setOnPrebuildTable((TableProxyOracle)pr);
                    }
                }
            }
            return this.mv;
        }
        return null;
    }

    public SnapshotOracle createSnapshot() {
        RelationalObjectProxy pr;
        SnapshotOracle sn = null;
        if (this.isMaterializedQueryTable() && (pr = (RelationalObjectProxy)this.getProxyObject()) != null && pr instanceof TableProxyOracle) {
            StorageDesignOracle storageDesign = (StorageDesignOracle)pr.getStorageDesign();
            sn = storageDesign.createSnapshotOracle();
            sn.setImplementedTableProxy((TableProxyOracle)pr);
            sn.setName(this.getName());
            ((TableProxyOracle)pr).setSnapshot(sn);
            if (this.isMaterializedQueryTable()) {
                // empty if block
            }
            if (this.isOnPrebuiltTable()) {
                sn.setOnPrebuildTable((TableProxyOracle)pr);
            }
        }
        return sn;
    }

    public void setSnapshot(SnapshotOracle snapshotOracle) {
        this.mv = snapshotOracle;
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof TableProxyOracle) {
            ((TableProxyOracle)pr).setSnapshot(snapshotOracle);
            snapshotOracle.setImplementedTableProxy((TableProxyOracle)pr);
        }
    }

    public ExternalTableProperties getExternalTableProperties() {
        if ("EXTERNAL".equalsIgnoreCase(this.getOrganization())) {
            RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
            if (pr != null && pr instanceof TableProxyOracle) {
                if (this.ext != null) {
                    if (this.ext.getTableProxyOracle() == null) {
                        this.ext.setTableProxyOracle((TableProxyOracle)pr);
                    }
                } else {
                    this.ext = new ExternalTableProperties((TableProxyOracle)pr);
                }
            }
            return this.ext;
        }
        return null;
    }

    public ExternalTableProperties createExternalTableProperties() {
        if ("EXTERNAL".equalsIgnoreCase(this.getOrganization())) {
            RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
            this.ext = new ExternalTableProperties((TableProxyOracle)pr);
            return this.ext;
        }
        return null;
    }

    public boolean isOracleLogTable() {
        return this.oracleLogTable;
    }

    public void setOracleLogTable(boolean oracleLogTable) {
        this.oracleLogTable = oracleLogTable;
    }

    public boolean isPartitioned() {
        TableProxyOracle tp = (TableProxyOracle)this.getProxyObject();
        if (tp != null) {
            return "YES".equalsIgnoreCase(tp.getPartitioned());
        }
        return false;
    }

    public boolean isRowArchival() {
        return this.rowArchival;
    }

    public void setRowArchival(boolean rowArchival) {
        this.rowArchival = rowArchival;
    }

    public List<Column> getJSONColumns() {
        ArrayList<Column> list = new ArrayList<Column>();
        for (Column col : this.getElementsCollection()) {
            if (!col.isJsonColumn()) continue;
            list.add(col);
        }
        return list;
    }

    public List<Column> getJSONColumnsIndexed() {
        ArrayList<Column> list = new ArrayList<Column>();
        for (Column col : this.getElementsCollection()) {
            if (!col.isJsonColumn()) continue;
            Column[] cols = new Column[]{col};
            Index ind = this.getIndexForColumns(cols);
            try {
                IndexProxyOracle pr;
                if (ind == null || (pr = (IndexProxyOracle)ind.getProxyObject()) == null || !pr.getIndexType().startsWith("CTXSYS.CONTEXT")) continue;
                list.add(col);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public Index getIndexForColumns(Column[] columns) {
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            Index index = (Index)it.next();
            if (index.isUnique() || index.isPK() || index.isFK() || !index.isIndexForColumns(columns)) continue;
            return index;
        }
        return null;
    }

    public FKIndexAssociation getFKforColumns(String cols) {
        String[] names = cols.split(",");
        HashSet<String> set = new HashSet<String>();
        for (String name : names) {
            set.add(name.trim().toUpperCase(Locale.ROOT));
        }
        for (FKIndexAssociation fk : this.getFKAssociationsList()) {
            boolean notFound = false;
            for (FKElement col : fk.getColumns()) {
                if (set.contains(col.getName().toUpperCase(Locale.ROOT))) continue;
                notFound = true;
                break;
            }
            if (notFound) continue;
            return fk;
        }
        return null;
    }

    public class ColumnGroup {
        public static final String TYPE_NAME = "ColumnGroup";
        String name = "";
        String objectId = "";
        String note = "";
        List<String> columns = null;

        public ColumnGroup(String name) {
            this.name = name;
            this.columns = new ArrayList<String>();
            this.objectId = new GUID().toString();
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setObjectID(String objectId) {
            this.objectId = objectId;
        }

        public String getObjectID() {
            return this.objectId;
        }

        public List<String> getColumns() {
            return this.columns;
        }

        public void setNote(String note) {
            this.note = note;
        }

        public String getNote() {
            return this.note;
        }

        public String getColumnRefs() {
            if (this.columns.size() > 0) {
                StringBuffer sb = new StringBuffer();
                boolean first = true;
                for (String id : this.columns) {
                    if (first) {
                        sb.append(id);
                        first = false;
                        continue;
                    }
                    sb.append(' ').append(id);
                }
                return sb.toString();
            }
            return "";
        }

        public void setColumnRefs(String refs) {
            if (refs != null) {
                this.columns.clear();
                String[] ids = refs.split(" ");
                for (int i = 0; i < ids.length; ++i) {
                    this.columns.add(ids[i]);
                }
            }
        }

        public void copy(ColumnGroup columnGroup, Map map) {
            columnGroup.setObjectID(this.getObjectID());
            columnGroup.setName(this.getName());
            columnGroup.setNote(this.getNote());
            columnGroup.getColumns().clear();
            if (map == null) {
                columnGroup.getColumns().addAll(this.getColumns());
            } else {
                List<String> tlist = columnGroup.getColumns();
                for (String col_id : this.getColumns()) {
                    Column col = (Column)map.get(col_id);
                    if (col == null) continue;
                    tlist.add(col.getObjectID());
                }
            }
        }

        public void copy(ColumnGroup columnGroup) {
            this.copy(columnGroup, null);
        }
    }

    public class DesignObjectPH_ShortName
    extends DesignObjectPlaceHolder {
        public DesignObjectPH_ShortName(DesignObject object) {
            super(object);
        }

        @Override
        public String toString() {
            return this.getDesignObject().getName();
        }
    }
}

