/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.dbtools.crest.model.Task;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.FKConnection;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;

public class ImpliedForeignKey
extends DesignObject
implements FKConnection {
    public static final String ID_PREFIX = "IMPLIEDFK";
    protected ContainerWithKeyObject container = null;
    private FKContainer referredTable;
    private FKElement localColumn;
    private FKElement referredColumn;
    private String referredTableID;
    private String referredColumnID = null;
    private String referredTableLongName;
    private String referredColumnName = null;
    private String discoverySources = "";
    private ContainerView sourceCV;
    private ContainerView targetCV;
    private boolean isExisting = false;
    private boolean modified = false;
    Collection dpvCol = new ArrayList();

    public ImpliedForeignKey(DesignPart designPart) {
        super(designPart);
    }

    public ImpliedForeignKey(DesignPart designPart, ContainerObject sourceObject, ContainerObject targetObject) {
        super(designPart);
        this.referredTable = (FKContainer)sourceObject;
        this.container = (ContainerWithKeyObject)targetObject;
    }

    @Override
    public String getIDPrefix() {
        return ID_PREFIX;
    }

    @Override
    public String getObjectTypeName() {
        return "ImpliedForeignKey";
    }

    @Override
    public void remove() {
        if (this.container != null) {
            ((FKContainer)this.container).getImpliedForeignKeyList().remove(this);
        }
        super.remove();
        this.dpvCol.clear();
    }

    @Override
    public void setTopView(TopView view) {
        this.addTopView(view);
    }

    @Override
    public TopView getTopView() {
        for (dpvInfo dpi : this.dpvCol) {
            if (dpi.tv == null) continue;
            return dpi.tv;
        }
        return null;
    }

    public void addTopView(TopView view) {
        DesignPartView dpv = view.getDesignPartView();
        dpvInfo inf = this.getDPVInfoFor(dpv);
        if (inf.tv != null && inf.tv != view) {
            throw new RuntimeException("Implied Foreign Key already exists");
        }
        inf.tv = view;
    }

    @Override
    public DesignObject getObject() {
        return this;
    }

    public String getReferredTableID() {
        if (this.referredTable != null) {
            this.referredTableID = this.referredTable.getObjectID();
        }
        return this.referredTableID;
    }

    public void setReferredTableID(String referredTableID) {
        this.referredTableID = referredTableID;
        if (referredTableID != null && !"".equals(referredTableID)) {
            FKContainer rTable = (FKContainer)this.getDesign().getDesignObject(referredTableID);
            if (rTable != null) {
                FKElement rColumn;
                this.setRemoteTable(rTable);
                if (this.referredColumnID != null && !"".equals(this.referredColumnID) && (rColumn = (FKElement)rTable.getElementByID(this.referredColumnID)) != null) {
                    this.setReferredColumn(rColumn);
                }
            } else {
                this.getDesignPart().addTask(new CreateImpliedForeignKeyTask(this));
            }
        }
    }

    public String getReferredColumnID() {
        if (this.referredColumn != null) {
            this.referredColumnID = this.referredColumn.getObjectID();
        }
        return this.referredColumnID;
    }

    public void setReferredColumnID(String referredColumnID) {
        this.referredColumnID = referredColumnID;
    }

    public String getReferredTableLongName() {
        if (this.referredTable != null) {
            this.referredTableLongName = this.referredTable.getLongName();
        }
        return this.referredTableLongName;
    }

    public void setReferredTableLongName(String referredTableLongName) {
        this.referredTableLongName = referredTableLongName;
    }

    public String getReferredColumnName() {
        if (this.referredColumn != null) {
            this.referredColumnName = this.referredColumn.getName();
        }
        return this.referredColumnName;
    }

    public void setReferredColumnName(String referredColumnName) {
        this.referredColumnName = referredColumnName;
    }

    public String getLocalColumnName() {
        if (this.localColumn != null) {
            return this.localColumn.getName();
        }
        return "";
    }

    public boolean setReferredObjects() {
        FKContainer rTable = (FKContainer)this.getDesign().getDesignObject(this.referredTableID);
        if (rTable != null) {
            FKElement rColumn;
            this.setRemoteTable(rTable);
            if (this.referredColumnID != null && !"".equals(this.referredColumnID) && (rColumn = (FKElement)rTable.getElementByID(this.referredColumnID)) != null) {
                this.setReferredColumn(rColumn);
            }
            return true;
        }
        return false;
    }

    public void setContainerWithKeyObject(ContainerWithKeyObject container) {
        this.container = container;
    }

    public ContainerWithKeyObject getContainerWithKeyObject() {
        return this.container;
    }

    public void setRemoteTable(FKContainer remoteTable) {
        this.referredTable = remoteTable;
    }

    @Override
    public FKContainer getRemoteTable() {
        return this.referredTable;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    public dpvInfo getDPVInfoFor(DesignPartView dpv) {
        dpvInfo dpi2;
        for (dpvInfo dpi2 : this.dpvCol) {
            if (dpi2.dpv != dpv) continue;
            return dpi2;
        }
        dpi2 = new dpvInfo();
        dpi2.dpv = dpv;
        this.dpvCol.add(dpi2);
        return dpi2;
    }

    public String getLocalColumnID() {
        if (this.localColumn != null) {
            return this.localColumn.getObjectID();
        }
        return "";
    }

    public FKElement getLocalColumn() {
        return this.localColumn;
    }

    public void setLocalColumn(FKElement localColumn) {
        this.localColumn = localColumn;
    }

    public FKElement getReferredColumn() {
        if (this.referredColumn == null && this.referredColumnID != null && !this.referredColumnID.isEmpty()) {
            this.referredColumn = (FKElement)this.getDesign().getDesignObject(this.referredColumnID);
        }
        return this.referredColumn;
    }

    public void setReferredColumn(FKElement referredColumn) {
        this.referredColumn = referredColumn;
    }

    public String getDiscoverySources() {
        if (this.discoverySources == null) {
            this.discoverySources = "";
        }
        return this.discoverySources;
    }

    public void setDiscoverySources(String discoverySources) {
        this.discoverySources = discoverySources;
    }

    public String getFormattedDiscoverySource() {
        String[] parts;
        if (this.discoverySources != null && !this.discoverySources.isEmpty() && (parts = this.discoverySources.split(";")).length > 1) {
            Object res = null;
            for (String p : parts) {
                res = res == null ? p : (String)res + "\n" + p;
            }
            return res;
        }
        return this.discoverySources;
    }

    public ContainerView getSourceContainerView() {
        return this.sourceCV;
    }

    public void setSourceContainerView(ContainerView sourceCV) {
        this.sourceCV = sourceCV;
    }

    public ContainerView getTargetContainerView() {
        return this.targetCV;
    }

    public void setTargetContainerView(ContainerView targetCV) {
        this.targetCV = targetCV;
    }

    public boolean isExisting() {
        return this.isExisting;
    }

    public void setExisting(boolean isExisting) {
        this.isExisting = isExisting;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public String createUniqueName(List<ImpliedForeignKey> list) {
        String prefix = this.getObjectTypeName() + "_";
        int index = list.size() + 1;
        String nameVariant = prefix + index;
        boolean matchingFound = false;
        do {
            matchingFound = false;
            for (ImpliedForeignKey ifk : list) {
                if (!nameVariant.equalsIgnoreCase(ifk.getName())) continue;
                matchingFound = true;
                nameVariant = prefix + ++index;
            }
        } while (matchingFound);
        return nameVariant;
    }

    @Override
    public FKContainer getTable() {
        return (FKContainer)this.getContainerWithKeyObject();
    }

    public String getJoinedColumns() {
        Object res = "";
        FKElement col = this.getLocalColumn();
        if (col != null) {
            res = col.getVeryLongName();
            FKElement rcol = this.getReferredColumn();
            if (rcol != null) {
                res = (String)res + " - " + rcol.getVeryLongName();
            }
        }
        return res;
    }

    public boolean containsSource(String source) {
        String[] parts;
        if (this.discoverySources == null || this.discoverySources.isEmpty()) {
            return false;
        }
        for (String s : parts = this.discoverySources.split(";")) {
            if (!s.equals(source)) continue;
            return true;
        }
        return false;
    }

    public void addDiscoverySource(String source) {
        if (this.discoverySources == null || this.discoverySources.isEmpty()) {
            this.discoverySources = source;
        }
        if (!this.containsSource(source)) {
            this.discoverySources = this.discoverySources + ";" + source;
        }
    }

    @Override
    public void setTargetTopView(TopView target) {
    }

    @Override
    public void setSourceTopView(TopView source) {
    }

    @Override
    public TopView getTargetTopView(DesignPartView dpv) {
        return null;
    }

    @Override
    public TopView getSourceTopView(DesignPartView dpv) {
        return null;
    }

    @Override
    public TopView getViewFor(DesignPartView dpv) {
        return null;
    }

    @Override
    public DesignObject getSourceObject() {
        return null;
    }

    @Override
    public DesignObject getTargetObject() {
        return null;
    }

    @Override
    public void removeTopView(TopView view) {
    }

    @Override
    public List getAllViews() {
        return null;
    }

    @Override
    public void restoreTopView(TopView tv, TopView sourceTV, TopView targetTV) {
    }

    public class dpvInfo {
        public ContainerView sourceTV;
        public ContainerView targetTV;
        public TopView tv;
        public DesignPartView dpv;
    }

    public class CreateImpliedForeignKeyTask
    implements Task {
        private static final String TASK_NAME = "create ImpliedForeignKey task";
        private ImpliedForeignKey ifk;

        public CreateImpliedForeignKeyTask(ImpliedForeignKey ifk) {
            this.ifk = ifk;
        }

        @Override
        public boolean execute() {
            return this.ifk.setReferredObjects();
        }

        public String toString() {
            return TASK_NAME;
        }
    }
}

