/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.model.Constants;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerObjectEvent;
import oracle.dbtools.crest.model.design.ContainerObjectListener;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.util.GUID;

public class FKIndexAssociation
extends DesignObject
implements ContainerObjectListener,
ConnectionInterface,
Constants {
    public static final String DELETE_RULE_CASCADE = "CASCADE";
    public static final String DELETE_RULE_SET_NULL = "SET NULL";
    public static final String DELETE_RULE_RESTRICT = "RESTRICT";
    public static final String DELETE_RULE_NOTHING = "NO ACTION";
    public static final String DELETE_RULE_SET_DEFAULT = "SET DEFAULT";
    public static final String[] DELETE_RULES = new String[]{"NO ACTION", "CASCADE", "SET NULL", "RESTRICT"};
    public static final String[] DELETE_RULES_ORACLE = new String[]{"NO ACTION", "CASCADE", "SET NULL"};
    public static final String[] OPTIONAL_CHILD_DELETE_RULES = new String[]{"RESTRICT", "NO ACTION", "SET NULL"};
    public static final String[] DELETE_RULES_WITHOUT_NULL = new String[]{"NO ACTION", "CASCADE", "RESTRICT"};
    public static final String[] DELETE_RULES_WITHOUT_NULL_ORACLE = new String[]{"NO ACTION", "CASCADE"};
    public static final String[] DELETE_RULES_WITH_DEFAULT = new String[]{"NO ACTION", "CASCADE", "SET NULL", "SET DEFAULT"};
    public static final String[] DELETE_RULES_WITH_DEFAULT_WITHOUT_NULL = new String[]{"NO ACTION", "CASCADE", "SET DEFAULT"};
    public static final String[] DELETE_RULES_RESTRICT_CASCADE = new String[]{"CASCADE", "RESTRICT"};
    public static final String[] DELETE_RULES_NOACTION_CASCADE = new String[]{"CASCADE", "NO ACTION"};
    public static final String PROPERTY_ASSOCIATION_ID = "fkassociation.id";
    public static final String ID_PREFIX = "IDXFK";
    public static boolean RESET_COLUMNS_IN_RESETMANDATORY_FROM_COLUMNS = true;
    private KeyObject fkIndex = null;
    Collection dpvCol = new ArrayList();
    protected KeyObject keyObject = null;
    protected ContainerWithKeyObject container = null;
    protected Map elementMap = new HashMap();
    protected String deleteRule = "NO ACTION";
    private boolean mandatory = true;
    private boolean transferable = true;
    private FKArc arc = null;
    public static float[] dashpattern = new float[]{8.0f, 8.0f};
    private FKIndexAssociation originatingFK;
    private boolean silentRemove = false;
    private String discriminatorValue = "";
    private String referredTableID;
    private String containerID;
    private String referredKeyID;
    private FKContainer referredTable;
    private boolean rely = false;
    private FKElement discriminatorColumn;
    private boolean columnDependencyConstraintGenerateInDDL = true;
    private String columnDependencyConstraintGenerateName = "";
    private String localFKColumnNames;
    private String referredColumnNames;
    private String referredKeyName;
    private String referredTableLongName;
    private String containerLongName;
    private boolean constraintDeferrable = false;
    private boolean constraintInitiallyImediate = true;
    private boolean constraintEnable = true;
    private boolean constraintRely = false;
    private boolean constraintValidate = true;
    public static final String TYPE_NAME = "FKIndexAssociation";
    FKConnection fkConnection = null;

    public FKIndexAssociation(FKContainer table) {
        super(table.getDesignPart());
        this.id = new GUID().toString();
        this.setContainerWithKeyObject(table);
        this.setBackup(table.isBackup());
    }

    public FKIndexAssociation(DesignPart designPart) {
        super(designPart);
    }

    public FKIndexAssociation(DesignPart designPart, FKIndexAssociation originatingFK) {
        super(designPart);
        this.originatingFK = originatingFK;
    }

    public void setContainerWithKeyObject(ContainerWithKeyObject container) {
        if (container != null) {
            container.addContainerListener(this);
        }
        this.container = container;
        if (container != null) {
            this.containerID = container.getObjectID();
        }
    }

    public FKContainer getTable() {
        return (FKContainer)this.getContainerWithKeyObject();
    }

    public FKElement createElementFor(FKElement fkElement) {
        FKElement column = this.getTable().getFKColumn(this, fkElement);
        if (column == null) {
            FKElement columnFK = this.getTable().createColumnFK(fkElement, this);
            this.getLocalFKIndex().add(columnFK);
            return columnFK;
        }
        return column;
    }

    @Override
    public String getIDPrefix() {
        return ID_PREFIX;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public FKElement[] getColumns() {
        return (FKElement[])this.getLocalFKIndex().getElements();
    }

    public boolean hasLocalFKIndex() {
        return this.fkIndex != null;
    }

    public void setLocalFKIndex(KeyObject index) {
        this.fkIndex = index;
        if (index != null) {
            if (index.getElementsCollection().size() == 0) {
                this.initializeLocalIndex(this.fkIndex);
            }
            if (this.fkIndex.getFKAssociation() != this) {
                this.fkIndex.setFKAssociation(this);
                ((RelationalDesign)this.getDesignPart()).getGlobalIndexSet().fireObjectStarusChanged(index);
            }
        }
    }

    public KeyObject getLocalFKIndex() {
        if (this.fkIndex == null) {
            KeyObject ind = (KeyObject)this.getTable().getKeySet().getByName(this.name);
            this.fkIndex = ind != null && "Foreign Key".equalsIgnoreCase(ind.getIndexState()) ? ind : this.createLocalFKIndex();
        } else if (this.fkIndex.getFKAssociation() == this && this.fkIndex.getContainerWithKeyObject() == null) {
            this.fkIndex.setContainerObject(this.getContainerWithKeyObject());
        }
        return this.fkIndex;
    }

    public KeyObject getRemoteIndex() {
        return this.getKeyObject();
    }

    public FKContainer getRemoteTable() {
        if (this.keyObject != null) {
            return (FKContainer)this.keyObject.getContainerObject();
        }
        if (this.referredTableID != null) {
            if (this.referredTable != null && !this.referredTable.isRemoved() && this.referredTable.getObjectID().equals(this.referredTableID)) {
                return this.referredTable;
            }
            DesignObject obj = this.getDesign().getDesignObject(this.referredTableID);
            if (obj instanceof FKContainer) {
                this.referredTable = (FKContainer)obj;
                return this.referredTable;
            }
        }
        return null;
    }

    public KeyObject createLocalFKIndex() {
        this.fkIndex = (KeyObject)this.getTable().getKeySet().getByName(this.getName());
        if (this.fkIndex == null) {
            this.fkIndex = this.getTable().createIndexFK(this);
        } else if (this.fkIndex.getElementsCollection().size() > 0 && "Foreign Key".equalsIgnoreCase(this.fkIndex.getIndexState())) {
            if (this.fkIndex.getFKAssociation() != this) {
                this.fkIndex.setFKAssociation(this);
                ((RelationalDesign)this.getDesignPart()).getGlobalIndexSet().fireObjectStarusChanged(this.fkIndex);
            }
            return this.fkIndex;
        }
        return this.initializeLocalIndex(this.fkIndex);
    }

    protected KeyObject initializeLocalIndex(KeyObject fkIndex) {
        block3: {
            String[] parts;
            block2: {
                fkIndex.setFKAssociation(this);
                FKElement[] columns = this.getTable().getAllFKColumns(this);
                if (columns.length <= 0) break block2;
                for (int i = 0; i < columns.length; ++i) {
                    fkIndex.add(columns[i]);
                }
                break block3;
            }
            if (this.localFKColumnNames == null || this.localFKColumnNames.isEmpty()) break block3;
            for (String p : parts = this.localFKColumnNames.split(",")) {
                FKElement el = (FKElement)this.getTable().getElementByName(p.trim());
                if (el == null) continue;
                fkIndex.add(el);
            }
        }
        return fkIndex;
    }

    @Override
    public void remove() {
        this.getTable().removeContainerListener(this);
        this.getLocalFKIndex().remove();
        this.getTable().removeFKAssociationFromList(this);
        this.removeAllFKElements();
        super.remove();
        this.dpvCol.clear();
    }

    public void callRemoveListeners() {
        ObjectChangeEvent event = ObjectChangeEvent.OBJECT_REMOVED;
        event.setAffected(this);
        this.fireChange(event);
        event.setAffected(null);
    }

    @Override
    public boolean shouldBeDroppedIndirectly() {
        if (Design.USE_DROP_DEPENDENCY) {
            return this.getContainerWithKeyObject().isDropEnabled() || this.getContainerWithKeyObject().shouldBeDroppedIndirectly();
        }
        return false;
    }

    @Override
    public void changed(ContainerObject container, ContainerObjectEvent event) {
        if (!this.isBackupFK() && !this.getDesign().isCleaning()) {
            if (container instanceof KeyObject && this.getDesign().isPropagatePKChahges()) {
                if (event.isType(0)) {
                    this.addFKElement((FKElement)event.getAffectedElement());
                } else if (event.isType(1)) {
                    if (event.getAffectedElement() instanceof Column) {
                        ArrayList<FKElement> cols = new ArrayList<FKElement>();
                        cols.add((FKElement)event.getAffectedElement());
                        this.removeFKElement(cols);
                    }
                } else if (!event.isType(4) && event.isType(7)) {
                    this.moveLocalColumn(container, (FKElement)event.getAffectedElement());
                }
            }
            if (event.isType(4) && this.hasLocalFKIndex() && this.getLocalFKIndex().equals(event.getAffectedElement())) {
                this.setLocalFKIndex(null);
            }
        }
    }

    public void synchronizeFKColumns() {
        if (this.keyObject != null) {
            int i;
            FKElement[] pkCols = (FKElement[])this.keyObject.getElements();
            FKContainer tab = (FKContainer)this.getContainerWithKeyObject();
            ArrayList<FKElement> list = new ArrayList<FKElement>();
            for (i = 0; i < pkCols.length; ++i) {
                FKElement fkcol = tab.getFKColumn(this, pkCols[i]);
                if (fkcol == null) {
                    fkcol = tab.getColumnForDelegate(this, pkCols[i]);
                    if (fkcol != null) {
                        fkcol.addFKAssociation(pkCols[i], this);
                        this.getLocalFKIndex().add(fkcol);
                    } else {
                        fkcol = tab.createColumnFK(pkCols[i], this);
                        String name = pkCols[i].getName();
                        fkcol.setName(name);
                    }
                }
                list.add(fkcol);
                if (this.getLocalFKIndex().contains(fkcol)) continue;
                this.getLocalFKIndex().add(fkcol);
            }
            for (i = 0; i < list.size(); ++i) {
                this.getLocalFKIndex().moveToIndex((FKElement)list.get(i), i);
            }
        }
    }

    private FKElement getColumnForReferencedColumn(FKElement refcol) {
        for (FKElement col : this.getLocalFKIndex().getElementsCollection()) {
            if (!col.isReferingTo(this, refcol)) continue;
            return col;
        }
        return null;
    }

    private void moveLocalColumn(ContainerObject refContainer, FKElement refColumn) {
        int ind = refContainer.getIndexOf(refColumn);
        FKElement col = this.getColumnForReferencedColumn(refColumn);
        if (col != null) {
            this.getLocalFKIndex().moveToIndex(col, ind);
        }
    }

    public void resetViewNumbers() {
    }

    public List getAllTVRelations() {
        ArrayList list = new ArrayList();
        return list;
    }

    @Override
    public String getGeneratorID() {
        if (this.hasLocalFKIndex()) {
            return this.getLocalFKIndex().getGeneratorID();
        }
        return "";
    }

    @Override
    public void setGeneratorID(String value) {
        if (this.hasLocalFKIndex()) {
            this.getLocalFKIndex().setGeneratorID(value);
        }
    }

    public void changeKeyObject(KeyObject newKey, FKElement[] fkColumns) {
        KeyObject oldKey = this.getKeyObject();
        FKElement[] old_cols = (FKElement[])this.getLocalFKIndex().getColumns();
        if (oldKey != newKey) {
            this.setKeyObject(newKey);
            if (newKey != null) {
                if (this.getContainerWithKeyObject().isBST()) {
                    if (this.getOriginalContainer().isBST()) {
                        FKElement col = (FKElement)this.getContainerWithKeyObject().getExactRefToStructurtedType(this.getOriginalContainer().getBasedOnStructuredType(), this.getOriginalContainer());
                        if (col == null) {
                            col = (FKElement)this.getContainerWithKeyObject().getRefToStructurtedType(this.getOriginalContainer().getBasedOnStructuredType(), this.getOriginalContainer());
                        }
                        if (col != null) {
                            this.setRefFKColumn(col);
                        }
                    } else {
                        FKElement[] elements = (FKElement[])this.keyObject.getElements();
                        for (int i = 0; i < elements.length; ++i) {
                            FKElement keyColumn = elements[i];
                            FKElement[] compatibleColumns = this.getCompatibleColumns(keyColumn);
                            if (compatibleColumns.length != 1) continue;
                            FKElement compatibleColumn = compatibleColumns[0];
                            compatibleColumn.addFKAssociation(keyColumn, this);
                            this.getLocalFKIndex().add(compatibleColumn);
                        }
                    }
                } else if (this.getOriginalContainer().isBST()) {
                    FKElement[] elements = (FKElement[])this.keyObject.getElements();
                    if (elements.length > 0 && !elements[0].isOid()) {
                        for (int i = 0; i < elements.length; ++i) {
                            this.addFKElement(elements[i]);
                        }
                    } else {
                        FKContainer table = (FKContainer)this.getContainerWithKeyObject();
                        table.createRefToStructuredType(this.getOriginalContainer().getBasedOnStructuredType(), this);
                    }
                }
            }
            this.callRemoveListeners();
            this.addToAllDPVs();
        }
        this.swapFKColumnsWithAskDelete(old_cols, fkColumns);
    }

    public void addToAllDPVs() {
    }

    public FKConnection getFKConnection() {
        if (this.fkConnection == null) {
            this.fkConnection = new FKConnection();
            this.fkConnection.setParentTable(this.getRemoteTable());
            this.fkConnection.setChildTable((FKContainer)this.getContainerWithKeyObject());
        }
        return this.fkConnection;
    }

    public void repairSelfReference() {
        if (this.getContainerWithKeyObject() == this.getRemoteTable()) {
            // empty if block
        }
    }

    public void setTargetTVTable(ContainerView target) {
        DesignPartView dpv = target.getDesignPartView();
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        if (dpi.targetTV != target) {
            boolean reassignConnection = false;
            if (dpi.targetTV != null) {
                reassignConnection = true;
                if (dpi.tv != null && !this.isBackupFK()) {
                    ((TVFKRelation)dpi.tv).removeConnection();
                }
            }
            dpi.targetTV = target;
            if (!this.isBackupFK()) {
                this.addTVFKRelation(dpi);
                if (reassignConnection && dpi.tv != null) {
                    ((TVFKRelation)dpi.tv).addConnection(true);
                    ((TVFKRelation)dpi.tv).resetEdgeParams();
                }
            }
        }
    }

    public void setSourceTVTable(ContainerView source) {
        DesignPartView dpv = source.getDesignPartView();
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        if (dpi.sourceTV != source) {
            boolean reassignConnection = false;
            if (dpi.sourceTV != null) {
                reassignConnection = true;
                if (dpi.tv != null && !this.isBackupFK()) {
                    ((TVFKRelation)dpi.tv).removeConnection();
                }
            }
            dpi.sourceTV = source;
            if (!this.isBackupFK()) {
                this.addTVFKRelation(dpi);
                if (reassignConnection && dpi.tv != null) {
                    ((TVFKRelation)dpi.tv).addConnection(true);
                    ((TVFKRelation)dpi.tv).resetEdgeParams();
                }
            }
        }
    }

    @Override
    public TopView getViewFor(DesignPartView dpv) {
        dpvInfo dpi = this.getDPVInfoFor(dpv);
        return dpi.tv;
    }

    public void addTVFKRelation(dpvInfo dpi) {
        if (dpi.tv == null && dpi.sourceTV != null && dpi.targetTV != null && dpi.dpv != null) {
            TVFKRelation tvr = (TVFKRelation)dpi.dpv.createTopViewFor(this);
            dpi.tv = tvr;
            tvr.setModel(this);
            tvr.setSize(new Dimension(100, 100));
            this.addObjectListener(tvr);
            dpi.dpv.registerForTreemodel(tvr);
        }
        if (dpi.tv != null && dpi.sourceTV != null && dpi.targetTV != null && dpi.dpv != null) {
            dpi.dpv.registerTopView(dpi.tv);
        }
    }

    public dpvInfo getDPVInfoFor(DesignPartView dpv) {
        dpvInfo dpi2;
        for (dpvInfo dpi2 : this.dpvCol) {
            if (dpi2.dpv != dpv) continue;
            return dpi2;
        }
        dpi2 = new dpvInfo();
        dpi2.dpv = dpv;
        this.dpvCol.add(dpi2);
        return dpi2;
    }

    public ContainerView getSourceTV(DesignPartView dpv) {
        FKContainer rt = this.getRemoteTable();
        if (rt != null) {
            return (ContainerView)dpv.getFirstViewFor(rt);
        }
        return null;
    }

    public ContainerView getTargetTV(DesignPartView dpv) {
        ContainerWithKeyObject cont = this.getContainerWithKeyObject();
        if (cont != null) {
            return (ContainerView)dpv.getFirstViewFor(cont);
        }
        return null;
    }

    @Override
    public boolean isReadOnly() {
        if (this.getContainerWithKeyObject() != null && this.getContainerWithKeyObject().isReadOnly()) {
            return true;
        }
        return super.isReadOnly();
    }

    public void swapAndRemoveFKColumn(FKElement fkColumn, FKElement compatibleColumn, FKElement delegateColumn) {
        if (fkColumn == compatibleColumn) {
            return;
        }
        if (fkColumn.getContainerWithKeyObject() != compatibleColumn.getContainerWithKeyObject() || fkColumn.getContainerWithKeyObject() != this.getContainerWithKeyObject()) {
            return;
        }
        if (FKIndexAssociation.compatibleColumns(fkColumn, compatibleColumn)) {
            int posInIndex = this.getLocalFKIndex().getIndexOf(fkColumn);
            fkColumn.removeFKAssociation(this.getObjectID());
            this.getLocalFKIndex().remove(fkColumn);
            compatibleColumn.addFKAssociation(delegateColumn, this);
            this.getLocalFKIndex().add(compatibleColumn);
            this.getLocalFKIndex().moveToIndex(compatibleColumn, posInIndex);
            if (fkColumn.getAssociationsCount() == 0 && !fkColumn.isPreviousColumn()) {
                fkColumn.remove();
            }
        }
    }

    public static boolean compatibleColumns(FKElement col1, FKElement col2) {
        if (col1.isOid() && col1.getContainerWithKeyObject().getBasedOnStructuredType() != null) {
            return col2.isRefToStructuredType(col1.getContainerWithKeyObject().getBasedOnStructuredType());
        }
        String c1name = col1.getDataType().getName();
        if (col1 instanceof AbstractViewElement && "UNKNOWN".equalsIgnoreCase(c1name)) {
            return true;
        }
        String c2name = col2.getDataType().getName();
        if (col2 instanceof AbstractViewElement && "UNKNOWN".equalsIgnoreCase(c2name)) {
            return true;
        }
        return c1name.equalsIgnoreCase(c2name);
    }

    public void swapFKColumnsWith(FKElement[] fkColumns) {
        FKElement col;
        int i;
        FKElement[] oldCols = (FKElement[])this.getLocalFKIndex().getElements();
        FKElement[] pkCols = (FKElement[])this.getKeyObject().getElements();
        int colnum = pkCols.length;
        if (fkColumns.length < colnum) {
            colnum = fkColumns.length;
        }
        this.changeMapping(oldCols, pkCols, fkColumns);
        for (i = 0; i < oldCols.length; ++i) {
            col = oldCols[i];
            col.removeFKAssociation(this.getObjectID());
            this.getLocalFKIndex().remove(col);
        }
        for (i = 0; i < colnum; ++i) {
            if (fkColumns[i] == null) continue;
            fkColumns[i].addFKAssociation(pkCols[i], this);
            this.getLocalFKIndex().add(fkColumns[i]);
        }
        for (i = 0; i < oldCols.length; ++i) {
            col = oldCols[i];
            if (col.getAssociationsCount() != 0 || col.isPreviousColumn()) continue;
            col.remove();
        }
    }

    public void swapFKColumnsWithAskDelete(FKElement[] oldCols, FKElement[] fkColumns) {
        int i;
        int deleteFKcolumns = 0;
        FKElement[] pkCols = (FKElement[])this.getKeyObject().getElements();
        int colnum = pkCols.length;
        if (fkColumns.length < colnum) {
            colnum = fkColumns.length;
        }
        this.changeMapping(oldCols, pkCols, fkColumns);
        for (i = 0; i < oldCols.length; ++i) {
            FKElement col = oldCols[i];
            col.removeFKAssociation(this.getObjectID());
            this.getLocalFKIndex().remove(col);
        }
        for (i = 0; i < colnum; ++i) {
            if (fkColumns[i] == null) continue;
            fkColumns[i].addFKAssociation(pkCols[i], this);
            this.getLocalFKIndex().add(fkColumns[i]);
        }
        Object colNames = "";
        ArrayList<FKElement> colList = new ArrayList<FKElement>();
        for (int i2 = 0; i2 < oldCols.length; ++i2) {
            FKElement col = oldCols[i2];
            if (col.getAssociationsCount() != 0 || col.isPreviousColumn()) continue;
            colNames = ((String)colNames).equals("") ? col.getName() : (String)colNames + ", " + col.getName();
            colList.add(col);
        }
        if (colList.size() > 0) {
            if (this.getDesign().isClosing() || this.isSilentRemove()) {
                this.removeColumns(colList);
            } else if (deleteFKcolumns == 0) {
                this.removeColumns(colList);
            } else if (deleteFKcolumns == 2) {
                // empty if block
            }
        }
    }

    private void changeMapping(FKElement[] oldCols, FKElement[] pkCols, FKElement[] fkColumns) {
    }

    private void removeColumns(List<FKElement> colList) {
        for (FKElement col : colList) {
            col.remove();
            this.elementMap.remove(col);
        }
    }

    public FKElement[] getCompatibleColumns(FKElement column) {
        return FKIndexAssociation.getCompatibleColumns((FKContainer)this.getContainerWithKeyObject(), column);
    }

    public FKElement getColumnForDelegate(FKElement delegate) {
        FKElement[] cols = this.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (!cols[i].isReferingTo(this, delegate)) continue;
            return cols[i];
        }
        return null;
    }

    public static FKElement[] getCompatibleColumns(FKContainer container, FKElement column) {
        ArrayList columns = container.getElementsCollection();
        List nestedColumns = container.getNestedElements();
        if (nestedColumns.size() > 0) {
            columns = new ArrayList(columns);
            columns.addAll(nestedColumns);
        }
        return FKIndexAssociation.getCompatibleColumns(columns, column);
    }

    public static FKElement[] getCompatibleColumns(Collection<FKElement> columns, FKElement column) {
        ArrayList<FKElement> col = new ArrayList<FKElement>();
        for (FKElement currentColumn : columns) {
            if (!FKIndexAssociation.compatibleColumns(column, currentColumn)) continue;
            col.add(currentColumn);
        }
        return col.toArray(new FKElement[0]);
    }

    public String getSubstitudeCaption() {
        return "Substitute FK Columns";
    }

    public boolean hasAliveGenerator() {
        return false;
    }

    @Override
    public void showPropertyDialog() {
    }

    public void addFKElementToView(String colName, FKElement fkElement, TableView view) {
        ColumnView columnView = view.getColumnViewByName(colName);
        if (columnView != null) {
            this.getLocalFKIndex().add(columnView);
            ((FKElement)columnView).addFKAssociation(fkElement, this);
            this.elementMap.put(fkElement, columnView);
            columnView.setNullsAllowed(!this.isMandatory());
        }
    }

    public void addFKElement(FKElement fkElement) {
        this.addFKElement(fkElement, false);
    }

    public void addFKElement(FKElement fkElement, boolean searchExisting) {
        ContainerObject originalContainer = this.getOriginalContainer();
        if (!this.getContainerWithKeyObject().isBST() && originalContainer != null) {
            FKContainer table = (FKContainer)this.getContainerWithKeyObject();
            FKElement columnFK = null;
            columnFK = table.getColumnForDelegate(this, fkElement);
            boolean matched = false;
            if (columnFK == null && searchExisting) {
                String fkColName = table.createFKColumnName(fkElement);
                columnFK = table.getEquivelentColumn(fkElement, fkColName, true);
                if (columnFK == null && table instanceof AbstractView) {
                    columnFK = table.getEquivelentColumn(fkElement, fkElement.getName(), true);
                }
                if (columnFK != null) {
                    matched = true;
                }
            }
            if (columnFK == null || !matched && !columnFK.getFKAssociationsForDelegate(fkElement.getObjectID()).contains(this)) {
                columnFK = this.doCreateElementFor(fkElement);
            } else {
                this.getLocalFKIndex().add(columnFK);
                columnFK.addFKAssociation(fkElement, this);
            }
            if (!matched) {
                columnFK.setNullsAllowed(!this.isMandatory());
            }
            this.elementMap.put(fkElement, columnFK);
        }
    }

    protected FKElement doCreateElementFor(FKElement fkElement) {
        FKElement element = this.createElementFor(fkElement);
        if (!element.isNameFixed()) {
            element.setName(fkElement.getName());
        }
        this.elementMap.put(fkElement, element);
        return element;
    }

    public void removeAllFKElements() {
        if (this.keyObject != null) {
            ArrayList<FKElement> col = new ArrayList<FKElement>();
            FKElement[] elements = (FKElement[])this.keyObject.getElements();
            for (int i = 0; i < elements.length; ++i) {
                col.add(elements[i]);
            }
            if (this.keyObject.getElementsCollection().size() > 0) {
                this.removeFKElement(col);
            } else {
                this.removeAssociationFromColumns();
            }
        }
        this.elementMap.clear();
    }

    private void removeAssociationFromColumns() {
        for (FKElement col : this.getLocalFKIndex().getElementsCollection()) {
            col.removeFKAssociation(this.getObjectID());
        }
        this.getLocalFKIndex().getElementsCollection().clear();
    }

    public void removeFKElement(List<FKElement> fkColumns) {
        int deleteFKcolumns = 0;
        String tableName = null;
        Object colNames = "";
        ArrayList<FKElement> colList = new ArrayList<FKElement>();
        Iterator<FKElement> it = fkColumns.iterator();
        while (it.hasNext()) {
            FKElement col = ((FKContainer)this.getContainerWithKeyObject()).getFKColumn(this, it.next());
            if (col == null) continue;
            tableName = col.getContainer().getName();
            this.getLocalFKIndex().remove(col);
            col.removeFKAssociation(this.getObjectID());
            if (this.isColumnUsedInConstraints(col) || col.getAssociationsCount() != 0 || col.isPreviousColumn()) continue;
            colNames = ((String)colNames).equals("") ? col.getName() : (String)colNames + ", " + col.getName();
            colList.add(col);
        }
        if (colList.size() > 0) {
            if (this.getDesign().isClosing() || this.isSilentRemove()) {
                this.removeColumns(colList);
            } else if (deleteFKcolumns == 0) {
                this.removeColumns(colList);
            } else if (deleteFKcolumns == 2) {
                // empty if block
            }
        }
    }

    public void setKeyObject(KeyObject keyObject) {
        if (this.keyObject != keyObject) {
            if (this.keyObject != null) {
                this.keyObject.removeContainerListener(this);
                this.keyObject.removeObjectListener(this.getContainerWithKeyObject());
            }
            this.keyObject = keyObject;
            if (this.keyObject != null) {
                keyObject.addContainerListener(this);
                keyObject.addObjectListener(this.getContainerWithKeyObject());
                this.referredKeyID = keyObject.getObjectID();
            } else {
                this.referredKeyID = null;
            }
        }
    }

    public KeyObject getKeyObject() {
        FKContainer rem;
        if (this.keyObject == null && this.referredKeyID != null && (rem = this.getRemoteTable()) != null && rem.isLoadedCompletely()) {
            this.keyObject = rem.getKeyObject(this.referredKeyID);
        }
        return this.keyObject;
    }

    public String[] getDeleteRuleChoices() {
        return DELETE_RULES;
    }

    public void setDeleteRule(String rule) {
        this.deleteRule = rule != null ? rule : DELETE_RULE_NOTHING;
    }

    public String getDeleteRule() {
        return this.deleteRule;
    }

    public String getValidDeleteRule() {
        StorageDesign sd = ((RelationalDesign)this.getDesignPart()).getStorageDesign();
        if (sd != null) {
            return sd.getValidFKRule(this.deleteRule);
        }
        return this.deleteRule;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    public void addAllFKElements() {
        FKElement[] elements = (FKElement[])this.keyObject.getElements();
        if (!this.getContainerWithKeyObject().isBST() && !this.getOriginalContainer().isBST()) {
            for (int i = 0; i < elements.length; ++i) {
                this.addFKElement(elements[i], false);
            }
        } else if (this.getContainerWithKeyObject().isBST()) {
            if (this.getOriginalContainer().isBST()) {
                FKElement col = (FKElement)this.getContainerWithKeyObject().getExactRefToStructurtedType(this.getOriginalContainer().getBasedOnStructuredType(), this.getOriginalContainer());
                if (col == null) {
                    col = (FKElement)this.getContainerWithKeyObject().getRefToStructurtedType(this.getOriginalContainer().getBasedOnStructuredType(), this.getOriginalContainer());
                }
                if (col != null) {
                    this.setRefFKColumn(col);
                }
            } else {
                for (int i = 0; i < elements.length; ++i) {
                    FKElement keyColumn = elements[i];
                    FKElement[] compatibleColumns = this.getCompatibleColumns(keyColumn);
                    if (compatibleColumns.length != 1) continue;
                    FKElement compatibleColumn = compatibleColumns[0];
                    compatibleColumn.addFKAssociation(keyColumn, this);
                    this.getLocalFKIndex().add(compatibleColumn);
                }
            }
        } else if (elements.length > 0 && !elements[0].isOid()) {
            for (int i = 0; i < elements.length; ++i) {
                this.addFKElement(elements[i]);
            }
        } else {
            FKContainer table = (FKContainer)this.getContainerWithKeyObject();
            table.createRefToStructuredType(this.getOriginalContainer().getBasedOnStructuredType(), this);
        }
    }

    private void setRefFKColumn(FKElement column) {
        FKElement col = (FKElement)this.getOriginalContainer().getOidElement();
        if (col != null) {
            column.addFKAssociation(col, this);
        }
        column.setScopeId(this.getOriginalContainer().getObjectID());
        this.getLocalFKIndex().add(column);
    }

    protected String longNameToName(String longName) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer stok = new StringTokenizer(longName, ".", true);
        while (stok.hasMoreTokens()) {
            String tok = stok.nextToken();
            if (tok.equals(".")) {
                buf.append('_');
                continue;
            }
            buf.append(tok);
        }
        return buf.toString();
    }

    public ContainerObject getOriginalContainer() {
        if (this.getKeyObject() == null) {
            return null;
        }
        return this.getKeyObject().getContainerObject();
    }

    public ContainerWithKeyObject getContainerWithKeyObject() {
        if (this.container == null && this.containerID != null) {
            this.container = (FKContainer)this.getDesign().getDesignObject(this.containerID);
        }
        if (this.container == null && this.containerLongName != null) {
            this.container = (ContainerWithKeyObject)((RelationalDesign)this.getDesignPart()).getTableSet().getByLongName(this.containerLongName);
        }
        if (this.container == null && this.containerLongName != null) {
            this.container = (ContainerWithKeyObject)((RelationalDesign)this.getDesignPart()).getTableViewSet().getByLongName(this.containerLongName);
        }
        return this.container;
    }

    @Override
    public String getLongName() {
        if (this.getTable() != null) {
            SchemaObject so = this.getTable().getSchemaObject();
            if (so != null) {
                return new StringBuffer(so.getLongName()).append('.').append(this.getName()).toString();
            }
            return this.getName();
        }
        return this.getName();
    }

    @Override
    public String getVeryLongName() {
        if (this.container != null) {
            SchemaObject so = this.container.getSchemaObject();
            if (so != null) {
                StringBuffer buffer = new StringBuffer(so.getName());
                buffer.append(".").append(this.container.getName()).append(".").append(this.getName());
                return buffer.toString();
            }
            StringBuffer buffer = new StringBuffer(this.container.getName());
            buffer.append(".").append(this.getName());
            return buffer.toString();
        }
        return this.getName();
    }

    @Override
    public void copy(DesignObject desObject) throws IOException {
        super.copy(desObject);
        FKIndexAssociation newAssociation = (FKIndexAssociation)desObject;
        newAssociation.setDeleteRule(this.getDeleteRule());
        newAssociation.setMandatory(this.isMandatory());
        newAssociation.setTransferable(this.isTransferable());
        newAssociation.setArc(this.getArc());
        FKContainer nt = newAssociation.getRemoteTable();
        FKElement col = this.getDiscriminatorColumn();
        if (col != null && nt != null) {
            FKElement dcol = null;
            if (nt.isRemoteObject()) {
                dcol = (FKElement)nt.getElementByRemoteObjectID(col.getObjectID());
            }
            if (dcol == null) {
                dcol = (FKElement)nt.getElementByID(col.getObjectID());
            }
            if (dcol == null) {
                dcol = (FKElement)nt.getElementByName(col.getName());
            }
            if (dcol != null) {
                newAssociation.setDiscriminatorColumn(dcol);
            }
        }
        newAssociation.setReferredColumnNames(this.getReferredColumnNames());
        newAssociation.setReferredTableLongName(this.getReferredTableLongName());
        newAssociation.setDiscriminatorValue(this.getDiscriminatorValue());
        newAssociation.setColumnDependencyConstraintGenerateName(this.getColumnDependencyConstraintGenerateName());
        newAssociation.setColumnDependencyConstraintGenerateInDDL(this.isColumnDependencyConstraintGenerateInDDL());
        newAssociation.setRely(this.isRely());
        newAssociation.setConstraintDeferrable(this.isConstraintDeferrable());
        newAssociation.setConstraintInitiallyImediate(this.isConstraintInitiallyImediate());
        newAssociation.setConstraintEnable(this.isConstraintEnable());
        newAssociation.setConstraintValidate(this.isConstraintValidate());
    }

    @Override
    public DesignObject getSourceObject() {
        return this.getRemoteTable();
    }

    @Override
    public DesignObject getTargetObject() {
        return this.getContainerWithKeyObject();
    }

    public boolean hasColumnWithAllowNulls() {
        FKElement[] columns = this.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].getNullsAllowed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean setName(String name) {
        KeyObject localFKIndex;
        boolean result = super.setName(name);
        if (this.getDesign().isTempVar()) {
            return result;
        }
        if (result && (localFKIndex = this.getLocalFKIndex()) != null) {
            localFKIndex.setName(this.getName());
        }
        return result;
    }

    @Override
    public void setMarkedGenerate(boolean markedGenerate) {
        super.setMarkedGenerate(markedGenerate);
        if (this.getLocalFKIndex() != null) {
            this.getLocalFKIndex().synchronizeMarkedGenerate(markedGenerate);
        }
    }

    public void synchronizeMarkedGenerate(boolean markedGenerate) {
        super.setMarkedGenerate(markedGenerate);
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        FKElement[] cols;
        if (this.getDesign().isLoading()) {
            this.mandatory = mandatory;
            return;
        }
        boolean hasMandatory = false;
        boolean hasOptional = false;
        for (FKElement co : cols = this.getColumns()) {
            boolean optional = co.getNullsAllowed();
            if (optional) {
                hasOptional = true;
                continue;
            }
            hasMandatory = true;
        }
        if (this.mandatory != mandatory) {
            this.mandatory = mandatory;
            this.setDirty(true);
        }
        KeyObject pk = this.getContainerWithKeyObject().getPK();
        if (!mandatory && !hasOptional) {
            for (int i = cols.length - 1; i >= 0; --i) {
                FKElement co = cols[i];
                if (pk != null && pk.contains(co) || co.isInMandatoryFK() || co.getNullsAllowed()) continue;
                co.setNullsAllowed(true);
                co.setDirty(true);
            }
        } else if (mandatory && hasOptional) {
            for (FKElement co : this.getLocalFKIndex().getElementsCollection()) {
                boolean optional = co.getNullsAllowed();
                if (!optional) continue;
                co.setNullsAllowed(false);
                co.setDirty(true);
            }
        }
        if (mandatory && DELETE_RULE_SET_NULL.equals(this.getDeleteRule())) {
            this.setDeleteRule(DELETE_RULE_NOTHING);
            this.resetEdgeParams();
        }
        this.resetDependentColumns(mandatory);
    }

    private void resetDependentColumns(boolean mandatory) {
        List list = this.getTable().getColumnsDependinOn(this);
        for (FKElement col : list) {
            if (mandatory) {
                if (col.isMandatory()) continue;
                col.setMandatory(col.isDependOnFK_AsMandatory());
                continue;
            }
            if (!col.isMandatory()) continue;
            col.setDependOnFK_AsMandatory(true);
            col.setMandatory(false);
        }
    }

    public boolean canBeOptional() {
        KeyObject pk = this.getTable().getPK();
        if (pk != null) {
            for (FKElement co : this.getLocalFKIndex().getElementsCollection()) {
                if (!pk.contains(co)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isTransferable() {
        return this.transferable;
    }

    public void setTransferable(boolean transferable) {
        this.transferable = transferable;
    }

    public FKArc getArc() {
        return this.arc;
    }

    public void setArc(FKArc arc) {
        this.arc = arc;
    }

    public boolean isInArc() {
        return this.arc != null;
    }

    public void resetEdgeParams() {
    }

    public void createDefaultSelfReferencePoints() {
    }

    public void resetMandatoryUsingColumns() {
        if (this.getLocalFKIndex() != null) {
            boolean hasNulls = false;
            boolean hasNotNulls = false;
            boolean pkelem = false;
            for (FKElement co : this.getLocalFKIndex().getElementsCollection()) {
                if (co.isPKElement()) {
                    pkelem = true;
                }
                if (co.getNullsAllowed()) {
                    hasNulls = true;
                    continue;
                }
                hasNotNulls = true;
            }
            boolean mand = false;
            if (hasNulls && hasNotNulls) {
                mand = false;
            } else if (hasNotNulls) {
                mand = true;
            }
            if (RESET_COLUMNS_IN_RESETMANDATORY_FROM_COLUMNS) {
                this.setMandatory(mand);
            } else {
                this.mandatory = mand;
            }
            if (this.mandatory && DELETE_RULE_SET_NULL.equals(this.getDeleteRule())) {
                this.setDeleteRule(DELETE_RULE_NOTHING);
            }
            this.resetEdgeParams();
        }
    }

    @Override
    public List getAllViews() {
        return this.getAllTVRelations();
    }

    public boolean canRemoveColumnAutomaticaly(FKElement column) {
        FKContainer table = (FKContainer)column.getContainerWithKeyObject();
        KeyObject index = this.getLocalFKIndex();
        if (table != this.getContainerWithKeyObject()) {
            return false;
        }
        if (column.isPreviousColumn()) {
            return false;
        }
        boolean deleteFKcolumns = false;
        if (deleteFKcolumns) {
            return false;
        }
        KeyObject[] keys = table.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            KeyObject key = keys[i];
            if (key == index || !key.isFK() && !key.isPK() && !key.isUnique() || !key.contains(column)) continue;
            return false;
        }
        return true;
    }

    public List getAutomaticallyRemovedcolumns() {
        ArrayList<FKElement> list = new ArrayList<FKElement>();
        for (FKElement column : this.getLocalFKIndex().getElementsCollection()) {
            if (!this.canRemoveColumnAutomaticaly(column)) continue;
            list.add(column);
        }
        return list;
    }

    private boolean isColumnUsedInConstraints(FKElement column) {
        FKContainer table = (FKContainer)this.getContainerWithKeyObject();
        KeyObject index = this.getLocalFKIndex();
        KeyObject[] keys = table.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            KeyObject key = keys[i];
            if (key == index || !key.isFK() && !key.isPK() && !key.isUnique() || !key.contains(column)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DesignObject getObject() {
        return this;
    }

    public boolean isBackupFK() {
        return this.originatingFK != null;
    }

    public FKIndexAssociation getOriginatingFK() {
        return this.originatingFK;
    }

    public void resetFromMemento(FKMemento mem) {
        if (mem.fk != this) {
            throw new RuntimeException("FKMemento object is for another Foreign key");
        }
        this.setNameFixed(mem.name_fixed);
        this.setName(mem.name);
        this.setComment(mem.comments);
        this.setNotes(mem.notes);
        this.setMarkedGenerate(mem.generate_in_DDL);
        this.setDeprecated(mem.cdcDeprecated);
        this.getLocalFKIndex().setMarkedGenerate(mem.generate_in_DDL);
        this.setDeleteRule(mem.deleteRule);
        this.setTransferable(mem.transferable);
        FKElement[] fkColumns = FKIndexAssociation.getFKColumnsFromTable(mem, (FKContainer)this.getContainerWithKeyObject());
        this.changeKeyObject(mem.remoteKey, fkColumns);
        this.setMandatory(mem.mandatory);
        this.setDiscriminatorColumn(mem.discrColumn);
        this.setDiscriminatorValue(mem.discrValue);
        this.setColumnDependencyConstraintGenerateName(mem.cdcName);
        this.setColumnDependencyConstraintGenerateInDDL(mem.cdcGenerateInDDL);
        this.setRely(mem.rely);
        this.getTable().setDirty(true);
        this.resetEdgeParams();
    }

    public static FKElement[] getFKColumnsFromTable(FKMemento fkMemento, FKContainer table) {
        ArrayList<FKElement> list = new ArrayList<FKElement>();
        for (int i = 0; i < fkMemento.columns.size(); ++i) {
            String columnID = fkMemento.columns.get(i);
            FKElement column = null;
            if (columnID == null || (column = (FKElement)table.getElementByID(columnID)) == null) continue;
            list.add(column);
        }
        return list.toArray(new FKElement[0]);
    }

    public void setNewFK(FKIndexAssociation fk) {
        this.setName(fk.name);
        this.setComment(fk.getComment());
        this.setNotes(fk.getNotes());
        this.setMarkedGenerate(fk.isMarkedGenerate());
        this.setDeleteRule(fk.deleteRule);
        this.setTransferable(fk.transferable);
        this.setMandatory(fk.mandatory);
        this.setColumnDependencyConstraintGenerateName(fk.columnDependencyConstraintGenerateName);
        this.setColumnDependencyConstraintGenerateInDDL(fk.columnDependencyConstraintGenerateInDDL);
        this.getTable().setDirty(true);
        this.resetEdgeParams();
    }

    @Override
    public String getStorageName() throws IOException {
        if (this.storageName == null) {
            this.storageName = new File(this.getDesignPart().getStoragePath(), "foreignkey/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        return this.storageName;
    }

    public boolean isSilentRemove() {
        return this.silentRemove;
    }

    public void setSilentRemove(boolean silentRemove) {
        this.silentRemove = silentRemove;
    }

    public boolean isOneToOne() {
        FKElement[] cols = (FKElement[])this.getLocalFKIndex().getElements();
        Iterator it = this.getTable().getKeySet().iterator();
        while (it.hasNext()) {
            KeyObject key = (KeyObject)it.next();
            if (!key.isPK() && !key.isUnique() && !"Unique Plain Index".equalsIgnoreCase(key.getIndexState()) || key.getElementsCollection().size() != cols.length) continue;
            boolean hasit = true;
            for (int i = 0; i < cols.length; ++i) {
                if (key.contains(cols[i])) continue;
                hasit = false;
                break;
            }
            if (!hasit) continue;
            return true;
        }
        return false;
    }

    public boolean isIdentifyingForPK() {
        FKElement[] cols = (FKElement[])this.getLocalFKIndex().getElements();
        Iterator it = this.getTable().getKeySet().iterator();
        while (it.hasNext()) {
            KeyObject key = (KeyObject)it.next();
            if (!key.isPK() || key.getElementsCollection().size() < cols.length) continue;
            boolean hasit = true;
            for (int i = 0; i < cols.length; ++i) {
                if (key.contains(cols[i])) continue;
                hasit = false;
                break;
            }
            if (!hasit) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToTable() {
        FKContainer table = (FKContainer)this.getContainerWithKeyObject();
        if (table != null && table.isLoadedCompletely() && !table.getFKAssociationsList().contains(this)) {
            boolean pk_prop = this.getDesign().isPropagatePKChahges();
            try {
                String segm_name = this.getDirectorySegmentName();
                this.getDesign().setPropagatePKChahges(false);
                table.addRecreateFKAssociation(this);
                this.setDirectorySegmentName(segm_name, true);
            }
            catch (Exception exception) {
            }
            finally {
                this.getDesign().setPropagatePKChahges(pk_prop);
            }
        }
    }

    @Override
    public String toString() {
        return this.getVeryLongName();
    }

    @Override
    public Collection getAffectedDPVs() {
        ArrayList list = new ArrayList();
        return list;
    }

    public String getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    public void setDiscriminatorValue(String discriminatorValue) {
        this.discriminatorValue = discriminatorValue;
    }

    public FKElement getDiscriminatorColumn() {
        Column col;
        if (this.arc != null && (col = this.arc.getDiscriminatorColumn()) != null) {
            return col;
        }
        return this.discriminatorColumn;
    }

    public FKElement getDiscriminatorColumnToStore() {
        if (this.arc != null && this.arc.getDiscriminatorColumn() != null) {
            return null;
        }
        return this.discriminatorColumn;
    }

    public void setDiscriminatorColumn(FKElement discriminatorColumn) {
        this.discriminatorColumn = discriminatorColumn;
    }

    public DesignObject getTempObject() {
        return new FKIndexAssociation(this.getDesignPart());
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        Design design = this.getDesign();
        if (design != null) {
            DesignObject result = design.getDesignObject(id);
            if (result == null) {
                Map map = design.getCorrespondenceMap();
                if (map != null) {
                    result = map.get(id);
                }
                if (result == null && this.getRemoteObjectID() != null && "containerWithKeyObject".equals(propertyName)) {
                    result = ((RelationalDesign)this.getDesignPart()).getTableSet().getObjectByRemoteObjectID(id);
                }
                if (result == null && this.getRemoteObjectID() != null && "localFKIndex".equals(propertyName)) {
                    result = this.getTable().getKeySet().getObjectByRemoteObjectID(id);
                }
                if (result == null && "localFKIndex".equals(propertyName)) {
                    result = this.getTable().getKeySet().getByName(id);
                }
                return result;
            }
            return result;
        }
        return null;
    }

    public boolean isColumnDependencyConstraintGenerateInDDL() {
        return this.columnDependencyConstraintGenerateInDDL;
    }

    public void setColumnDependencyConstraintGenerateInDDL(boolean columnDependencyConstraintGenerateInDDL) {
        this.columnDependencyConstraintGenerateInDDL = columnDependencyConstraintGenerateInDDL;
    }

    public String getColumnDependencyConstraintGenerateName() {
        return this.columnDependencyConstraintGenerateName;
    }

    public void setColumnDependencyConstraintGenerateName(String columnDependencyConstraintGenerateName) {
        this.columnDependencyConstraintGenerateName = columnDependencyConstraintGenerateName;
    }

    public String getReferredTableID() {
        KeyObject key = this.getKeyObject();
        if (key != null && key.getContainerWithKeyObject() != null) {
            this.referredTableID = key.getContainerWithKeyObject().getObjectID();
        }
        return this.referredTableID;
    }

    public void setReferredTableID(String referredTableID) {
        this.referredTableID = referredTableID;
    }

    public String getContainerID() {
        FKContainer co = (FKContainer)this.getContainerWithKeyObject();
        if (!(co == null || co.isRemoved() && this.containerID != null)) {
            this.containerID = co.getObjectID();
        }
        return this.containerID;
    }

    public void setContainerID(String containerID) {
        this.containerID = containerID;
    }

    public String getReferredKeyID() {
        KeyObject key = this.getKeyObject();
        if (key != null) {
            this.referredKeyID = key.getObjectID();
        }
        return this.referredKeyID;
    }

    public void setReferredKeyID(String referredKeyID) {
        this.referredKeyID = referredKeyID;
    }

    public String getContainerLongName() {
        ContainerWithKeyObject container = this.getContainerWithKeyObject();
        if (container != null) {
            return container.getLongName();
        }
        return this.containerLongName != null ? this.containerLongName : "";
    }

    public void setContainerLongName(String name) {
        this.containerLongName = name;
    }

    public String getReferredTableLongName() {
        FKContainer remoteContainer = this.getRemoteTable();
        if (remoteContainer != null) {
            return remoteContainer.getLongName();
        }
        if (this.referredTableLongName == null) {
            return "";
        }
        return this.referredTableLongName;
    }

    public void setReferredTableLongName(String name) {
        this.referredTableLongName = name;
    }

    public String getFormattedReferredTableLongName() {
        StorageDesign sd = ((RelationalDesign)this.getDesignPart()).getStorageDesign();
        FKContainer remoteContainer = this.getRemoteTable();
        if (remoteContainer != null) {
            return sd.getFormatedLongNameDDL(remoteContainer);
        }
        if (this.referredTableLongName == null) {
            return "";
        }
        String name = this.referredTableLongName;
        if (!this.getDesign().getSettings().isIncludeSchemaInDDL()) {
            name = name.substring(name.indexOf(46));
        }
        return sd.getFormatedName(name);
    }

    public String getReferredKeyName() {
        KeyObject remoteKey = this.getKeyObject();
        if (remoteKey != null) {
            return remoteKey.getName();
        }
        if (this.referredKeyName == null) {
            return "";
        }
        return this.referredKeyName;
    }

    public void setReferredKeyName(String name) {
        this.referredKeyName = name;
    }

    public boolean isRely() {
        return this.rely;
    }

    public void setRely(boolean rely) {
        this.rely = rely;
    }

    public int getNumberOfColumns() {
        if (this.getLocalFKIndex() == null) {
            return 0;
        }
        return this.getLocalFKIndex().getElementsCollection().size();
    }

    public boolean isAllColumnGenerated() {
        FKElement[] cols = (FKElement[])this.getLocalFKIndex().getElements();
        for (int i = 0; i < cols.length; ++i) {
            FKElement col = cols[i];
            if (!col.isPreviousColumn()) continue;
            return false;
        }
        return true;
    }

    public String getLocalFKColumnNames() {
        KeyObject fki = this.getLocalFKIndex();
        if (fki != null && fki.getElementsCollection().size() > 0) {
            this.localFKColumnNames = "";
            boolean first = true;
            RelationalDesign rd = (RelationalDesign)this.getDesignPart();
            for (DesignObject dob : fki.getElementsCollection()) {
                String name = dob.getFormatedName(rd.getStorageDesign());
                if (!first) {
                    this.localFKColumnNames = this.localFKColumnNames + ",";
                } else {
                    first = false;
                }
                this.localFKColumnNames = this.localFKColumnNames + name;
            }
        }
        if (this.localFKColumnNames == null) {
            return "";
        }
        return this.localFKColumnNames;
    }

    public void setLocalFKColumnNames(String localFKColumnNames) {
        this.localFKColumnNames = localFKColumnNames;
    }

    public String getReferredColumnNames() {
        KeyObject remoteKey = this.getKeyObject();
        if (remoteKey != null && remoteKey.getElementsCollection().size() > 0) {
            this.referredColumnNames = "";
            boolean first = true;
            RelationalDesign rd = (RelationalDesign)this.getDesignPart();
            for (DesignObject dob : remoteKey.getElementsCollection()) {
                String name = dob.getFormatedName(rd.getStorageDesign());
                if (!first) {
                    this.referredColumnNames = this.referredColumnNames + ",";
                } else {
                    first = false;
                }
                this.referredColumnNames = this.referredColumnNames + name;
            }
        }
        if (this.referredColumnNames == null) {
            return "";
        }
        return this.referredColumnNames;
    }

    public void setReferredColumnNames(String referredColumnNames) {
        this.referredColumnNames = referredColumnNames;
    }

    @Override
    public TopView getSourceTopView(DesignPartView dpv) {
        return this.getSourceTV(dpv);
    }

    @Override
    public TopView getTargetTopView(DesignPartView dpv) {
        return this.getTargetTV(dpv);
    }

    @Override
    public void setSourceTopView(TopView source) {
        this.setSourceTVTable((ContainerView)source);
    }

    @Override
    public void setTargetTopView(TopView target) {
        this.setTargetTVTable((ContainerView)target);
    }

    @Override
    public void removeTopView(TopView view) {
    }

    @Override
    public void restoreTopView(TopView tv, TopView sourceTV, TopView targetTV) {
    }

    public boolean isSelfReference() {
        return this.getSourceObject() == this.getTargetObject();
    }

    public boolean containsElement(FKElement element) {
        KeyObject key = this.getLocalFKIndex();
        return key != null && key.contains(element);
    }

    public boolean isConstraintDeferrable() {
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof FKProxyOracle) {
            FKProxyOracle cp = (FKProxyOracle)pr;
            return "YES".equalsIgnoreCase(cp.getDeferrable());
        }
        return this.constraintDeferrable;
    }

    public void setConstraintDeferrable(boolean constraintDeferrable) {
        this.constraintDeferrable = constraintDeferrable;
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof FKProxyOracle) {
            FKProxyOracle cp = (FKProxyOracle)pr;
            cp.setDeferrable(constraintDeferrable ? "YES" : "NO");
        }
    }

    public boolean isConstraintInitiallyImediate() {
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof FKProxyOracle) {
            FKProxyOracle cp = (FKProxyOracle)pr;
            return "IMMEDIATE".equalsIgnoreCase(cp.getInitially());
        }
        return this.constraintInitiallyImediate;
    }

    public void setConstraintInitiallyImediate(boolean constraintInitiallyImediate) {
        this.constraintInitiallyImediate = constraintInitiallyImediate;
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof FKProxyOracle) {
            FKProxyOracle cp = (FKProxyOracle)pr;
            cp.setInitially(constraintInitiallyImediate ? "IMMEDIATE" : "DEFERRED");
        }
    }

    public boolean isConstraintEnable() {
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof FKProxyOracle) {
            FKProxyOracle cp = (FKProxyOracle)pr;
            return "YES".equalsIgnoreCase(cp.getEnable());
        }
        return this.constraintEnable;
    }

    public void setConstraintEnable(boolean constraintEnable) {
        this.constraintEnable = constraintEnable;
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof FKProxyOracle) {
            FKProxyOracle cp = (FKProxyOracle)pr;
            cp.setEnable(constraintEnable ? "YES" : "NO");
        }
    }

    public boolean isConstraintValidate() {
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof FKProxyOracle) {
            FKProxyOracle cp = (FKProxyOracle)pr;
            return "YES".equalsIgnoreCase(cp.getValidate());
        }
        return this.constraintValidate;
    }

    public void setConstraintValidate(boolean constraintValidate) {
        this.constraintValidate = constraintValidate;
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof FKProxyOracle) {
            FKProxyOracle cp = (FKProxyOracle)pr;
            cp.setValidate(constraintValidate ? "YES" : "NO");
        }
    }

    @Override
    public StorageObject getProxyObject() {
        if (this.physicalProperties != null) {
            return this.physicalProperties;
        }
        if (this.fkIndex != null) {
            return this.fkIndex.getProxyObject();
        }
        return null;
    }

    public String getJoinedColumns() {
        Object res = "";
        KeyObject fki = this.getLocalFKIndex();
        if (fki != null && fki.getElementsCollection().size() > 0) {
            boolean first = true;
            for (DesignObject dob : fki.getElementsCollection()) {
                if (!first) {
                    res = (String)res + ",";
                } else {
                    first = false;
                }
                res = (String)res + dob.getLongName();
            }
            res = (String)res + " - ";
            if (this.getRemoteIndex() != null) {
                first = true;
                for (DesignObject dob : this.getRemoteIndex().getElementsCollection()) {
                    if (!first) {
                        res = (String)res + ",";
                    } else {
                        first = false;
                    }
                    res = (String)res + dob.getLongName();
                }
            } else if (!this.getReferredColumnNames().isEmpty()) {
                String[] parts = this.getReferredColumnNames().split(",");
                Object t = "";
                for (String part : parts) {
                    if (!((String)t).isEmpty()) {
                        t = (String)t + ",";
                    }
                    t = (String)t + this.getReferredTableLongName() + "." + part;
                }
                res = (String)res + (String)t;
            }
        }
        return res;
    }

    public class FKConnection {
        FKContainer child;
        FKContainer parent;
        public int countAdded = 0;

        public void setChildTable(FKContainer table) {
            this.child = table;
        }

        public FKContainer getChildTable() {
            return this.child;
        }

        public void setParentTable(FKContainer table) {
            this.parent = table;
        }

        public FKContainer getParentTable() {
            return this.parent;
        }

        public String toString() {
            return FKIndexAssociation.this.getName();
        }

        public FKIndexAssociation getFKIndexAssociation() {
            return FKIndexAssociation.this;
        }

        public ContainerView getSourceTV(DesignPartView dpv) {
            return FKIndexAssociation.this.getSourceTV(dpv);
        }

        public ContainerView getTargetTV(DesignPartView dpv) {
            return FKIndexAssociation.this.getTargetTV(dpv);
        }
    }

    public class dpvInfo {
        public ContainerView sourceTV;
        public ContainerView targetTV;
        public TopView tv;
        public DesignPartView dpv;

        dpvInfo() {
        }
    }

    public class FKMemento {
        public FKIndexAssociation fk;
        public String comments = "";
        public String notes = "";
        public String name;
        public String id;
        public String index_id;
        public boolean mandatory;
        public boolean transferable;
        public boolean generate_in_DDL;
        public boolean name_fixed;
        public FKContainer table;
        public FKContainer remoteTable;
        public String remoteKeyID;
        public KeyObject remoteKey;
        public List<String> columns = new ArrayList<String>();
        public String deleteRule = "";
        public FKArc arc;
        public FKElement discrColumn;
        public String discrValue = "";
        public String cdcName = "";
        public boolean cdcGenerateInDDL;
        public boolean cdcDeprecated;
        public boolean rely;

        public FKMemento(FKIndexAssociation fk) {
            this.fk = fk;
        }

        public void copyTo(FKMemento mem) {
            mem.comments = this.comments;
            mem.notes = this.notes;
            mem.name = this.name;
            mem.id = this.id;
            mem.index_id = this.index_id;
            mem.mandatory = this.mandatory;
            mem.transferable = this.transferable;
            mem.generate_in_DDL = this.generate_in_DDL;
            mem.table = this.table;
            mem.remoteTable = this.remoteTable;
            mem.remoteKeyID = this.remoteKeyID;
            mem.remoteKey = this.remoteKey;
            mem.columns.addAll(this.columns);
            mem.deleteRule = this.deleteRule;
            mem.arc = this.arc;
            mem.discrColumn = this.discrColumn;
            mem.discrValue = this.discrValue;
            mem.name_fixed = this.name_fixed;
            mem.cdcName = this.cdcName;
            mem.cdcGenerateInDDL = this.cdcGenerateInDDL;
            mem.cdcDeprecated = this.cdcDeprecated;
            mem.rely = this.rely;
        }
    }
}

