/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage.oracle;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.compare.storage.oracle.TableComparatorOracle;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.oracle.MaterializedViewLogOracle;

public class MViewLogComparator
extends StoragePropertiesComparator {
    public static final String COLUMNS = MViewLogComparator.getPropertyNameOracle("MaterializedViewLogPropertyDialogOraclev10g.Columns");
    public static final String COLUMN_NAMES = "columnNames";
    public static final String CACHE = "Cache";
    public static final String RowIDLogged = MViewLogComparator.getPropertyNameOracle("MaterializedViewLogPropertyDialogOraclev10g.RowIDLogged");
    public static final String PKLogged = MViewLogComparator.getPropertyNameOracle("MaterializedViewLogPropertyDialogOraclev10g.PKLogged");
    public static final String Degree = MViewLogComparator.getPropertyNameOracle("MaterializedViewLogPropertyDialogOraclev10g.Degree");
    public static final String Parallel = MViewLogComparator.getPropertyNameOracle("MaterializedViewLogPropertyDialogOraclev10g.Parallel");
    public static final String NewValues = MViewLogComparator.getPropertyNameOracle("MaterializedViewLogPropertyDialogOraclev10g.NewValues");
    public static final String SequenceLogged = MViewLogComparator.getPropertyNameOracle("MaterializedViewLogPropertyDialogOraclev10g.SequenceLogged");
    public static final String PURGE_TYPE = MViewLogComparator.getPropertyNameOracle("MaterializedViewLogPropertyDialogOraclev9i.PurgeType");
    public static final String PURGE_START = MViewLogComparator.getPropertyNameOracle("MaterializedViewLogPropertyDialogOraclev9i.PurgeStart");
    public static final String PURGE_NEXT = MViewLogComparator.getPropertyNameOracle("MaterializedViewLogPropertyDialogOraclev9i.PurgeNext");
    public static final String PURGE_REPEAT = MViewLogComparator.getPropertyNameOracle("MaterializedViewLogPropertyDialogOraclev9i.PurgeRepeat");
    public static final String COMMIT_SCN = MViewLogComparator.getPropertyNameOracle("MaterializedViewLogPropertyDialogOraclev9i.CommitSCN");
    public static final String OBJECT_ID_LOGGED = MViewLogComparator.getPropertyNameOracle("MaterializedViewLogPropertyDialogOraclev9i.ObjectIDLogged");
    public static final String REFRESH_TYPE = MViewLogComparator.getPropertyNameOracle("MaterializedViewLogPropertyDialogOraclev9i.RefreshType");
    public static final String STAGING_LOG = MViewLogComparator.getPropertyNameOracle("MaterializedViewLogPropertyDialogOraclev9i.StagingLog");
    private MaterializedViewLogOracle sourceMVLog;
    private MaterializedViewLogOracle targetMVLog;

    public MViewLogComparator(MaterializedViewLogOracle sourceMVLog, MaterializedViewLogOracle targetMVLog) {
        super(sourceMVLog, targetMVLog);
        this.sourceMVLog = sourceMVLog;
        this.targetMVLog = targetMVLog;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentProperty();
        this.initColumnsProperty();
        this.initProperty(RowIDLogged, "rowIDLogged");
        this.initProperty(PKLogged, "pkLogged");
        this.initProperty(OBJECT_ID_LOGGED, "objectIDLogged");
        this.initProperty(SequenceLogged, "sequenceLogged");
        this.initProperty(NewValues, "newValues");
        this.initProperty(COMMIT_SCN, "commitSCN");
        this.initProperty(Parallel, "parallelDegree");
        this.initProperty(Degree, "degree");
        this.initProperty(CACHE, "cache");
        this.initProperty(PURGE_TYPE, "purgeType");
        this.initProperty(PURGE_START, "purgeSWExpression");
        this.initProperty(PURGE_NEXT, "purgeNextExpression");
        this.initProperty(PURGE_REPEAT, "purgeRIExpression");
        this.initProperty(TABLESPACE, "tablespace");
        this.initProperty(TableComparatorOracle.LOGGING, "logging");
        this.initProperty(PCT_FREE, "percentFree");
        this.initProperty(PCT_USED, "percentUsed");
        this.initProperty(INIT_TRANS, "initrans");
        this.initProperty(SC_INITIAL_EXTENT, "initialExtent");
        this.initProperty(SC_NEXT_EXTENT, "nextExtent");
        this.initProperty(SC_MIN_EXTENTS, "minExtent");
        this.initProperty(SC_MAX_EXTENTS, "maxExtent");
        this.initProperty(SC_PCT_INCREASE, "percentIncrease");
    }

    private void initColumnsProperty() {
        PropertyHolder ph = new PropertyHolder(COLUMN_NAMES);
        ph.setLeftValue(this.sourceMVLog != null ? this.getListAsString(this.sourceMVLog.getSortedColumnNamesList()) : "");
        ph.setRightValue(this.targetMVLog != null ? this.getListAsString(this.targetMVLog.getSortedColumnNamesList()) : "");
        if (this.isExcludedFromComparison(COLUMN_NAMES) || this.isExcludeNamesFromComparison(ph)) {
            ph.setExcluded(true);
        } else if (!(this.sourceMVLog == null || this.targetMVLog == null || ph.getLeftValue().equals(ph.getRightValue()) || !this.caseSensitive && ph.getLeftValue().equalsIgnoreCase(ph.getRightValue()))) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    private String getListAsString(List<String> list) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (String s : list) {
            if (first) {
                sb.append(s);
                first = false;
                continue;
            }
            sb.append(" \n").append(s);
        }
        return sb.toString();
    }

    public boolean hasRemovedLogItems() {
        Map<String, EngPropertyHolder> map = this.getPropertiesMap();
        if (this.loggedColumnRemoved(map)) {
            return true;
        }
        EngPropertyHolder ph = map.get(RowIDLogged);
        if (ph != null && "NO".equalsIgnoreCase(ph.getLeftValue())) {
            return true;
        }
        ph = map.get(PKLogged);
        if (ph != null && "NO".equalsIgnoreCase(ph.getLeftValue())) {
            return true;
        }
        ph = map.get(SequenceLogged);
        if (ph != null && "NO".equalsIgnoreCase(ph.getLeftValue())) {
            return true;
        }
        ph = map.get(OBJECT_ID_LOGGED);
        if (ph != null && "NO".equalsIgnoreCase(ph.getLeftValue())) {
            return true;
        }
        ph = map.get(COMMIT_SCN);
        return ph != null;
    }

    @Override
    protected boolean hasToBeRename() {
        if (this.hasRemovedLogItems()) {
            return true;
        }
        return super.hasToBeRename();
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.sourceMVLog == null && this.targetMVLog != null) {
            return true;
        }
        return super.hasToBeDrop();
    }

    public boolean loggedColumnRemoved(Map<String, EngPropertyHolder> propMap) {
        EngPropertyHolder ph = propMap.get(COLUMN_NAMES);
        if (ph != null) {
            String lv = ph.getLeftValue().trim();
            String rv = ph.getRightValue().trim();
            if (lv.isEmpty() && !rv.isEmpty()) {
                return true;
            }
            if (rv.isEmpty()) {
                return false;
            }
            String[] names = ph.getLeftValue().split("\n");
            HashMap<String, String> map = new HashMap<String, String>();
            for (String name : names) {
                map.put(name.trim().toUpperCase(), name);
            }
            for (String name : names = ph.getRightValue().split("\n")) {
                if (map.get(name.trim().toUpperCase()) != null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isExcludedFromComparison(String propertyName) {
        return false;
    }

    public static void main(String[] args) {
    }
}

