/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage.oracle;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.storage.oracle.HierarchyOracle;
import oracle.dbtools.crest.model.metadata.ClassDescription;

public class HierarchyComparatorOracle
extends StoragePropertiesComparator {
    public static final String LEVELS = Messages.getString("DimensionOracle.Levels");
    public static final String JOIN_CLAUSE = HierarchyComparatorOracle.getPropertyNameOracle("HierarchyPropertyDialogOracle.JoinClause");
    private HierarchyOracle sourceHierarchy;
    private HierarchyOracle targetHierarchy;

    public HierarchyComparatorOracle(HierarchyOracle sourceHierarchy, HierarchyOracle targetHierarchy) {
        super(sourceHierarchy, targetHierarchy);
        this.sourceHierarchy = sourceHierarchy;
        this.targetHierarchy = targetHierarchy;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentProperty();
        PropertyHolder ph = new PropertyHolder(LEVELS);
        String leftLevels = this.getLevels(this.sourceHierarchy);
        String rightLevels = this.getLevels(this.targetHierarchy);
        ph.setLeftValue(leftLevels);
        ph.setRightValue(rightLevels);
        if (this.isExcludedFromComparison(LEVELS)) {
            ph.setExcluded(true);
        } else if (this.sourceHierarchy != null && this.targetHierarchy != null && !leftLevels.equals(rightLevels)) {
            ph.setModified(true);
            ph.setSelected(true);
            if (this.classDescr != null) {
                ClassDescription.PropertyDescription propDescr = this.classDescr.getPropertyDescriptionByName("levels");
                ph.setPropertyDescription(propDescr);
            }
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(JOIN_CLAUSE);
        String leftJoins = this.getJoinClause(this.sourceHierarchy);
        String rightJoins = this.getJoinClause(this.targetHierarchy);
        ph.setLeftValue(leftJoins);
        ph.setRightValue(rightJoins);
        if (this.isExcludedFromComparison(JOIN_CLAUSE)) {
            ph.setExcluded(true);
        } else if (this.sourceHierarchy != null && this.targetHierarchy != null && !leftJoins.equals(rightJoins)) {
            ph.setModified(true);
            ph.setSelected(true);
            if (this.classDescr != null) {
                ClassDescription.PropertyDescription propDescr = this.classDescr.getPropertyDescriptionByName("joins");
                ph.setPropertyDescription(propDescr);
            }
        }
        this.propertiesList.add(ph);
    }

    private String getLevels(HierarchyOracle hierarchy) {
        Object levelNames = "";
        if (hierarchy != null) {
            boolean first = true;
            for (String levelId : hierarchy.getLevelSet()) {
                ModelIDObject level = hierarchy.getStorageDesignOracle().getLevelSet().getById(levelId);
                if (level == null) continue;
                if (first) {
                    first = false;
                    levelNames = level.getName();
                    continue;
                }
                levelNames = (String)levelNames + ", " + level.getName();
            }
        }
        return levelNames;
    }

    private String getJoinClause(HierarchyOracle hierarchy) {
        Object joinClause = "";
        if (hierarchy != null) {
            boolean first = true;
            for (String join : hierarchy.getJoinSet()) {
                if (first) {
                    first = false;
                    joinClause = join;
                    continue;
                }
                joinClause = (String)joinClause + " " + join;
            }
        }
        return joinClause;
    }
}

