/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.cwddesign;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.cwddesign.CompareCWDDesigns;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;

public class DistinctTypeComparator
extends PropertiesComparator {
    public static final String LOGICAL_TYPE = "LOGICAL TYPE";
    public static final String SIZE = "SIZE";
    public static final String PRECISION = "Precision";
    public static final String SCALE = "Scale";
    private DistinctType sourceType;
    private DistinctType targetType;
    private CompareCWDDesigns selectionObject;

    public DistinctTypeComparator(DistinctType source, DistinctType target) {
        super(source, target);
        this.sourceType = source;
        this.targetType = target;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        PropertyHolder ph = new PropertyHolder(LOGICAL_TYPE);
        ph.setDDLHolder(true);
        ph.setLeftValue(this.getLogicalDatatypeName(this.sourceType));
        ph.setRightValue(this.getLogicalDatatypeName(this.targetType));
        if (this.isExcludedFromComparison(LOGICAL_TYPE)) {
            ph.setExcluded(true);
        } else if (this.sourceType != null && this.targetType != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(SIZE);
        ph.setDDLHolder(true);
        ph.setLeftValue(this.sourceType != null ? this.sourceType.getSize() : "");
        ph.setRightValue(this.targetType != null ? this.targetType.getSize() : "");
        if (this.isExcludedFromComparison(SIZE)) {
            ph.setExcluded(true);
        } else if (this.sourceType != null && this.targetType != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(PRECISION);
        ph.setDDLHolder(true);
        ph.setLeftValue(this.sourceType != null ? String.valueOf(this.sourceType.getPrecision()) : "");
        ph.setRightValue(this.targetType != null ? String.valueOf(this.targetType.getPrecision()) : "");
        if (this.isExcludedFromComparison(PRECISION)) {
            ph.setExcluded(true);
        } else if (this.sourceType != null && this.targetType != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(SCALE);
        ph.setDDLHolder(true);
        ph.setLeftValue(this.sourceType != null ? String.valueOf(this.sourceType.getScale()) : "");
        ph.setRightValue(this.targetType != null ? String.valueOf(this.targetType.getScale()) : "");
        if (this.isExcludedFromComparison(SCALE)) {
            ph.setExcluded(true);
        } else if (this.sourceType != null && this.targetType != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        this.initCommentsAndNotes();
        this.initDynamicProperties();
    }

    private String getLogicalDatatypeName(DistinctType distinctType) {
        LogicalDatatype datatype;
        if (distinctType != null && (datatype = distinctType.getLogicalDataType()) != null) {
            return datatype.getName();
        }
        return "";
    }

    @Override
    public void copySelectedProperties() {
        if (this.sourceType != null && this.targetType != null) {
            this.copyPropertiesFromLeftToRight();
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(LOGICAL_TYPE)) {
                    this.targetType.setLogicalDataType((LogicalDatatype)this.targetType.getDesign().getLogicalDatatypeSet().getByName(ph.getLeftValue()));
                    continue;
                }
                if (ph.getName().equals(SIZE)) {
                    this.targetType.setSize(this.sourceType.getSize());
                    continue;
                }
                if (ph.getName().equals(PRECISION)) {
                    this.targetType.setPrecision(this.sourceType.getPrecision());
                    continue;
                }
                if (!ph.getName().equals(SCALE)) continue;
                this.targetType.setScale(this.sourceType.getScale());
            }
        }
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.sourceType == null && this.targetType != null) {
            return true;
        }
        return super.hasToBeDrop();
    }

    public CompareCWDDesigns getSelectionObject() {
        return this.selectionObject;
    }

    public void setLeftSelectionObject(CompareCWDDesigns selectionObject) {
        this.selectionObject = selectionObject;
    }

    @Override
    public String getLeftName() {
        return this.sourceType != null ? MessageFormat.format(Messages.getString("DistinctTypeComparator.SourceDistinctType"), this.sourceType.getName()) : "";
    }

    @Override
    public String getRightName() {
        return this.targetType != null ? MessageFormat.format(Messages.getString("DistinctTypeComparator.TargetDistinctType"), this.targetType.getName()) : "";
    }
}

