/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.NameSpaceController;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.SchemaObject;

public class IndexAndConstraintNameController
extends NameSpaceController {
    Map<String, Object> constrNames = new TreeMap<String, Object>();

    @Override
    public synchronized void addObject(Object obj) {
        if (obj instanceof KeyObject) {
            KeyObject ind = (KeyObject)obj;
            if (ind.isFK()) {
                return;
            }
            String name = ind.getLongName();
            if (ind.isPK() || ind.isUnique()) {
                if (!ind.isBackup()) {
                    if (!this.caseSensitive) {
                        this.constrNames.put(name.toUpperCase(), obj);
                    } else {
                        this.constrNames.put(name, obj);
                    }
                }
            } else {
                super.addObject(obj);
            }
        } else {
            String longName = obj instanceof ModelIDObject ? ((ModelIDObject)obj).getLongName() : obj.toString();
            if (!this.caseSensitive) {
                longName = longName.toUpperCase();
            }
            this.constrNames.put(longName, obj);
        }
    }

    @Override
    public void removeObject(Object obj) {
        if (obj instanceof KeyObject) {
            KeyObject ind = (KeyObject)obj;
            if (ind.isPK() || ind.isUnique()) {
                this.removeObject(obj, this.constrNames);
                return;
            }
            this.removeObject(obj, this.names);
            return;
        }
        this.removeObject(obj, this.constrNames);
    }

    @Override
    public void objectStatusChanged(Map oldStatus, ModelIDObject obj) {
        if (obj instanceof KeyObject) {
            KeyObject ind = (KeyObject)obj;
            Boolean primary = (Boolean)oldStatus.get("Primary Constraint");
            Boolean unique = (Boolean)oldStatus.get("Unique Constraint");
            if (ind.isPK() || ind.isUnique()) {
                if (!(primary != null && primary.booleanValue() || unique != null && unique.booleanValue())) {
                    this.removeObject(obj, this.names);
                    this.addObject(obj);
                }
            } else if (primary != null && primary.booleanValue() || unique != null && unique.booleanValue()) {
                this.removeObject(obj, this.constrNames);
                this.addObject(obj);
            }
        }
    }

    @Override
    public String createNameVariant(String schema, String name, ModelIDObject obj) {
        if (obj instanceof KeyObject) {
            KeyObject ind = (KeyObject)obj;
            if (ind.isPK() || ind.isUnique()) {
                return this.createNameVariant(schema, name, this.constrNames, obj);
            }
            return this.createNameVariant(schema, name, this.names, obj);
        }
        return this.createNameVariant(schema, name, this.constrNames, obj);
    }

    @Override
    public String getValidName(ModelIDObject obj, String schema, String name) {
        if (obj instanceof KeyObject) {
            KeyObject ind = (KeyObject)obj;
            if (ind.isFK()) {
                return name;
            }
            if (ind.isPK() || ind.isUnique()) {
                return this.getValidName(obj, schema, name, this.constrNames);
            }
            return this.getValidName(obj, schema, name, this.names);
        }
        return this.getValidName(obj, schema, name, this.constrNames);
    }

    @Override
    public void updateNamesMap(String schema, String oldName, String newName, ModelIDObject obj) {
        if (obj instanceof KeyObject) {
            KeyObject ind = (KeyObject)obj;
            if (ind.isFK()) {
                return;
            }
            if (ind.isPK() || ind.isUnique()) {
                this.updateNamesMap(schema, oldName, newName, obj, this.constrNames);
            } else {
                this.updateNamesMap(schema, oldName, newName, obj, this.names);
            }
            return;
        }
        this.updateNamesMap(schema, oldName, newName, obj, this.constrNames);
    }

    @Override
    public void clear() {
        this.names.clear();
        this.constrNames.clear();
    }

    @Override
    public boolean updateNamesMap(SchemaObject oldSchema, String oldName, SchemaObject newSchema, String newName, DesignObject obj) {
        if (obj instanceof KeyObject) {
            KeyObject ind = (KeyObject)obj;
            if (ind.isFK()) {
                return true;
            }
            if (ind.isPK() || ind.isUnique()) {
                return this.updateNamesMap(oldSchema, oldName, newSchema, newName, obj, this.constrNames);
            }
            return this.updateNamesMap(oldSchema, oldName, newSchema, newName, obj, this.names);
        }
        return this.updateNamesMap(oldSchema, oldName, newSchema, newName, obj, this.constrNames);
    }

    @Override
    public boolean updateNamesMapStr(String oldSchema, String oldName, String newSchema, String newName, DesignObject obj) {
        if (obj instanceof KeyObject) {
            KeyObject ind = (KeyObject)obj;
            if (ind.isFK()) {
                return true;
            }
            if (ind.isPK() || ind.isUnique()) {
                return this.updateNamesMapStr(oldSchema, oldName, newSchema, newName, obj, this.constrNames);
            }
            return this.updateNamesMapStr(oldSchema, oldName, newSchema, newName, obj, this.names);
        }
        return this.updateNamesMapStr(oldSchema, oldName, newSchema, newName, obj, this.constrNames);
    }
}

