/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.scheduling;

import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.scheduling.DBMExtractionHandlerScheduling;
import oracle.dbtools.crest.imports.metadata.scheduling.MOHSchedHandler;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;
import oracle.dbtools.crest.model.scheduling.SchedulerWindowGroup;
import oracle.dbtools.util.Closeables;

public class MOHSchedulerWindowGroup
extends MOHSchedHandler {
    public static final String OBJECT_TYPE = "SCHEDULER_WINDOW_GROUP";
    public static final String DBA_TABLE = "SYS.DBA_SCHEDULER_WINDOW_GROUPS";
    public static final String ALL_TABLE = "SYS.ALL_SCHEDULER_WINDOW_GROUPS";
    public static final String DBA_WG_MEMBERS_TABLE = "SYS.DBA_SCHEDULER_WINGROUP_MEMBERS";
    public static final String ALL_WG_MEMBERS_TABLE = "SYS.ALL_SCHEDULER_WINGROUP_MEMBERS";

    public MOHSchedulerWindowGroup(DBMExtractionHandlerScheduling dbmeHandler) {
        super(dbmeHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SchedulerObject> generate(Connection conn, List<DBObject> selectedObjects) throws Exception {
        boolean dba = this.isDBA(conn);
        String sql = this.getSQL(dba);
        String args_sql = this.getMembersSQL(dba);
        ArrayList<SchedulerObject> res = new ArrayList<SchedulerObject>();
        PreparedStatement statement = null;
        ResultSet rs = null;
        PreparedStatement statement_a = null;
        try {
            for (DBObject dbo : selectedObjects) {
                if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
                if (statement == null) {
                    statement = conn.prepareStatement(sql);
                }
                statement.setString(1, dbo.getName());
                rs = statement.executeQuery();
                if (rs == null || !rs.next()) continue;
                SchedulerWindowGroup prog = new SchedulerWindowGroup();
                for (String prop : prog.getPropsList()) {
                    String value = null;
                    try {
                        value = rs.getString(prop);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.out.println("propname - " + prop);
                    }
                    prog.setProperty(prop, value);
                }
                rs.close();
                res.add(prog);
                if (prog.getNumberOfWindows() <= 0) continue;
                if (statement_a == null) {
                    statement_a = conn.prepareStatement(args_sql);
                }
                this.processMembers(conn, statement_a, prog, dbo);
            }
        }
        catch (Throwable e) {
            try {
                e.printStackTrace();
                System.out.println(e.getMessage());
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new AutoCloseable[]{rs, statement, statement_a});
                throw throwable;
            }
            Closeables.close((Object[])new AutoCloseable[]{rs, statement, statement_a});
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, statement, statement_a});
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMembers(Connection conn, PreparedStatement statement, SchedulerWindowGroup prog, DBObject dbo) {
        ResultSet rs = null;
        try {
            statement.setString(1, dbo.getName());
            rs = statement.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    String value = null;
                    try {
                        String[] vals;
                        Clob clob = rs.getClob(1);
                        if (clob == null || (value = clob.getSubString(1L, (int)clob.length())) == null || value.isEmpty()) continue;
                        for (String val : vals = value.split(",")) {
                            prog.addWindow(val);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                rs.close();
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Closeables.close(rs);
        }
    }

    String getSQL(boolean dba) {
        String sql = "select \n'SYS' as OWNER,\r\nWINDOW_GROUP_NAME,\r\nENABLED,\r\nNUMBER_OF_WINDOWS,\r\nNEXT_START_DATE,\r\nCOMMENTS from " + (dba ? DBA_TABLE : ALL_TABLE) + " \nwhere WINDOW_GROUP_NAME = ?";
        return sql;
    }

    String getMembersSQL(boolean dba) {
        String sql = "with function f1(name in varchar2) return clob is\ncl1 clob;\ncursor ss( n varchar2) is  \n      select window_name  from " + (dba ? DBA_WG_MEMBERS_TABLE : ALL_WG_MEMBERS_TABLE) + "  \n       where window_group_name = n  order by 1;\nBEGIN\n    CL1 := '';\n    FOR SR IN SS(NAME) LOOP\n        IF CL1 is null THEN\n            CL1 := SR.WINDOW_NAME;\n        ELSE\n            CL1 := CL1 || ',' || SR.WINDOW_NAME;\n        END IF;\n    END LOOP;\n    RETURN CL1;\nEND;\nselect f1( ? ) from dual";
        return sql;
    }
}

