/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.exports.ddl.SQLAnalyzer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.MOHView;
import oracle.dbtools.crest.imports.metadata.oracle.MOHTableOracle;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.TableViewSet;
import oracle.dbtools.crest.model.design.relational.ViewIndex;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableViewProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.dbtools.util.Closeables;

public class MOHViewOracle
extends MOHView {
    protected static String SYSTEM_NAME_PREFIX = "SYS_";
    private final Map ukMap = new TreeMap();
    private final List fkTempList = new ArrayList();
    private static final Logger LOGGER = new Logger(MOHViewOracle.class);
    private List postProc;
    protected boolean dbaUser;
    protected MOHTableOracle tableHandlerOracle;
    private boolean oracle11g;
    private boolean oracle12c;

    public MOHViewOracle(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
        this.dbaUser = false;
    }

    public MOHViewOracle(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler);
        this.dbaUser = dbaUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void old_generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws SQLException {
        PreparedStatement statement;
        PreparedStatement trig_statement;
        PreparedStatement col_statement;
        ArrayList dbos;
        boolean importCommentsInRDBMS;
        int cont_id;
        block52: {
            TimeLog.log("Views begin");
            this.ukMap.clear();
            this.fkTempList.clear();
            cont_id = 0;
            StorageDesign storageDesign = this.getStorageDesign();
            importCommentsInRDBMS = this.getDesign().getSettings().isImportCommentsInRDBMS();
            if (importCommentsInRDBMS && storageDesign instanceof StorageDesignOraclev12c) {
                String sql = "select SYS_CONTEXT('USERENV', 'CON_ID') ID FROM DUAL";
                PreparedStatement ps = null;
                try {
                    ps = sqlConnection.prepareStatement(sql);
                    try (ResultSet rs = ps.executeQuery();){
                        if (rs != null && rs.next()) {
                            cont_id = rs.getInt(1);
                        }
                        rs.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("MOHTableOracle.Error in getting container ID", e);
                }
                finally {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Exception e) {
                            LOGGER.error("MOHTableOracle.Error in getting container ID", e);
                        }
                    }
                }
            }
            this.postProc = new ArrayList();
            dbos = new ArrayList();
            col_statement = null;
            trig_statement = null;
            statement = null;
            boolean queriesPrepared = false;
            ArrayList<DBObject> cdbObjects = new ArrayList<DBObject>();
            ArrayList<DBObject> seedObjects = new ArrayList<DBObject>();
            try {
                block54: {
                    for (int i = 0; i < selectedObjects.size(); ++i) {
                        DBObject dbo = (DBObject)selectedObjects.get(i);
                        if (!"VIEW".equalsIgnoreCase(dbo.getType())) continue;
                        if (!queriesPrepared) {
                            StringBuffer buffer = new StringBuffer();
                            buffer.append("SELECT").append(' ');
                            buffer.append("a.").append("COLUMN_NAME").append(',');
                            buffer.append("DATA_TYPE").append(',');
                            buffer.append("DATA_LENGTH").append(',');
                            buffer.append("DATA_PRECISION").append(',');
                            buffer.append("DATA_SCALE");
                            buffer.append(' ');
                            buffer.append("FROM").append(' ');
                            buffer.append(this.dbaUser ? "dba_tab_columns" : "all_tab_columns").append(' ').append("a");
                            buffer.append(' ');
                            buffer.append("WHERE").append(' ');
                            buffer.append("a.").append("TABLE_NAME").append('=').append('?').append(' ');
                            buffer.append("AND").append(' ');
                            buffer.append("a.").append("OWNER").append('=').append('?').append(' ');
                            buffer.append("ORDER BY").append(' ').append("COLUMN_ID");
                            String colsql = buffer.toString();
                            col_statement = sqlConnection.prepareStatement(colsql);
                            buffer = new StringBuffer();
                            buffer.append("SELECT").append(' ');
                            buffer.append("OWNER").append(',');
                            buffer.append("TRIGGER_NAME").append(',');
                            buffer.append("TRIGGER_TYPE").append(',');
                            buffer.append("TRIGGERING_EVENT").append(',');
                            buffer.append("REFERENCING_NAMES").append(',');
                            buffer.append("WHEN_CLAUSE").append(',');
                            buffer.append("TRIGGER_BODY").append(' ');
                            buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_triggers" : "all_triggers").append(' ');
                            buffer.append("WHERE").append(' ').append("TABLE_OWNER").append('=').append('?').append(' ');
                            buffer.append("AND").append(' ').append("TABLE_NAME").append('=').append('?');
                            String trigsql = buffer.toString();
                            trig_statement = sqlConnection.prepareStatement(trigsql);
                            this.oracle11g = this.getStorageDesign() instanceof StorageDesignOraclev11g;
                            this.oracle12c = this.getStorageDesign() instanceof StorageDesignOraclev12c;
                            buffer = new StringBuffer();
                            buffer.append("SELECT").append(' ');
                            buffer.append("TEXT").append(',');
                            if (this.oracle12c) {
                                buffer.append("TEXT_LENGTH").append(',');
                                buffer.append("TEXT_VC").append(',');
                            }
                            if (this.oracle11g) {
                                buffer.append("EDITIONING_VIEW").append(',');
                            }
                            buffer.append("VIEW_TYPE").append(',');
                            buffer.append("VIEW_TYPE_OWNER").append(',');
                            buffer.append("OID_TEXT").append(',');
                            buffer.append("SUPERVIEW_NAME");
                            if (this.oracle12c) {
                                buffer.append(',').append("a.").append("ORIGIN_CON_ID");
                            }
                            buffer.append(' ');
                            buffer.append("FROM").append(' ');
                            buffer.append(this.dbaUser ? "dba_views" : "all_views").append(' ').append("a");
                            if (importCommentsInRDBMS) {
                                buffer.append(',');
                                buffer.append(this.dbaUser ? "dba_tab_comments" : "all_tab_comments").append(' ').append("b");
                            }
                            buffer.append(' ');
                            buffer.append("WHERE").append(' ');
                            buffer.append("VIEW_NAME").append('=').append('?').append(' ');
                            buffer.append("AND").append(' ');
                            buffer.append("a.").append("OWNER").append('=').append('?').append(' ');
                            if (importCommentsInRDBMS) {
                                buffer.append("AND").append(' ');
                                buffer.append("VIEW_NAME").append('=').append("b.").append("TABLE_NAME").append(' ').append("(+)").append(' ');
                                buffer.append("AND").append(' ');
                                buffer.append("a.").append("OWNER").append('=').append("b.").append("OWNER").append(' ').append("(+)");
                            }
                            String sql = buffer.toString();
                            statement = sqlConnection.prepareStatement(sql);
                            queriesPrepared = true;
                        }
                        this.generateView(dbo, statement, importLog, dbos, cdbObjects, seedObjects, col_statement, trig_statement);
                    }
                    if (!queriesPrepared) break block52;
                    if (!cdbObjects.isEmpty() || !seedObjects.isEmpty()) {
                        String savedConName = null;
                        Statement st = sqlConnection.createStatement();
                        try {
                            try (ResultSet rs = st.executeQuery("SELECT SYS_CONTEXT('USERENV', 'CON_NAME') FROM DUAL");){
                                if (rs != null) {
                                    if (rs.next()) {
                                        savedConName = rs.getString(1);
                                    }
                                    rs.close();
                                }
                            }
                            if (savedConName == null) break block54;
                            boolean containerChanged = false;
                            try {
                                Iterator it;
                                if (!cdbObjects.isEmpty()) {
                                    st.execute("ALTER SESSION SET CONTAINER = CDB$ROOT");
                                    containerChanged = true;
                                    it = cdbObjects.iterator();
                                    while (it.hasNext()) {
                                        this.generateView((DBObject)it.next(), statement, importLog, dbos, null, null, col_statement, trig_statement);
                                    }
                                }
                                if (!seedObjects.isEmpty()) {
                                    st.execute("ALTER SESSION SET CONTAINER = PDB$SEED");
                                    containerChanged = true;
                                    it = seedObjects.iterator();
                                    while (it.hasNext()) {
                                        this.generateView((DBObject)it.next(), statement, importLog, dbos, null, null, col_statement, trig_statement);
                                    }
                                }
                            }
                            catch (Exception e) {
                                LOGGER.error("MOHViewOracle.generateView(): ALTER SESSION SET CONTAINER failed", e);
                            }
                            if (containerChanged) {
                                try {
                                    st.execute("ALTER SESSION SET CONTAINER = " + savedConName);
                                }
                                catch (Exception e) {
                                    LOGGER.error("MOHViewOracle.generateView(): Reinstate Container failed", e);
                                }
                            }
                        }
                        finally {
                            Closeables.close((Object)st);
                        }
                    }
                }
                Closeables.close((Object[])new PreparedStatement[]{trig_statement, col_statement, statement});
                this.initUK_PK_FK_CHECK_Constraints(sqlConnection, dbos, this.ukMap, this.fkTempList);
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new PreparedStatement[]{trig_statement, col_statement, statement});
                throw throwable;
            }
        }
        Closeables.close((Object[])new PreparedStatement[]{trig_statement, col_statement, statement});
        if (importCommentsInRDBMS) {
            MOHTableOracle.processTableComments(sqlConnection, dbos, cont_id, this.dbaUser);
            MOHTableOracle.processColumnComments(sqlConnection, dbos, cont_id, this.dbaUser);
            TimeLog.log("End Column comments");
        }
        TimeLog.log("End Views");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(Connection sqlConnection, List objects, ImportLogger importLog) throws SQLException {
        TimeLog.log("Views begin");
        this.ukMap.clear();
        this.fkTempList.clear();
        this.postProc = new ArrayList();
        int cont_id = 0;
        StorageDesign storageDesign = this.getStorageDesign();
        boolean importCommentsInRDBMS = this.getDesign().getSettings().isImportCommentsInRDBMS();
        if (importCommentsInRDBMS && storageDesign instanceof StorageDesignOraclev12c) {
            String sql = "select SYS_CONTEXT('USERENV', 'CON_ID') ID FROM DUAL";
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                ps = sqlConnection.prepareStatement(sql);
                rs = ps.executeQuery();
                if (rs != null && rs.next()) {
                    cont_id = rs.getInt(1);
                }
                rs.close();
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    LOGGER.error("MOHViewOracle.Error in getting container ID", e);
                }
                catch (Throwable throwable) {
                    Closeables.close((Object[])new AutoCloseable[]{rs, ps});
                    throw throwable;
                }
                Closeables.close((Object[])new AutoCloseable[]{rs, ps});
            }
            Closeables.close((Object[])new AutoCloseable[]{rs, ps});
        }
        ArrayList<DBObject> columnDbos = new ArrayList<DBObject>();
        ArrayList<DBObject> processedDbos = new ArrayList<DBObject>();
        ArrayList<DBObject> cdbObjects = new ArrayList<DBObject>();
        ArrayList<DBObject> seedObjects = new ArrayList<DBObject>();
        ArrayList<DBObject> selectedObjects = new ArrayList<DBObject>();
        for (int i = 0; i < objects.size(); ++i) {
            DBObject dbo = (DBObject)objects.get(i);
            if (!"VIEW".equalsIgnoreCase(dbo.getType())) continue;
            selectedObjects.add(dbo);
        }
        HashMap<String, List<List<DBObject>>> masterMap = new HashMap<String, List<List<DBObject>>>();
        ArrayList<String> schList = new ArrayList<String>();
        HashMap<String, DBObject> nmap = new HashMap<String, DBObject>();
        MOHTableOracle.prepareNameMapsRestricted(schList, masterMap, nmap, selectedObjects, MOHTableOracle.batchCount);
        for (String schema : schList) {
            List lists = (List)masterMap.get(schema);
            for (List dbos : lists) {
                processedDbos.clear();
                columnDbos.clear();
                cdbObjects.clear();
                seedObjects.clear();
                TimeLog.log("  generateViews - begin");
                this.generateViews(sqlConnection, dbos, processedDbos, importLog, columnDbos, cdbObjects, seedObjects);
                TimeLog.log("  generateViews - end");
                this.processViewsFromOtherContainer(sqlConnection, columnDbos, processedDbos, importLog, cdbObjects, seedObjects);
                TimeLog.log("processViewsFromOtherContainer - end");
                this.processColumns(sqlConnection, columnDbos);
                TimeLog.log("  processColumns - end");
                if (this.getDbmeHandler().isTriggers()) {
                    this.initViewTriggers(sqlConnection, processedDbos);
                    TimeLog.log("  initViewTriggers - end");
                }
                if (this.getDesign().getSettings().isImportConstraints()) {
                    ArrayList fkTemp = new ArrayList();
                    TimeLog.log("Constraints begin");
                    this.initUK_PK_FK_Constraints(sqlConnection, processedDbos, this.ukMap, fkTemp);
                    this.fkTempList.addAll(fkTemp);
                }
                if (!importCommentsInRDBMS) continue;
                TimeLog.log("comments - begin");
                MOHTableOracle.processTableComments(sqlConnection, processedDbos, cont_id, this.dbaUser);
                MOHTableOracle.processColumnComments(sqlConnection, columnDbos, cont_id, this.dbaUser);
                TimeLog.log("comments - end");
            }
        }
        TimeLog.log("End Views");
    }

    private String getViewsQuery() {
        StringBuilder buffer = new StringBuilder();
        this.oracle11g = this.getStorageDesign() instanceof StorageDesignOraclev11g;
        this.oracle12c = this.getStorageDesign() instanceof StorageDesignOraclev12c;
        buffer.append("SELECT").append(' ');
        buffer.append("VIEW_NAME").append(',');
        buffer.append("TEXT_LENGTH").append(',');
        buffer.append("TEXT").append(',');
        if (this.oracle12c) {
            buffer.append("TEXT_VC").append(',');
        }
        if (this.oracle11g) {
            buffer.append("EDITIONING_VIEW").append(',');
        }
        buffer.append("VIEW_TYPE").append(',');
        buffer.append("VIEW_TYPE_OWNER").append(',');
        buffer.append("OID_TEXT").append(',');
        buffer.append("SUPERVIEW_NAME");
        if (this.oracle12c) {
            buffer.append(',').append("a.").append("ORIGIN_CON_ID");
        }
        buffer.append(' ');
        buffer.append("FROM").append(' ');
        buffer.append(this.dbaUser ? "dba_views" : "all_views").append(' ').append("a").append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("a.").append("OWNER").append('=').append('?').append(' ');
        return buffer.toString();
    }

    private String getColumnsQuery(String incl) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SELECT").append(' ');
        buffer.append("TABLE_NAME").append(',');
        buffer.append("a.").append("COLUMN_NAME").append(',');
        buffer.append("DATA_TYPE").append(',');
        buffer.append("DATA_LENGTH").append(',');
        buffer.append("DATA_PRECISION").append(',');
        buffer.append("DATA_SCALE").append(',');
        buffer.append("CHAR_USED").append(',');
        buffer.append("CHAR_LENGTH").append(' ');
        buffer.append("FROM").append(' ');
        buffer.append(this.dbaUser ? "dba_tab_columns" : "all_tab_columns").append(' ').append("a").append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("a.").append("OWNER").append('=').append('?').append(' ').append(" and " + incl);
        buffer.append("ORDER BY").append(' ').append("COLUMN_ID");
        return buffer.toString();
    }

    private String getConstraintsQuery(String incl) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SELECT").append(' ');
        buffer.append("TABLE_NAME").append(',');
        buffer.append("CONSTRAINT_NAME").append(',');
        buffer.append("CONSTRAINT_TYPE").append(',');
        buffer.append("R_OWNER").append(',');
        buffer.append("R_CONSTRAINT_NAME").append(',');
        buffer.append("INDEX_NAME").append(',');
        buffer.append("GENERATED").append(',');
        buffer.append("RELY").append(' ');
        buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_constraints" : "all_constraints").append(' ');
        buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
        buffer.append("AND").append(' ').append(incl).append(' ');
        buffer.append("AND").append(' ').append("CONSTRAINT_TYPE").append(' ').append("IN").append(' ');
        buffer.append('(').append("'P','U','R'").append(')').append(' ');
        buffer.append("ORDER BY").append(' ').append("CONSTRAINT_NAME");
        return buffer.toString();
    }

    private String getTriggersQuery(String incl) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SELECT").append(' ');
        buffer.append("TABLE_NAME").append(',');
        buffer.append("OWNER").append(',');
        buffer.append("TRIGGER_NAME").append(',');
        buffer.append("TRIGGER_TYPE").append(',');
        buffer.append("TRIGGERING_EVENT").append(',');
        buffer.append("REFERENCING_NAMES").append(',');
        buffer.append("WHEN_CLAUSE").append(',');
        buffer.append("TRIGGER_BODY").append(' ');
        buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_triggers" : "all_triggers").append(' ');
        buffer.append("WHERE").append(' ').append("TABLE_OWNER").append('=').append('?').append(' ');
        buffer.append("AND").append(' ').append(incl);
        return buffer.toString();
    }

    static void prepareNameMaps(List<String> schList, Map<String, List<String>> tmap, Map nmap, List selectedObjects) {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            String schema = dbo.getSchema();
            String name = dbo.getName();
            nmap.put(schema + "." + name, dbo);
            List<String> list = tmap.get(schema);
            if (list == null) {
                list = new ArrayList<String>();
                tmap.put(schema, list);
            }
            list.add(name);
            if (schList.contains(schema)) continue;
            schList.add(schema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateViews(Connection sqlConnection, List<DBObject> dbos, List<DBObject> processedDbos, ImportLogger importLog, List<DBObject> columnDbos, List<DBObject> cdbObjects, List<DBObject> seedObjects) {
        HashMap<String, List<String>> tmap = new HashMap<String, List<String>>();
        ArrayList<String> schList = new ArrayList<String>();
        PreparedStatement statement = null;
        HashMap nmap = new HashMap();
        MOHViewOracle.prepareNameMaps(schList, tmap, nmap, dbos);
        ResultSet rs = null;
        for (String schema : schList) {
            block33: {
                List list = (List)tmap.get(schema);
                String incl = list.size() > 990 ? MOHTableOracle.getInParamExpr(list.size(), "VIEW_NAME", 600) : MOHTableOracle.getInParamExpr(list.size(), "VIEW_NAME");
                String sql = this.getViewsQuery() + " and " + incl;
                try {
                    statement = sqlConnection.prepareStatement(sql);
                    statement.setFetchSize(50);
                    statement.setString(1, schema);
                    int k = 1;
                    for (String tname : list) {
                        statement.setString(++k, tname);
                    }
                    rs = statement.executeQuery();
                    if (rs == null) break block33;
                    while (rs.next()) {
                        String editioning;
                        SchemaObjectSet schemaSet;
                        SchemaObject so;
                        boolean doLater = false;
                        String viewName = rs.getString("VIEW_NAME");
                        DBObject dbo = (DBObject)nmap.get(schema + "." + viewName);
                        if (dbo == null) continue;
                        int tlength = rs.getInt("TEXT_LENGTH");
                        String viewDef = rs.getString("TEXT");
                        if (viewDef == null && (viewDef = rs.getString("TEXT_VC")).length() < tlength) {
                            int conId = rs.getInt("ORIGIN_CON_ID");
                            if (conId == 1) {
                                doLater = true;
                                if (cdbObjects != null) {
                                    cdbObjects.add(dbo);
                                }
                            } else if (conId == 2) {
                                doLater = true;
                                if (seedObjects != null) {
                                    seedObjects.add(dbo);
                                }
                            }
                        }
                        if (doLater) continue;
                        TableView tableView = this.getRelationalDesign().getTableViewSet().createTableView(null);
                        tableView.setSchema(schema);
                        String userName = schema;
                        UserOracle user = (UserOracle)((StorageDesignOracle)this.getStorageDesign()).getUserSet().getByName(userName);
                        TableViewProxyOracle vp = (TableViewProxyOracle)this.getStorageDesign().getTableViewProxySet().getProxy(tableView.getObjectID());
                        if (user == null) {
                            user = (UserOracle)((StorageDesignOracle)this.getStorageDesign()).getUserSet().createElement(null);
                            user.setName(userName);
                            this.stampModelObject((ModelObject)user, "", userName);
                        }
                        if ((so = (SchemaObject)(schemaSet = ((RelationalDesign)tableView.getDesignPart()).getSchemaObjectSet()).getByName(userName)) == null) {
                            so = schemaSet.createSchemaObject(null);
                            so.setName(userName);
                            this.stampModelObject((ModelObject)so, "", userName);
                        }
                        if (user != null) {
                            if (user.getSchemaObject() == null) {
                                user.setSchemaObject(so);
                            }
                            if (user.getSchemaObject() != so) {
                                vp.setUser(user);
                            }
                        }
                        tableView.setSchemaObject(so);
                        tableView.setName(viewName);
                        dbo.setTable(tableView);
                        if (processedDbos != null) {
                            processedDbos.add(dbo);
                        }
                        if (!viewName.equals(viewName.toUpperCase(Locale.ROOT))) {
                            tableView.setNameHasQuotes(true);
                        }
                        if (this.oracle11g && (editioning = rs.getString("EDITIONING_VIEW")).equals("Y")) {
                            ((TableViewProxyOraclev10g)vp).setEditioning("YES");
                        }
                        StructuredType st = null;
                        String viewType = rs.getString("VIEW_TYPE");
                        if (viewType != null) {
                            String viewTypeOwner = rs.getString("VIEW_TYPE_OWNER");
                            StructuredTypeProxyOracle stp = ((StructuredTypeProxySetOracle)this.getStorageDesign().getStructuredTypeProxySet()).getByLongName(viewType, viewTypeOwner);
                            if (stp != null) {
                                st = stp.getStructuredType();
                                tableView.setBasedOnStructuredType(st);
                            }
                            tableView.setBasedOnStructuredTypeLongName(viewTypeOwner + "." + viewType);
                            String superViewName = rs.getString("SUPERVIEW_NAME");
                            String oidText = rs.getString("OID_TEXT");
                            if (superViewName != null) {
                                Temp temp = new Temp();
                                temp.superViewName = superViewName;
                                temp.tview = tableView;
                                this.postProc.add(temp);
                            }
                            if (oidText != null) {
                                tableView.setOidText(oidText);
                                if (vp != null) {
                                    vp.setOidAttributes(oidText);
                                }
                            }
                        } else if (columnDbos != null) {
                            columnDbos.add(dbo);
                        }
                        tableView.setUserDefined(true);
                        String vdef = viewDef.trim();
                        tableView.setSelectDef(vdef);
                        int ind = StringUtilities.indexOf(vdef, "WITH READ ONLY");
                        String vend = "";
                        if (ind > -1) {
                            vend = vdef.substring(ind);
                            vdef = vdef.substring(0, ind);
                            vp.setViewReadOnly("YES");
                        } else {
                            ind = StringUtilities.indexOf(vdef, "WITH CHECK OPTION");
                            if (ind > -1) {
                                vend = vdef.substring(ind);
                                vdef = vdef.substring(0, ind);
                                vp.setCheckOption(true);
                            }
                        }
                        if (!"".equals(vend)) {
                            // empty if block
                        }
                        if (vdef.startsWith("(")) {
                            vdef = Token.getValBetweenBrackets(vdef);
                        }
                        String definition = "CREATE OR REPLACE VIEW " + viewName + "\nAS \n" + vdef;
                        tableView.setUserDefinedSQL(definition);
                        this.stampModelObject(tableView, dbo);
                        importLog.incrementImportedStatements();
                        this.addToHandledObjects(dbo);
                    }
                    rs.close();
                }
                catch (Exception e) {
                    try {
                        System.out.println(e.getMessage());
                        LOGGER.error("MOHViewOracle.generateView():", e);
                    }
                    catch (Throwable throwable) {
                        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                        throw throwable;
                    }
                    Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                    continue;
                }
            }
            Closeables.close((Object[])new AutoCloseable[]{rs, statement});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processViewsFromOtherContainer(Connection sqlConnection, List<DBObject> columnDbos, List<DBObject> processedDbos, ImportLogger importLog, List<DBObject> cdbObjects, List<DBObject> seedObjects) {
        block17: {
            if (cdbObjects.isEmpty() && seedObjects.isEmpty()) break block17;
            TimeLog.log("other - begin");
            String savedConName = null;
            Statement st = null;
            ResultSet rs = null;
            try {
                block16: {
                    try {
                        st = sqlConnection.createStatement();
                        rs = st.executeQuery("SELECT SYS_CONTEXT('USERENV', 'CON_NAME') FROM DUAL");
                        if (rs == null) break block16;
                        if (rs.next()) {
                            savedConName = rs.getString(1);
                        }
                        rs.close();
                    }
                    catch (SQLException e1) {
                        try {
                            e1.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            Closeables.close(rs);
                            throw throwable;
                        }
                        Closeables.close((Object)rs);
                    }
                }
                Closeables.close((Object)rs);
                if (savedConName != null) {
                    boolean containerChanged = false;
                    try {
                        if (!seedObjects.isEmpty()) {
                            st.execute("ALTER SESSION SET CONTAINER = PDB$SEED");
                            containerChanged = true;
                            this.generateViews(sqlConnection, seedObjects, processedDbos, importLog, columnDbos, null, null);
                        }
                        if (!cdbObjects.isEmpty()) {
                            st.execute("ALTER SESSION SET CONTAINER = CDB$ROOT");
                            containerChanged = true;
                            this.generateViews(sqlConnection, cdbObjects, processedDbos, importLog, columnDbos, null, null);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("MOHViewOracle.generateView(): ALTER SESSION SET CONTAINER failed", e);
                    }
                    if (containerChanged) {
                        try {
                            st.execute("ALTER SESSION SET CONTAINER = " + savedConName);
                        }
                        catch (Exception e) {
                            LOGGER.error("MOHViewOracle.generateView(): Reinstate Container failed", e);
                        }
                    }
                }
                TimeLog.log("other - end");
            }
            finally {
                Closeables.close((Object)st);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processColumns(Connection sqlConnection, List<DBObject> dbos) {
        HashMap<String, List<String>> tmap = new HashMap<String, List<String>>();
        ArrayList<String> schList = new ArrayList<String>();
        PreparedStatement statement = null;
        HashMap nmap = new HashMap();
        MOHTableOracle.prepareNameMaps(schList, tmap, nmap, dbos);
        ResultSet rs = null;
        for (String schema : schList) {
            block8: {
                List list = (List)tmap.get(schema);
                String incl = list.size() > 990 ? MOHTableOracle.getInParamExpr(list.size(), "table_name", 600) : MOHTableOracle.getInParamExpr(list.size(), "table_name");
                String sql = this.getColumnsQuery(incl);
                try {
                    statement = sqlConnection.prepareStatement(sql);
                    statement.setFetchSize(150);
                    statement.setString(1, schema);
                    int k = 1;
                    for (String tname : list) {
                        statement.setString(++k, tname);
                    }
                    rs = statement.executeQuery();
                    if (rs == null) break block8;
                    while (rs.next()) {
                        String tname = rs.getString(1);
                        String col_name = rs.getString(2);
                        String col_type = rs.getString(3);
                        String dt_length = rs.getString(4);
                        String dt_precision = rs.getString(5);
                        String dt_scale = rs.getString(6);
                        String char_used = rs.getString("CHAR_USED");
                        String charLength = rs.getString("CHAR_LENGTH");
                        DBObject dbo = (DBObject)nmap.get(schema + "." + tname);
                        if (dbo == null) continue;
                        TableView tableView = (TableView)dbo.getTable();
                        char_used = char_used == null ? "" : (char_used.equalsIgnoreCase("C") ? " CHAR" : (char_used.equalsIgnoreCase("B") ? " BYTE" : ""));
                        AbstractViewElement cvExp = tableView.createViewElement(tableView.getDesignPart());
                        cvExp.setName(col_name);
                        cvExp.setHeaderAlias(col_name);
                        cvExp.setDataType(this.createDataTypeString(col_type, charLength, dt_precision, dt_scale, char_used));
                        cvExp.setDesign(tableView.getDesign());
                        cvExp.setAlias(col_name);
                        cvExp.setContainer(tableView);
                        tableView.add(cvExp);
                        if (!col_name.equals(col_name.toUpperCase(Locale.ROOT))) {
                            cvExp.setNameHasQuotes(true);
                        }
                        this.stampModelObject((ModelObject)cvExp, tableView.getName(), col_name);
                    }
                    rs.close();
                }
                catch (Exception e) {
                    try {
                        System.out.println(e.getMessage());
                        LOGGER.error("MOHViewOracle.generate() column names:", e);
                    }
                    catch (Throwable throwable) {
                        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                        throw throwable;
                    }
                    Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                    continue;
                }
            }
            Closeables.close((Object[])new AutoCloseable[]{rs, statement});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initViewTriggers(Connection sqlConnection, List<DBObject> dbos) throws SQLException {
        HashMap<String, List<String>> tmap = new HashMap<String, List<String>>();
        ArrayList<String> schList = new ArrayList<String>();
        PreparedStatement statement = null;
        HashMap nmap = new HashMap();
        MOHViewOracle.prepareNameMaps(schList, tmap, nmap, dbos);
        ResultSet rs = null;
        for (String schema : schList) {
            block19: {
                List list = (List)tmap.get(schema);
                String incl = list.size() > 990 ? MOHTableOracle.getInParamExpr(list.size(), "table_name", 600) : MOHTableOracle.getInParamExpr(list.size(), "table_name");
                String sql = this.getTriggersQuery(incl);
                try {
                    statement = sqlConnection.prepareStatement(sql);
                    statement.setFetchSize(50);
                    statement.setString(1, schema);
                    int k = 1;
                    for (String tname : list) {
                        statement.setString(++k, tname);
                    }
                    rs = statement.executeQuery();
                    if (rs == null) break block19;
                    StorageDesignOracle storage = (StorageDesignOracle)this.getStorageDesign();
                    while (rs.next()) {
                        String tname;
                        tname = rs.getString(1);
                        String trigOwner = rs.getString("OWNER");
                        String trigName = rs.getString("TRIGGER_NAME");
                        String type = rs.getString("TRIGGER_TYPE");
                        String event = rs.getString("TRIGGERING_EVENT");
                        String refNames = rs.getString("REFERENCING_NAMES");
                        String whenClause = rs.getString("WHEN_CLAUSE");
                        String trBody = rs.getString("TRIGGER_BODY");
                        DBObject dbo = (DBObject)nmap.get(schema + "." + tname);
                        if (dbo == null) continue;
                        TableView table = (TableView)dbo.getTable();
                        TriggerOracle trigger = storage.getTriggerSet().createTrigger();
                        TableViewProxyOracle tableProxy = (TableViewProxyOracle)storage.getTableViewProxySet().getProxy(table.getObjectID());
                        UserOracle user = (UserOracle)storage.getUserSet().getByName(trigOwner);
                        trigger.setOwner(user);
                        trigger.setName(trigName);
                        if (!trigName.equals(trigName.toUpperCase(Locale.ROOT))) {
                            trigger.setNameHasQuotes(true);
                        }
                        trigger.setView(tableProxy);
                        this.stampModelObject((ModelObject)trigger, tableProxy, trigName);
                        if (type.indexOf("STATEMENT") > -1) {
                            trigger.setScope(TriggerOracle.SCOPE_TYPES[1]);
                        } else {
                            trigger.setScope(TriggerOracle.SCOPE_TYPES[0]);
                        }
                        if (type.indexOf("BEFORE") > -1) {
                            trigger.setTriggerTime("BEFORE");
                        } else if (type.indexOf("AFTER") > -1) {
                            trigger.setTriggerTime("AFTER");
                        } else {
                            trigger.setTriggerTime(type);
                        }
                        if (event.indexOf("INSERT") > -1) {
                            trigger.setActions(Trigger.ACTION_TYPES[0]);
                        }
                        if (event.indexOf("UPDATE") > -1) {
                            trigger.setActions(Trigger.ACTION_TYPES[1]);
                        }
                        if (event.indexOf("DELETE") > -1) {
                            trigger.setActions(Trigger.ACTION_TYPES[2]);
                        }
                        String newref = "NEW";
                        String oldref = "OLD";
                        String parentref = "PARENT";
                        if (refNames.indexOf("NEW AS") > -1 && !"NEW".equalsIgnoreCase(newref = Token.getFirstToken(Token.getStringAfter(refNames, "NEW AS")))) {
                            trigger.setRef_NEW_AS(newref);
                        }
                        if (refNames.indexOf("OLD AS") > -1 && !"OLD".equalsIgnoreCase(oldref = Token.getFirstToken(Token.getStringAfter(refNames, "OLD AS")))) {
                            trigger.setRef_OLD_AS(oldref);
                        }
                        if (refNames.indexOf("PARENT AS") > -1 && !"PARENT".equalsIgnoreCase(parentref = Token.getFirstToken(Token.getStringAfter(refNames, "PARENT AS")))) {
                            trigger.setRef_PARENT_AS(parentref);
                        }
                        if (whenClause != null) {
                            trigger.setCondition(whenClause);
                        }
                        trigger.setBody(trBody);
                    }
                    rs.close();
                }
                catch (Throwable throwable) {
                    Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                    throw throwable;
                }
            }
            Closeables.close((Object[])new AutoCloseable[]{rs, statement});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUK_PK_FK_Constraints(Connection sqlConnection, List dbos, Map ukMap, List fkTempList) throws SQLException {
        HashMap<String, List<String>> tmap = new HashMap<String, List<String>>();
        ArrayList<String> schList = new ArrayList<String>();
        PreparedStatement statement = null;
        HashMap nmap = new HashMap();
        MOHViewOracle.prepareNameMaps(schList, tmap, nmap, dbos);
        ResultSet rs = null;
        for (String schema : schList) {
            ArrayList<MOHTableOracle.ConstrHelper> clist;
            block36: {
                clist = new ArrayList<MOHTableOracle.ConstrHelper>();
                List list = (List)tmap.get(schema);
                String incl = list.size() > 990 ? MOHTableOracle.getInParamExpr(list.size(), "table_name", 600) : MOHTableOracle.getInParamExpr(list.size(), "table_name");
                String sql = this.getConstraintsQuery(incl);
                int uk_count = 0;
                String ownerName = schema;
                try {
                    statement = sqlConnection.prepareStatement(sql);
                    statement.setFetchSize(150);
                    statement.setString(1, schema);
                    int k = 1;
                    for (String tname : list) {
                        statement.setString(++k, tname);
                    }
                    rs = statement.executeQuery();
                    if (rs == null) break block36;
                    while (rs.next()) {
                        String tname = rs.getString(1);
                        DBObject dbo = (DBObject)nmap.get(schema + "." + tname);
                        if (dbo == null) continue;
                        TableView view = (TableView)dbo.getTable();
                        String constrName = rs.getString(2);
                        String constrType = rs.getString(3);
                        if ("R".equalsIgnoreCase(constrType)) {
                            MOHTableOracle.FKTemp fktemp = new MOHTableOracle.FKTemp();
                            fkTempList.add(fktemp);
                            fktemp.name = constrName;
                            fktemp.owner = dbo.getSchema();
                            fktemp.UK_Owner = rs.getString(4);
                            fktemp.UK_Name = rs.getString(5);
                            fktemp.view = (TableView)dbo.getTable();
                            fktemp.rely = rs.getString(8);
                            continue;
                        }
                        MOHTableOracle.ConstrHelper ch = new MOHTableOracle.ConstrHelper();
                        ch.owner = ownerName;
                        ch.cname = constrName;
                        clist.add(ch);
                        String ind_name = rs.getString(6);
                        String generated = rs.getString(7);
                        ViewIndex index = null;
                        if (ind_name != null) {
                            if (!generated.equalsIgnoreCase("USER NAME")) {
                                if (constrName.equals(ind_name)) {
                                    index = view.getIndexByName(ind_name);
                                }
                            } else if (!constrName.equals(ind_name)) {
                                index = view.getIndexByName(constrName);
                            }
                        }
                        if ("P".equalsIgnoreCase(constrType) && view.isBST()) {
                            if (index != null) {
                                ViewIndex existingPK = (ViewIndex)view.getPK();
                                if (existingPK != null) {
                                    existingPK.getElementsCollection().clear();
                                    if (index != existingPK) {
                                        index.remove();
                                        index = existingPK;
                                    }
                                    ch.key = existingPK;
                                }
                                if (generated.equalsIgnoreCase("USER NAME")) {
                                    index.setName(constrName);
                                } else {
                                    index.setName(ind_name);
                                }
                            } else {
                                ViewIndex pk = (ViewIndex)view.getPK();
                                if (pk == null) {
                                    pk = view.createIndex();
                                }
                                String pkName = generated.equalsIgnoreCase("USER NAME") ? constrName : ind_name;
                                ch.key = pk;
                                pk.setName(pkName);
                                if (!pkName.equals(pkName.toUpperCase(Locale.ROOT))) {
                                    pk.setNameHasQuotes(true);
                                }
                                this.stampModelObject((ModelObject)pk, view.getSchema(), pk.getName());
                                if ("".equals(pk.getIndexExpression())) {
                                    ColumnView col = (ColumnView)view.getOidElement();
                                    if (col != null) {
                                        pk.remove(col);
                                    }
                                    ArrayList<String> colNames = new ArrayList<String>();
                                    for (Column column : pk.getElementsCollection()) {
                                        colNames.add(column.getName());
                                    }
                                    ViewIndex idx = this.getIndexForColumnNames(view, colNames, pk);
                                    if (idx != null) {
                                        idx.remove();
                                    }
                                }
                            }
                        } else if (index == null) {
                            index = view.createIndex();
                        }
                        if (index == null) continue;
                        ukMap.put(ownerName + constrName, index);
                        ch.key = index;
                        if ("U".equalsIgnoreCase(constrType)) {
                            index.setIndexState("Unique Constraint");
                            ++uk_count;
                        } else if ("P".equalsIgnoreCase(constrType) && !view.isBST()) {
                            index.setIndexState("Primary Constraint");
                        }
                        boolean valid = true;
                        if (index.getElementsCollection().size() == 0) {
                            // empty if block
                        }
                        if (!valid || view.isBST() && !"".equals(index.getIndexExpression())) {
                            ukMap.put(ownerName + constrName, index.getView());
                            index.remove();
                        }
                        if (index.isRemoved()) continue;
                        if (generated.equalsIgnoreCase("USER NAME")) {
                            index.setName(constrName);
                            if (!constrName.equals(constrName.toUpperCase(Locale.ROOT))) {
                                index.setNameHasQuotes(true);
                            }
                            this.stampModelObject((ModelObject)index, view.getSchema(), index.getName());
                            continue;
                        }
                        tname = view.getName();
                        String abbrname = view.getAbbreviation();
                        if (abbrname == null || "".equals(abbrname)) {
                            abbrname = tname;
                        }
                        index.setName(constrName);
                        this.stampModelObject((ModelObject)index, view.getSchema(), constrName);
                    }
                    rs.close();
                }
                catch (Exception e) {
                    try {
                        LOGGER.error("MOHViewOracle.initUK_PK_FK_CHECK_Constraints():", e);
                    }
                    catch (Throwable throwable) {
                        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                        throw throwable;
                    }
                    Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                }
            }
            Closeables.close((Object[])new AutoCloseable[]{rs, statement});
            TimeLog.log("ConstraintColumns begin");
            MOHTableOracle.initConstraintColumns(sqlConnection, ukMap, fkTempList, clist, this.dbaUser);
            TimeLog.log("ConstraintColumns end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateView(DBObject dbo, PreparedStatement statement, ImportLogger importLog, List dbos, List<DBObject> cdbObjects, List<DBObject> seedObjects, PreparedStatement col_statement, PreparedStatement trig_statement) {
        String viewName = dbo.getName();
        String schemaName = dbo.getSchema();
        ResultSet rs = null;
        try {
            statement.setString(1, viewName);
            statement.setString(2, schemaName);
            rs = statement.executeQuery();
            if (rs != null) {
                if (rs.next()) {
                    boolean doLater = false;
                    String viewDef = rs.getString("TEXT");
                    if (viewDef == null && (viewDef = rs.getString("TEXT_VC")).length() < rs.getInt("TEXT_LENGTH")) {
                        int conId = rs.getInt("ORIGIN_CON_ID");
                        if (conId == 1) {
                            doLater = true;
                            if (cdbObjects != null) {
                                cdbObjects.add(dbo);
                            }
                        } else if (conId == 2) {
                            doLater = true;
                            if (seedObjects != null) {
                                seedObjects.add(dbo);
                            }
                        }
                    }
                    if (!doLater) {
                        String editioning;
                        SchemaObjectSet schemaSet;
                        SchemaObject so;
                        TableView tableView = this.getDesign().getRelationalDesign().getTableViewSet().createTableView(null);
                        boolean importCommentsInRDBMS = this.getDesign().getSettings().isImportCommentsInRDBMS();
                        tableView.setSchema(schemaName);
                        tableView.setDwhType(dbo.dwhType);
                        if (dbo.joins != null && dbo.joins.size() > 0) {
                            tableView.getImpliedFKeys().addAll(dbo.joins);
                        }
                        String userName = schemaName;
                        UserOracle user = (UserOracle)((StorageDesignOracle)this.getStorageDesign()).getUserSet().getByName(userName);
                        TableViewProxyOracle vp = (TableViewProxyOracle)this.getStorageDesign().getTableViewProxySet().getProxy(tableView.getObjectID());
                        if (user == null) {
                            user = (UserOracle)((StorageDesignOracle)this.getStorageDesign()).getUserSet().createElement(null);
                            user.setName(userName);
                            this.stampModelObject((ModelObject)user, "", userName);
                        }
                        if ((so = (SchemaObject)(schemaSet = ((RelationalDesign)tableView.getDesignPart()).getSchemaObjectSet()).getByName(userName)) == null) {
                            so = schemaSet.createSchemaObject(null);
                            so.setName(userName);
                            this.stampModelObject((ModelObject)so, "", userName);
                        }
                        if (user != null) {
                            if (user.getSchemaObject() == null) {
                                user.setSchemaObject(so);
                            }
                            if (user.getSchemaObject() != so) {
                                vp.setUser(user);
                            }
                        }
                        tableView.setSchemaObject(so);
                        tableView.setName(viewName);
                        dbo.setTable(tableView);
                        dbos.add(dbo);
                        if (!viewName.equals(viewName.toUpperCase(Locale.ROOT))) {
                            tableView.setNameHasQuotes(true);
                        }
                        if (this.oracle11g && (editioning = rs.getString("EDITIONING_VIEW")).equals("Y")) {
                            ((TableViewProxyOraclev10g)vp).setEditioning("YES");
                        }
                        StructuredType st = null;
                        String viewType = rs.getString("VIEW_TYPE");
                        if (viewType != null) {
                            String viewTypeOwner = rs.getString("VIEW_TYPE_OWNER");
                            StructuredTypeProxyOracle stp = ((StructuredTypeProxySetOracle)this.getStorageDesign().getStructuredTypeProxySet()).getByLongName(viewType, viewTypeOwner);
                            if (stp != null) {
                                st = stp.getStructuredType();
                                tableView.setBasedOnStructuredType(st);
                                tableView.setBasedOnStructuredTypeLongName(viewTypeOwner + "." + viewType);
                            } else {
                                tableView.setBasedOnStructuredTypeLongName(viewTypeOwner + "." + viewType);
                            }
                            String superViewName = rs.getString("SUPERVIEW_NAME");
                            String oidText = rs.getString("OID_TEXT");
                            if (superViewName != null) {
                                Temp temp = new Temp();
                                temp.superViewName = superViewName;
                                temp.tview = tableView;
                                this.postProc.add(temp);
                            }
                            if (oidText != null) {
                                tableView.setOidText(oidText);
                                if (vp != null) {
                                    vp.setOidAttributes(oidText);
                                }
                            }
                        }
                        if (st == null) {
                            ResultSet rs_col = null;
                            try {
                                col_statement.setString(1, viewName);
                                col_statement.setString(2, schemaName);
                                rs_col = col_statement.executeQuery();
                                if (rs_col != null) {
                                    while (rs_col.next()) {
                                        String col_name = rs_col.getString(1);
                                        if (col_name.startsWith("SYS_NC")) continue;
                                        String col_type = rs_col.getString(2);
                                        String dt_length = rs_col.getString(3);
                                        String dt_precision = rs_col.getString(4);
                                        String dt_scale = rs_col.getString(5);
                                        AbstractViewElement cvExp = tableView.createViewElement(tableView.getDesignPart());
                                        cvExp.setName(col_name);
                                        cvExp.setHeaderAlias(col_name);
                                        cvExp.setDataType(this.createDataTypeString(col_type, dt_length, dt_precision, dt_scale));
                                        cvExp.setDesign(tableView.getDesign());
                                        cvExp.setAlias(col_name);
                                        cvExp.setContainer(tableView);
                                        tableView.add(cvExp);
                                        if (!col_name.equals(col_name.toUpperCase(Locale.ROOT))) {
                                            cvExp.setNameHasQuotes(true);
                                        }
                                        this.stampModelObject((ModelObject)cvExp, tableView.getName(), col_name);
                                    }
                                }
                                Closeables.close((Object)rs_col);
                            }
                            catch (Exception e) {
                                Logger.error_("MOHViewOracle.generate() column names:", e);
                            }
                            finally {
                                Closeables.close(rs_col);
                            }
                        }
                        tableView.setUserDefined(true);
                        String vdef = viewDef.trim();
                        tableView.setSelectDef(vdef);
                        int ind = StringUtilities.indexOf(vdef, "WITH READ ONLY");
                        String vend = "";
                        if (ind > -1) {
                            vend = vdef.substring(ind);
                            vdef = vdef.substring(0, ind);
                            vp.setViewReadOnly("YES");
                        } else {
                            ind = StringUtilities.indexOf(vdef, "WITH CHECK OPTION");
                            if (ind > -1) {
                                vend = vdef.substring(ind);
                                vdef = vdef.substring(0, ind);
                                vp.setCheckOption(true);
                            }
                        }
                        if (!"".equals(vend)) {
                            // empty if block
                        }
                        if (vdef.startsWith("(")) {
                            vdef = Token.getValBetweenBrackets(vdef);
                        }
                        String definition = "CREATE OR REPLACE VIEW " + viewName + "\nAS \n" + vdef;
                        tableView.setUserDefinedSQL(definition);
                        if (this.getDbmeHandler().isTriggers()) {
                            this.initViewTriggers(trig_statement, tableView, schemaName);
                        }
                        this.stampModelObject(tableView, dbo);
                        importLog.incrementImportedStatements();
                        this.addToHandledObjects(dbo);
                    }
                }
                rs.close();
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            Logger.error_("MOHViewOracle.generateView():", e);
        }
        finally {
            Closeables.close(rs);
        }
    }

    private boolean isNotEmpty(String param) {
        return param != null && !"".equalsIgnoreCase(param) && !"0".equalsIgnoreCase(param);
    }

    private String createDataTypeString(String datatype, String length, String precision, String scale, String char_used) {
        if (!(datatype.startsWith("TIMESTAMP") || datatype.startsWith("INTERVAL") || length == null && precision == null && scale == null)) {
            StringBuffer buffer = new StringBuffer();
            boolean needComma = false;
            if (!"NUMBER".equalsIgnoreCase(datatype) && this.isNotEmpty(length)) {
                buffer.append(length);
                if (datatype.equals("CHAR") || datatype.equals("VARCHAR2") || datatype.equals("VARCHAR")) {
                    buffer.append(char_used);
                }
                needComma = true;
            }
            if (this.isNotEmpty(precision)) {
                if (needComma) {
                    buffer.append(',').append(' ');
                }
                buffer.append(precision);
                needComma = true;
            }
            if (this.isNotEmpty(scale)) {
                if (needComma) {
                    buffer.append(',').append(' ');
                }
                buffer.append(scale);
            }
            if (buffer.length() > 0) {
                buffer.append(')');
                return datatype + " (" + buffer.toString();
            }
        }
        return datatype;
    }

    private String createDataTypeString(String datatype, String length, String precision, String scale) {
        if (!(datatype.startsWith("TIMESTAMP") || datatype.startsWith("INTERVAL") || length == null && precision == null && scale == null)) {
            StringBuffer buffer = new StringBuffer();
            boolean needComma = false;
            if (!"NUMBER".equalsIgnoreCase(datatype) && this.isNotEmpty(length)) {
                buffer.append(length);
                needComma = true;
            }
            if (this.isNotEmpty(precision)) {
                if (needComma) {
                    buffer.append(',').append(' ');
                }
                buffer.append(precision);
                needComma = true;
            }
            if (this.isNotEmpty(scale)) {
                if (needComma) {
                    buffer.append(',').append(' ');
                }
                buffer.append(scale);
            }
            if (buffer.length() > 0) {
                buffer.append(')');
                return datatype + " (" + buffer.toString();
            }
        }
        return datatype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List extract(Connection sqlConnection, List schemas) throws SQLException {
        TimeLog.log("Extract View begin");
        statement = null;
        list = new ArrayList<DBObject>();
        it = schemas.iterator();
        try {
            while (it.hasNext()) {
                dboNext = (DBObject)it.next();
                if (!dboNext.isSelected()) continue;
                schemaName = dboNext.getName();
                if (statement == null) {
                    filterCondition = this.getFilterConditionOracle("VIEW_NAME");
                    buffer = new StringBuffer();
                    buffer.append("SELECT").append(' ').append("VIEW_NAME").append(',');
                    buffer.append("VIEW_TYPE").append(',');
                    buffer.append("VIEW_TYPE_OWNER").append(' ');
                    buffer.append("FROM").append(' ').append(this.dbaUser != false ? "dba_views" : "all_views").append(' ');
                    buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
                    if (filterCondition != null) {
                        buffer.append("AND").append(' ').append(filterCondition).append(' ');
                    }
                    buffer.append("ORDER BY").append(' ').append("VIEW_NAME");
                    sql = buffer.toString();
                    if (this.getDbmeHandler().getLimit() > 0) {
                        sql = this.getDbmeHandler().getPaginatedQuery(sql);
                    }
                    statement = sqlConnection.prepareStatement(sql);
                }
                rs = null;
                try {
                    statement.setString(1, dboNext.getName());
                    rs = statement.executeQuery();
                    if (rs != null) {
                        while (rs.next()) {
                            viewName = rs.getString("VIEW_NAME");
                            viewType = rs.getString("VIEW_TYPE");
                            viewTypeOwner = rs.getString("VIEW_TYPE_OWNER");
                            dboView = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), viewName, "VIEW", schemaName);
                            dboView.setTypeName(viewType);
                            dboView.setTypeOwner(viewTypeOwner);
                            list.add(dboView);
                        }
                        rs.close();
                    }
                    ** GOTO lbl57
                }
                catch (Exception e) {
                    try {
                        MOHViewOracle.LOGGER.error("MOHViewOracle.extract():", e);
                    }
                    catch (Throwable var13_14) {
                        Closeables.close(rs);
                        throw var13_14;
                    }
lbl57:
                    // 1 sources

                    Closeables.close((Object)rs);
                    continue;
                    Closeables.close((Object)rs);
                }
            }
        }
        finally {
            Closeables.close(statement);
        }
        TimeLog.log("Extract View end");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initViewTriggers(PreparedStatement trig_statement, TableView table, String ownerName) throws SQLException {
        ResultSet rs = null;
        try {
            trig_statement.setString(1, ownerName);
            trig_statement.setString(2, table.getName());
            rs = trig_statement.executeQuery();
            if (rs != null) {
                StorageDesignOracle storage = (StorageDesignOracle)this.getStorageDesign();
                TableViewProxyOracle tableProxy = (TableViewProxyOracle)storage.getTableViewProxySet().getProxy(table.getObjectID());
                while (rs.next()) {
                    String trigOwner = rs.getString("OWNER");
                    String trigName = rs.getString("TRIGGER_NAME");
                    String type = rs.getString("TRIGGER_TYPE");
                    String event = rs.getString("TRIGGERING_EVENT");
                    String refNames = rs.getString("REFERENCING_NAMES");
                    String whenClause = rs.getString("WHEN_CLAUSE");
                    String trBody = rs.getString("TRIGGER_BODY");
                    TriggerOracle trigger = storage.getTriggerSet().createTrigger();
                    UserOracle user = (UserOracle)storage.getUserSet().getByName(trigOwner);
                    trigger.setOwner(user);
                    trigger.setName(trigName);
                    if (!trigName.equals(trigName.toUpperCase(Locale.ROOT))) {
                        trigger.setNameHasQuotes(true);
                    }
                    trigger.setView(tableProxy);
                    this.stampModelObject((ModelObject)trigger, tableProxy, trigName);
                    if (type.indexOf("STATEMENT") > -1) {
                        trigger.setScope(TriggerOracle.SCOPE_TYPES[1]);
                    } else {
                        trigger.setScope(TriggerOracle.SCOPE_TYPES[0]);
                    }
                    if (type.indexOf("BEFORE") > -1) {
                        trigger.setTriggerTime("BEFORE");
                    } else if (type.indexOf("AFTER") > -1) {
                        trigger.setTriggerTime("AFTER");
                    } else {
                        trigger.setTriggerTime(type);
                    }
                    if (event.indexOf("INSERT") > -1) {
                        trigger.setActions(Trigger.ACTION_TYPES[0]);
                    }
                    if (event.indexOf("UPDATE") > -1) {
                        trigger.setActions(Trigger.ACTION_TYPES[1]);
                    }
                    if (event.indexOf("DELETE") > -1) {
                        trigger.setActions(Trigger.ACTION_TYPES[2]);
                    }
                    String newref = "NEW";
                    String oldref = "OLD";
                    String parentref = "PARENT";
                    if (refNames.indexOf("NEW AS") > -1 && !"NEW".equalsIgnoreCase(newref = Token.getFirstToken(Token.getStringAfter(refNames, "NEW AS")))) {
                        trigger.setRef_NEW_AS(newref);
                    }
                    if (refNames.indexOf("OLD AS") > -1 && !"OLD".equalsIgnoreCase(oldref = Token.getFirstToken(Token.getStringAfter(refNames, "OLD AS")))) {
                        trigger.setRef_OLD_AS(oldref);
                    }
                    if (refNames.indexOf("PARENT AS") > -1 && !"PARENT".equalsIgnoreCase(parentref = Token.getFirstToken(Token.getStringAfter(refNames, "PARENT AS")))) {
                        trigger.setRef_PARENT_AS(parentref);
                    }
                    if (whenClause != null) {
                        trigger.setCondition(whenClause);
                    }
                    trigger.setBody(trBody);
                }
                rs.close();
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            LOGGER.error("MOHViewOracle.initViewTriggers():", e);
        }
        finally {
            Closeables.close(rs);
        }
    }

    @Override
    public void postGenerateProcessing(Connection sqlConnection) {
        this.createFKeys(sqlConnection, this.fkTempList, this.ukMap);
        this.fkTempList.clear();
        this.ukMap.clear();
        if (this.postProc != null) {
            TableViewSet vs = this.getDesign().getRelationalDesign().getTableViewSet();
            for (Temp temp : this.postProc) {
                TableView tview = (TableView)vs.getByName(temp.superViewName);
                if (tview == null || tview == temp.tview) continue;
                TypeSubstitution ts = this.getDesign().getRelationalDesign().createTypeSubstitution();
                ts.setChildContainerObject(temp.tview);
                ts.setParentContainerObject(tview);
            }
            this.postProc.clear();
        }
        if (this.getDbmeHandler().isParseQueriesAfterImport()) {
            Map containers = this.getRelationalDesign().getContainersMap();
            TimeLog.log("begin parsing of views");
            Iterator it = this.getDesign().getRelationalDesign().getTableViewSet().iterator();
            while (it.hasNext()) {
                TableView view = (TableView)it.next();
                view.removeFK_DuplicatingJoins();
                String sel = view.getSelectDef();
                if (sel == null || sel.isEmpty()) continue;
                List<SQLAnalyzer.PDescriptor> list_cols = SQLAnalyzer.getTablesAndColumns(sel, view.getSchema(), containers);
                List<SQLAnalyzer.PDescriptor> list = SQLAnalyzer.getTables(sel);
                for (SQLAnalyzer.PDescriptor pd : list) {
                    if ("DUAL".equalsIgnoreCase(pd.name)) continue;
                    SQLNameHelper nh = new SQLNameHelper(true, false);
                    if (pd.schema != null) {
                        nh.setSchema(pd.schema.toUpperCase());
                    } else {
                        nh.setSchema(view.getSchema());
                    }
                    nh.setTableName(pd.name.toUpperCase());
                    nh.setContainer(true);
                    view.getSQLNames().add(nh);
                }
            }
            TimeLog.log("end parsing of views");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUK_PK_FK_CHECK_Constraints(Connection sqlConnection, List dbos, Map ukMap, List fkTempList) throws SQLException {
        StringBuffer buffer = new StringBuffer();
        buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("CONSTRAINT_NAME").append(',');
        buffer.append("COLUMN_NAME").append(',');
        buffer.append("POSITION").append(' ');
        buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_cons_columns" : "all_cons_columns").append(' ');
        buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
        buffer.append("AND").append(' ').append("TABLE_NAME").append('=').append('?').append(' ');
        buffer.append("ORDER BY").append(' ').append("CONSTRAINT_NAME").append(',').append("POSITION").append(',').append("COLUMN_NAME");
        String ncol_sql = buffer.toString();
        PreparedStatement ncol_st = null;
        buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("CONSTRAINT_NAME").append(',');
        buffer.append("CONSTRAINT_TYPE").append(',');
        buffer.append("R_OWNER").append(',');
        buffer.append("R_CONSTRAINT_NAME").append(',');
        buffer.append("INDEX_NAME").append(',');
        buffer.append("GENERATED").append(',');
        buffer.append("RELY").append(' ');
        buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_constraints" : "all_constraints").append(' ');
        buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
        buffer.append("AND").append(' ').append("TABLE_NAME").append('=').append('?').append(' ');
        buffer.append("AND").append(' ').append("CONSTRAINT_TYPE").append(' ').append("IN").append(' ');
        buffer.append('(').append("'P','U','C','R'").append(')').append(' ');
        buffer.append("ORDER BY").append(' ').append("CONSTRAINT_NAME");
        String sql = buffer.toString();
        PreparedStatement statement = null;
        try {
            Iterator it = dbos.iterator();
            boolean first = true;
            TreeMap<String, ArrayList<String>> map = new TreeMap<String, ArrayList<String>>();
            while (it.hasNext()) {
                DBObject dbo = (DBObject)it.next();
                TableView view = (TableView)dbo.getTable();
                int uk_count = 0;
                String ownerName = dbo.getSchema();
                ResultSet rs = null;
                try {
                    if (statement == null) {
                        statement = sqlConnection.prepareStatement(sql);
                    }
                    statement.setString(1, dbo.getSchema());
                    statement.setString(2, dbo.getName());
                    rs = statement.executeQuery();
                    first = true;
                    if (rs != null) {
                        while (rs.next()) {
                            String constrName = rs.getString(1);
                            String constrType = rs.getString(2);
                            if (first) {
                                ResultSet nrs = null;
                                first = false;
                                map.clear();
                                if (ncol_st == null) {
                                    ncol_st = sqlConnection.prepareStatement(ncol_sql);
                                }
                                try {
                                    ncol_st.setString(1, dbo.getSchema());
                                    ncol_st.setString(2, dbo.getName());
                                    nrs = ncol_st.executeQuery();
                                    if (nrs != null) {
                                        while (nrs.next()) {
                                            String cName = nrs.getString(1);
                                            String colName = Token.removeQuotes(nrs.getString(2));
                                            ArrayList<String> list = (ArrayList<String>)map.get(cName);
                                            if (list == null) {
                                                list = new ArrayList<String>();
                                                map.put(cName, list);
                                            }
                                            list.add(colName);
                                        }
                                        nrs.close();
                                    }
                                    Closeables.close((Object)nrs);
                                }
                                catch (Exception e) {
                                    LOGGER.error("MOHViewOracle.initUK_PK_FK_CHECK_Constraints():", e);
                                }
                                finally {
                                    Closeables.close(nrs);
                                }
                            }
                            if ("R".equalsIgnoreCase(constrType)) {
                                MOHTableOracle.FKTemp fktemp = new MOHTableOracle.FKTemp();
                                fkTempList.add(fktemp);
                                fktemp.name = constrName;
                                fktemp.UK_Owner = rs.getString(3);
                                fktemp.UK_Name = rs.getString(4);
                                fktemp.view = (TableView)dbo.getTable();
                                fktemp.rely = rs.getString(7);
                                this.initFK_Columns(map, constrName, fktemp.columns);
                                continue;
                            }
                            if ("C".equalsIgnoreCase(constrType)) continue;
                            String ind_name = rs.getString(5);
                            String generated = rs.getString(6);
                            ViewIndex index = null;
                            if (ind_name != null) {
                                if (!generated.equalsIgnoreCase("USER NAME")) {
                                    if (constrName.equals(ind_name)) {
                                        index = view.getIndexByName(ind_name);
                                    }
                                } else if (!constrName.equals(ind_name)) {
                                    index = view.getIndexByName(constrName);
                                }
                            }
                            if ("P".equalsIgnoreCase(constrType) && view.isBST()) {
                                if (index != null) {
                                    ViewIndex existingPK = (ViewIndex)view.getPK();
                                    if (existingPK != null) {
                                        existingPK.getElementsCollection().clear();
                                        if (index != existingPK) {
                                            index.remove();
                                            index = existingPK;
                                        }
                                    }
                                    if (generated.equalsIgnoreCase("USER NAME")) {
                                        index.setName(constrName);
                                    } else {
                                        index.setName(ind_name);
                                    }
                                } else {
                                    ViewIndex pk = (ViewIndex)view.getPK();
                                    if (pk == null) {
                                        pk = view.createIndex();
                                    }
                                    String pkName = generated.equalsIgnoreCase("USER NAME") ? constrName : ind_name;
                                    pk.setName(pkName);
                                    if (!pkName.equals(pkName.toUpperCase(Locale.ROOT))) {
                                        pk.setNameHasQuotes(true);
                                    }
                                    this.stampModelObject((ModelObject)pk, view.getSchema(), pk.getName());
                                    this.initPK_UK_Columns(pk, map, constrName);
                                    if ("".equals(pk.getIndexExpression())) {
                                        ColumnView col = (ColumnView)view.getOidElement();
                                        if (col != null) {
                                            pk.remove(col);
                                        }
                                        ArrayList<String> colNames = new ArrayList<String>();
                                        for (Column column : pk.getElementsCollection()) {
                                            colNames.add(column.getName());
                                        }
                                        ViewIndex idx = this.getIndexForColumnNames(view, colNames, pk);
                                        if (idx != null) {
                                            idx.remove();
                                        }
                                    }
                                }
                            } else if (index == null) {
                                index = view.createIndex();
                            }
                            if (index == null) continue;
                            ukMap.put(ownerName + constrName, index);
                            if ("U".equalsIgnoreCase(constrType)) {
                                index.setIndexState("Unique Constraint");
                                ++uk_count;
                            } else if ("P".equalsIgnoreCase(constrType) && !view.isBST()) {
                                index.setIndexState("Primary Constraint");
                            }
                            boolean valid = true;
                            if (index.getElementsCollection().size() == 0) {
                                valid = this.initPK_UK_Columns(index, map, constrName);
                            }
                            if (!valid || view.isBST() && !"".equals(index.getIndexExpression())) {
                                ukMap.put(ownerName + constrName, index.getView());
                                index.remove();
                            }
                            if (index.isRemoved()) continue;
                            if (generated.equalsIgnoreCase("USER NAME")) {
                                index.setName(constrName);
                                if (!constrName.equals(constrName.toUpperCase(Locale.ROOT))) {
                                    index.setNameHasQuotes(true);
                                }
                                this.stampModelObject((ModelObject)index, view.getSchema(), index.getName());
                                continue;
                            }
                            String tname = view.getName();
                            String abbrname = view.getAbbreviation();
                            if (abbrname == null || "".equals(abbrname)) {
                                abbrname = tname;
                            }
                            index.setName(constrName);
                            this.stampModelObject((ModelObject)index, view.getSchema(), constrName);
                        }
                        rs.close();
                    }
                    Closeables.close((Object)rs);
                }
                catch (Exception e) {
                    LOGGER.error("MOHViewOracle.initUK_PK_FK_CHECK_Constraints():", e);
                }
                finally {
                    Closeables.close(rs);
                }
            }
        }
        catch (Throwable throwable) {
            Closeables.close((Object[])new PreparedStatement[]{ncol_st, statement});
            throw throwable;
        }
        Closeables.close((Object[])new PreparedStatement[]{ncol_st, statement});
    }

    private void initFK_Columns(Map map, String constrName, List columns) throws SQLException {
        List list = (List)map.get(constrName);
        if (list != null) {
            columns.addAll(list);
        }
    }

    private boolean initPK_UK_Columns(ViewIndex index, Map map, String constrName) throws SQLException {
        boolean valid = true;
        List list = (List)map.get(constrName);
        if (list != null) {
            Object ind_expr = "";
            boolean expr = false;
            boolean first = true;
            TableView view = (TableView)index.getContainerWithKeyObject();
            for (int i = 0; i < list.size(); ++i) {
                String colName = (String)list.get(i);
                if (first) {
                    ind_expr = colName;
                    first = false;
                } else {
                    ind_expr = (String)ind_expr + "," + colName;
                }
                ColumnView column = (ColumnView)view.getElementByName(colName);
                if (column != null) {
                    if (column.getCollectionType() != null || column.getStructuredType() != null) {
                        valid = false;
                    }
                    index.add(column);
                    continue;
                }
                if (colName.startsWith("SYS_NC")) {
                    valid = false;
                }
                expr = true;
            }
            if (expr) {
                index.getElementsCollection().clear();
                index.setIndexExpression((String)ind_expr);
            }
        }
        return valid;
    }

    private ViewIndex getIndexForColumnNames(TableView view, List names, ViewIndex notThis) {
        ViewIndex[] inds = (ViewIndex[])view.getKeys();
        for (int i = 0; i < inds.length; ++i) {
            if (inds[i] == notThis || !this.isIndexForColumnNames(inds[i], names)) continue;
            return inds[i];
        }
        return null;
    }

    private boolean isIndexForColumnNames(ViewIndex index, List names) {
        ColumnView[] columns = (ColumnView[])index.getElements();
        if (columns.length != names.size()) {
            return false;
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getName().equalsIgnoreCase((String)names.get(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void createFKeys(Connection sqlConnection, List fkTempList, Map ukMap) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("TABLE_NAME").append(',');
        buffer.append("COLUMN_NAME").append(',');
        buffer.append("POSITION").append(' ');
        buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_cons_columns" : "all_cons_columns").append(' ');
        buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
        buffer.append("AND").append(' ').append("CONSTRAINT_NAME").append('=').append('?').append(' ');
        buffer.append("ORDER BY").append(' ').append("POSITION").append(',').append("COLUMN_NAME");
        String fk_sql = buffer.toString();
        PreparedStatement fk_statement = null;
        try {
            Map tukMap = null;
            for (MOHTableOracle.FKTemp fkt : fkTempList) {
                try {
                    DesignObject ukMapObject = (DesignObject)ukMap.get(fkt.UK_Owner + fkt.UK_Name);
                    if (ukMapObject == null) {
                        if (tukMap == null) {
                            tukMap = this.getTableHandlerOracle().getUkMap();
                        }
                        if (tukMap != null) {
                            ukMapObject = (DesignObject)tukMap.get(fkt.UK_Owner + fkt.UK_Name);
                        }
                    }
                    KeyObject index = ukMapObject instanceof TableView ? ((TableView)ukMapObject).getPK() : (ukMapObject instanceof Table ? ((Table)ukMapObject).getPK() : (KeyObject)ukMapObject);
                    ArrayList<String> refColumns = new ArrayList<String>();
                    String refTable = null;
                    if (index == null) {
                        index = fkt.view.getIndexByName(fkt.UK_Name);
                        if (index == null) {
                            index = (Index)((RelationalDesign)fkt.view.getDesignPart()).getGlobalIndexSet().getBySchemaAndName(fkt.UK_Owner, fkt.UK_Name);
                            RelationalDesign rd = ((RelationalDesign)fkt.view.getDesignPart()).getRelatedSyncModel();
                            if (index == null && rd != null) {
                                index = (Index)rd.getGlobalIndexSet().getBySchemaAndName(fkt.UK_Owner, fkt.UK_Name);
                            }
                        }
                        if (index == null) {
                            if (fk_statement == null) {
                                fk_statement = sqlConnection.prepareStatement(fk_sql);
                            }
                            fk_statement.setString(1, fkt.UK_Owner);
                            fk_statement.setString(2, fkt.UK_Name);
                            try (ResultSet fk_rs = fk_statement.executeQuery();){
                                if (fk_rs != null) {
                                    while (fk_rs.next()) {
                                        refTable = fk_rs.getString(1);
                                        refColumns.add(fk_rs.getString(2));
                                    }
                                }
                            }
                            index = ((RelationalDesign)fkt.view.getDesignPart()).getViewIndexByMatchingColumns(fkt.UK_Owner, refTable, refColumns);
                        }
                    }
                    FKIndexAssociation fk = null;
                    KeyObject localFKIndex = null;
                    if (index != null) {
                        fk = fkt.view.addFK(index);
                        fk.setName(fkt.name);
                        this.stampModelObject((ModelObject)fk, fkt.view.getSchema(), fkt.name);
                        localFKIndex = fk.getLocalFKIndex();
                        localFKIndex.setName(fkt.name);
                        if (!fkt.name.equals(fkt.name.toUpperCase(Locale.ROOT))) {
                            localFKIndex.setNameHasQuotes(true);
                        }
                        for (int i = 0; i < fkt.columns.size(); ++i) {
                            String colName = fkt.columns.get(i);
                            ColumnView column = (ColumnView)fkt.view.getElementByName(colName);
                            FKElement refCol = null;
                            try {
                                refCol = (FKElement)index.getElement(i);
                            }
                            catch (Exception exception) {
                                continue;
                            }
                            if (column == null || refCol == null) continue;
                            column.addFKAssociation(refCol, fk);
                            localFKIndex.add(column);
                        }
                    } else if (refTable != null && refColumns.size() > 0) {
                        Object refTableName;
                        Object refTableOwner;
                        fk = ((RelationalDesign)fkt.view.getDesignPart()).createForeignKey();
                        fk.setContainerWithKeyObject(fkt.view);
                        fk.setName(fkt.name);
                        fkt.view.setLoadedCompletely(true);
                        fk.addToTable();
                        this.stampModelObject((ModelObject)fk, fkt.view.getSchema(), fkt.name);
                        localFKIndex = fk.getLocalFKIndex();
                        localFKIndex.setName(fkt.name);
                        if (!fkt.name.equals(fkt.name.toUpperCase(Locale.ROOT))) {
                            localFKIndex.setNameHasQuotes(true);
                        }
                        if (!((String)(refTableOwner = fkt.UK_Owner)).equals(((String)refTableOwner).toUpperCase(Locale.ROOT))) {
                            refTableOwner = "\"" + (String)refTableOwner + "\"";
                        }
                        if (!((String)(refTableName = refTable)).equals(((String)refTableName).toUpperCase(Locale.ROOT))) {
                            refTableName = "\"" + (String)refTableName + "\"";
                        }
                        fk.setReferredTableLongName((String)refTableOwner + "." + (String)refTableName);
                        fk.setReferredKeyName(fkt.UK_Name);
                        String refCols = null;
                        for (String string : refColumns) {
                            void var20_30;
                            if (!string.equals(string.toUpperCase(Locale.ROOT))) {
                                String string2 = "\"" + string + "\"";
                            }
                            if (refCols == null) {
                                refCols = var20_30;
                                continue;
                            }
                            refCols = refCols + "," + (String)var20_30;
                        }
                        fk.setReferredColumnNames(refCols);
                        for (int i = 0; i < fkt.columns.size(); ++i) {
                            String string = fkt.columns.get(i);
                            ColumnView column = (ColumnView)fkt.view.getElementByName(string);
                            if (column == null) continue;
                            localFKIndex.add(column);
                        }
                    }
                    if (fk == null) continue;
                    if (fkt.rely != null && fkt.rely.equals("RELY")) {
                        fk.setRely(true);
                    } else {
                        fk.setRely(false);
                    }
                    fk.resetMandatoryUsingColumns();
                }
                catch (Exception e) {
                    LOGGER.error("MOHViewOracle.createFKeys(): " + fkt.name, e);
                }
            }
        }
        finally {
            Closeables.close(fk_statement);
        }
    }

    public MOHTableOracle getTableHandlerOracle() {
        return this.tableHandlerOracle;
    }

    public void setTableHandlerOracle(MOHTableOracle tableHandlerOracle) {
        this.tableHandlerOracle = tableHandlerOracle;
    }

    public Map getUkMap() {
        return this.ukMap;
    }

    class Temp {
        TableView tview;
        String superViewName;

        Temp() {
        }
    }
}

