/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata;

import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.RequestManager;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.metadata.JSONObjToStreamTransformer;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.dbtools.util.Closeables;

public class DataGuideRequestProcessor {
    public static RequestManager.RequestResult processDataGuideRequest(Connection conn, String url, RequestManager.ContentWrapper cw, Map<String, Boolean> options) {
        String oper;
        String[] opers = cw.getParameterValues("oper");
        if (opers.length > 0 && (oper = opers[0]) != null && "dataguide".equalsIgnoreCase(oper)) {
            ArrayList<String[]> guides = new ArrayList<String[]>();
            RequestManager.RequestResult rr = new RequestManager.RequestResult();
            rr.contentType = RequestManager.CT_JSON_UTF8;
            String[] cols = cw.getParameterValues("column");
            List<TableHelper> list = DataGuideRequestProcessor.getTableHelpers(conn, url, cw);
            boolean dbaUser = false;
            if (list.size() > 0) {
                dbaUser = DataGuideRequestProcessor.isDBAUser(conn);
            }
            for (TableHelper th : list) {
                try {
                    if (th.allColumns) {
                        DataGuideRequestProcessor.getCompatibleForJsonColumns(conn, th, dbaUser);
                        guides.addAll(DataGuideRequestProcessor.getDataGuidesForColumns(conn, th, dbaUser));
                        continue;
                    }
                    if (th.declaredJsonColumns) {
                        DataGuideRequestProcessor.getDeclaredJsonColumns(conn, th, dbaUser);
                        guides.addAll(DataGuideRequestProcessor.getDataGuidesForColumns(conn, th, dbaUser));
                        continue;
                    }
                    guides.addAll(DataGuideRequestProcessor.getDataGuidesForColumns(conn, th, dbaUser));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                JSONObjToStreamTransformer.addListOfObjectsInArrays(guides, cw.getWriter(), true);
                cw.getWriter().flush();
                rr.returnedWriter = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            rr.processed = true;
            return rr;
        }
        return null;
    }

    static List<TableHelper> getTableHelpers(Connection conn, String url, RequestManager.ContentWrapper cw) {
        ArrayList<TableHelper> list;
        block9: {
            list = new ArrayList<TableHelper>();
            String defSchema = cw.getParameter("schema");
            String[] tables = cw.getParameterValues("table");
            String[] columns = cw.getParameterValues("column");
            if (defSchema == null || defSchema.isEmpty() || tables.length <= 0) break block9;
            if (tables.length == 1 && columns != null && columns.length > 0) {
                String table = tables[0];
                for (String column : columns) {
                    TableHelper th = new TableHelper();
                    th.schema = defSchema;
                    th.table = table;
                    if ("*".equals(column)) {
                        if (list.size() > 0) {
                            list.clear();
                        }
                        th.allColumns = true;
                        list.add(th);
                        return list;
                    }
                    if (column.startsWith("(", 0) && column.endsWith(")")) {
                        String[] parts;
                        String comp = Token.getValBetweenBrackets(column);
                        for (String part : parts = comp.split(",")) {
                            th.columns.add(part);
                        }
                    } else {
                        th.columns.add(column);
                    }
                    list.add(th);
                }
            } else {
                for (String table : tables) {
                    TableHelper th = new TableHelper();
                    th.schema = defSchema;
                    th.table = table;
                    th.declaredJsonColumns = true;
                    list.add(th);
                }
            }
        }
        return list;
    }

    public static List<String[]> getDataGuideForColumns(Connection conn, String url, RequestManager.ContentWrapper cw, Map<String, Boolean> options) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        String[] guide = new String[]{"name", "column1", "dataGude", "{\r\n\r\n    \"class\": \"oracle.dbtools.crest.model.design.storage.oracle.v10g.SequenceOraclev10g\",\r\n    \"objectType\": \"SEQUENCE\",\r\n    \"name\": \"DEF_SEQUENCE1\",\r\n    \"sourceObjSchema\": \"DMWTEST\",\r\n    \"sourceObjName\": \"DEF_SEQUENCE1\",\r\n    \"commentInRDBMS\": \"\",\r\n    \"cache\": \"20\",\r\n    \"cycle\": \"NO\",\r\n    \"incrementBy\": \"1\",\r\n    \"maxValue\": \"9999999999999999999999999999\",\r\n    \"minValue\": \"1\",\r\n    \"noCache\": \"NO\",\r\n    \"order\": \"NO\",\r\n    \"session\": \"NO\",\r\n    \"startWith\": \"1\",\r\n    \"user\": \"DMWTEST\",\r\n    \"userName\": \"DMWTEST\",\r\n    \"lastNumber\": \"1\",\r\n    \"synonyms\": [ ]\r\n\r\n}"};
        list.add(guide);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDBAUser(Connection conn) {
        if (conn != null) {
            boolean bl;
            PreparedStatement statement = null;
            ResultSet rs = null;
            try {
                String sql = "SELECT 1 FROM DBA_USERS where username = 'SYSTEM'";
                statement = conn.prepareStatement(sql);
                rs = statement.executeQuery();
                Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                sql = "SELECT count(*) FROM DBA_ALL_TABLES where owner = 'sYSt3478'";
                statement = conn.prepareStatement(sql);
                rs = statement.executeQuery();
                bl = true;
            }
            catch (SQLException se) {
                boolean bl2;
                try {
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    try {
                        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                        throw throwable;
                    }
                    catch (Exception ex) {
                        return false;
                    }
                }
                Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                return bl2;
            }
            Closeables.close((Object[])new AutoCloseable[]{rs, statement});
            return bl;
        }
        return false;
    }

    private static void initJSON_DataGuides(Connection sqlConnection, List<TableHelper> helpers) throws Exception {
        String json;
        Clob clob;
        ResultSet rs;
        String tableName;
        List<Column> columns;
        Table table;
        PreparedStatement statement;
        String sql;
        boolean dbaUser = DataGuideRequestProcessor.isDBAUser(sqlConnection);
        String schemaName = "";
        String cur_schema = "";
        try {
            schemaName = sqlConnection.getMetaData().getUserName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (TableHelper th : helpers) {
            if (!th.allColumns && !th.declaredJsonColumns) continue;
        }
        ArrayList flat_dgs = new ArrayList();
        ArrayList hier_dgs = new ArrayList();
        if (hier_dgs.size() > 0) {
            sql = "select DBMS_JSON.GET_INDEX_DATAGUIDE(?,?,DBMS_JSON.FORMAT_HIERARCHICAL, DBMS_JSON.PRETTY) from dual";
            statement = sqlConnection.prepareStatement(sql);
            try {
                for (DBObject dbo : hier_dgs) {
                    table = (Table)dbo.getTable();
                    columns = table.getJSONColumnsIndexed();
                    if (columns.size() <= 0) continue;
                    tableName = table.getName();
                    for (Column col : columns) {
                        try {
                            statement.setString(1, tableName);
                            statement.setString(2, col.getName());
                            rs = statement.executeQuery();
                            try {
                                if (rs == null) continue;
                                if (rs.next() && (clob = rs.getClob(1)) != null && (json = clob.getSubString(1L, (int)clob.length())) != null) {
                                    col.setJsonDataGuide(json);
                                }
                                rs.close();
                            }
                            finally {
                                if (rs == null) continue;
                                rs.close();
                            }
                        }
                        catch (Exception e) {
                            Logger.error_("MOHTableOracle.initJSON_DataGuides(): hier dg", e);
                        }
                    }
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (flat_dgs.size() > 0) {
            sql = "select dataguide from all_json_dataguides where owner = ? and table_name= ? and column_name = ?";
            if (dbaUser) {
                sql = "select dataguide from dba_json_dataguides where owner = ? and table_name= ? and column_name = ?";
            }
            statement = sqlConnection.prepareStatement(sql);
            try {
                for (DBObject dbo : flat_dgs) {
                    table = (Table)dbo.getTable();
                    columns = table.getJSONColumnsIndexed();
                    if (columns.size() <= 0) continue;
                    tableName = table.getName();
                    for (Column col : columns) {
                        try {
                            statement.setString(1, table.getSchema());
                            statement.setString(2, tableName);
                            statement.setString(3, col.getName());
                            rs = statement.executeQuery();
                            try {
                                if (rs == null) continue;
                                if (rs.next() && (json = (clob = rs.getClob(1)).getSubString(1L, (int)clob.length())) != null) {
                                    col.setJsonDataGuide(json);
                                }
                                rs.close();
                            }
                            finally {
                                if (rs == null) continue;
                                rs.close();
                            }
                        }
                        catch (Exception e) {
                            Logger.error_("MOHTableOracle.initJSON_DataGuides(): flat dg", e);
                        }
                    }
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    private static void getDeclaredJsonColumns(Connection conn, TableHelper th, boolean dbaUser) throws Exception {
        if (th.schema != null && th.table != null) {
            String sql = "select column_name from all_json_columns where owner = ? and table_name= ?";
            if (dbaUser) {
                sql = "select column_name from dba_json_columns where owner = ? and table_name= ? ";
            }
            try (PreparedStatement statement = conn.prepareStatement(sql);){
                try {
                    statement.setString(1, th.schema);
                    statement.setString(2, th.table);
                    try (ResultSet rs = statement.executeQuery();){
                        if (rs != null) {
                            while (rs.next()) {
                                String column = rs.getString(1);
                                th.columns.add(column);
                            }
                            rs.close();
                        }
                    }
                }
                catch (Exception e) {
                    Logger.error_("MOHTableOracle.initJSON_DataGuides(): flat dg", e);
                }
            }
        }
    }

    private static void getCompatibleForJsonColumns(Connection conn, TableHelper th, boolean dbaUser) throws Exception {
        if (th.schema != null && th.table != null) {
            String sql = "select column_name from all_tab_columns where owner = ? and table_name = ? and ((data_type ='VARCHAR2' and data_length>260) or (data_type in ('BLOB','CLOB','JSON')))";
            if (dbaUser) {
                sql = "select column_name from dba_tab_columns where owner = ? and table_name = ? and ((data_type ='VARCHAR2' and data_length>260) or (data_type in ('BLOB','CLOB','JSON')))";
            }
            try (PreparedStatement statement = conn.prepareStatement(sql);){
                try {
                    statement.setString(1, th.schema);
                    statement.setString(2, th.table);
                    try (ResultSet rs = statement.executeQuery();){
                        if (rs != null) {
                            while (rs.next()) {
                                String column = rs.getString(1);
                                th.columns.add(column);
                            }
                            rs.close();
                        }
                    }
                }
                catch (Exception e) {
                    Logger.error_("MOHTableOracle.initJSON_DataGuides(): flat dg", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String[]> getDataGuidesForColumns(Connection conn, TableHelper th, boolean dbaUser) throws Exception {
        ArrayList<String[]> list = new ArrayList<String[]>();
        if (th.schema != null && th.table != null && th.columns.size() > 0) {
            Object sql = "select dataguide from all_json_dataguides where owner = ? and table_name= ? and column_name = ?";
            if (dbaUser) {
                sql = "select dataguide from dba_json_dataguides where owner = ? and table_name= ? and column_name = ?";
            }
            ArrayList<String> notprocessed = new ArrayList<String>();
            try (PreparedStatement statement = conn.prepareStatement((String)sql);){
                for (String column : th.columns) {
                    try {
                        statement.setString(1, th.schema);
                        statement.setString(2, th.table);
                        statement.setString(3, column);
                        ResultSet rs = statement.executeQuery();
                        try {
                            if (rs != null) {
                                if (rs.next()) {
                                    Clob clob = rs.getClob(1);
                                    String json = clob.getSubString(1L, (int)clob.length());
                                    if (json != null) {
                                        String[] dg = new String[]{"name", DataGuideRequestProcessor.enQuoteName(column), "dataguide", json};
                                        list.add(dg);
                                    } else {
                                        notprocessed.add(column);
                                    }
                                } else {
                                    notprocessed.add(column);
                                }
                                rs.close();
                                continue;
                            }
                            notprocessed.add(column);
                        }
                        finally {
                            if (rs == null) continue;
                            rs.close();
                        }
                    }
                    catch (Exception e) {
                        Logger.error_("MOHTableOracle.initJSON_DataGuides(): flat dg", e);
                    }
                }
            }
            if (notprocessed.size() > 0) {
                ResultSet rs;
                block34: {
                    statement = null;
                    rs = null;
                    try {
                        boolean valid = DataGuideRequestProcessor.isSchemaName(conn, th.schema);
                        if (!valid) break block34;
                        String tname = th.table;
                        if (tname != null) {
                            tname = DataGuideRequestProcessor.enQuoteName(tname);
                        }
                        if (!(valid = DataGuideRequestProcessor.isObjectName(conn, th.schema + "." + tname))) break block34;
                        sql = "select ";
                        boolean first = true;
                        for (String column : notprocessed) {
                            if (!first) {
                                sql = (String)sql + ",";
                            } else {
                                first = false;
                            }
                            sql = (String)sql + " json_dataguide(\"" + column + "\") ";
                        }
                        statement = conn.prepareStatement((String)(sql = (String)sql + " from " + th.schema + "." + tname));
                        rs = statement.executeQuery();
                        if (rs == null || !rs.next()) break block34;
                        int k = 1;
                        for (String column : notprocessed) {
                            String json;
                            Clob clob = rs.getClob(k);
                            if (clob != null && clob.length() > 0L && (json = clob.getSubString(1L, (int)clob.length())) != null && !json.isEmpty()) {
                                String[] dg = new String[]{"name", DataGuideRequestProcessor.enQuoteName(column), "dataguide", json};
                                list.add(dg);
                            }
                            ++k;
                        }
                    }
                    catch (Exception e) {
                        try {
                            String mes = e.getMessage();
                            if (mes != null && !mes.isEmpty()) {
                                String[] er = new String[]{"error", DataGuideRequestProcessor.enQuoteName(StringUtilities.encodeAttributeValueJSON(mes))};
                                list.add(er);
                            }
                            e.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                            throw throwable;
                        }
                        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                    }
                }
                Closeables.close((Object[])new AutoCloseable[]{rs, statement});
            }
        }
        return list;
    }

    static String enQuoteName(String value) {
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return value;
        }
        return "\"" + value + "\"";
    }

    public static boolean isSchemaName(Connection conn, String name) throws Exception {
        boolean bl;
        String sql = "SELECT sys.DBMS_ASSERT.SCHEMA_NAME( ? ) FROM dual";
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = conn.prepareStatement(sql);
            statement.setString(1, name);
            rs = statement.executeQuery();
            bl = true;
        }
        catch (Exception e) {
            try {
                Logger.error_("Bad schema name - " + name, e);
                throw e;
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                throw throwable;
            }
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
        return bl;
    }

    public static boolean isObjectName(Connection conn, String name) throws Exception {
        boolean bl;
        String sql = "SELECT sys.DBMS_ASSERT.SQL_OBJECT_NAME( ? ) FROM dual";
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = conn.prepareStatement(sql);
            statement.setString(1, name);
            rs = statement.executeQuery();
            bl = true;
        }
        catch (Exception e) {
            try {
                Logger.error_("Bad object name - " + name, e);
                throw e;
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                throw throwable;
            }
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
        return bl;
    }

    public static void main(String[] args) {
    }

    static class TableHelper {
        public String schema;
        public String table;
        public boolean allColumns;
        public boolean declaredJsonColumns;
        public List<String> columns = new ArrayList<String>();
        public List<String[]> dguides = new ArrayList<String[]>();

        TableHelper() {
        }
    }
}

