/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.scheduling.compare;

import java.util.List;
import oracle.dbtools.crest.exports.ddl.DDLGenerator;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.exports.ddl.scheduling.compare.ScheduleComparerDDLGenerator;
import oracle.dbtools.crest.model.scheduling.compare.SchedulerObjectCompare;
import oracle.dbtools.crest.util.string.StringUtilities;

public class SchedulerCDDLMaker {
    private StringBuffer contentBuffer;
    private String content;

    public StringBuffer buffer() {
        if (this.contentBuffer == null) {
            this.contentBuffer = new StringBuffer();
        }
        return this.contentBuffer;
    }

    private String appendStatementFor(Object object, DDLGenerator generator) {
        StringBuffer buffer = new StringBuffer();
        generator.appendDDLFor(buffer, object);
        String result = buffer.toString();
        if (!"".equalsIgnoreCase(result.trim())) {
            result = StringUtilities.rtrim(StringUtilities.ltrim(result));
            this.buffer().append(result);
            this.buffer().append(this.newline());
            this.buffer().append(this.newline());
        }
        return result;
    }

    public String newline() {
        return SQLStatementBuilder.NEWLINE;
    }

    public void clearContent() {
        this.buffer().setLength(0);
        this.content = null;
    }

    public String getContent() {
        if (this.content == null) {
            this.content = this.buffer().toString();
        }
        return this.content;
    }

    public void generateDDLContent(List<SchedulerObjectCompare> objects) {
        ScheduleComparerDDLGenerator gen = new ScheduleComparerDDLGenerator();
        for (SchedulerObjectCompare object : objects) {
            this.appendStatementFor(object, gen);
        }
    }
}

