/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.scheduling.compare;

import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.crest.exports.ddl.scheduling.compare.CSSBScheduler;
import oracle.dbtools.crest.exports.ddl.scheduling.compare.CSSBSchedulerJob;
import oracle.dbtools.crest.model.scheduling.SchedulerSchedule;
import oracle.dbtools.crest.model.scheduling.compare.SchedulerObjectCompare;

public class CSSBSchedulerSchedule
extends CSSBScheduler {
    Map<String, String> excludeNullsMap = new HashMap<String, String>();

    public CSSBSchedulerSchedule() {
        this.excludeNullsMap.put("OWNER", "OWNER");
        this.excludeNullsMap.put("SCHEDULE_NAME", "SCHEDULE_NAME");
        this.excludeNullsMap.put("REPEAT_INTERVAL", "REPEAT_INTERVAL");
        this.excludeNullsMap.put("FILE_WATCHER_NAME", "FILE_WATCHER_NAME");
        this.excludeNullsMap.put("FILE_WATCHER_OWNER", "FILE_WATCHER_OWNER");
        this.excludeNullsMap.put("SCHEDULE_TYPE", "SCHEDULE_TYPE");
        this.excludeNullsMap.put("EVENT_QUEUE_OWNER", "EVENT_QUEUE_OWNER");
        this.excludeNullsMap.put("EVENT_QUEUE_NAME", "EVENT_QUEUE_NAME");
        this.excludeNullsMap.put("EVENT_QUEUE_AGENT", "EVENT_QUEUE_AGENT");
        this.excludeNullsMap.put("EVENT_CONDITION", "EVENT_CONDITION");
        this.excludeNullsMap.put("HAS_CONSTRAINTS", "HAS_CONSTRAINTS");
        this.excludeNullsMap.put("ENABLED", "ENABLED");
    }

    @Override
    public Map<String, String> getExcludeMap() {
        if (this.excludeMap == null) {
            this.excludeMap = new HashMap();
        }
        this.excludeMap.put("OWNER", "OWNER");
        this.excludeMap.put("SCHEDULE_NAME", "SCHEDULE_NAME");
        this.excludeMap.put("FILE_WATCHER_NAME", "FILE_WATCHER_NAME");
        this.excludeMap.put("FILE_WATCHER_OWNER", "FILE_WATCHER_OWNER");
        this.excludeMap.put("SCHEDULE_TYPE", "SCHEDULE_TYPE");
        this.excludeMap.put("EVENT_QUEUE_OWNER", "EVENT_QUEUE_OWNER");
        this.excludeMap.put("EVENT_QUEUE_NAME", "EVENT_QUEUE_NAME");
        this.excludeMap.put("EVENT_QUEUE_AGENT", "EVENT_QUEUE_AGENT");
        this.excludeMap.put("EVENT_CONDITION", "EVENT_CONDITION");
        this.excludeMap.put("ENABLED", "ENABLED");
        return this.excludeMap;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        SchedulerObjectCompare comp;
        if (object instanceof SchedulerObjectCompare && (comp = (SchedulerObjectCompare)object).isModified()) {
            Map<String, String> excludeMap = this.getExcludeMap();
            StringBuffer buffer = new StringBuffer();
            CSSBSchedulerSchedule.appendStringWithSpace(buffer, "BEGIN");
            CSSBSchedulerJob.appendFileWatcherQueueSpec(buffer, comp, prettyPrint);
            CSSBSchedulerJob.appendEventQueueDetails(buffer, comp, prettyPrint);
            CSSBSchedulerSchedule.appendAtrtributes(buffer, comp, prettyPrint, excludeMap);
            CSSBSchedulerSchedule.appendNewLine(buffer, prettyPrint, 0);
            CSSBSchedulerSchedule.appendString(buffer, "END");
            CSSBSchedulerSchedule.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, "");
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SchedulerObjectCompare && ((SchedulerObjectCompare)object).getSource() instanceof SchedulerSchedule;
    }
}

