/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.scheduling;

import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.crest.exports.ddl.DDLAdvancedGenerator;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.exports.ddl.scheduling.DDLConstantsSched;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;

public abstract class SQLStatementBuilderScheduler
extends SQLStatementBuilder
implements DDLConstantsSched {
    protected Map<String, String> excludeMap;

    @Override
    public DDLAdvancedGenerator getddlAdvancedGenenerator() {
        return null;
    }

    public Map<String, String> getExcludeMap() {
        if (this.excludeMap == null) {
            this.excludeMap = new HashMap<String, String>();
        }
        return this.excludeMap;
    }

    public static String replaceSingle_Quote(String fromBuffer) {
        return fromBuffer.replaceAll("\\'", "\\'\\'");
    }

    public static void appendEnable(StringBuffer buffer, SchedulerObject job, boolean prettyPrint) {
        String res = job.getProperty("ENABLED");
        if (res != null && !res.isEmpty() && "TRUE".equalsIgnoreCase(res)) {
            String name = job.getNameFormatted();
            SQLStatementBuilderScheduler.appendNewLine(buffer, prettyPrint, 1);
            SQLStatementBuilderScheduler.appendStringWithSpace(buffer, "SYS.DBMS_SCHEDULER.enable(name => '" + name + "');");
        }
    }

    public void appendAtrtributes(StringBuffer buffer, SchedulerObject job, boolean prettyPrint, Map<String, String> excludeMap) {
        for (String prop : job.getPropsList()) {
            String def;
            String value;
            if (this.getExcludeMap().get(prop) != null || (value = job.getProperty(prop)) == null || (def = job.getDefaultValue(prop)) != null && def.equalsIgnoreCase(value)) continue;
            String dataType = job.getPropertyDataType(prop);
            SQLStatementBuilderScheduler.appendSetAttribute(buffer, job.getNameFormatted(), prop, SQLStatementBuilderScheduler.replaceSingle_Quote(value), dataType, prettyPrint);
        }
    }

    public static void appendSetAttribute(StringBuffer buffer, String name, String attribute, String value, String dataType, boolean prettyPrint) {
        if (name != null && !name.isEmpty() && attribute != null && !attribute.isEmpty()) {
            SQLStatementBuilderScheduler.appendNewLine(buffer, prettyPrint, 1);
            SQLStatementBuilderScheduler.appendStringWithSpace(buffer, "SYS.DBMS_SCHEDULER.SET_ATTRIBUTE(");
            SQLStatementBuilderScheduler.appendNewLine(buffer, prettyPrint, 2);
            SQLStatementBuilderScheduler.appendString(buffer, "NAME".toLowerCase() + " => '" + name + "',");
            SQLStatementBuilderScheduler.appendNewLine(buffer, prettyPrint, 2);
            SQLStatementBuilderScheduler.appendString(buffer, "ATTRIBUTE".toLowerCase() + " => '" + attribute + "',");
            SQLStatementBuilderScheduler.appendNewLine(buffer, prettyPrint, 2);
            if (value == null) {
                SQLStatementBuilderScheduler.appendString(buffer, "VALUE".toLowerCase() + " => null");
            } else if (dataType != null && !dataType.isEmpty()) {
                String dt = dataType.toUpperCase();
                if (dt.startsWith("VARCHAR") || dt.startsWith("STRING")) {
                    SQLStatementBuilderScheduler.appendString(buffer, "VALUE".toLowerCase() + " => '" + value + "'");
                } else if (dt.startsWith("BOOLEAN") || dt.startsWith("NUMBER")) {
                    SQLStatementBuilderScheduler.appendString(buffer, "VALUE".toLowerCase() + " => " + value);
                } else if (dt.startsWith("TIMESTAMP") && dt.indexOf("WITH") > 0 && dt.indexOf("ZONE") > 0) {
                    SQLStatementBuilderScheduler.appendString(buffer, "VALUE".toLowerCase() + " => TO_TIMESTAMP_TZ('" + value + "','YYYY-MM-DD\"T\"HH24:MI:SS.FF TZR')");
                } else if (dt.startsWith("TIMESTAMP")) {
                    SQLStatementBuilderScheduler.appendString(buffer, "VALUE".toLowerCase() + " => TO_TIMESTAMP('" + value + "','YYYY-MM-DD\"T\"HH24:MI:SS.FF')");
                } else if (dt.startsWith("INTERVAL")) {
                    SQLStatementBuilderScheduler.appendString(buffer, "VALUE".toLowerCase() + " => to_dsinterval('" + value + "')");
                }
            }
            SQLStatementBuilderScheduler.appendString(buffer, ");");
        }
    }

    public static String getValue(SchedulerObject job, String prop) {
        String value = job.getProperty(prop);
        if (value != null) {
            String dataType = job.getPropertyDataType(prop);
            value = SQLStatementBuilderScheduler.getValue(value, dataType);
        }
        return value;
    }

    public static String getValue(String value, String dataType) {
        if (dataType != null) {
            String dt = dataType.toUpperCase();
            if (dt.startsWith("VARCHAR") || dt.startsWith("STRING")) {
                return "'" + value + "'";
            }
            if (dt.startsWith("BOOLEAN") || dt.startsWith("NUMBER")) {
                return value;
            }
            if (dt.startsWith("TIMESTAMP")) {
                if (value.toUpperCase().startsWith("TO_TIMESTAMP")) {
                    return value;
                }
                return "TO_TIMESTAMP_TZ('" + value + "','YYYY-MM-DD\"T\"HH24:MI:SS.FF TZR')";
            }
            if (dt.startsWith("INTERVAL")) {
                if (value.toUpperCase().startsWith("TO_DSINTERVAL(")) {
                    return value;
                }
                return "TO_DSINTERVAL('" + value + "')";
            }
        }
        return "'" + value + "'";
    }

    public static void appendArgument(StringBuffer buffer, SchedulerObject obj, String prop, boolean prettyPrint) {
        String value = SQLStatementBuilderScheduler.getValue(obj, prop);
        SQLStatementBuilderScheduler.appendString(buffer, ',');
        SQLStatementBuilderScheduler.appendNewLine(buffer, prettyPrint, 2);
        if (value != null) {
            SQLStatementBuilderScheduler.appendString(buffer, prop.toLowerCase() + " => " + value);
        } else {
            SQLStatementBuilderScheduler.appendString(buffer, prop.toLowerCase() + " => null");
        }
    }

    public static void appendStringAttribute(StringBuffer buffer, String name, String value, boolean prettyPrint) {
        SQLStatementBuilderScheduler.appendNewLine(buffer, prettyPrint, 2);
        SQLStatementBuilderScheduler.appendString(buffer, name + " => '" + value + "'");
    }

    public static void appendNonStringAttribute(StringBuffer buffer, String name, String value, boolean prettyPrint) {
        SQLStatementBuilderScheduler.appendNewLine(buffer, prettyPrint, 2);
        SQLStatementBuilderScheduler.appendString(buffer, name + " => " + value);
    }

    public static void appendCredential(StringBuffer buffer, SchedulerObject job, boolean prettyPrint) {
        String res = job.getCredentialNameFormatted();
        if (res != null && !res.isEmpty()) {
            SQLStatementBuilderScheduler.appendString(buffer, ',');
            SQLStatementBuilderScheduler.appendNewLine(buffer, prettyPrint, 2);
            SQLStatementBuilderScheduler.appendString(buffer, "credential_name => '" + res + "'");
        }
    }
}

