/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.oci;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import oracle.dbtools.oci.OciUtils;

public class OCISignature {
    private static final String PKCS_1_PEM_HEADER = "-----BEGIN RSA PRIVATE KEY-----";
    private static final String PKCS_1_PEM_FOOTER = "-----END RSA PRIVATE KEY-----";
    private static final String PKCS_8_PEM_HEADER = "-----BEGIN PRIVATE KEY-----";
    private static final String PKCS_8_PEM_FOOTER = "-----END PRIVATE KEY-----";
    private PrivateKey _privateKey;
    private String _keyId;

    public OCISignature(String keyString, String keyId) throws GeneralSecurityException, IOException {
        this._keyId = keyId;
        this._privateKey = this.loadKey(keyString.replaceAll("\n", ""));
    }

    public OCISignature(File keyFile, String keyId) throws GeneralSecurityException, IOException {
        this._keyId = keyId;
        this._privateKey = this.loadKeyFile(keyFile.getAbsolutePath());
    }

    public String signSHA256RSA(String input, String key) throws Exception {
        return this.signSHA256RSA(input);
    }

    private String signSHA256RSA(String input) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, UnsupportedEncodingException {
        Signature privateSignature = Signature.getInstance("SHA256withRSA");
        privateSignature.initSign(this._privateKey);
        privateSignature.update(input.getBytes("UTF-8"));
        byte[] s = privateSignature.sign();
        return Base64.getEncoder().encodeToString(s);
    }

    public PrivateKey loadKeyFile(String keyFilePath) throws GeneralSecurityException, IOException {
        byte[] keyDataBytes = Files.readAllBytes(Paths.get(OciUtils.substituteHomeDirectory(keyFilePath), new String[0]));
        return this.loadKey(new String(keyDataBytes, StandardCharsets.UTF_8));
    }

    public PrivateKey loadKey(String keyDataString) throws GeneralSecurityException, IOException {
        if ((keyDataString = keyDataString.replaceAll("[\r\n]", "")).contains(PKCS_1_PEM_HEADER)) {
            keyDataString = keyDataString.replace(PKCS_1_PEM_HEADER, "");
            keyDataString = keyDataString.replace(PKCS_1_PEM_FOOTER, "");
            return this.readPkcs1PrivateKey(Base64.getDecoder().decode(keyDataString));
        }
        if (keyDataString.contains(PKCS_8_PEM_HEADER)) {
            keyDataString = keyDataString.replace(PKCS_8_PEM_HEADER, "");
            keyDataString = keyDataString.replace(PKCS_8_PEM_FOOTER, "");
            return this.readPkcs8PrivateKey(Base64.getDecoder().decode(keyDataString));
        }
        return this.readPkcs8PrivateKey(keyDataString.getBytes());
    }

    private PrivateKey readPkcs8PrivateKey(byte[] pkcs8Bytes) throws GeneralSecurityException {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", "SunRsaSign");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(pkcs8Bytes);
        try {
            return keyFactory.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException("Invalid key format", e);
        }
    }

    private PrivateKey readPkcs1PrivateKey(byte[] pkcs1Bytes) throws GeneralSecurityException {
        int pkcs1Length = pkcs1Bytes.length;
        int totalLength = pkcs1Length + 22;
        byte[] pkcs8Header = new byte[]{48, -126, (byte)(totalLength >> 8 & 0xFF), (byte)(totalLength & 0xFF), 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 4, -126, (byte)(pkcs1Length >> 8 & 0xFF), (byte)(pkcs1Length & 0xFF)};
        byte[] pkcs8bytes = this.join(pkcs8Header, pkcs1Bytes);
        return this.readPkcs8PrivateKey(pkcs8bytes);
    }

    private byte[] join(byte[] byteArray1, byte[] byteArray2) {
        byte[] bytes = new byte[byteArray1.length + byteArray2.length];
        System.arraycopy(byteArray1, 0, bytes, 0, byteArray1.length);
        System.arraycopy(byteArray2, 0, bytes, byteArray1.length, byteArray2.length);
        return bytes;
    }

    public String ociAuthHeader(String singingString, String headers) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException, UnsupportedEncodingException {
        if (this._keyId == null) {
            throw new SignatureException("No OCI Information provided");
        }
        String alg = "rsa-sha256";
        String sigVersion = "1";
        String header = "(request-target) " + headers;
        String sig = this.signSHA256RSA(singingString);
        String authHeader = "Signature version=\"" + sigVersion + "\",keyId=\"" + this._keyId + "\",algorithm=\"" + alg + "\",headers=\"" + header + "\",signature=\"" + sig + "\"";
        return authHeader;
    }

    public static String sha256Digest(File fileName) throws NoSuchAlgorithmException, IOException {
        int count;
        byte[] buffer = new byte[8192];
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fileName));
        while ((count = bis.read(buffer)) > 0) {
            digest.update(buffer, 0, count);
        }
        bis.close();
        byte[] encodedhash = digest.digest();
        return Base64.getEncoder().encodeToString(encodedhash);
    }

    public static String sha256Digest(String s) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] encodedhash = digest.digest(s.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(encodedhash);
    }

    public static class Builder {
        private String _keyString;
        private File _keyFile;
        private String _tenancyId;
        private String _authUserId;
        private String _keyFingerprint;

        public Builder keyString(String key) {
            this._keyString = key;
            return this;
        }

        public Builder tenancyId(String tenancyId) {
            this._tenancyId = tenancyId;
            return this;
        }

        public Builder authUserId(String authUserId) {
            this._authUserId = authUserId;
            return this;
        }

        public Builder keyFingerprint(String keyFingerprint) {
            this._keyFingerprint = keyFingerprint;
            return this;
        }

        public Builder keyFile(File key) {
            this._keyFile = key;
            return this;
        }

        public OCISignature build() throws GeneralSecurityException, IOException {
            if (this._keyString != null) {
                return new OCISignature(this._keyString, this._tenancyId + "/" + this._authUserId + "/" + this._keyFingerprint);
            }
            if (this._keyFile != null) {
                return new OCISignature(this._keyFile, this._tenancyId + "/" + this._authUserId + "/" + this._keyFingerprint);
            }
            throw new GeneralSecurityException("no key available");
        }
    }
}

