/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.http;

import java.io.IOException;
import java.io.Reader;
import oracle.dbtools.core.io.StreamCopy;
import oracle.dbtools.http.Client;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.message.StatusLine;

public abstract class AbstractResponseHandler<T>
implements HttpClientResponseHandler<T> {
    public final T handleResponse(ClassicHttpResponse resp) throws ClientProtocolException, IOException {
        T result = null;
        int code = resp.getCode();
        switch (code) {
            case 200: {
                result = this.handleSuccess(resp);
                break;
            }
            case 500: {
                this.report500Error(resp);
            }
            default: {
                result = this.handleError(resp);
            }
        }
        return result;
    }

    protected final void report500Error(ClassicHttpResponse resp) throws IOException {
        StatusLine status = new StatusLine((HttpResponse)resp);
        String contentType = resp.getEntity().getContentType();
        throw this.createInternalServerError(status.toString(), StreamCopy.string((Reader)Client.createReader(resp)), contentType);
    }

    protected abstract T handleSuccess(ClassicHttpResponse var1) throws ClientProtocolException, IOException;

    protected abstract IOException createInternalServerError(String var1, String var2, String var3);

    protected abstract T handleError(ClassicHttpResponse var1) throws ClientProtocolException, IOException;
}

