/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.parser;

import java.util.ArrayList;
import java.util.Formatter;
import oracle.json.parser.QueryException;
import oracle.json.parser.QueryMessage;

public class PathParser {
    private static final char STEP_SEPARATOR = '.';
    private static final char SEG_DELIMITER = '`';
    private static final char SQL_DELIMITER = '\"';
    private static final char ESCAPE_CHAR = '\\';
    private static final char ARRAY_START = '[';
    private static final char ARRAY_STOP = ']';
    private static final char WILD_STEP = '*';
    private static final char ROOT_STEP = '$';
    private static final char CONTEXT_STEP = '@';
    private final String pathString;
    private static final String ALPHA_NUM_UNDER = "_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final int IS_DIGIT_POS = "_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".indexOf(48);

    public PathParser(String string) {
        this.pathString = string;
    }

    private String buildStep(StringBuilder stringBuilder, int n, boolean bl, boolean bl2) throws QueryException {
        String string;
        if (bl && !bl2) {
            if (stringBuilder.length() == 1) {
                this.throwPathException(QueryMessage.EX_EMPTY_PATH_STEP, n);
            }
            if (stringBuilder.length() == 2) {
                char c = stringBuilder.charAt(1);
                if (c == '$' || c == '@') {
                    this.throwPathException(QueryMessage.EX_PATH_SYNTAX_ERROR, n);
                }
                if (c == '*') {
                    bl = false;
                }
            }
        }
        if (!bl) {
            string = stringBuilder.substring(1);
        } else {
            stringBuilder.append('\"');
            string = stringBuilder.toString();
        }
        stringBuilder.setLength(1);
        return string;
    }

    private String buildArrayStep(StringBuilder stringBuilder) {
        stringBuilder.append(']');
        String string = stringBuilder.toString();
        stringBuilder.setLength(0);
        stringBuilder.append('\"');
        return string;
    }

    private void throwException(QueryMessage queryMessage, Object ... objectArray) throws QueryException {
        throw new QueryException(queryMessage.get(objectArray));
    }

    private void throwPathException(QueryMessage queryMessage, int n) throws QueryException {
        this.throwException(queryMessage, this.pathString, Integer.toString(n));
    }

    private void throwArrayException(String string) throws QueryException {
        this.throwException(QueryMessage.EX_BAD_ARRAY_SUBSCRIPT, this.pathString, string);
    }

    private boolean checkIsWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    private int checkWhitespaceBetween(String string, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (this.checkIsWhitespace(string.charAt(i))) continue;
            return i;
        }
        return n2;
    }

    private boolean checkLastPlusNum(String string) {
        char c;
        int n = string.indexOf("last", 1);
        if (n < 0) {
            return false;
        }
        int n2 = string.indexOf(43, n);
        if (n2 < 0) {
            return false;
        }
        int n3 = string.length() - 1;
        if (this.checkWhitespaceBetween(string, 1, n) != n) {
            return false;
        }
        if (this.checkWhitespaceBetween(string, n += "last".length(), n2) != n2) {
            return false;
        }
        n = this.checkWhitespaceBetween(string, n2 + 1, n3);
        if (n == n3) {
            return false;
        }
        while (n < n3 && (c = string.charAt(n)) >= '0' && c <= '9') {
            ++n;
        }
        return this.checkWhitespaceBetween(string, n, n3) == n3;
    }

    private void validateArrayStep(String string) throws QueryException {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = true;
        for (int i = 1; i < string.length() - 1; ++i) {
            char c = string.charAt(i);
            if (c == '*') {
                if (!bl) {
                    this.throwArrayException(string);
                }
                bl = false;
                bl5 = false;
                bl9 = false;
                continue;
            }
            if (c == ',') {
                if (!bl6) {
                    this.throwArrayException(string);
                }
                bl6 = false;
                bl7 = false;
                bl2 = false;
                bl3 = false;
                bl4 = false;
                bl5 = true;
                bl9 = true;
                continue;
            }
            if (c >= '0' && c <= '9') {
                if (!bl5) {
                    this.throwArrayException(string);
                }
                bl = false;
                bl6 = true;
                bl9 = false;
                continue;
            }
            if (c == '-') {
                if (!bl3) {
                    this.throwArrayException(string);
                }
                bl4 = true;
                bl3 = false;
                bl9 = true;
                bl5 = true;
                bl6 = false;
                continue;
            }
            if (this.checkIsWhitespace(c)) {
                if (bl8) {
                    bl8 = false;
                    bl5 = true;
                    bl9 = true;
                } else if (!bl2 && !bl4 && !bl9 && bl6) {
                    bl7 = true;
                }
                if (!bl6) continue;
                bl5 = false;
                continue;
            }
            if (c == 'l') {
                if (bl6) {
                    this.throwArrayException(string);
                }
                if (!string.substring(i).startsWith("last")) {
                    this.throwArrayException(string);
                }
                i += 3;
                bl = false;
                bl6 = true;
                bl5 = false;
                bl9 = false;
                bl3 = true;
                continue;
            }
            if (c == 't') {
                if (!bl7) {
                    this.throwArrayException(string);
                }
                if (!string.substring(i).startsWith("to")) {
                    this.throwArrayException(string);
                }
                ++i;
                bl7 = false;
                bl2 = true;
                bl6 = false;
                bl5 = false;
                bl4 = false;
                bl3 = false;
                bl8 = true;
                continue;
            }
            this.throwArrayException(string);
        }
        if (bl) {
            this.throwArrayException(string);
        }
        if (bl8 || bl9) {
            this.throwArrayException(string);
        }
        if (!bl6 && bl5) {
            this.throwArrayException(string);
        }
    }

    public String[] splitAndSQLEscape() throws QueryException {
        if (this.pathString == null) {
            this.throwException(QueryMessage.EX_EMPTY_PATH, new Object[0]);
        }
        return this.splitSteps(true);
    }

    public String[] splitSteps(boolean bl) throws QueryException {
        return this.splitSteps(bl, false);
    }

    public String[] splitSteps(boolean bl, boolean bl2) throws QueryException {
        if (this.pathString == null) {
            this.throwException(QueryMessage.EX_EMPTY_PATH, new Object[0]);
        }
        char[] cArray = this.pathString.toCharArray();
        int n = cArray.length;
        ArrayList<String> arrayList = new ArrayList<String>(10);
        StringBuilder stringBuilder = new StringBuilder(Math.max(n * 2 + 2, 128));
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = true;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        int n2 = 0;
        stringBuilder.append('\"');
        if (n == 0) {
            bl6 = false;
            bl5 = bl;
        }
        block13: while (n2 < cArray.length) {
            Object object;
            char c = cArray[n2];
            switch (c) {
                case '`': {
                    if (bl4) {
                        this.throwPathException(QueryMessage.EX_BAD_BACKQUOTE, n2);
                    }
                    if (bl7 || bl8) {
                        this.throwPathException(QueryMessage.EX_MISSING_STEP_DOT, n2);
                    }
                    bl9 = false;
                    if (!bl3) {
                        if (stringBuilder.length() > 1) {
                            this.throwPathException(QueryMessage.EX_BAD_BACKQUOTE, n2);
                        }
                        bl3 = true;
                        ++n2;
                        continue block13;
                    }
                    if (++n2 < cArray.length && (c = cArray[n2]) == '`') {
                        stringBuilder.append(c);
                        ++n2;
                        bl5 = bl;
                        continue block13;
                    }
                    if (stringBuilder.length() == 1) {
                        bl5 = bl;
                    }
                    bl3 = false;
                    bl8 = true;
                    continue block13;
                }
                case ']': {
                    if (bl4) {
                        bl4 = false;
                        object = this.buildArrayStep(stringBuilder);
                        if (!bl2 || !this.checkLastPlusNum((String)object)) {
                            this.validateArrayStep((String)object);
                        }
                        arrayList.add((String)object);
                        bl7 = true;
                        bl9 = false;
                        ++n2;
                        continue block13;
                    }
                    if (!bl3 && c == ']') {
                        this.throwPathException(QueryMessage.EX_PATH_SYNTAX_ERROR, n2);
                    }
                }
                case '[': {
                    bl9 = false;
                }
                case '.': {
                    if (bl3 || bl4) break;
                    boolean bl10 = false;
                    boolean bl11 = bl4 = c == '[';
                    if (!bl4 && n2 + 1 < cArray.length && cArray[n2 + 1] == '.') {
                        if (bl9) {
                            this.throwPathException(QueryMessage.EX_EMPTY_PATH_STEP, n2);
                        }
                        bl10 = true;
                        ++n2;
                    }
                    if (stringBuilder.length() > 1 || bl8) {
                        arrayList.add(this.buildStep(stringBuilder, n2, bl5, bl8));
                    } else if (!bl4) {
                        if (!bl7 && !bl10) {
                            this.throwPathException(QueryMessage.EX_EMPTY_PATH_STEP, n2);
                        }
                    } else if (!bl6) {
                        arrayList.add(this.buildStep(stringBuilder, n2, true, bl8));
                    }
                    if (bl10) {
                        arrayList.add(this.buildStep(stringBuilder, n2, false, false));
                        bl9 = true;
                    }
                    bl8 = false;
                    bl6 = bl4;
                    bl5 = false;
                    bl7 = false;
                    ++n2;
                    if (bl4) {
                        stringBuilder.setLength(0);
                        stringBuilder.append('[');
                        continue block13;
                    }
                    if (n2 < cArray.length) continue block13;
                    bl5 = bl;
                    continue block13;
                }
            }
            if (bl7 || bl8) {
                this.throwPathException(QueryMessage.EX_MISSING_STEP_DOT, n2);
            }
            bl9 = false;
            bl6 = true;
            if (bl4) {
                stringBuilder.append(c);
            } else if (c == '\'') {
                if (bl) {
                    stringBuilder.append(c);
                }
                stringBuilder.append(c);
                bl5 = bl;
            } else if (c == '\"' || c == '\\') {
                bl5 = bl;
                if (bl) {
                    stringBuilder.append('\\');
                }
                stringBuilder.append(c);
            } else if (bl && (c < ' ' || c == '\u007f')) {
                stringBuilder.append('\\');
                switch (c) {
                    case '\n': {
                        stringBuilder.append('n');
                        break;
                    }
                    case '\r': {
                        stringBuilder.append('r');
                        break;
                    }
                    case '\t': {
                        stringBuilder.append('t');
                        break;
                    }
                    case '\b': {
                        stringBuilder.append('b');
                        break;
                    }
                    case '\f': {
                        stringBuilder.append('f');
                        break;
                    }
                    default: {
                        object = new Formatter(stringBuilder);
                        ((Formatter)object).format("u%04x", c);
                        ((Formatter)object).close();
                    }
                }
                bl5 = bl;
            } else {
                if (!bl5 && bl) {
                    int n3 = ALPHA_NUM_UNDER.indexOf(c);
                    if (n3 < 0) {
                        bl5 = true;
                    } else if (stringBuilder.length() == 1 && n3 >= IS_DIGIT_POS) {
                        bl5 = true;
                    }
                }
                stringBuilder.append(c);
            }
            ++n2;
        }
        if (bl4) {
            this.throwException(QueryMessage.EX_UNCLOSED_STEP, "array", this.pathString);
        }
        if (bl3) {
            this.throwException(QueryMessage.EX_UNCLOSED_STEP, "quote", this.pathString);
        }
        if (stringBuilder.length() > 1 || !bl6 || bl8) {
            if (stringBuilder.length() == 1 && !bl8) {
                bl5 = true;
            }
            arrayList.add(this.buildStep(stringBuilder, n2, bl5, bl8));
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }
}

