/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.responses;

import com.oracle.bmc.database.model.SchedulingWindow;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CreateSchedulingWindowResponse
extends BmcResponse {
    private String opcWorkRequestId;
    private String etag;
    private String opcRequestId;
    private SchedulingWindow schedulingWindow;

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public SchedulingWindow getSchedulingWindow() {
        return this.schedulingWindow;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcWorkRequestId", "etag", "opcRequestId", "schedulingWindow"})
    private CreateSchedulingWindowResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcWorkRequestId, String etag, String opcRequestId, SchedulingWindow schedulingWindow) {
        super(__httpStatusCode__, headers);
        this.opcWorkRequestId = opcWorkRequestId;
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.schedulingWindow = schedulingWindow;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcWorkRequestId=").append(String.valueOf(this.opcWorkRequestId));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",schedulingWindow=").append(String.valueOf((Object)this.schedulingWindow));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateSchedulingWindowResponse)) {
            return false;
        }
        CreateSchedulingWindowResponse other = (CreateSchedulingWindowResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcWorkRequestId, other.opcWorkRequestId) && Objects.equals(this.etag, other.etag) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.schedulingWindow, (Object)other.schedulingWindow);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcWorkRequestId == null ? 43 : this.opcWorkRequestId.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.schedulingWindow == null ? 43 : this.schedulingWindow.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<CreateSchedulingWindowResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcWorkRequestId;
        private String etag;
        private String opcRequestId;
        private SchedulingWindow schedulingWindow;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder schedulingWindow(SchedulingWindow schedulingWindow) {
            this.schedulingWindow = schedulingWindow;
            return this;
        }

        public Builder copy(CreateSchedulingWindowResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.schedulingWindow(o.getSchedulingWindow());
            return this;
        }

        public CreateSchedulingWindowResponse build() {
            return new CreateSchedulingWindowResponse(this.__httpStatusCode__, this.headers, this.opcWorkRequestId, this.etag, this.opcRequestId, this.schedulingWindow);
        }
    }
}

