/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.database.model.UpdateExecutionWindowDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateExecutionWindowRequest
extends BmcRequest<UpdateExecutionWindowDetails> {
    private String executionWindowId;
    private UpdateExecutionWindowDetails updateExecutionWindowDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getExecutionWindowId() {
        return this.executionWindowId;
    }

    public UpdateExecutionWindowDetails getUpdateExecutionWindowDetails() {
        return this.updateExecutionWindowDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateExecutionWindowDetails getBody$() {
        return this.updateExecutionWindowDetails;
    }

    public Builder toBuilder() {
        return new Builder().executionWindowId(this.executionWindowId).updateExecutionWindowDetails(this.updateExecutionWindowDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",executionWindowId=").append(String.valueOf(this.executionWindowId));
        sb.append(",updateExecutionWindowDetails=").append(String.valueOf((Object)this.updateExecutionWindowDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateExecutionWindowRequest)) {
            return false;
        }
        UpdateExecutionWindowRequest other = (UpdateExecutionWindowRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.executionWindowId, other.executionWindowId) && Objects.equals((Object)this.updateExecutionWindowDetails, (Object)other.updateExecutionWindowDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.executionWindowId == null ? 43 : this.executionWindowId.hashCode());
        result = result * 59 + (this.updateExecutionWindowDetails == null ? 43 : this.updateExecutionWindowDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateExecutionWindowRequest, UpdateExecutionWindowDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String executionWindowId = null;
        private UpdateExecutionWindowDetails updateExecutionWindowDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder executionWindowId(String executionWindowId) {
            this.executionWindowId = executionWindowId;
            return this;
        }

        public Builder updateExecutionWindowDetails(UpdateExecutionWindowDetails updateExecutionWindowDetails) {
            this.updateExecutionWindowDetails = updateExecutionWindowDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateExecutionWindowRequest o) {
            this.executionWindowId(o.getExecutionWindowId());
            this.updateExecutionWindowDetails(o.getUpdateExecutionWindowDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateExecutionWindowRequest build() {
            UpdateExecutionWindowRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateExecutionWindowDetails body) {
            this.updateExecutionWindowDetails(body);
            return this;
        }

        public UpdateExecutionWindowRequest buildWithoutInvocationCallback() {
            UpdateExecutionWindowRequest request = new UpdateExecutionWindowRequest();
            request.executionWindowId = this.executionWindowId;
            request.updateExecutionWindowDetails = this.updateExecutionWindowDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

