/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.database.model.CreateSchedulingWindowDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateSchedulingWindowRequest
extends BmcRequest<CreateSchedulingWindowDetails> {
    private String schedulingPolicyId;
    private CreateSchedulingWindowDetails createSchedulingWindowDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public String getSchedulingPolicyId() {
        return this.schedulingPolicyId;
    }

    public CreateSchedulingWindowDetails getCreateSchedulingWindowDetails() {
        return this.createSchedulingWindowDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CreateSchedulingWindowDetails getBody$() {
        return this.createSchedulingWindowDetails;
    }

    public Builder toBuilder() {
        return new Builder().schedulingPolicyId(this.schedulingPolicyId).createSchedulingWindowDetails(this.createSchedulingWindowDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",schedulingPolicyId=").append(String.valueOf(this.schedulingPolicyId));
        sb.append(",createSchedulingWindowDetails=").append(String.valueOf((Object)this.createSchedulingWindowDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateSchedulingWindowRequest)) {
            return false;
        }
        CreateSchedulingWindowRequest other = (CreateSchedulingWindowRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.schedulingPolicyId, other.schedulingPolicyId) && Objects.equals((Object)this.createSchedulingWindowDetails, (Object)other.createSchedulingWindowDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.schedulingPolicyId == null ? 43 : this.schedulingPolicyId.hashCode());
        result = result * 59 + (this.createSchedulingWindowDetails == null ? 43 : this.createSchedulingWindowDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateSchedulingWindowRequest, CreateSchedulingWindowDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String schedulingPolicyId = null;
        private CreateSchedulingWindowDetails createSchedulingWindowDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder schedulingPolicyId(String schedulingPolicyId) {
            this.schedulingPolicyId = schedulingPolicyId;
            return this;
        }

        public Builder createSchedulingWindowDetails(CreateSchedulingWindowDetails createSchedulingWindowDetails) {
            this.createSchedulingWindowDetails = createSchedulingWindowDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateSchedulingWindowRequest o) {
            this.schedulingPolicyId(o.getSchedulingPolicyId());
            this.createSchedulingWindowDetails(o.getCreateSchedulingWindowDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateSchedulingWindowRequest build() {
            CreateSchedulingWindowRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateSchedulingWindowDetails body) {
            this.createSchedulingWindowDetails(body);
            return this;
        }

        public CreateSchedulingWindowRequest buildWithoutInvocationCallback() {
            CreateSchedulingWindowRequest request = new CreateSchedulingWindowRequest();
            request.schedulingPolicyId = this.schedulingPolicyId;
            request.createSchedulingWindowDetails = this.createSchedulingWindowDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

