/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.MaintenanceWindow;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateAutonomousVmClusterDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="maintenanceWindowDetails")
    private final MaintenanceWindow maintenanceWindowDetails;
    @JsonProperty(value="licenseModel")
    private final LicenseModel licenseModel;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="autonomousDataStorageSizeInTBs")
    private final Double autonomousDataStorageSizeInTBs;
    @JsonProperty(value="cpuCoreCountPerNode")
    private final Integer cpuCoreCountPerNode;
    @JsonProperty(value="totalContainerDatabases")
    private final Integer totalContainerDatabases;

    @Deprecated
    @ConstructorProperties(value={"maintenanceWindowDetails", "licenseModel", "freeformTags", "definedTags", "autonomousDataStorageSizeInTBs", "cpuCoreCountPerNode", "totalContainerDatabases"})
    public UpdateAutonomousVmClusterDetails(MaintenanceWindow maintenanceWindowDetails, LicenseModel licenseModel, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Double autonomousDataStorageSizeInTBs, Integer cpuCoreCountPerNode, Integer totalContainerDatabases) {
        this.maintenanceWindowDetails = maintenanceWindowDetails;
        this.licenseModel = licenseModel;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.autonomousDataStorageSizeInTBs = autonomousDataStorageSizeInTBs;
        this.cpuCoreCountPerNode = cpuCoreCountPerNode;
        this.totalContainerDatabases = totalContainerDatabases;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public MaintenanceWindow getMaintenanceWindowDetails() {
        return this.maintenanceWindowDetails;
    }

    public LicenseModel getLicenseModel() {
        return this.licenseModel;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Double getAutonomousDataStorageSizeInTBs() {
        return this.autonomousDataStorageSizeInTBs;
    }

    public Integer getCpuCoreCountPerNode() {
        return this.cpuCoreCountPerNode;
    }

    public Integer getTotalContainerDatabases() {
        return this.totalContainerDatabases;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateAutonomousVmClusterDetails(");
        sb.append("super=").append(super.toString());
        sb.append("maintenanceWindowDetails=").append(String.valueOf((Object)this.maintenanceWindowDetails));
        sb.append(", licenseModel=").append(String.valueOf((Object)this.licenseModel));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", autonomousDataStorageSizeInTBs=").append(String.valueOf(this.autonomousDataStorageSizeInTBs));
        sb.append(", cpuCoreCountPerNode=").append(String.valueOf(this.cpuCoreCountPerNode));
        sb.append(", totalContainerDatabases=").append(String.valueOf(this.totalContainerDatabases));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateAutonomousVmClusterDetails)) {
            return false;
        }
        UpdateAutonomousVmClusterDetails other = (UpdateAutonomousVmClusterDetails)((Object)o);
        return Objects.equals((Object)this.maintenanceWindowDetails, (Object)other.maintenanceWindowDetails) && Objects.equals((Object)this.licenseModel, (Object)other.licenseModel) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.autonomousDataStorageSizeInTBs, other.autonomousDataStorageSizeInTBs) && Objects.equals(this.cpuCoreCountPerNode, other.cpuCoreCountPerNode) && Objects.equals(this.totalContainerDatabases, other.totalContainerDatabases) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.maintenanceWindowDetails == null ? 43 : this.maintenanceWindowDetails.hashCode());
        result = result * 59 + (this.licenseModel == null ? 43 : this.licenseModel.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.autonomousDataStorageSizeInTBs == null ? 43 : this.autonomousDataStorageSizeInTBs.hashCode());
        result = result * 59 + (this.cpuCoreCountPerNode == null ? 43 : this.cpuCoreCountPerNode.hashCode());
        result = result * 59 + (this.totalContainerDatabases == null ? 43 : this.totalContainerDatabases.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LicenseModel implements BmcEnum
    {
        LicenseIncluded("LICENSE_INCLUDED"),
        BringYourOwnLicense("BRING_YOUR_OWN_LICENSE");

        private final String value;
        private static Map<String, LicenseModel> map;

        private LicenseModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LicenseModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid LicenseModel: " + key);
        }

        static {
            map = new HashMap<String, LicenseModel>();
            for (LicenseModel v : LicenseModel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="maintenanceWindowDetails")
        private MaintenanceWindow maintenanceWindowDetails;
        @JsonProperty(value="licenseModel")
        private LicenseModel licenseModel;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="autonomousDataStorageSizeInTBs")
        private Double autonomousDataStorageSizeInTBs;
        @JsonProperty(value="cpuCoreCountPerNode")
        private Integer cpuCoreCountPerNode;
        @JsonProperty(value="totalContainerDatabases")
        private Integer totalContainerDatabases;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder maintenanceWindowDetails(MaintenanceWindow maintenanceWindowDetails) {
            this.maintenanceWindowDetails = maintenanceWindowDetails;
            this.__explicitlySet__.add("maintenanceWindowDetails");
            return this;
        }

        public Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel = licenseModel;
            this.__explicitlySet__.add("licenseModel");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder autonomousDataStorageSizeInTBs(Double autonomousDataStorageSizeInTBs) {
            this.autonomousDataStorageSizeInTBs = autonomousDataStorageSizeInTBs;
            this.__explicitlySet__.add("autonomousDataStorageSizeInTBs");
            return this;
        }

        public Builder cpuCoreCountPerNode(Integer cpuCoreCountPerNode) {
            this.cpuCoreCountPerNode = cpuCoreCountPerNode;
            this.__explicitlySet__.add("cpuCoreCountPerNode");
            return this;
        }

        public Builder totalContainerDatabases(Integer totalContainerDatabases) {
            this.totalContainerDatabases = totalContainerDatabases;
            this.__explicitlySet__.add("totalContainerDatabases");
            return this;
        }

        public UpdateAutonomousVmClusterDetails build() {
            UpdateAutonomousVmClusterDetails model = new UpdateAutonomousVmClusterDetails(this.maintenanceWindowDetails, this.licenseModel, this.freeformTags, this.definedTags, this.autonomousDataStorageSizeInTBs, this.cpuCoreCountPerNode, this.totalContainerDatabases);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateAutonomousVmClusterDetails model) {
            if (model.wasPropertyExplicitlySet("maintenanceWindowDetails")) {
                this.maintenanceWindowDetails(model.getMaintenanceWindowDetails());
            }
            if (model.wasPropertyExplicitlySet("licenseModel")) {
                this.licenseModel(model.getLicenseModel());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("autonomousDataStorageSizeInTBs")) {
                this.autonomousDataStorageSizeInTBs(model.getAutonomousDataStorageSizeInTBs());
            }
            if (model.wasPropertyExplicitlySet("cpuCoreCountPerNode")) {
                this.cpuCoreCountPerNode(model.getCpuCoreCountPerNode());
            }
            if (model.wasPropertyExplicitlySet("totalContainerDatabases")) {
                this.totalContainerDatabases(model.getTotalContainerDatabases());
            }
            return this;
        }
    }
}

