/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SaasAdminUserConfiguration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="password")
    private final String password;
    @JsonProperty(value="secretId")
    private final String secretId;
    @JsonProperty(value="secretVersionNumber")
    private final Integer secretVersionNumber;
    @JsonProperty(value="duration")
    private final Integer duration;
    @JsonProperty(value="isEnabled")
    private final Boolean isEnabled;
    @JsonProperty(value="accessType")
    private final AccessType accessType;
    @JsonProperty(value="timeSaasAdminUserEnabled")
    private final Date timeSaasAdminUserEnabled;

    @Deprecated
    @ConstructorProperties(value={"password", "secretId", "secretVersionNumber", "duration", "isEnabled", "accessType", "timeSaasAdminUserEnabled"})
    public SaasAdminUserConfiguration(String password, String secretId, Integer secretVersionNumber, Integer duration, Boolean isEnabled, AccessType accessType, Date timeSaasAdminUserEnabled) {
        this.password = password;
        this.secretId = secretId;
        this.secretVersionNumber = secretVersionNumber;
        this.duration = duration;
        this.isEnabled = isEnabled;
        this.accessType = accessType;
        this.timeSaasAdminUserEnabled = timeSaasAdminUserEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getPassword() {
        return this.password;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public Integer getSecretVersionNumber() {
        return this.secretVersionNumber;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public Date getTimeSaasAdminUserEnabled() {
        return this.timeSaasAdminUserEnabled;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SaasAdminUserConfiguration(");
        sb.append("super=").append(super.toString());
        sb.append("password=").append(String.valueOf(this.password));
        sb.append(", secretId=").append(String.valueOf(this.secretId));
        sb.append(", secretVersionNumber=").append(String.valueOf(this.secretVersionNumber));
        sb.append(", duration=").append(String.valueOf(this.duration));
        sb.append(", isEnabled=").append(String.valueOf(this.isEnabled));
        sb.append(", accessType=").append(String.valueOf((Object)this.accessType));
        sb.append(", timeSaasAdminUserEnabled=").append(String.valueOf(this.timeSaasAdminUserEnabled));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SaasAdminUserConfiguration)) {
            return false;
        }
        SaasAdminUserConfiguration other = (SaasAdminUserConfiguration)((Object)o);
        return Objects.equals(this.password, other.password) && Objects.equals(this.secretId, other.secretId) && Objects.equals(this.secretVersionNumber, other.secretVersionNumber) && Objects.equals(this.duration, other.duration) && Objects.equals(this.isEnabled, other.isEnabled) && Objects.equals((Object)this.accessType, (Object)other.accessType) && Objects.equals(this.timeSaasAdminUserEnabled, other.timeSaasAdminUserEnabled) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.password == null ? 43 : this.password.hashCode());
        result = result * 59 + (this.secretId == null ? 43 : this.secretId.hashCode());
        result = result * 59 + (this.secretVersionNumber == null ? 43 : this.secretVersionNumber.hashCode());
        result = result * 59 + (this.duration == null ? 43 : this.duration.hashCode());
        result = result * 59 + (this.isEnabled == null ? 43 : this.isEnabled.hashCode());
        result = result * 59 + (this.accessType == null ? 43 : this.accessType.hashCode());
        result = result * 59 + (this.timeSaasAdminUserEnabled == null ? 43 : this.timeSaasAdminUserEnabled.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum AccessType implements BmcEnum
    {
        ReadOnly("READ_ONLY"),
        ReadWrite("READ_WRITE"),
        Admin("ADMIN");

        private final String value;
        private static Map<String, AccessType> map;

        private AccessType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AccessType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AccessType: " + key);
        }

        static {
            map = new HashMap<String, AccessType>();
            for (AccessType v : AccessType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="password")
        private String password;
        @JsonProperty(value="secretId")
        private String secretId;
        @JsonProperty(value="secretVersionNumber")
        private Integer secretVersionNumber;
        @JsonProperty(value="duration")
        private Integer duration;
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="accessType")
        private AccessType accessType;
        @JsonProperty(value="timeSaasAdminUserEnabled")
        private Date timeSaasAdminUserEnabled;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder password(String password) {
            this.password = password;
            this.__explicitlySet__.add("password");
            return this;
        }

        public Builder secretId(String secretId) {
            this.secretId = secretId;
            this.__explicitlySet__.add("secretId");
            return this;
        }

        public Builder secretVersionNumber(Integer secretVersionNumber) {
            this.secretVersionNumber = secretVersionNumber;
            this.__explicitlySet__.add("secretVersionNumber");
            return this;
        }

        public Builder duration(Integer duration) {
            this.duration = duration;
            this.__explicitlySet__.add("duration");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder accessType(AccessType accessType) {
            this.accessType = accessType;
            this.__explicitlySet__.add("accessType");
            return this;
        }

        public Builder timeSaasAdminUserEnabled(Date timeSaasAdminUserEnabled) {
            this.timeSaasAdminUserEnabled = timeSaasAdminUserEnabled;
            this.__explicitlySet__.add("timeSaasAdminUserEnabled");
            return this;
        }

        public SaasAdminUserConfiguration build() {
            SaasAdminUserConfiguration model = new SaasAdminUserConfiguration(this.password, this.secretId, this.secretVersionNumber, this.duration, this.isEnabled, this.accessType, this.timeSaasAdminUserEnabled);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SaasAdminUserConfiguration model) {
            if (model.wasPropertyExplicitlySet("password")) {
                this.password(model.getPassword());
            }
            if (model.wasPropertyExplicitlySet("secretId")) {
                this.secretId(model.getSecretId());
            }
            if (model.wasPropertyExplicitlySet("secretVersionNumber")) {
                this.secretVersionNumber(model.getSecretVersionNumber());
            }
            if (model.wasPropertyExplicitlySet("duration")) {
                this.duration(model.getDuration());
            }
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("accessType")) {
                this.accessType(model.getAccessType());
            }
            if (model.wasPropertyExplicitlySet("timeSaasAdminUserEnabled")) {
                this.timeSaasAdminUserEnabled(model.getTimeSaasAdminUserEnabled());
            }
            return this;
        }
    }
}

