/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DbSystemShapeSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="shapeFamily")
    private final String shapeFamily;
    @JsonProperty(value="shapeType")
    private final ShapeType shapeType;
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="availableCoreCount")
    private final Integer availableCoreCount;
    @JsonProperty(value="minimumCoreCount")
    private final Integer minimumCoreCount;
    @JsonProperty(value="coreCountIncrement")
    private final Integer coreCountIncrement;
    @JsonProperty(value="minStorageCount")
    private final Integer minStorageCount;
    @JsonProperty(value="maxStorageCount")
    private final Integer maxStorageCount;
    @JsonProperty(value="availableDataStoragePerServerInTBs")
    private final Double availableDataStoragePerServerInTBs;
    @JsonProperty(value="availableMemoryPerNodeInGBs")
    private final Integer availableMemoryPerNodeInGBs;
    @JsonProperty(value="availableDbNodePerNodeInGBs")
    private final Integer availableDbNodePerNodeInGBs;
    @JsonProperty(value="minCoreCountPerNode")
    private final Integer minCoreCountPerNode;
    @JsonProperty(value="availableMemoryInGBs")
    private final Integer availableMemoryInGBs;
    @JsonProperty(value="minMemoryPerNodeInGBs")
    private final Integer minMemoryPerNodeInGBs;
    @JsonProperty(value="availableDbNodeStorageInGBs")
    private final Integer availableDbNodeStorageInGBs;
    @JsonProperty(value="minDbNodeStoragePerNodeInGBs")
    private final Integer minDbNodeStoragePerNodeInGBs;
    @JsonProperty(value="availableDataStorageInTBs")
    private final Integer availableDataStorageInTBs;
    @JsonProperty(value="minDataStorageInTBs")
    private final Integer minDataStorageInTBs;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="computeModel")
    private final ComputeModel computeModel;
    @JsonProperty(value="areServerTypesSupported")
    private final Boolean areServerTypesSupported;
    @JsonProperty(value="minimumNodeCount")
    private final Integer minimumNodeCount;
    @JsonProperty(value="maximumNodeCount")
    private final Integer maximumNodeCount;
    @JsonProperty(value="availableCoreCountPerNode")
    private final Integer availableCoreCountPerNode;

    @Deprecated
    @ConstructorProperties(value={"name", "shapeFamily", "shapeType", "shape", "availableCoreCount", "minimumCoreCount", "coreCountIncrement", "minStorageCount", "maxStorageCount", "availableDataStoragePerServerInTBs", "availableMemoryPerNodeInGBs", "availableDbNodePerNodeInGBs", "minCoreCountPerNode", "availableMemoryInGBs", "minMemoryPerNodeInGBs", "availableDbNodeStorageInGBs", "minDbNodeStoragePerNodeInGBs", "availableDataStorageInTBs", "minDataStorageInTBs", "displayName", "computeModel", "areServerTypesSupported", "minimumNodeCount", "maximumNodeCount", "availableCoreCountPerNode"})
    public DbSystemShapeSummary(String name, String shapeFamily, ShapeType shapeType, String shape, Integer availableCoreCount, Integer minimumCoreCount, Integer coreCountIncrement, Integer minStorageCount, Integer maxStorageCount, Double availableDataStoragePerServerInTBs, Integer availableMemoryPerNodeInGBs, Integer availableDbNodePerNodeInGBs, Integer minCoreCountPerNode, Integer availableMemoryInGBs, Integer minMemoryPerNodeInGBs, Integer availableDbNodeStorageInGBs, Integer minDbNodeStoragePerNodeInGBs, Integer availableDataStorageInTBs, Integer minDataStorageInTBs, String displayName, ComputeModel computeModel, Boolean areServerTypesSupported, Integer minimumNodeCount, Integer maximumNodeCount, Integer availableCoreCountPerNode) {
        this.name = name;
        this.shapeFamily = shapeFamily;
        this.shapeType = shapeType;
        this.shape = shape;
        this.availableCoreCount = availableCoreCount;
        this.minimumCoreCount = minimumCoreCount;
        this.coreCountIncrement = coreCountIncrement;
        this.minStorageCount = minStorageCount;
        this.maxStorageCount = maxStorageCount;
        this.availableDataStoragePerServerInTBs = availableDataStoragePerServerInTBs;
        this.availableMemoryPerNodeInGBs = availableMemoryPerNodeInGBs;
        this.availableDbNodePerNodeInGBs = availableDbNodePerNodeInGBs;
        this.minCoreCountPerNode = minCoreCountPerNode;
        this.availableMemoryInGBs = availableMemoryInGBs;
        this.minMemoryPerNodeInGBs = minMemoryPerNodeInGBs;
        this.availableDbNodeStorageInGBs = availableDbNodeStorageInGBs;
        this.minDbNodeStoragePerNodeInGBs = minDbNodeStoragePerNodeInGBs;
        this.availableDataStorageInTBs = availableDataStorageInTBs;
        this.minDataStorageInTBs = minDataStorageInTBs;
        this.displayName = displayName;
        this.computeModel = computeModel;
        this.areServerTypesSupported = areServerTypesSupported;
        this.minimumNodeCount = minimumNodeCount;
        this.maximumNodeCount = maximumNodeCount;
        this.availableCoreCountPerNode = availableCoreCountPerNode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getShapeFamily() {
        return this.shapeFamily;
    }

    public ShapeType getShapeType() {
        return this.shapeType;
    }

    public String getShape() {
        return this.shape;
    }

    public Integer getAvailableCoreCount() {
        return this.availableCoreCount;
    }

    public Integer getMinimumCoreCount() {
        return this.minimumCoreCount;
    }

    public Integer getCoreCountIncrement() {
        return this.coreCountIncrement;
    }

    public Integer getMinStorageCount() {
        return this.minStorageCount;
    }

    public Integer getMaxStorageCount() {
        return this.maxStorageCount;
    }

    public Double getAvailableDataStoragePerServerInTBs() {
        return this.availableDataStoragePerServerInTBs;
    }

    public Integer getAvailableMemoryPerNodeInGBs() {
        return this.availableMemoryPerNodeInGBs;
    }

    public Integer getAvailableDbNodePerNodeInGBs() {
        return this.availableDbNodePerNodeInGBs;
    }

    public Integer getMinCoreCountPerNode() {
        return this.minCoreCountPerNode;
    }

    public Integer getAvailableMemoryInGBs() {
        return this.availableMemoryInGBs;
    }

    public Integer getMinMemoryPerNodeInGBs() {
        return this.minMemoryPerNodeInGBs;
    }

    public Integer getAvailableDbNodeStorageInGBs() {
        return this.availableDbNodeStorageInGBs;
    }

    public Integer getMinDbNodeStoragePerNodeInGBs() {
        return this.minDbNodeStoragePerNodeInGBs;
    }

    public Integer getAvailableDataStorageInTBs() {
        return this.availableDataStorageInTBs;
    }

    public Integer getMinDataStorageInTBs() {
        return this.minDataStorageInTBs;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ComputeModel getComputeModel() {
        return this.computeModel;
    }

    public Boolean getAreServerTypesSupported() {
        return this.areServerTypesSupported;
    }

    public Integer getMinimumNodeCount() {
        return this.minimumNodeCount;
    }

    public Integer getMaximumNodeCount() {
        return this.maximumNodeCount;
    }

    public Integer getAvailableCoreCountPerNode() {
        return this.availableCoreCountPerNode;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DbSystemShapeSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", shapeFamily=").append(String.valueOf(this.shapeFamily));
        sb.append(", shapeType=").append(String.valueOf((Object)this.shapeType));
        sb.append(", shape=").append(String.valueOf(this.shape));
        sb.append(", availableCoreCount=").append(String.valueOf(this.availableCoreCount));
        sb.append(", minimumCoreCount=").append(String.valueOf(this.minimumCoreCount));
        sb.append(", coreCountIncrement=").append(String.valueOf(this.coreCountIncrement));
        sb.append(", minStorageCount=").append(String.valueOf(this.minStorageCount));
        sb.append(", maxStorageCount=").append(String.valueOf(this.maxStorageCount));
        sb.append(", availableDataStoragePerServerInTBs=").append(String.valueOf(this.availableDataStoragePerServerInTBs));
        sb.append(", availableMemoryPerNodeInGBs=").append(String.valueOf(this.availableMemoryPerNodeInGBs));
        sb.append(", availableDbNodePerNodeInGBs=").append(String.valueOf(this.availableDbNodePerNodeInGBs));
        sb.append(", minCoreCountPerNode=").append(String.valueOf(this.minCoreCountPerNode));
        sb.append(", availableMemoryInGBs=").append(String.valueOf(this.availableMemoryInGBs));
        sb.append(", minMemoryPerNodeInGBs=").append(String.valueOf(this.minMemoryPerNodeInGBs));
        sb.append(", availableDbNodeStorageInGBs=").append(String.valueOf(this.availableDbNodeStorageInGBs));
        sb.append(", minDbNodeStoragePerNodeInGBs=").append(String.valueOf(this.minDbNodeStoragePerNodeInGBs));
        sb.append(", availableDataStorageInTBs=").append(String.valueOf(this.availableDataStorageInTBs));
        sb.append(", minDataStorageInTBs=").append(String.valueOf(this.minDataStorageInTBs));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", computeModel=").append(String.valueOf((Object)this.computeModel));
        sb.append(", areServerTypesSupported=").append(String.valueOf(this.areServerTypesSupported));
        sb.append(", minimumNodeCount=").append(String.valueOf(this.minimumNodeCount));
        sb.append(", maximumNodeCount=").append(String.valueOf(this.maximumNodeCount));
        sb.append(", availableCoreCountPerNode=").append(String.valueOf(this.availableCoreCountPerNode));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbSystemShapeSummary)) {
            return false;
        }
        DbSystemShapeSummary other = (DbSystemShapeSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.shapeFamily, other.shapeFamily) && Objects.equals((Object)this.shapeType, (Object)other.shapeType) && Objects.equals(this.shape, other.shape) && Objects.equals(this.availableCoreCount, other.availableCoreCount) && Objects.equals(this.minimumCoreCount, other.minimumCoreCount) && Objects.equals(this.coreCountIncrement, other.coreCountIncrement) && Objects.equals(this.minStorageCount, other.minStorageCount) && Objects.equals(this.maxStorageCount, other.maxStorageCount) && Objects.equals(this.availableDataStoragePerServerInTBs, other.availableDataStoragePerServerInTBs) && Objects.equals(this.availableMemoryPerNodeInGBs, other.availableMemoryPerNodeInGBs) && Objects.equals(this.availableDbNodePerNodeInGBs, other.availableDbNodePerNodeInGBs) && Objects.equals(this.minCoreCountPerNode, other.minCoreCountPerNode) && Objects.equals(this.availableMemoryInGBs, other.availableMemoryInGBs) && Objects.equals(this.minMemoryPerNodeInGBs, other.minMemoryPerNodeInGBs) && Objects.equals(this.availableDbNodeStorageInGBs, other.availableDbNodeStorageInGBs) && Objects.equals(this.minDbNodeStoragePerNodeInGBs, other.minDbNodeStoragePerNodeInGBs) && Objects.equals(this.availableDataStorageInTBs, other.availableDataStorageInTBs) && Objects.equals(this.minDataStorageInTBs, other.minDataStorageInTBs) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.computeModel, (Object)other.computeModel) && Objects.equals(this.areServerTypesSupported, other.areServerTypesSupported) && Objects.equals(this.minimumNodeCount, other.minimumNodeCount) && Objects.equals(this.maximumNodeCount, other.maximumNodeCount) && Objects.equals(this.availableCoreCountPerNode, other.availableCoreCountPerNode) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.shapeFamily == null ? 43 : this.shapeFamily.hashCode());
        result = result * 59 + (this.shapeType == null ? 43 : this.shapeType.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.availableCoreCount == null ? 43 : this.availableCoreCount.hashCode());
        result = result * 59 + (this.minimumCoreCount == null ? 43 : this.minimumCoreCount.hashCode());
        result = result * 59 + (this.coreCountIncrement == null ? 43 : this.coreCountIncrement.hashCode());
        result = result * 59 + (this.minStorageCount == null ? 43 : this.minStorageCount.hashCode());
        result = result * 59 + (this.maxStorageCount == null ? 43 : this.maxStorageCount.hashCode());
        result = result * 59 + (this.availableDataStoragePerServerInTBs == null ? 43 : this.availableDataStoragePerServerInTBs.hashCode());
        result = result * 59 + (this.availableMemoryPerNodeInGBs == null ? 43 : this.availableMemoryPerNodeInGBs.hashCode());
        result = result * 59 + (this.availableDbNodePerNodeInGBs == null ? 43 : this.availableDbNodePerNodeInGBs.hashCode());
        result = result * 59 + (this.minCoreCountPerNode == null ? 43 : this.minCoreCountPerNode.hashCode());
        result = result * 59 + (this.availableMemoryInGBs == null ? 43 : this.availableMemoryInGBs.hashCode());
        result = result * 59 + (this.minMemoryPerNodeInGBs == null ? 43 : this.minMemoryPerNodeInGBs.hashCode());
        result = result * 59 + (this.availableDbNodeStorageInGBs == null ? 43 : this.availableDbNodeStorageInGBs.hashCode());
        result = result * 59 + (this.minDbNodeStoragePerNodeInGBs == null ? 43 : this.minDbNodeStoragePerNodeInGBs.hashCode());
        result = result * 59 + (this.availableDataStorageInTBs == null ? 43 : this.availableDataStorageInTBs.hashCode());
        result = result * 59 + (this.minDataStorageInTBs == null ? 43 : this.minDataStorageInTBs.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.computeModel == null ? 43 : this.computeModel.hashCode());
        result = result * 59 + (this.areServerTypesSupported == null ? 43 : this.areServerTypesSupported.hashCode());
        result = result * 59 + (this.minimumNodeCount == null ? 43 : this.minimumNodeCount.hashCode());
        result = result * 59 + (this.maximumNodeCount == null ? 43 : this.maximumNodeCount.hashCode());
        result = result * 59 + (this.availableCoreCountPerNode == null ? 43 : this.availableCoreCountPerNode.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ComputeModel implements BmcEnum
    {
        Ecpu("ECPU"),
        Ocpu("OCPU"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ComputeModel> map;

        private ComputeModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ComputeModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ComputeModel', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ComputeModel.class);
            map = new HashMap<String, ComputeModel>();
            for (ComputeModel v : ComputeModel.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ShapeType implements BmcEnum
    {
        Amd("AMD"),
        Intel("INTEL"),
        IntelFlexX9("INTEL_FLEX_X9"),
        AmpereFlexA1("AMPERE_FLEX_A1"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ShapeType> map;

        private ShapeType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ShapeType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ShapeType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ShapeType.class);
            map = new HashMap<String, ShapeType>();
            for (ShapeType v : ShapeType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="shapeFamily")
        private String shapeFamily;
        @JsonProperty(value="shapeType")
        private ShapeType shapeType;
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="availableCoreCount")
        private Integer availableCoreCount;
        @JsonProperty(value="minimumCoreCount")
        private Integer minimumCoreCount;
        @JsonProperty(value="coreCountIncrement")
        private Integer coreCountIncrement;
        @JsonProperty(value="minStorageCount")
        private Integer minStorageCount;
        @JsonProperty(value="maxStorageCount")
        private Integer maxStorageCount;
        @JsonProperty(value="availableDataStoragePerServerInTBs")
        private Double availableDataStoragePerServerInTBs;
        @JsonProperty(value="availableMemoryPerNodeInGBs")
        private Integer availableMemoryPerNodeInGBs;
        @JsonProperty(value="availableDbNodePerNodeInGBs")
        private Integer availableDbNodePerNodeInGBs;
        @JsonProperty(value="minCoreCountPerNode")
        private Integer minCoreCountPerNode;
        @JsonProperty(value="availableMemoryInGBs")
        private Integer availableMemoryInGBs;
        @JsonProperty(value="minMemoryPerNodeInGBs")
        private Integer minMemoryPerNodeInGBs;
        @JsonProperty(value="availableDbNodeStorageInGBs")
        private Integer availableDbNodeStorageInGBs;
        @JsonProperty(value="minDbNodeStoragePerNodeInGBs")
        private Integer minDbNodeStoragePerNodeInGBs;
        @JsonProperty(value="availableDataStorageInTBs")
        private Integer availableDataStorageInTBs;
        @JsonProperty(value="minDataStorageInTBs")
        private Integer minDataStorageInTBs;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="computeModel")
        private ComputeModel computeModel;
        @JsonProperty(value="areServerTypesSupported")
        private Boolean areServerTypesSupported;
        @JsonProperty(value="minimumNodeCount")
        private Integer minimumNodeCount;
        @JsonProperty(value="maximumNodeCount")
        private Integer maximumNodeCount;
        @JsonProperty(value="availableCoreCountPerNode")
        private Integer availableCoreCountPerNode;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder shapeFamily(String shapeFamily) {
            this.shapeFamily = shapeFamily;
            this.__explicitlySet__.add("shapeFamily");
            return this;
        }

        public Builder shapeType(ShapeType shapeType) {
            this.shapeType = shapeType;
            this.__explicitlySet__.add("shapeType");
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder availableCoreCount(Integer availableCoreCount) {
            this.availableCoreCount = availableCoreCount;
            this.__explicitlySet__.add("availableCoreCount");
            return this;
        }

        public Builder minimumCoreCount(Integer minimumCoreCount) {
            this.minimumCoreCount = minimumCoreCount;
            this.__explicitlySet__.add("minimumCoreCount");
            return this;
        }

        public Builder coreCountIncrement(Integer coreCountIncrement) {
            this.coreCountIncrement = coreCountIncrement;
            this.__explicitlySet__.add("coreCountIncrement");
            return this;
        }

        public Builder minStorageCount(Integer minStorageCount) {
            this.minStorageCount = minStorageCount;
            this.__explicitlySet__.add("minStorageCount");
            return this;
        }

        public Builder maxStorageCount(Integer maxStorageCount) {
            this.maxStorageCount = maxStorageCount;
            this.__explicitlySet__.add("maxStorageCount");
            return this;
        }

        public Builder availableDataStoragePerServerInTBs(Double availableDataStoragePerServerInTBs) {
            this.availableDataStoragePerServerInTBs = availableDataStoragePerServerInTBs;
            this.__explicitlySet__.add("availableDataStoragePerServerInTBs");
            return this;
        }

        public Builder availableMemoryPerNodeInGBs(Integer availableMemoryPerNodeInGBs) {
            this.availableMemoryPerNodeInGBs = availableMemoryPerNodeInGBs;
            this.__explicitlySet__.add("availableMemoryPerNodeInGBs");
            return this;
        }

        public Builder availableDbNodePerNodeInGBs(Integer availableDbNodePerNodeInGBs) {
            this.availableDbNodePerNodeInGBs = availableDbNodePerNodeInGBs;
            this.__explicitlySet__.add("availableDbNodePerNodeInGBs");
            return this;
        }

        public Builder minCoreCountPerNode(Integer minCoreCountPerNode) {
            this.minCoreCountPerNode = minCoreCountPerNode;
            this.__explicitlySet__.add("minCoreCountPerNode");
            return this;
        }

        public Builder availableMemoryInGBs(Integer availableMemoryInGBs) {
            this.availableMemoryInGBs = availableMemoryInGBs;
            this.__explicitlySet__.add("availableMemoryInGBs");
            return this;
        }

        public Builder minMemoryPerNodeInGBs(Integer minMemoryPerNodeInGBs) {
            this.minMemoryPerNodeInGBs = minMemoryPerNodeInGBs;
            this.__explicitlySet__.add("minMemoryPerNodeInGBs");
            return this;
        }

        public Builder availableDbNodeStorageInGBs(Integer availableDbNodeStorageInGBs) {
            this.availableDbNodeStorageInGBs = availableDbNodeStorageInGBs;
            this.__explicitlySet__.add("availableDbNodeStorageInGBs");
            return this;
        }

        public Builder minDbNodeStoragePerNodeInGBs(Integer minDbNodeStoragePerNodeInGBs) {
            this.minDbNodeStoragePerNodeInGBs = minDbNodeStoragePerNodeInGBs;
            this.__explicitlySet__.add("minDbNodeStoragePerNodeInGBs");
            return this;
        }

        public Builder availableDataStorageInTBs(Integer availableDataStorageInTBs) {
            this.availableDataStorageInTBs = availableDataStorageInTBs;
            this.__explicitlySet__.add("availableDataStorageInTBs");
            return this;
        }

        public Builder minDataStorageInTBs(Integer minDataStorageInTBs) {
            this.minDataStorageInTBs = minDataStorageInTBs;
            this.__explicitlySet__.add("minDataStorageInTBs");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder computeModel(ComputeModel computeModel) {
            this.computeModel = computeModel;
            this.__explicitlySet__.add("computeModel");
            return this;
        }

        public Builder areServerTypesSupported(Boolean areServerTypesSupported) {
            this.areServerTypesSupported = areServerTypesSupported;
            this.__explicitlySet__.add("areServerTypesSupported");
            return this;
        }

        public Builder minimumNodeCount(Integer minimumNodeCount) {
            this.minimumNodeCount = minimumNodeCount;
            this.__explicitlySet__.add("minimumNodeCount");
            return this;
        }

        public Builder maximumNodeCount(Integer maximumNodeCount) {
            this.maximumNodeCount = maximumNodeCount;
            this.__explicitlySet__.add("maximumNodeCount");
            return this;
        }

        public Builder availableCoreCountPerNode(Integer availableCoreCountPerNode) {
            this.availableCoreCountPerNode = availableCoreCountPerNode;
            this.__explicitlySet__.add("availableCoreCountPerNode");
            return this;
        }

        public DbSystemShapeSummary build() {
            DbSystemShapeSummary model = new DbSystemShapeSummary(this.name, this.shapeFamily, this.shapeType, this.shape, this.availableCoreCount, this.minimumCoreCount, this.coreCountIncrement, this.minStorageCount, this.maxStorageCount, this.availableDataStoragePerServerInTBs, this.availableMemoryPerNodeInGBs, this.availableDbNodePerNodeInGBs, this.minCoreCountPerNode, this.availableMemoryInGBs, this.minMemoryPerNodeInGBs, this.availableDbNodeStorageInGBs, this.minDbNodeStoragePerNodeInGBs, this.availableDataStorageInTBs, this.minDataStorageInTBs, this.displayName, this.computeModel, this.areServerTypesSupported, this.minimumNodeCount, this.maximumNodeCount, this.availableCoreCountPerNode);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DbSystemShapeSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("shapeFamily")) {
                this.shapeFamily(model.getShapeFamily());
            }
            if (model.wasPropertyExplicitlySet("shapeType")) {
                this.shapeType(model.getShapeType());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("availableCoreCount")) {
                this.availableCoreCount(model.getAvailableCoreCount());
            }
            if (model.wasPropertyExplicitlySet("minimumCoreCount")) {
                this.minimumCoreCount(model.getMinimumCoreCount());
            }
            if (model.wasPropertyExplicitlySet("coreCountIncrement")) {
                this.coreCountIncrement(model.getCoreCountIncrement());
            }
            if (model.wasPropertyExplicitlySet("minStorageCount")) {
                this.minStorageCount(model.getMinStorageCount());
            }
            if (model.wasPropertyExplicitlySet("maxStorageCount")) {
                this.maxStorageCount(model.getMaxStorageCount());
            }
            if (model.wasPropertyExplicitlySet("availableDataStoragePerServerInTBs")) {
                this.availableDataStoragePerServerInTBs(model.getAvailableDataStoragePerServerInTBs());
            }
            if (model.wasPropertyExplicitlySet("availableMemoryPerNodeInGBs")) {
                this.availableMemoryPerNodeInGBs(model.getAvailableMemoryPerNodeInGBs());
            }
            if (model.wasPropertyExplicitlySet("availableDbNodePerNodeInGBs")) {
                this.availableDbNodePerNodeInGBs(model.getAvailableDbNodePerNodeInGBs());
            }
            if (model.wasPropertyExplicitlySet("minCoreCountPerNode")) {
                this.minCoreCountPerNode(model.getMinCoreCountPerNode());
            }
            if (model.wasPropertyExplicitlySet("availableMemoryInGBs")) {
                this.availableMemoryInGBs(model.getAvailableMemoryInGBs());
            }
            if (model.wasPropertyExplicitlySet("minMemoryPerNodeInGBs")) {
                this.minMemoryPerNodeInGBs(model.getMinMemoryPerNodeInGBs());
            }
            if (model.wasPropertyExplicitlySet("availableDbNodeStorageInGBs")) {
                this.availableDbNodeStorageInGBs(model.getAvailableDbNodeStorageInGBs());
            }
            if (model.wasPropertyExplicitlySet("minDbNodeStoragePerNodeInGBs")) {
                this.minDbNodeStoragePerNodeInGBs(model.getMinDbNodeStoragePerNodeInGBs());
            }
            if (model.wasPropertyExplicitlySet("availableDataStorageInTBs")) {
                this.availableDataStorageInTBs(model.getAvailableDataStorageInTBs());
            }
            if (model.wasPropertyExplicitlySet("minDataStorageInTBs")) {
                this.minDataStorageInTBs(model.getMinDataStorageInTBs());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("computeModel")) {
                this.computeModel(model.getComputeModel());
            }
            if (model.wasPropertyExplicitlySet("areServerTypesSupported")) {
                this.areServerTypesSupported(model.getAreServerTypesSupported());
            }
            if (model.wasPropertyExplicitlySet("minimumNodeCount")) {
                this.minimumNodeCount(model.getMinimumNodeCount());
            }
            if (model.wasPropertyExplicitlySet("maximumNodeCount")) {
                this.maximumNodeCount(model.getMaximumNodeCount());
            }
            if (model.wasPropertyExplicitlySet("availableCoreCountPerNode")) {
                this.availableCoreCountPerNode(model.getAvailableCoreCountPerNode());
            }
            return this;
        }
    }
}

