/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.EncryptionKeyLocationDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateStandbyDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="sourceDatabaseId")
    private final String sourceDatabaseId;
    @JsonProperty(value="databaseAdminPassword")
    private final String databaseAdminPassword;
    @JsonProperty(value="sourceTdeWalletPassword")
    private final String sourceTdeWalletPassword;
    @JsonProperty(value="sourceEncryptionKeyLocationDetails")
    private final EncryptionKeyLocationDetails sourceEncryptionKeyLocationDetails;
    @JsonProperty(value="isActiveDataGuardEnabled")
    private final Boolean isActiveDataGuardEnabled;
    @JsonProperty(value="dbUniqueName")
    private final String dbUniqueName;
    @JsonProperty(value="sidPrefix")
    private final String sidPrefix;
    @JsonProperty(value="protectionMode")
    private final ProtectionMode protectionMode;
    @JsonProperty(value="transportType")
    private final TransportType transportType;

    @Deprecated
    @ConstructorProperties(value={"sourceDatabaseId", "databaseAdminPassword", "sourceTdeWalletPassword", "sourceEncryptionKeyLocationDetails", "isActiveDataGuardEnabled", "dbUniqueName", "sidPrefix", "protectionMode", "transportType"})
    public CreateStandbyDetails(String sourceDatabaseId, String databaseAdminPassword, String sourceTdeWalletPassword, EncryptionKeyLocationDetails sourceEncryptionKeyLocationDetails, Boolean isActiveDataGuardEnabled, String dbUniqueName, String sidPrefix, ProtectionMode protectionMode, TransportType transportType) {
        this.sourceDatabaseId = sourceDatabaseId;
        this.databaseAdminPassword = databaseAdminPassword;
        this.sourceTdeWalletPassword = sourceTdeWalletPassword;
        this.sourceEncryptionKeyLocationDetails = sourceEncryptionKeyLocationDetails;
        this.isActiveDataGuardEnabled = isActiveDataGuardEnabled;
        this.dbUniqueName = dbUniqueName;
        this.sidPrefix = sidPrefix;
        this.protectionMode = protectionMode;
        this.transportType = transportType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSourceDatabaseId() {
        return this.sourceDatabaseId;
    }

    public String getDatabaseAdminPassword() {
        return this.databaseAdminPassword;
    }

    public String getSourceTdeWalletPassword() {
        return this.sourceTdeWalletPassword;
    }

    public EncryptionKeyLocationDetails getSourceEncryptionKeyLocationDetails() {
        return this.sourceEncryptionKeyLocationDetails;
    }

    public Boolean getIsActiveDataGuardEnabled() {
        return this.isActiveDataGuardEnabled;
    }

    public String getDbUniqueName() {
        return this.dbUniqueName;
    }

    public String getSidPrefix() {
        return this.sidPrefix;
    }

    public ProtectionMode getProtectionMode() {
        return this.protectionMode;
    }

    public TransportType getTransportType() {
        return this.transportType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateStandbyDetails(");
        sb.append("super=").append(super.toString());
        sb.append("sourceDatabaseId=").append(String.valueOf(this.sourceDatabaseId));
        sb.append(", databaseAdminPassword=").append("<redacted>");
        sb.append(", sourceTdeWalletPassword=").append("<redacted>");
        sb.append(", sourceEncryptionKeyLocationDetails=").append(String.valueOf((Object)this.sourceEncryptionKeyLocationDetails));
        sb.append(", isActiveDataGuardEnabled=").append(String.valueOf(this.isActiveDataGuardEnabled));
        sb.append(", dbUniqueName=").append(String.valueOf(this.dbUniqueName));
        sb.append(", sidPrefix=").append(String.valueOf(this.sidPrefix));
        sb.append(", protectionMode=").append(String.valueOf((Object)this.protectionMode));
        sb.append(", transportType=").append(String.valueOf((Object)this.transportType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateStandbyDetails)) {
            return false;
        }
        CreateStandbyDetails other = (CreateStandbyDetails)((Object)o);
        return Objects.equals(this.sourceDatabaseId, other.sourceDatabaseId) && Objects.equals(this.databaseAdminPassword, other.databaseAdminPassword) && Objects.equals(this.sourceTdeWalletPassword, other.sourceTdeWalletPassword) && Objects.equals((Object)this.sourceEncryptionKeyLocationDetails, (Object)other.sourceEncryptionKeyLocationDetails) && Objects.equals(this.isActiveDataGuardEnabled, other.isActiveDataGuardEnabled) && Objects.equals(this.dbUniqueName, other.dbUniqueName) && Objects.equals(this.sidPrefix, other.sidPrefix) && Objects.equals((Object)this.protectionMode, (Object)other.protectionMode) && Objects.equals((Object)this.transportType, (Object)other.transportType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.sourceDatabaseId == null ? 43 : this.sourceDatabaseId.hashCode());
        result = result * 59 + (this.databaseAdminPassword == null ? 43 : this.databaseAdminPassword.hashCode());
        result = result * 59 + (this.sourceTdeWalletPassword == null ? 43 : this.sourceTdeWalletPassword.hashCode());
        result = result * 59 + (this.sourceEncryptionKeyLocationDetails == null ? 43 : this.sourceEncryptionKeyLocationDetails.hashCode());
        result = result * 59 + (this.isActiveDataGuardEnabled == null ? 43 : this.isActiveDataGuardEnabled.hashCode());
        result = result * 59 + (this.dbUniqueName == null ? 43 : this.dbUniqueName.hashCode());
        result = result * 59 + (this.sidPrefix == null ? 43 : this.sidPrefix.hashCode());
        result = result * 59 + (this.protectionMode == null ? 43 : this.protectionMode.hashCode());
        result = result * 59 + (this.transportType == null ? 43 : this.transportType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum TransportType implements BmcEnum
    {
        Sync("SYNC"),
        Async("ASYNC"),
        Fastsync("FASTSYNC");

        private final String value;
        private static Map<String, TransportType> map;

        private TransportType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TransportType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid TransportType: " + key);
        }

        static {
            map = new HashMap<String, TransportType>();
            for (TransportType v : TransportType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ProtectionMode implements BmcEnum
    {
        MaximumAvailability("MAXIMUM_AVAILABILITY"),
        MaximumPerformance("MAXIMUM_PERFORMANCE"),
        MaximumProtection("MAXIMUM_PROTECTION");

        private final String value;
        private static Map<String, ProtectionMode> map;

        private ProtectionMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ProtectionMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ProtectionMode: " + key);
        }

        static {
            map = new HashMap<String, ProtectionMode>();
            for (ProtectionMode v : ProtectionMode.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="sourceDatabaseId")
        private String sourceDatabaseId;
        @JsonProperty(value="databaseAdminPassword")
        private String databaseAdminPassword;
        @JsonProperty(value="sourceTdeWalletPassword")
        private String sourceTdeWalletPassword;
        @JsonProperty(value="sourceEncryptionKeyLocationDetails")
        private EncryptionKeyLocationDetails sourceEncryptionKeyLocationDetails;
        @JsonProperty(value="isActiveDataGuardEnabled")
        private Boolean isActiveDataGuardEnabled;
        @JsonProperty(value="dbUniqueName")
        private String dbUniqueName;
        @JsonProperty(value="sidPrefix")
        private String sidPrefix;
        @JsonProperty(value="protectionMode")
        private ProtectionMode protectionMode;
        @JsonProperty(value="transportType")
        private TransportType transportType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder sourceDatabaseId(String sourceDatabaseId) {
            this.sourceDatabaseId = sourceDatabaseId;
            this.__explicitlySet__.add("sourceDatabaseId");
            return this;
        }

        public Builder databaseAdminPassword(String databaseAdminPassword) {
            this.databaseAdminPassword = databaseAdminPassword;
            this.__explicitlySet__.add("databaseAdminPassword");
            return this;
        }

        public Builder sourceTdeWalletPassword(String sourceTdeWalletPassword) {
            this.sourceTdeWalletPassword = sourceTdeWalletPassword;
            this.__explicitlySet__.add("sourceTdeWalletPassword");
            return this;
        }

        public Builder sourceEncryptionKeyLocationDetails(EncryptionKeyLocationDetails sourceEncryptionKeyLocationDetails) {
            this.sourceEncryptionKeyLocationDetails = sourceEncryptionKeyLocationDetails;
            this.__explicitlySet__.add("sourceEncryptionKeyLocationDetails");
            return this;
        }

        public Builder isActiveDataGuardEnabled(Boolean isActiveDataGuardEnabled) {
            this.isActiveDataGuardEnabled = isActiveDataGuardEnabled;
            this.__explicitlySet__.add("isActiveDataGuardEnabled");
            return this;
        }

        public Builder dbUniqueName(String dbUniqueName) {
            this.dbUniqueName = dbUniqueName;
            this.__explicitlySet__.add("dbUniqueName");
            return this;
        }

        public Builder sidPrefix(String sidPrefix) {
            this.sidPrefix = sidPrefix;
            this.__explicitlySet__.add("sidPrefix");
            return this;
        }

        public Builder protectionMode(ProtectionMode protectionMode) {
            this.protectionMode = protectionMode;
            this.__explicitlySet__.add("protectionMode");
            return this;
        }

        public Builder transportType(TransportType transportType) {
            this.transportType = transportType;
            this.__explicitlySet__.add("transportType");
            return this;
        }

        public CreateStandbyDetails build() {
            CreateStandbyDetails model = new CreateStandbyDetails(this.sourceDatabaseId, this.databaseAdminPassword, this.sourceTdeWalletPassword, this.sourceEncryptionKeyLocationDetails, this.isActiveDataGuardEnabled, this.dbUniqueName, this.sidPrefix, this.protectionMode, this.transportType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateStandbyDetails model) {
            if (model.wasPropertyExplicitlySet("sourceDatabaseId")) {
                this.sourceDatabaseId(model.getSourceDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("databaseAdminPassword")) {
                this.databaseAdminPassword(model.getDatabaseAdminPassword());
            }
            if (model.wasPropertyExplicitlySet("sourceTdeWalletPassword")) {
                this.sourceTdeWalletPassword(model.getSourceTdeWalletPassword());
            }
            if (model.wasPropertyExplicitlySet("sourceEncryptionKeyLocationDetails")) {
                this.sourceEncryptionKeyLocationDetails(model.getSourceEncryptionKeyLocationDetails());
            }
            if (model.wasPropertyExplicitlySet("isActiveDataGuardEnabled")) {
                this.isActiveDataGuardEnabled(model.getIsActiveDataGuardEnabled());
            }
            if (model.wasPropertyExplicitlySet("dbUniqueName")) {
                this.dbUniqueName(model.getDbUniqueName());
            }
            if (model.wasPropertyExplicitlySet("sidPrefix")) {
                this.sidPrefix(model.getSidPrefix());
            }
            if (model.wasPropertyExplicitlySet("protectionMode")) {
                this.protectionMode(model.getProtectionMode());
            }
            if (model.wasPropertyExplicitlySet("transportType")) {
                this.transportType(model.getTransportType());
            }
            return this;
        }
    }
}

