/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateMaintenanceRunDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="targetResourceId")
    private final String targetResourceId;
    @JsonProperty(value="isDstFileUpdateEnabled")
    private final Boolean isDstFileUpdateEnabled;
    @JsonProperty(value="timeScheduled")
    private final Date timeScheduled;
    @JsonProperty(value="patchingMode")
    private final PatchingMode patchingMode;
    @JsonProperty(value="patchType")
    private final PatchType patchType;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="databaseSoftwareImageId")
    private final String databaseSoftwareImageId;

    @Deprecated
    @ConstructorProperties(value={"targetResourceId", "isDstFileUpdateEnabled", "timeScheduled", "patchingMode", "patchType", "compartmentId", "databaseSoftwareImageId"})
    public CreateMaintenanceRunDetails(String targetResourceId, Boolean isDstFileUpdateEnabled, Date timeScheduled, PatchingMode patchingMode, PatchType patchType, String compartmentId, String databaseSoftwareImageId) {
        this.targetResourceId = targetResourceId;
        this.isDstFileUpdateEnabled = isDstFileUpdateEnabled;
        this.timeScheduled = timeScheduled;
        this.patchingMode = patchingMode;
        this.patchType = patchType;
        this.compartmentId = compartmentId;
        this.databaseSoftwareImageId = databaseSoftwareImageId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getTargetResourceId() {
        return this.targetResourceId;
    }

    public Boolean getIsDstFileUpdateEnabled() {
        return this.isDstFileUpdateEnabled;
    }

    public Date getTimeScheduled() {
        return this.timeScheduled;
    }

    public PatchingMode getPatchingMode() {
        return this.patchingMode;
    }

    public PatchType getPatchType() {
        return this.patchType;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDatabaseSoftwareImageId() {
        return this.databaseSoftwareImageId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateMaintenanceRunDetails(");
        sb.append("super=").append(super.toString());
        sb.append("targetResourceId=").append(String.valueOf(this.targetResourceId));
        sb.append(", isDstFileUpdateEnabled=").append(String.valueOf(this.isDstFileUpdateEnabled));
        sb.append(", timeScheduled=").append(String.valueOf(this.timeScheduled));
        sb.append(", patchingMode=").append(String.valueOf((Object)this.patchingMode));
        sb.append(", patchType=").append(String.valueOf((Object)this.patchType));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", databaseSoftwareImageId=").append(String.valueOf(this.databaseSoftwareImageId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateMaintenanceRunDetails)) {
            return false;
        }
        CreateMaintenanceRunDetails other = (CreateMaintenanceRunDetails)((Object)o);
        return Objects.equals(this.targetResourceId, other.targetResourceId) && Objects.equals(this.isDstFileUpdateEnabled, other.isDstFileUpdateEnabled) && Objects.equals(this.timeScheduled, other.timeScheduled) && Objects.equals((Object)this.patchingMode, (Object)other.patchingMode) && Objects.equals((Object)this.patchType, (Object)other.patchType) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.databaseSoftwareImageId, other.databaseSoftwareImageId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.targetResourceId == null ? 43 : this.targetResourceId.hashCode());
        result = result * 59 + (this.isDstFileUpdateEnabled == null ? 43 : this.isDstFileUpdateEnabled.hashCode());
        result = result * 59 + (this.timeScheduled == null ? 43 : this.timeScheduled.hashCode());
        result = result * 59 + (this.patchingMode == null ? 43 : this.patchingMode.hashCode());
        result = result * 59 + (this.patchType == null ? 43 : this.patchType.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.databaseSoftwareImageId == null ? 43 : this.databaseSoftwareImageId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum PatchType implements BmcEnum
    {
        Quarterly("QUARTERLY"),
        Timezone("TIMEZONE"),
        CustomDatabaseSoftwareImage("CUSTOM_DATABASE_SOFTWARE_IMAGE");

        private final String value;
        private static Map<String, PatchType> map;

        private PatchType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PatchType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid PatchType: " + key);
        }

        static {
            map = new HashMap<String, PatchType>();
            for (PatchType v : PatchType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum PatchingMode implements BmcEnum
    {
        Rolling("ROLLING"),
        Nonrolling("NONROLLING");

        private final String value;
        private static Map<String, PatchingMode> map;

        private PatchingMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PatchingMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid PatchingMode: " + key);
        }

        static {
            map = new HashMap<String, PatchingMode>();
            for (PatchingMode v : PatchingMode.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="targetResourceId")
        private String targetResourceId;
        @JsonProperty(value="isDstFileUpdateEnabled")
        private Boolean isDstFileUpdateEnabled;
        @JsonProperty(value="timeScheduled")
        private Date timeScheduled;
        @JsonProperty(value="patchingMode")
        private PatchingMode patchingMode;
        @JsonProperty(value="patchType")
        private PatchType patchType;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="databaseSoftwareImageId")
        private String databaseSoftwareImageId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder targetResourceId(String targetResourceId) {
            this.targetResourceId = targetResourceId;
            this.__explicitlySet__.add("targetResourceId");
            return this;
        }

        public Builder isDstFileUpdateEnabled(Boolean isDstFileUpdateEnabled) {
            this.isDstFileUpdateEnabled = isDstFileUpdateEnabled;
            this.__explicitlySet__.add("isDstFileUpdateEnabled");
            return this;
        }

        public Builder timeScheduled(Date timeScheduled) {
            this.timeScheduled = timeScheduled;
            this.__explicitlySet__.add("timeScheduled");
            return this;
        }

        public Builder patchingMode(PatchingMode patchingMode) {
            this.patchingMode = patchingMode;
            this.__explicitlySet__.add("patchingMode");
            return this;
        }

        public Builder patchType(PatchType patchType) {
            this.patchType = patchType;
            this.__explicitlySet__.add("patchType");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder databaseSoftwareImageId(String databaseSoftwareImageId) {
            this.databaseSoftwareImageId = databaseSoftwareImageId;
            this.__explicitlySet__.add("databaseSoftwareImageId");
            return this;
        }

        public CreateMaintenanceRunDetails build() {
            CreateMaintenanceRunDetails model = new CreateMaintenanceRunDetails(this.targetResourceId, this.isDstFileUpdateEnabled, this.timeScheduled, this.patchingMode, this.patchType, this.compartmentId, this.databaseSoftwareImageId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateMaintenanceRunDetails model) {
            if (model.wasPropertyExplicitlySet("targetResourceId")) {
                this.targetResourceId(model.getTargetResourceId());
            }
            if (model.wasPropertyExplicitlySet("isDstFileUpdateEnabled")) {
                this.isDstFileUpdateEnabled(model.getIsDstFileUpdateEnabled());
            }
            if (model.wasPropertyExplicitlySet("timeScheduled")) {
                this.timeScheduled(model.getTimeScheduled());
            }
            if (model.wasPropertyExplicitlySet("patchingMode")) {
                this.patchingMode(model.getPatchingMode());
            }
            if (model.wasPropertyExplicitlySet("patchType")) {
                this.patchType(model.getPatchType());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("databaseSoftwareImageId")) {
                this.databaseSoftwareImageId(model.getDatabaseSoftwareImageId());
            }
            return this;
        }
    }
}

