/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.AssociatedDatabaseDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BackupDestination
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="type")
    private final Type type;
    @JsonProperty(value="associatedDatabases")
    private final List<AssociatedDatabaseDetails> associatedDatabases;
    @JsonProperty(value="connectionString")
    private final String connectionString;
    @JsonProperty(value="vpcUsers")
    private final List<String> vpcUsers;
    @JsonProperty(value="localMountPointPath")
    private final String localMountPointPath;
    @JsonProperty(value="nfsMountType")
    private final NfsMountType nfsMountType;
    @JsonProperty(value="nfsServer")
    private final List<String> nfsServer;
    @JsonProperty(value="nfsServerExport")
    private final String nfsServerExport;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="totalStorageSizeInGBs")
    private final Integer totalStorageSizeInGBs;
    @JsonProperty(value="utilizedStorageSizeInGBs")
    private final Integer utilizedStorageSizeInGBs;
    @JsonProperty(value="timeAtWhichStorageDetailsAreUpdated")
    private final Date timeAtWhichStorageDetailsAreUpdated;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "compartmentId", "type", "associatedDatabases", "connectionString", "vpcUsers", "localMountPointPath", "nfsMountType", "nfsServer", "nfsServerExport", "lifecycleState", "timeCreated", "lifecycleDetails", "freeformTags", "definedTags", "totalStorageSizeInGBs", "utilizedStorageSizeInGBs", "timeAtWhichStorageDetailsAreUpdated"})
    public BackupDestination(String id, String displayName, String compartmentId, Type type, List<AssociatedDatabaseDetails> associatedDatabases, String connectionString, List<String> vpcUsers, String localMountPointPath, NfsMountType nfsMountType, List<String> nfsServer, String nfsServerExport, LifecycleState lifecycleState, Date timeCreated, String lifecycleDetails, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Integer totalStorageSizeInGBs, Integer utilizedStorageSizeInGBs, Date timeAtWhichStorageDetailsAreUpdated) {
        this.id = id;
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.type = type;
        this.associatedDatabases = associatedDatabases;
        this.connectionString = connectionString;
        this.vpcUsers = vpcUsers;
        this.localMountPointPath = localMountPointPath;
        this.nfsMountType = nfsMountType;
        this.nfsServer = nfsServer;
        this.nfsServerExport = nfsServerExport;
        this.lifecycleState = lifecycleState;
        this.timeCreated = timeCreated;
        this.lifecycleDetails = lifecycleDetails;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.totalStorageSizeInGBs = totalStorageSizeInGBs;
        this.utilizedStorageSizeInGBs = utilizedStorageSizeInGBs;
        this.timeAtWhichStorageDetailsAreUpdated = timeAtWhichStorageDetailsAreUpdated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Type getType() {
        return this.type;
    }

    public List<AssociatedDatabaseDetails> getAssociatedDatabases() {
        return this.associatedDatabases;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public List<String> getVpcUsers() {
        return this.vpcUsers;
    }

    public String getLocalMountPointPath() {
        return this.localMountPointPath;
    }

    public NfsMountType getNfsMountType() {
        return this.nfsMountType;
    }

    public List<String> getNfsServer() {
        return this.nfsServer;
    }

    public String getNfsServerExport() {
        return this.nfsServerExport;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Integer getTotalStorageSizeInGBs() {
        return this.totalStorageSizeInGBs;
    }

    public Integer getUtilizedStorageSizeInGBs() {
        return this.utilizedStorageSizeInGBs;
    }

    public Date getTimeAtWhichStorageDetailsAreUpdated() {
        return this.timeAtWhichStorageDetailsAreUpdated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BackupDestination(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", associatedDatabases=").append(String.valueOf(this.associatedDatabases));
        sb.append(", connectionString=").append(String.valueOf(this.connectionString));
        sb.append(", vpcUsers=").append(String.valueOf(this.vpcUsers));
        sb.append(", localMountPointPath=").append(String.valueOf(this.localMountPointPath));
        sb.append(", nfsMountType=").append(String.valueOf((Object)this.nfsMountType));
        sb.append(", nfsServer=").append(String.valueOf(this.nfsServer));
        sb.append(", nfsServerExport=").append(String.valueOf(this.nfsServerExport));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", totalStorageSizeInGBs=").append(String.valueOf(this.totalStorageSizeInGBs));
        sb.append(", utilizedStorageSizeInGBs=").append(String.valueOf(this.utilizedStorageSizeInGBs));
        sb.append(", timeAtWhichStorageDetailsAreUpdated=").append(String.valueOf(this.timeAtWhichStorageDetailsAreUpdated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BackupDestination)) {
            return false;
        }
        BackupDestination other = (BackupDestination)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.associatedDatabases, other.associatedDatabases) && Objects.equals(this.connectionString, other.connectionString) && Objects.equals(this.vpcUsers, other.vpcUsers) && Objects.equals(this.localMountPointPath, other.localMountPointPath) && Objects.equals((Object)this.nfsMountType, (Object)other.nfsMountType) && Objects.equals(this.nfsServer, other.nfsServer) && Objects.equals(this.nfsServerExport, other.nfsServerExport) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.totalStorageSizeInGBs, other.totalStorageSizeInGBs) && Objects.equals(this.utilizedStorageSizeInGBs, other.utilizedStorageSizeInGBs) && Objects.equals(this.timeAtWhichStorageDetailsAreUpdated, other.timeAtWhichStorageDetailsAreUpdated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.associatedDatabases == null ? 43 : this.associatedDatabases.hashCode());
        result = result * 59 + (this.connectionString == null ? 43 : this.connectionString.hashCode());
        result = result * 59 + (this.vpcUsers == null ? 43 : this.vpcUsers.hashCode());
        result = result * 59 + (this.localMountPointPath == null ? 43 : this.localMountPointPath.hashCode());
        result = result * 59 + (this.nfsMountType == null ? 43 : this.nfsMountType.hashCode());
        result = result * 59 + (this.nfsServer == null ? 43 : this.nfsServer.hashCode());
        result = result * 59 + (this.nfsServerExport == null ? 43 : this.nfsServerExport.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.totalStorageSizeInGBs == null ? 43 : this.totalStorageSizeInGBs.hashCode());
        result = result * 59 + (this.utilizedStorageSizeInGBs == null ? 43 : this.utilizedStorageSizeInGBs.hashCode());
        result = result * 59 + (this.timeAtWhichStorageDetailsAreUpdated == null ? 43 : this.timeAtWhichStorageDetailsAreUpdated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Active("ACTIVE"),
        Failed("FAILED"),
        Deleted("DELETED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum NfsMountType implements BmcEnum
    {
        SelfMount("SELF_MOUNT"),
        AutomatedMount("AUTOMATED_MOUNT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, NfsMountType> map;

        private NfsMountType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static NfsMountType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'NfsMountType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(NfsMountType.class);
            map = new HashMap<String, NfsMountType>();
            for (NfsMountType v : NfsMountType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Type implements BmcEnum
    {
        Nfs("NFS"),
        RecoveryAppliance("RECOVERY_APPLIANCE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="type")
        private Type type;
        @JsonProperty(value="associatedDatabases")
        private List<AssociatedDatabaseDetails> associatedDatabases;
        @JsonProperty(value="connectionString")
        private String connectionString;
        @JsonProperty(value="vpcUsers")
        private List<String> vpcUsers;
        @JsonProperty(value="localMountPointPath")
        private String localMountPointPath;
        @JsonProperty(value="nfsMountType")
        private NfsMountType nfsMountType;
        @JsonProperty(value="nfsServer")
        private List<String> nfsServer;
        @JsonProperty(value="nfsServerExport")
        private String nfsServerExport;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="totalStorageSizeInGBs")
        private Integer totalStorageSizeInGBs;
        @JsonProperty(value="utilizedStorageSizeInGBs")
        private Integer utilizedStorageSizeInGBs;
        @JsonProperty(value="timeAtWhichStorageDetailsAreUpdated")
        private Date timeAtWhichStorageDetailsAreUpdated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder associatedDatabases(List<AssociatedDatabaseDetails> associatedDatabases) {
            this.associatedDatabases = associatedDatabases;
            this.__explicitlySet__.add("associatedDatabases");
            return this;
        }

        public Builder connectionString(String connectionString) {
            this.connectionString = connectionString;
            this.__explicitlySet__.add("connectionString");
            return this;
        }

        public Builder vpcUsers(List<String> vpcUsers) {
            this.vpcUsers = vpcUsers;
            this.__explicitlySet__.add("vpcUsers");
            return this;
        }

        public Builder localMountPointPath(String localMountPointPath) {
            this.localMountPointPath = localMountPointPath;
            this.__explicitlySet__.add("localMountPointPath");
            return this;
        }

        public Builder nfsMountType(NfsMountType nfsMountType) {
            this.nfsMountType = nfsMountType;
            this.__explicitlySet__.add("nfsMountType");
            return this;
        }

        public Builder nfsServer(List<String> nfsServer) {
            this.nfsServer = nfsServer;
            this.__explicitlySet__.add("nfsServer");
            return this;
        }

        public Builder nfsServerExport(String nfsServerExport) {
            this.nfsServerExport = nfsServerExport;
            this.__explicitlySet__.add("nfsServerExport");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder totalStorageSizeInGBs(Integer totalStorageSizeInGBs) {
            this.totalStorageSizeInGBs = totalStorageSizeInGBs;
            this.__explicitlySet__.add("totalStorageSizeInGBs");
            return this;
        }

        public Builder utilizedStorageSizeInGBs(Integer utilizedStorageSizeInGBs) {
            this.utilizedStorageSizeInGBs = utilizedStorageSizeInGBs;
            this.__explicitlySet__.add("utilizedStorageSizeInGBs");
            return this;
        }

        public Builder timeAtWhichStorageDetailsAreUpdated(Date timeAtWhichStorageDetailsAreUpdated) {
            this.timeAtWhichStorageDetailsAreUpdated = timeAtWhichStorageDetailsAreUpdated;
            this.__explicitlySet__.add("timeAtWhichStorageDetailsAreUpdated");
            return this;
        }

        public BackupDestination build() {
            BackupDestination model = new BackupDestination(this.id, this.displayName, this.compartmentId, this.type, this.associatedDatabases, this.connectionString, this.vpcUsers, this.localMountPointPath, this.nfsMountType, this.nfsServer, this.nfsServerExport, this.lifecycleState, this.timeCreated, this.lifecycleDetails, this.freeformTags, this.definedTags, this.totalStorageSizeInGBs, this.utilizedStorageSizeInGBs, this.timeAtWhichStorageDetailsAreUpdated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BackupDestination model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("associatedDatabases")) {
                this.associatedDatabases(model.getAssociatedDatabases());
            }
            if (model.wasPropertyExplicitlySet("connectionString")) {
                this.connectionString(model.getConnectionString());
            }
            if (model.wasPropertyExplicitlySet("vpcUsers")) {
                this.vpcUsers(model.getVpcUsers());
            }
            if (model.wasPropertyExplicitlySet("localMountPointPath")) {
                this.localMountPointPath(model.getLocalMountPointPath());
            }
            if (model.wasPropertyExplicitlySet("nfsMountType")) {
                this.nfsMountType(model.getNfsMountType());
            }
            if (model.wasPropertyExplicitlySet("nfsServer")) {
                this.nfsServer(model.getNfsServer());
            }
            if (model.wasPropertyExplicitlySet("nfsServerExport")) {
                this.nfsServerExport(model.getNfsServerExport());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("totalStorageSizeInGBs")) {
                this.totalStorageSizeInGBs(model.getTotalStorageSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("utilizedStorageSizeInGBs")) {
                this.utilizedStorageSizeInGBs(model.getUtilizedStorageSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("timeAtWhichStorageDetailsAreUpdated")) {
                this.timeAtWhichStorageDetailsAreUpdated(model.getTimeAtWhichStorageDetailsAreUpdated());
            }
            return this;
        }
    }
}

