/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import java.util.Map;
import oracle.apexlang.core.APEXLangDataType;
import oracle.apexlang.core.APEXLangManifest;
import oracle.apexlang.core.APEXLangStringDataType;
import oracle.apexlang.core.Component;
import oracle.apexlang.core.ComponentParameter;

public class Transpiler {
    public static final String PLSQL_PLACEHOLDER_PARAMETERS = "%parameters%";
    public static final String PLSQL_PLACEHOLDER_VALUE = ":value";
    public static final String PLSQL_PLACEHOLDER_PARENT_EXTERNAL_IDENTIFICATION = ":parent_identifier";
    public static final String PLSQL_PLACEHOLDER_IS_CENTRAL = ":is_central";
    public static final String PLSQL_PLACEHOLDER_REF_APP_ID = ":ref_app_id";
    public static final String PLSQL_PLACEHOLDER_EXTERNAL_IDENTIFIER = ":external_identifier";
    public static final String PLSQL_PLACEHOLDER_API_VERSION = ":api_version";
    public static final String PLSQL_PLACEHOLDER_APEX_VERSION = ":apex_version";
    public static final String PLSQL_PLACEHOLDER_WORKSPACE_ID = ":workspace_id";
    public static final String PLSQL_PLACEHOLDER_APP_ID = ":app_id";
    public static final String PLSQL_PLACEHOLDER_DEFAULT_ID_OFFSET = ":default_id_offset";
    public static final String PLSQL_PLACEHOLDER_DEFAULT_OWNER = ":default_owner";
    public static final String PLSQL_PLACEHOLDER_CENTRAL_THEME_APP_ID = ":central_theme_app_id";
    public static final String PLSQL_PLACEHOLDER_CURRENT_THEME_ID = ":current_theme_id";
    public static final String PLSQL_PLACEHOLDER_PLUGIN_ATTR_EXPRESSION = ":plugin_attribute_expression";
    public static final String PLSQL_PLACEHOLDER_PLUGIN_ATTR_STATIC_ID = ":plugin_attribute_static_id";
    static final String COMPONENT_ID_APPLICATION = "1000";
    static final String PARAMETER_ATTRIBUTE_THEME = "263";

    public static String replaceAllSafely(String template, String regex, String replacement) {
        String rep2 = replacement.replaceAll("\\$", "\\\\\\$");
        String result = template.replaceAll(regex, rep2);
        return result;
    }

    public static String transpile(Map<Integer, Component> componentsParsed, APEXLangManifest manifest) {
        Object result = "set define off verify off feedback off\nwhenever sqlerror exit sql.sqlcode rollback\n\n";
        ComponentParameter currentThemeParameter = Transpiler.findCurrentThemeParam(componentsParsed);
        Object centralThemeAppId = "null";
        String currentThemeId = "null";
        if (currentThemeParameter != null) {
            APEXLangDataType data = currentThemeParameter.getData();
            currentThemeId = data.toString();
            for (Component component : componentsParsed.values()) {
                if (!component.getTypeId().equals("2000") || !component.getExternalIdentifier().equals(currentThemeId)) continue;
                ComponentParameter subscription = component.getParameters().get("498");
                if (subscription == null || !(subscription.getData() instanceof APEXLangStringDataType)) break;
                APEXLangStringDataType stringData = (APEXLangStringDataType)subscription.getData();
                centralThemeAppId = "'" + stringData.getRefAppId() + "'";
                break;
            }
        }
        result = (String)result + "\nbegin\n" + manifest.getImportPlSQL((String)centralThemeAppId) + "end;\n/\n";
        for (Integer currentComponentKey : componentsParsed.keySet()) {
            Component currentComponent = componentsParsed.get(currentComponentKey);
            result = (String)result + "\nbegin\n" + currentComponent.generatePlSQLCode() + "end;\n/\n";
        }
        result = (String)result + "\nbegin\n" + manifest.getEndPlSQL() + "end;\n/\n";
        result = Transpiler.replaceAllSafely((String)result, PLSQL_PLACEHOLDER_CURRENT_THEME_ID, "'" + currentThemeId + "'");
        result = (String)result + "\nset verify on feedback on define on\n";
        return result;
    }

    public static String transpile(Map<Integer, Component> componentsParsed) {
        return Transpiler.transpile(componentsParsed, new APEXLangManifest());
    }

    public static ComponentParameter findCurrentThemeParam(Map<Integer, Component> componentsParsed) {
        for (Component component : componentsParsed.values()) {
            if (!COMPONENT_ID_APPLICATION.equals(component.getTypeId())) continue;
            return component.getParameters().get(PARAMETER_ATTRIBUTE_THEME);
        }
        return null;
    }
}

