/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.apexlang.core.Component;
import oracle.apexlang.core.ComponentParameter;
import oracle.apexlang.metametadata.ComponentType;
import oracle.apexlang.metametadata.Metametadata;
import oracle.apexlang.metametadata.Plugins;
import oracle.apexlang.metametadata.Property;

public class ComponentPlugin {
    private List<CustomAttribute> customAttributes;

    public ComponentPlugin(Component plugin, ComponentType.Plugin.APIExpression apiExpression, Map<Component, List<Component>> pluginsChildren, Metametadata metametadata) {
        Plugins plugins = metametadata.getPlugins();
        if (!plugin.getTypeId().equals(plugins.getComponentTypeId())) {
            return;
        }
        List<Component> pluginChildren = pluginsChildren.get(plugin);
        this.customAttributes = pluginChildren.stream().filter(component -> component.getTypeId().equals(plugins.getCustomAttributes().getComponentTypeId())).map(customAttributeComponent -> this.createCustomAttributeFromComponent(plugins, metametadata, apiExpression, (Component)customAttributeComponent)).toList();
    }

    private CustomAttribute createCustomAttributeFromComponent(Plugins plugins, Metametadata metametadata, ComponentType.Plugin.APIExpression apiExpression, Component customAttributeComponent) {
        String propertyTypePropertyId = plugins.getCustomAttributes().getTypePropertyId();
        ComponentParameter propertyTypeParameter = customAttributeComponent.getParameters().get(propertyTypePropertyId);
        String propertyId = propertyTypeParameter != null ? propertyTypeParameter.getValue() : "TEXT";
        Plugins.Template propertyTemplate = plugins.getCustomAttributes().getTemplates().get(propertyId);
        Integer attribute = this.getAttributeValueFromComponent(customAttributeComponent, plugins);
        String name = this.getNameValueFromComponent(customAttributeComponent, propertyTemplate);
        String helpText = "";
        String groupId = this.getGroupIdValueFromComponent(customAttributeComponent, propertyTemplate);
        String groupName = metametadata.getGroups().get(groupId).getName();
        Property property = this.getPropertyValueFromComponent(customAttributeComponent, propertyTemplate, plugins, groupId);
        String staticId = this.getStaticIdValueFromComponent(customAttributeComponent, plugins);
        String attributeNo = "" + attribute;
        if (attributeNo.length() == 1) {
            attributeNo = "0" + attributeNo;
        }
        ComponentType.ApiParameter apiParameter = this.getApiParameter(staticId, attributeNo, propertyTemplate, apiExpression);
        ComponentType.ComponentProperty componentProperty = this.getComponentProperty(customAttributeComponent, propertyTemplate, groupName, apiParameter);
        return new CustomAttribute(attribute, name, helpText, groupName, property.getName(), staticId, property, componentProperty);
    }

    private ComponentType.ComponentProperty getComponentProperty(Component customAttributeComponent, Plugins.Template propertyTemplate, String groupName, ComponentType.ApiParameter apiParameter) {
        ComponentType.ComponentProperty componentProperty = new ComponentType.ComponentProperty();
        componentProperty.setIsRequired(this.isRequiredValueFromComponent(customAttributeComponent, propertyTemplate));
        componentProperty.setDefaultValue(this.getDefaultValueFromComponent(customAttributeComponent, propertyTemplate));
        componentProperty.setDependingOn(this.getDependingOnValueFromComponent(customAttributeComponent, propertyTemplate, groupName));
        componentProperty.setApiParameter(apiParameter);
        return componentProperty;
    }

    private ComponentType.DependingOn[] getDependingOnValueFromComponent(Component customAttributeComponent, Plugins.Template propertyTemplate, String groupName) {
        ArrayList<ComponentType.DependingOn> dependingOnList = new ArrayList<ComponentType.DependingOn>();
        for (Plugins.Template.ComponentProperty.ComponentPropertyDependingOn componentPropertyDependingOn : propertyTemplate.getComponentProperty().getDependingOn()) {
            ComponentParameter dependingOnPropertyId = customAttributeComponent.getParameters().get(componentPropertyDependingOn.getId().getPropertyId());
            ComponentParameter dependingOnType = customAttributeComponent.getParameters().get(componentPropertyDependingOn.getType().getPropertyId());
            ComponentParameter dependingOnValue = customAttributeComponent.getParameters().get(componentPropertyDependingOn.getValue().getPropertyId());
            ComponentParameter dependingOnValues = customAttributeComponent.getParameters().get(componentPropertyDependingOn.getValues().getPropertyId());
            ComponentParameter dependingOnHasToExist = customAttributeComponent.getParameters().get(componentPropertyDependingOn.getHasToExist().getPropertyId());
            if (dependingOnPropertyId == null) continue;
            ComponentType.DependingOn dependingOn = new ComponentType.DependingOn();
            dependingOn.setPropertyId(groupName + "#" + dependingOnPropertyId.getValue());
            if (dependingOnValue != null) {
                dependingOn.setValue(dependingOnValue.getValue());
            }
            if (dependingOnType != null) {
                dependingOn.setType(dependingOnType.getValue());
            }
            if (dependingOnValues != null) {
                String[] values = dependingOnValues.getValue().split(":");
                dependingOn.setValues(values);
            }
            if (dependingOnHasToExist != null) {
                dependingOn.setHasToExist(dependingOnHasToExist.getValue().equals("true"));
            }
            dependingOnList.add(dependingOn);
        }
        return dependingOnList.toArray(new ComponentType.DependingOn[dependingOnList.size()]);
    }

    private String getDefaultValueFromComponent(Component customAttributeComponent, Plugins.Template propertyTemplate) {
        ComponentParameter defaultValueComponentParameter = customAttributeComponent.getParameters().get(propertyTemplate.getComponentProperty().getDefaultValue().getPropertyId());
        String defaultValue = propertyTemplate.getComponentProperty().getDefaultValue().getDefaultValue();
        return defaultValueComponentParameter != null ? defaultValueComponentParameter.getValue() : defaultValue;
    }

    private Boolean isRequiredValueFromComponent(Component customAttributeComponent, Plugins.Template propertyTemplate) {
        ComponentParameter isRequiredComponentParameter = customAttributeComponent.getParameters().get(propertyTemplate.getComponentProperty().getIsRequired().getPropertyId());
        return isRequiredComponentParameter != null ? "true".equals(isRequiredComponentParameter.getValue()) : false;
    }

    private ComponentType.ApiParameter getApiParameter(String staticId, String attributeNo, Plugins.Template propertyTemplate, ComponentType.Plugin.APIExpression apiExpression) {
        String expression = apiExpression.getProperty();
        expression = expression.replace(":plugin_attribute_static_id", "'" + staticId + "'");
        expression = expression.replace(":plugin_attribute_no", attributeNo);
        ComponentType.ApiParameter apiParameter = new ComponentType.ApiParameter();
        apiParameter.setExpression(expression);
        apiParameter.setDataType(propertyTemplate.getComponentProperty().getApiParameter().getDataType());
        return apiParameter;
    }

    private Integer getAttributeValueFromComponent(Component customAttributeComponent, Plugins plugins) {
        return Integer.parseInt(customAttributeComponent.getParameters().get(plugins.getCustomAttributes().getAttributeNoPropertyId()).getValue());
    }

    private String getNameValueFromComponent(Component customAttributeComponent, Plugins.Template propertyTemplate) {
        return customAttributeComponent.getParameters().get(propertyTemplate.getProperty().getName().getPropertyId()).getValue();
    }

    private Property getPropertyValueFromComponent(Component customAttributeComponent, Plugins.Template propertyTemplate, Plugins plugins, String groupId) {
        String propertyName = customAttributeComponent.getParameters().get(plugins.getCustomAttributes().getApexLangNamePropertyId()).getValue();
        Property property = new Property();
        property.setType(propertyTemplate.getProperty().getType().getValue());
        property.setDeprecatedValues(new String[0]);
        property.setGroupId(Integer.parseInt(groupId));
        property.setName(propertyName);
        property.setInternal(false);
        return property;
    }

    private String getStaticIdValueFromComponent(Component customAttributeComponent, Plugins plugins) {
        ComponentParameter staticIdParameter = customAttributeComponent.getParameters().get(plugins.getCustomAttributes().getAttributeStaticIdPropertyId());
        String staticId = "";
        if (staticIdParameter != null) {
            staticId = staticIdParameter.getValue();
        }
        return staticId;
    }

    private String getGroupIdValueFromComponent(Component customAttributeComponent, Plugins.Template propertyTemplate) {
        ComponentParameter groupIdParameter = customAttributeComponent.getParameters().get(propertyTemplate.getProperty().getGroupId().getPropertyId());
        return groupIdParameter != null ? groupIdParameter.getValue() : propertyTemplate.getProperty().getGroupId().getDefaultValue();
    }

    public List<CustomAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    public class CustomAttribute {
        private Integer attribute;
        private String name;
        private String helpText;
        private String groupName;
        private String propertyName;
        private Property property;
        private ComponentType.ComponentProperty componentProperty;
        private String staticId;

        public CustomAttribute(Integer attribute, String name, String helpText, String groupName, String propertyName, String staticId, Property property, ComponentType.ComponentProperty componentProperty) {
            this.attribute = attribute;
            this.name = name;
            this.helpText = helpText;
            this.groupName = groupName;
            this.propertyName = propertyName;
            this.property = property;
            this.componentProperty = componentProperty;
            this.staticId = staticId;
        }

        public String getStaticId() {
            return this.staticId;
        }

        public ComponentType.ComponentProperty getComponentProperty() {
            return this.componentProperty;
        }

        public Integer getAttribute() {
            return this.attribute;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public String getHelpText() {
            return this.helpText;
        }

        public String getName() {
            return this.name;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public Property getProperty() {
            return this.property;
        }
    }
}

