/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import oracle.apexlang.core.APEXLangDataType;
import oracle.apexlang.core.Component;
import oracle.apexlang.core.Range;
import oracle.apexlang.metametadata.Property;

public class ComponentParameter {
    private Component component;
    private String expression;
    private Range range;
    private Range keyRange;
    private Range valueRange;
    private int line;
    private int column;
    private APEXLangDataType data;
    private boolean inSource;
    private boolean implicitGroup;
    private Property property;
    private Boolean pluginParameter;
    private Boolean externalIdentifier;

    public ComponentParameter(Component component, APEXLangDataType data, String expression, Integer start, Integer propNameEnd, Integer propValueStart, Integer end, int line, int column, boolean inSource, boolean implicitGroup, Property property, Boolean pluginParameter, Boolean externalIdentifier) {
        this.component = component;
        this.data = data;
        this.expression = expression;
        this.range = new Range(start, end);
        this.keyRange = new Range(start, propNameEnd);
        this.valueRange = new Range(propValueStart, end);
        this.line = line;
        this.column = column;
        this.inSource = inSource;
        this.implicitGroup = implicitGroup;
        this.property = property;
        this.pluginParameter = pluginParameter;
        this.externalIdentifier = externalIdentifier;
    }

    public Boolean isExternalIdentifier() {
        return this.externalIdentifier;
    }

    public Boolean isPluginParameter() {
        return this.pluginParameter;
    }

    public Property getProperty() {
        return this.property;
    }

    public Component getComponent() {
        return this.component;
    }

    public APEXLangDataType getData() {
        return this.data;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLine() {
        return this.line;
    }

    public String getValue() {
        return this.data.toString();
    }

    public Range getRange() {
        return this.range;
    }

    public Range getKeyRange() {
        return this.keyRange;
    }

    public Range getValueRange() {
        return this.valueRange;
    }

    public String getExpression() {
        return this.expression;
    }

    public String generatePlSQLCode() {
        String plsql = this.getExpression();
        String bindVariable = ":value";
        if (this.pluginParameter.booleanValue()) {
            bindVariable = ":plugin_attribute_expression";
        }
        plsql = this.getData().toPlSql(plsql, bindVariable);
        return plsql;
    }

    public boolean isInSource() {
        return this.inSource;
    }

    public boolean isImplicitGroup() {
        return this.implicitGroup;
    }
}

