/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.apexlang.core.ComponentGroup;
import oracle.apexlang.core.ComponentParameter;
import oracle.apexlang.core.ComponentPlugin;
import oracle.apexlang.core.PluginType;
import oracle.apexlang.core.Range;
import oracle.apexlang.core.Transpiler;

public class Component {
    private String name;
    private Map<String, ComponentParameter> componentParameters;
    private List<ComponentGroup> componentGroups;
    private String typeId;
    private String expression;
    private String parentId;
    private Integer insertOrder;
    private Range range;
    private int line;
    private int column;
    private String externalIdentifierPropertyId;
    private String filename;
    private String parentExternalIdentifier;
    private PluginType pluginType;
    private Component parent;
    private ComponentPlugin componentPlugin;

    public Component(String name, String typeId, String parentId, Integer insertOrder, String expression, Integer start, Integer stop, int line, int column, String externalIdentifierPropertyId, String filename, String parentExternalIdentifier, List<ComponentGroup> componentGroups) {
        this.typeId = typeId;
        this.componentParameters = new HashMap<String, ComponentParameter>();
        this.expression = expression;
        this.parentId = parentId;
        this.insertOrder = insertOrder;
        this.range = new Range(start, stop);
        this.line = line;
        this.column = column;
        this.externalIdentifierPropertyId = externalIdentifierPropertyId;
        this.filename = filename;
        this.parentExternalIdentifier = parentExternalIdentifier;
        this.componentGroups = componentGroups;
    }

    public String getName() {
        return this.name;
    }

    public void setComponentPlugin(ComponentPlugin componentPlugin) {
        this.componentPlugin = componentPlugin;
    }

    public ComponentPlugin getComponentPlugin() {
        return this.componentPlugin;
    }

    public PluginType getPluginType() {
        return this.pluginType;
    }

    public void setPluginType(PluginType plugin) {
        this.pluginType = plugin;
    }

    public void addParameter(String parameterId, ComponentParameter componentParameter) {
        this.componentParameters.put(parameterId, componentParameter);
    }

    public int getColumn() {
        return this.column;
    }

    public String getExternalIdentifierPropertyId() {
        return this.externalIdentifierPropertyId;
    }

    public String getExternalIdentifier() {
        ComponentParameter externalIdentifierParameter = this.componentParameters.get(this.externalIdentifierPropertyId);
        if (externalIdentifierParameter != null) {
            return externalIdentifierParameter.getValue();
        }
        return "";
    }

    public String getFilename() {
        return this.filename;
    }

    public int getLine() {
        return this.line;
    }

    public Map<String, ComponentParameter> getParameters() {
        return this.componentParameters;
    }

    public List<ComponentGroup> getComponentGroups() {
        return this.componentGroups;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String getExpression() {
        return this.expression;
    }

    public Integer getInsertOrder() {
        return this.insertOrder;
    }

    public void setParent(Component parent) {
        this.parent = parent;
    }

    public Component getParent() {
        return this.parent;
    }

    public String getParentId() {
        return this.parentId;
    }

    public Range getRange() {
        return this.range;
    }

    public String getParentExternalIdentifier() {
        return this.parentExternalIdentifier;
    }

    public String generatePlSQLCode() {
        Object plsql = "";
        ArrayList<String> parametersResult = new ArrayList<String>();
        for (String currentParameterKey : this.getParameters().keySet()) {
            String paramPLSQL;
            ComponentParameter currentParameter = this.getParameters().get(currentParameterKey);
            if (currentParameter.isPluginParameter().booleanValue() || (paramPLSQL = currentParameter.generatePlSQLCode()).length() <= 0) continue;
            parametersResult.add(paramPLSQL);
        }
        Iterator<String> parameterKeys = this.getParameters().keySet().iterator();
        ArrayList<String> pluginParametersResult = new ArrayList<String>();
        while (parameterKeys.hasNext()) {
            String paramPLSQL;
            String currentParameterKey = parameterKeys.next();
            ComponentParameter currentParameter = this.getParameters().get(currentParameterKey);
            if (!currentParameter.isPluginParameter().booleanValue() || (paramPLSQL = currentParameter.generatePlSQLCode()).length() <= 0) continue;
            pluginParametersResult.add(paramPLSQL);
        }
        String parameters = "\n" + String.join((CharSequence)", \n", parametersResult);
        if (pluginParametersResult.size() > 0) {
            String pre = "";
            String post = "";
            if (this.pluginType != null && this.pluginType.getApi() != null && this.pluginType.getApi().getExpression() != null) {
                pre = this.pluginType.getApi().getExpression().getPre() != null ? this.pluginType.getApi().getExpression().getPre() : "";
                post = this.pluginType.getApi().getExpression().getPost() != null ? this.pluginType.getApi().getExpression().getPost() : "";
            }
            parameters = parameters + ", \n" + pre + String.join((CharSequence)", \n", pluginParametersResult) + post;
        }
        Object expressionResult = this.getExpression();
        expressionResult = Transpiler.replaceAllSafely((String)expressionResult, "%parameters%", parameters);
        ComponentParameter externalIdentifier = this.getParameters().get(this.getExternalIdentifierPropertyId());
        if (externalIdentifier != null) {
            expressionResult = Transpiler.replaceAllSafely((String)expressionResult, ":external_identifier", externalIdentifier.getData().toPlSql(":value", ":value"));
        }
        if (!"".equals(this.getParentExternalIdentifier()) || this.getParentExternalIdentifier() != null) {
            expressionResult = Transpiler.replaceAllSafely((String)expressionResult, ":parent_identifier", "'" + this.getParentExternalIdentifier() + "'");
        }
        plsql = (String)plsql + String.format("%s\n\n", expressionResult);
        return plsql;
    }
}

