/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import java.util.regex.Matcher;
import oracle.apexlang.APEXLangCompiler;
import oracle.apexlang.core.APEXLangDataType;
import oracle.apexlang.core.Transpiler;

public class APEXLangStringDataType
implements APEXLangDataType {
    private String data;
    private String outputType;
    private boolean isCentral;
    private String refAppId;

    public APEXLangStringDataType(String data, String outputType) {
        this.data = data.startsWith("\"") && data.endsWith("\"") && data.length() > 1 ? data.substring(1, data.length() - 1) : data;
        this.outputType = outputType;
        this.refAppId = "";
    }

    @Override
    public String toPlSql(String template, String bindVariable) {
        String result = this.data;
        if (this.outputType != null && (this.outputType.equals("integer") || this.outputType.equals("number"))) {
            return Transpiler.replaceAllSafely(template, bindVariable, result);
        }
        Matcher m = APEXLangCompiler.MLT_REGEX.matcher(this.data);
        if (m.matches()) {
            String[] lines = m.group(2).split("\n");
            Object join = "";
            int start = 0;
            int end = lines.length - 1;
            if (lines[0].trim().isEmpty()) {
                start = 1;
            }
            if (lines[end].trim().isEmpty()) {
                --end;
            }
            if (lines.length > 0 && start <= end) {
                for (int i = start; i <= end; ++i) {
                    join = (String)join + "\n'" + lines[i].replaceAll("'", "''") + "'";
                    if (i >= end) continue;
                    join = (String)join + ",";
                }
                return Transpiler.replaceAllSafely(template, bindVariable, "wwv_flow_string.join(wwv_flow_t_varchar2(" + (String)join + "))");
            }
            return "''";
        }
        result = Transpiler.replaceAllSafely(template, bindVariable, "'" + result.replaceAll("'", "''") + "'");
        result = Transpiler.replaceAllSafely(result, ":is_central", this.isCentral ? "true" : "false");
        result = Transpiler.replaceAllSafely(result, ":ref_app_id", this.refAppId);
        return result;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setCentral(boolean isCentral) {
        this.isCentral = isCentral;
    }

    public void setRefAppId(String refAppId) {
        this.refAppId = refAppId;
    }

    public String getRefAppId() {
        return this.refAppId;
    }

    public String getData() {
        return this.data;
    }

    public String toString() {
        return this.data;
    }
}

