/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.apexlang.APEXLangCompiler;
import oracle.apexlang.FileLoader;
import oracle.apexlang.core.APEXLangCompilerContext;

public class APEXLangCentralThemeLoader {
    private static final Logger LOGGER = Logger.getLogger(APEXLangCentralThemeLoader.class.getName());
    private Map<String, APEXLangCompilerContext> centralThemes = new HashMap<String, APEXLangCompilerContext>();

    public APEXLangCentralThemeLoader(APEXLangCompiler compiler) {
        HashMap<String, HashMap<String, String>> deliveredApps = new HashMap<String, HashMap<String, String>>();
        try (InputStream input = compiler.getClass().getClassLoader().getResourceAsStream("apexlang.zip");){
            List<String> filters = Collections.singletonList("^apexlangmeta/central-themes/.*/[^/.]*[.]apx$");
            Map<String, String> allApxFilesInZip = new FileLoader().getFilesFromZipInputStream(input, filters);
            HashSet<String> paths = new HashSet<String>(allApxFilesInZip.keySet());
            for (String path : paths) {
                String[] chunks = path.split("/");
                HashMap<String, String> appMap = (HashMap<String, String>)deliveredApps.get(chunks[2]);
                if (appMap == null) {
                    appMap = new HashMap<String, String>();
                    deliveredApps.put(chunks[2], appMap);
                }
                appMap.put(path, allApxFilesInZip.remove(path));
            }
            for (String key : deliveredApps.keySet()) {
                Map fileMap = (Map)deliveredApps.get(key);
                this.centralThemes.put(key, compiler.getCompilerContext(fileMap));
            }
        }
        catch (Exception e) {
            LOGGER.warning(e.getMessage());
        }
    }

    public Map<String, APEXLangCompilerContext> getCentralThemes() {
        return this.centralThemes;
    }
}

