/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class FileLoader {
    public Map<String, String> getFilesFromZip(String zipFilePath) throws IOException {
        HashMap<String, String> fileMap = new HashMap<String, String>();
        try (ZipFile zipFile = new ZipFile(zipFilePath);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                InputStream inputStream = zipFile.getInputStream(entry);
                try {
                    String filename = entry.getName();
                    String content = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                    fileMap.put(filename, content);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        return fileMap;
    }

    public Map<String, String> getFilesFromZipInputStream(InputStream input) throws IOException {
        return this.getFilesFromZipInputStream(input, null);
    }

    public Map<String, String> getFilesFromZipInputStream(InputStream input, List<String> filters) throws IOException {
        ZipEntry entry;
        HashMap<String, String> fileMap = new HashMap<String, String>();
        ZipInputStream zis = new ZipInputStream(input);
        while ((entry = zis.getNextEntry()) != null) {
            int bytesRead;
            if (entry.isDirectory()) continue;
            String filename = entry.getName();
            if (filters != null && !filters.isEmpty() && !filters.stream().anyMatch(filter -> filename.matches((String)filter))) continue;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((bytesRead = zis.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
            String content = baos.toString("UTF-8");
            fileMap.put(filename, content);
        }
        return fileMap;
    }

    public Map<String, String> getFilesFromDirectory(String directoryPath) throws IOException {
        return this.getFilesFromDirectory(directoryPath, "");
    }

    private Map<String, String> getFilesFromDirectory(String directoryPath, String prefix) throws IOException {
        HashMap<String, String> fileMap = new HashMap<String, String>();
        try (Stream<Path> stream = Files.list(Paths.get(directoryPath, new String[0]));){
            for (Path path : stream.collect(Collectors.toList())) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    Map<String, String> subMap = this.getFilesFromDirectory(path.toString(), prefix + String.valueOf(path.getFileName()) + "/");
                    fileMap.putAll(subMap);
                    continue;
                }
                String filename = path.getFileName().toString();
                String content = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
                fileMap.put(prefix + filename, content);
            }
        }
        return fileMap;
    }

    public Map<String, String> loadAPEXLangSourceFiles(String path) throws IOException {
        Map<Object, Object> fileMap = new HashMap();
        Path sourcePath = Paths.get(path, new String[0]);
        if (Files.isDirectory(sourcePath, new LinkOption[0])) {
            fileMap = this.getFilesFromDirectory(path);
        } else if (sourcePath.toString().endsWith(".zip")) {
            fileMap = this.getFilesFromZip(path);
        }
        return fileMap;
    }
}

