/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.utility;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extension.apex.command.ApexCommand;
import oracle.dbtools.extension.apex.command.ApexOptions;
import oracle.dbtools.extension.apex.exceptions.AppNotInstalledException;
import oracle.dbtools.extension.apex.help.ApexMessages;
import oracle.dbtools.extension.apex.utility.QueryUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.IListPrinter;
import oracle.dbtools.raptor.utils.ListPrinter;

public class ApexUtil {
    public static String _version = "";
    private static IListPrinter _listPrinter = new ListPrinter();

    public static BigDecimal getBigDecimal(String name) {
        return BigDecimal.valueOf(Long.parseLong(name));
    }

    public static Boolean getBoolParm(String name) {
        return Boolean.parseBoolean(ApexUtil.getParm(name));
    }

    public static File getFile(ScriptRunnerContext ctx, String fileName, boolean create) throws IOException {
        return ApexUtil.getFile(ctx, fileName, create, false);
    }

    public static File getFile(ScriptRunnerContext ctx, String fileName, boolean create, boolean overWrite) throws IOException {
        return ApexUtil.getPath(ctx, fileName, create, overWrite).toFile();
    }

    public static String getFileString(ScriptRunnerContext ctx, String fileName, boolean create, boolean overWrite) throws IOException {
        return ApexUtil.getPath(ctx, fileName, create, overWrite).toString();
    }

    public static String getFileNameString(ScriptRunnerContext ctx, String fileName, boolean create, boolean overWrite) throws IOException {
        return ApexUtil.getPath(ctx, fileName, create, overWrite).getFileName().toString();
    }

    public static int getInt(String name) {
        return Integer.parseInt(ApexUtil.getParm(name));
    }

    public static String getParm(String name) {
        return ApexCommand.ctx.getParameterInstance().getParameterAsString("apex.parms", name);
    }

    public static Path getPath(ScriptRunnerContext ctx, String fileName, boolean create, boolean overWrite) throws IOException {
        if (fileName == null) {
            return Paths.get(ctx.prependCD(""), new String[0]);
        }
        Path out = fileName.contains(ctx.prependCD("")) ? Paths.get(fileName, new String[0]) : Paths.get(ctx.prependCD(""), fileName);
        if (!overWrite) {
            out = ApexUtil.getNextPath(fileName, out);
        }
        if (create) {
            if (out.toFile().getParentFile() != null) {
                out.toFile().getParentFile().mkdirs();
            }
            out.toFile().createNewFile();
        }
        return out;
    }

    private static Path getNextPath(String fileName, Path out) {
        String[] parts = fileName.split("\\.");
        String front = parts.length > 1 ? parts[0] : fileName;
        int i = 1;
        Object oldfront = front;
        String newfront = (String)oldfront + "_" + i;
        while (Files.exists(out, new LinkOption[0])) {
            out = Paths.get(out.toString().replace((CharSequence)oldfront, newfront), new String[0]);
            oldfront = newfront;
            newfront = front + "_" + ++i;
        }
        return out;
    }

    public static String getUser(Connection conn) {
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        HashMap binds = new HashMap();
        return dbUtil.executeReturnOneCol("select user from dual", binds);
    }

    public static boolean newApexVersion(Connection conn) throws AppNotInstalledException {
        String cleanversion;
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        String version = dbUtil.executeReturnOneCol(QueryUtils.getXMLQueries().getQuery("apex.version", conn).getSql());
        if (version == null || version.isEmpty()) {
            throw new AppNotInstalledException();
        }
        _version = cleanversion = version.replaceAll("-", "");
        Version source = new Version(cleanversion);
        return source.compareTo(new Version("19.2")) > 0;
    }

    public static String getApexSchema(Connection conn) throws SQLException {
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        HashMap binds = new HashMap();
        try (ResultSet rs = dbUtil.executeQuery(QueryUtils.getXMLQueries().getQuery("apex.version", conn).getSql(), binds);){
            rs.next();
            String string = rs.getString(2);
            return string;
        }
    }

    public static void printList(Connection conn, ScriptRunnerContext ctx, String report) {
        ApexUtil.printList(conn, ctx, report, new HashMap());
    }

    public static void printList(Connection conn, ScriptRunnerContext ctx, String report, Map<String, ?> binds) {
        Query colSQL = QueryUtils.getXMLQueries().getQuery(report, conn);
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        List rows = dbUtil.executeReturnListofList(colSQL.getSql(), binds);
        if (rows == null || rows.isEmpty() || rows.size() == 1) {
            ctx.writeln(ApexMessages.get("NO_ENTRIES"));
        } else {
            _listPrinter.printListofList(ctx, rows);
        }
    }

    public static void setListPrinter(IListPrinter listprinter) {
        _listPrinter = listprinter;
    }

    public static void writeFile(ScriptRunnerContext ctx, String fileName, String data) throws IOException {
        File file = ApexUtil.getFile(ctx, fileName, true);
        ApexUtil.writeToFile(ctx, file, data);
    }

    public static void writeToFile(File file, Reader reader) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(reader);
             BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            int numRead;
            char[] buffer = new char[8192];
            while ((numRead = bufferedReader.read(buffer)) != -1) {
                writer.write(buffer, 0, numRead);
            }
        }
    }

    public static void writeToFile(ScriptRunnerContext ctx, File file, String data) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(data);
        }
        URI path = Paths.get(ctx.prependCD(""), new String[0]).toUri();
        URI relative = path.relativize(file.toURI());
    }

    public static Throwable getRoot(Throwable throwable) {
        Throwable rootCause;
        Objects.requireNonNull(throwable);
        for (rootCause = throwable; rootCause.getCause() != null && rootCause.getCause() != rootCause; rootCause = rootCause.getCause()) {
        }
        return rootCause;
    }

    public static boolean isDebug(ScriptRunnerContext ctx) {
        return ctx.getParameterInstance().getParameterAsBoolean("apex.parms", ApexOptions.Symbol.DEBUG.toString());
    }
}

