/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.utility;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import oracle.apexlang.APEXLangCompiler;
import oracle.dbtools.extension.apex.help.ApexMessages;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.InvalidParameterException;

public class APEXLangUtils {
    public static boolean isDirectory(Path filepath) {
        return Files.isDirectory(filepath, new LinkOption[0]);
    }

    public static boolean isZip(Path filepath) {
        return filepath.toString().endsWith(".zip");
    }

    public static boolean isAPEXLangFile(Path filepath) {
        for (String fileExtension : APEXLangCompiler.APEX_EXTENSIONS) {
            if (!filepath.toString().endsWith(fileExtension)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDirectoryOrZip(Path filepath) {
        return APEXLangUtils.isDirectory(filepath) || APEXLangUtils.isZip(filepath);
    }

    public static String getTranspileOutputFileName(Path filepath) {
        Object outputFileName = "output.sql";
        if (APEXLangUtils.isAPEXLangFile(filepath)) {
            outputFileName = filepath.getFileName().toString().replace(".apx", ".sql");
        } else if (APEXLangUtils.isZip(filepath)) {
            outputFileName = filepath.getFileName().toString().replace(".zip", ".sql");
        } else if (APEXLangUtils.isDirectory(filepath)) {
            outputFileName = String.valueOf(filepath.getFileName()) + ".sql";
        }
        return outputFileName;
    }

    public static Path resolveRelativePathOption(String pathStr, String cwd) throws InvalidParameterException {
        if (pathStr == null) {
            return null;
        }
        Path path = Paths.get(pathStr, new String[0]);
        if (path.isAbsolute()) {
            return path;
        }
        if (cwd != null) {
            return Paths.get(cwd, new String[0]).resolve(path);
        }
        throw new InvalidParameterException(ApexMessages.getString("CWD_ERROR"));
    }

    public static boolean directoryContainsManifestOrAPEXlang(Path dir) throws InvalidParameterException, IOException {
        if (APEXLangUtils.isDirectory(dir)) {
            if (Files.exists(dir.resolve(APEXLangCompiler.MANIFEST_FILENAME), new LinkOption[0])) {
                return true;
            }
            try (Stream<Path> stream = Files.list(dir);){
                List results = stream.filter(file -> APEXLangUtils.isAPEXLangFile(file)).collect(Collectors.toList());
                boolean bl = results.size() > 0;
                return bl;
            }
        }
        throw new InvalidParameterException(ApexMessages.getString("DIRECTORY_PATH_ERROR"));
    }
}

