/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.command;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.extension.apex.command.ApexOptions;
import oracle.dbtools.extension.apex.command.MutableCommand;
import oracle.dbtools.extension.apex.core.APEXExport;
import oracle.dbtools.extension.apex.core.APEXLangHandler;
import oracle.dbtools.extension.apex.exceptions.AppNotInstalledException;
import oracle.dbtools.extension.apex.exceptions.InvalidApexExportException;
import oracle.dbtools.extension.apex.exceptions.OutputBufferNotInitialized;
import oracle.dbtools.extension.apex.help.ApexMessages;
import oracle.dbtools.extension.apex.utility.ApexUtil;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Connected;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.InvalidParameterException;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPages;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPagesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.CommandPageAssemblers;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parser;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;

public class ApexCommand
extends CommandListener
implements IHelp,
SQLCLService,
Connected {
    public static ScriptRunnerContext ctx;

    public static String exceptionToString(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print(e.getMessage() + "\r\n");
        while (null != e.getCause()) {
            e = (Exception)e.getCause();
            pw.print(e.getMessage() + "\r\n");
        }
        pw.flush();
        return sw.toString();
    }

    private static APEXExport getApexExporter(Connection conn, ScriptRunnerContext ctx, MutableCommand command) throws InvalidParameterException, AppNotInstalledException {
        APEXExport apexExport = new APEXExport(command);
        apexExport.setCtx(ctx);
        apexExport.setConnection(conn);
        apexExport.setOutStream((OutputStream)ctx.getOutputStream());
        return apexExport;
    }

    private static APEXLangHandler getAPEXLangHandler(Connection conn, ScriptRunnerContext ctx, MutableCommand command) {
        APEXLangHandler apexLangCommandHandler = new APEXLangHandler(command);
        apexLangCommandHandler.setCtx(ctx);
        apexLangCommandHandler.setConnection(conn);
        apexLangCommandHandler.setOutStream((OutputStream)ctx.getOutputStream());
        return apexLangCommandHandler;
    }

    public Type getParserType() {
        return ApexOptions.commandType;
    }

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public String getCommand() {
        return "APEX";
    }

    public Class<? extends CommandListener> getCommandListener() {
        return ((Object)((Object)this)).getClass();
    }

    public String getExtensionDescription() {
        return ApexMessages.getString("EXT_DESC");
    }

    public String getExtensionName() {
        return "APEX";
    }

    public String getExtensionVersion() {
        return ApexMessages.getString("SQLclVersion.VERSION");
    }

    public Optional<String> getHelp(ScriptRunnerContext ctx, String pagePath) {
        return this.createHelpPages(ctx).get(pagePath);
    }

    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ApexCommand.ctx = ctx;
        if (!cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("apex") && !cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("ax")) {
            return false;
        }
        System.setProperty("user.dir", ctx.prependCD(""));
        try {
            Parser parser = new Parser(ApexOptions.commandType, ctx.getEnvironment());
            Optional optParsedCommand = parser.parse(cmd.getSql(), error -> ctx.write(error + "\n"));
            if (optParsedCommand.isEmpty()) {
                return true;
            }
            MutableCommand parsedCommand = new MutableCommand((ParsedCommand)optParsedCommand.get());
            Id command = parsedCommand.getType().getId();
            if (ApexOptions.Symbol.VALIDATE != command) {
                if (null == conn) {
                    ctx.write(ApexMessages.getString("NOT_CONNECTED"));
                    ctx.errorLog(ctx.getSourceRef(), ApexMessages.getString("NOT_CONNECTED"), cmd.getSql());
                    return true;
                }
                try {
                    ApexUtil.newApexVersion(conn);
                }
                catch (AppNotInstalledException e) {
                    ctx.write(ApexMessages.getString("NOT_INSTALLED") + "\n");
                    return true;
                }
            }
            APEXExport apexExport = ApexCommand.getApexExporter(conn, ctx, parsedCommand);
            APEXLangHandler apexLangHandler = ApexCommand.getAPEXLangHandler(conn, ctx, parsedCommand);
            if (ApexOptions.Symbol.LIST == command) {
                apexExport.list();
                ctx.write(System.lineSeparator());
            } else if (ApexOptions.Symbol.LOG == command) {
                String report = "apex.log";
                ApexUtil.printList(conn, ctx, "apex.log");
                ctx.write(System.lineSeparator());
            } else if (ApexOptions.Symbol.EXPORT == command) {
                apexExport.doCapture();
                ctx.write(System.lineSeparator());
            } else if (ApexOptions.Symbol.EXPORT_FEEDBACK == command) {
                apexExport.exportFeedback();
                ctx.write(System.lineSeparator());
            } else if (ApexOptions.Symbol.EXPORT_WORKSPACE == command) {
                apexExport.exportWorkspace();
                ctx.write(System.lineSeparator());
            } else if (ApexOptions.Symbol.EXPORT_ALL_WORKSPACES == command) {
                apexExport.exportAllWorkspaces();
                ctx.write(System.lineSeparator());
            } else if (ApexOptions.Symbol.EXPORT_STATIC_FILES == command) {
                apexExport.exportStaticFiles();
                ctx.write(System.lineSeparator());
            } else if (ApexOptions.Symbol.EXPORT_APPLICATION == command) {
                apexExport.exportApplication(false);
                ctx.write(System.lineSeparator());
            } else if (ApexOptions.Symbol.EXPORT_INSTANCE == command) {
                apexExport.exportInstance();
                ctx.write(System.lineSeparator());
            } else if (ApexOptions.Symbol.EXPORT_COMPONENTS == command) {
                apexExport.exportComponents();
                ctx.write(System.lineSeparator());
            } else if (ApexOptions.Symbol.EXPORT_ALL_APPLICATIONS == command) {
                apexExport.exportAllApplications();
                ctx.write(System.lineSeparator());
            } else if (ApexOptions.Symbol.VERSION == command) {
                ctx.writeln(ApexMessages.format("VERSION_MSG", ApexUtil._version));
            } else if (ApexOptions.Symbol.VALIDATE == command) {
                apexLangHandler.Validate();
                ctx.write(System.lineSeparator());
            } else if (ApexOptions.Symbol.IMPORT == command) {
                apexLangHandler.Import();
                ctx.write(System.lineSeparator());
            } else {
                ctx.write(this.getHelp(ctx, "APEX").orElse("") + "\n");
            }
            if (ctx.getParameterInstance().getParameterAsBoolean("apex.parms", "exitwhendone").booleanValue()) {
                System.exit(0);
            }
            return true;
        }
        catch (IOException | SQLException | AppNotInstalledException | InvalidApexExportException | OutputBufferNotInitialized | InvalidParameterException e) {
            if (ApexUtil.isDebug(ctx)) {
                ctx.write("PARMS---------------------------------------------------");
                ctx.getParameterInstance().printParametersAsTable("apex.parms");
                ctx.write("ERROR---------------------------------------------------");
                ctx.write(Throwables.getStackTraceAsString((Throwable)e));
            }
            ctx.writeln(e.getMessage());
            if (ctx.getParameterInstance().getParameterAsBoolean("apex.parms", "exitwhendone").booleanValue()) {
                System.exit(0);
            }
            return true;
        }
    }

    public boolean isSqlPlus() {
        return false;
    }

    public boolean needsConnection() {
        return true;
    }

    private HelpPages createHelpPages(ScriptRunnerContext ctx) {
        return new HelpPagesBuilder(ctx.getEnvironment()).alphaSort().enableColorCode(ctx.isCommandLine()).addHelpContainerFor((Object)this).addPages((Iterable)new CommandPageAssemblers(ApexOptions.commandType, new Type[0])).build();
    }
}

