/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.nio2.Nio2CompletionHandler;
import org.apache.sshd.common.io.nio2.Nio2Service;
import org.apache.sshd.common.io.nio2.Nio2ServiceFactory;
import org.apache.sshd.common.io.nio2.Nio2Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.core.CoreModuleProperties;

public class Nio2Acceptor
extends Nio2Service
implements IoAcceptor {
    protected final Map<SocketAddress, AsynchronousServerSocketChannel> channels = new ConcurrentHashMap<SocketAddress, AsynchronousServerSocketChannel>();
    private final Nio2ServiceFactory nio2ServiceFactory;
    private int backlog;

    public Nio2Acceptor(Nio2ServiceFactory nio2ServiceFactory, PropertyResolver propertyResolver, IoHandler handler, AsynchronousChannelGroup group, ExecutorService resumeTasks) {
        super(propertyResolver, handler, group, resumeTasks);
        this.nio2ServiceFactory = nio2ServiceFactory;
        this.backlog = CoreModuleProperties.SOCKET_BACKLOG.getRequired(propertyResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(Collection<? extends SocketAddress> addresses) throws IOException {
        if (GenericUtils.isEmpty(addresses)) {
            return;
        }
        AsynchronousChannelGroup group = this.getChannelGroup();
        ArrayList<java.io.Closeable> bound = new ArrayList<java.io.Closeable>(addresses.size());
        try {
            boolean debugEnabled = this.log.isDebugEnabled();
            for (SocketAddress socketAddress : addresses) {
                if (debugEnabled) {
                    this.log.debug("bind({}) binding to address", (Object)socketAddress);
                }
                try {
                    AsynchronousServerSocketChannel prev;
                    AsynchronousServerSocketChannel asyncChannel = this.openAsynchronousServerSocketChannel(socketAddress, group);
                    java.io.Closeable protector = this.protectInProgressBinding(socketAddress, asyncChannel);
                    bound.add(protector);
                    AsynchronousServerSocketChannel socket = this.setSocketOptions(asyncChannel);
                    socket.bind(socketAddress, this.backlog);
                    SocketAddress local = socket.getLocalAddress();
                    if (debugEnabled) {
                        this.log.debug("bind({}) bound to {}", (Object)socketAddress, (Object)local);
                    }
                    if ((prev = this.channels.put(local, socket)) != null && debugEnabled) {
                        this.log.debug("bind({}) replaced previous channel ({}) for {}", new Object[]{socketAddress, prev.getLocalAddress(), local});
                    }
                    CompletionHandler<AsynchronousSocketChannel, ? super SocketAddress> handler = ValidateUtils.checkNotNull(this.createSocketCompletionHandler(this.channels, socket), "No completion handler created for address=%s[%s]", socketAddress, local);
                    socket.accept(local, handler);
                }
                catch (IOException | RuntimeException e) {
                    this.error("bind({}) - failed ({}) to bind: {}", socketAddress, e.getClass().getSimpleName(), e.getMessage(), e);
                    throw e;
                }
            }
            bound.clear();
        }
        finally {
            IOException err = IoUtils.closeQuietly(bound);
            if (err != null) {
                throw err;
            }
        }
    }

    protected java.io.Closeable protectInProgressBinding(final SocketAddress address, final AsynchronousServerSocketChannel asyncChannel) {
        final boolean debugEnabled = this.log.isDebugEnabled();
        return new java.io.Closeable(){
            final /* synthetic */ Nio2Acceptor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void close() throws IOException {
                block8: {
                    try {
                        try {
                            SocketAddress local = asyncChannel.getLocalAddress();
                            if (local != null) {
                                if (debugEnabled) {
                                    this.this$0.log.debug("protectInProgressBinding({}) remove {} binding", (Object)address, (Object)local);
                                }
                                this.this$0.channels.remove(local);
                            }
                        }
                        finally {
                            if (debugEnabled) {
                                this.this$0.log.debug("protectInProgressBinding({}) auto-close", (Object)address);
                            }
                            asyncChannel.close();
                        }
                    }
                    catch (ClosedChannelException e) {
                        if (!debugEnabled) break block8;
                        this.this$0.log.debug("protectInProgressBinding(" + address + ") ignore close channel exception", (Throwable)e);
                    }
                }
            }

            public String toString() {
                return "protectInProgressBinding(" + address + ")";
            }
        };
    }

    protected AsynchronousServerSocketChannel openAsynchronousServerSocketChannel(SocketAddress address, AsynchronousChannelGroup group) throws IOException {
        return AsynchronousServerSocketChannel.open(group);
    }

    protected CompletionHandler<AsynchronousSocketChannel, ? super SocketAddress> createSocketCompletionHandler(Map<SocketAddress, AsynchronousServerSocketChannel> channelsMap, AsynchronousServerSocketChannel socket) throws IOException {
        return new AcceptCompletionHandler(socket);
    }

    @Override
    public void bind(SocketAddress address) throws IOException {
        this.bind(Collections.singleton(address));
    }

    @Override
    public void unbind() {
        Set<SocketAddress> addresses = this.getBoundAddresses();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Unbinding {}", addresses);
        }
        this.unbind(addresses);
    }

    @Override
    public void unbind(Collection<? extends SocketAddress> addresses) {
        boolean traceEnabled = this.log.isTraceEnabled();
        for (SocketAddress socketAddress : addresses) {
            AsynchronousServerSocketChannel channel = this.channels.remove(socketAddress);
            if (channel != null) {
                try {
                    if (traceEnabled) {
                        this.log.trace("unbind({})", (Object)socketAddress);
                    }
                    channel.close();
                }
                catch (IOException e) {
                    this.warn("unbind({}) {} while unbinding channel: {}", socketAddress, e.getClass().getSimpleName(), e.getMessage(), e);
                }
                continue;
            }
            if (!traceEnabled) continue;
            this.log.trace("No active channel to unbind for {}", (Object)socketAddress);
        }
    }

    @Override
    public void unbind(SocketAddress address) {
        this.unbind(Collections.singleton(address));
    }

    @Override
    public Set<SocketAddress> getBoundAddresses() {
        return new HashSet<SocketAddress>(this.channels.keySet());
    }

    @Override
    protected void preClose() {
        this.unbind();
        super.preClose();
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().close(super.getInnerCloseable()).run(this.toString(), this::closeImmediately0).build();
    }

    protected void closeImmediately0() {
        Set<SocketAddress> boundAddresses = this.getBoundAddresses();
        boolean debugEnabled = this.log.isDebugEnabled();
        for (SocketAddress address : boundAddresses) {
            AsynchronousServerSocketChannel asyncChannel = this.channels.remove(address);
            if (asyncChannel == null) continue;
            try {
                asyncChannel.close();
                if (!debugEnabled) continue;
                this.log.debug("doCloseImmediately({}) closed channel", (Object)address);
            }
            catch (IOException e) {
                if (!debugEnabled) continue;
                this.log.debug("Exception caught while closing channel of " + address, (Throwable)e);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getBoundAddresses() + "]";
    }

    protected class AcceptCompletionHandler
    extends Nio2CompletionHandler<AsynchronousSocketChannel, SocketAddress> {
        protected final AsynchronousServerSocketChannel socket;

        AcceptCompletionHandler(AsynchronousServerSocketChannel socket) {
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onCompleted(AsynchronousSocketChannel result, SocketAddress address) {
            boolean keepAccepting;
            if (!Nio2Acceptor.this.channels.containsKey(address)) {
                if (Nio2Acceptor.this.log.isDebugEnabled()) {
                    Nio2Acceptor.this.log.debug("onCompleted({}) unbound address", (Object)address);
                }
                return;
            }
            Closeable session = null;
            Long sessionId = null;
            IoServiceEventListener listener = Nio2Acceptor.this.getIoServiceEventListener();
            try {
                if (listener != null) {
                    SocketAddress localAddress = result.getLocalAddress();
                    SocketAddress remoteAddress = result.getRemoteAddress();
                    listener.connectionAccepted(Nio2Acceptor.this, localAddress, remoteAddress, address);
                }
                IoHandler handler = Nio2Acceptor.this.getIoHandler();
                Nio2Acceptor.this.setSocketOptions(result);
                session = Objects.requireNonNull(this.createSession(Nio2Acceptor.this, address, result, handler), "No NIO2 session created");
                sessionId = ((Nio2Session)session).getId();
                handler.sessionCreated((IoSession)session);
                Nio2Acceptor.this.sessions.put(sessionId, session);
                if (((AbstractCloseable)session).isClosing()) {
                    try {
                        handler.sessionClosed((IoSession)session);
                    }
                    finally {
                        Nio2Acceptor.this.unmapSession(sessionId);
                    }
                } else {
                    ((Nio2Session)session).startReading();
                }
                keepAccepting = true;
            }
            catch (Throwable exc) {
                block20: {
                    if (listener != null) {
                        try {
                            SocketAddress localAddress = result.getLocalAddress();
                            SocketAddress remoteAddress = result.getRemoteAddress();
                            listener.abortAcceptedConnection(Nio2Acceptor.this, localAddress, remoteAddress, address, exc);
                        }
                        catch (Exception e) {
                            if (!Nio2Acceptor.this.log.isDebugEnabled()) break block20;
                            Nio2Acceptor.this.log.debug("onCompleted(" + address + ") listener=" + listener + " ignoring abort event exception", (Throwable)e);
                        }
                    }
                }
                keepAccepting = this.okToReaccept(exc, address);
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable t) {
                        Nio2Acceptor.this.log.warn("onCompleted(" + address + ") Failed (" + t.getClass().getSimpleName() + ") to close accepted connection from " + address + ": " + t.getMessage(), t);
                    }
                }
                Nio2Acceptor.this.unmapSession(sessionId);
            }
            if (keepAccepting) {
                try {
                    this.socket.accept(address, this);
                }
                catch (Throwable exc) {
                    this.failed(exc, address);
                }
            } else {
                Nio2Acceptor.this.log.error("=====> onCompleted({}) no longer accepting incoming connections <====", (Object)address);
            }
        }

        protected Nio2Session createSession(Nio2Acceptor acceptor, SocketAddress address, AsynchronousSocketChannel channel, IoHandler handler) throws Throwable {
            if (Nio2Acceptor.this.log.isTraceEnabled()) {
                Nio2Acceptor.this.log.trace("createNio2Session({}) address={}", (Object)acceptor, (Object)address);
            }
            return Nio2Acceptor.this.nio2ServiceFactory.createSession(acceptor, handler, channel, address);
        }

        @Override
        protected void onFailed(Throwable exc, SocketAddress address) {
            if (this.okToReaccept(exc, address)) {
                try {
                    this.socket.accept(address, this);
                }
                catch (Throwable t) {
                    Nio2Acceptor.this.log.error("Failed (" + t.getClass().getSimpleName() + " to re-accept new connections on " + address + ": " + t.getMessage(), t);
                }
            }
        }

        protected boolean okToReaccept(Throwable exc, SocketAddress address) {
            AsynchronousServerSocketChannel channel = Nio2Acceptor.this.channels.get(address);
            boolean debugEnabled = Nio2Acceptor.this.log.isDebugEnabled();
            if (channel == null) {
                if (debugEnabled) {
                    Nio2Acceptor.this.log.debug("Caught {} for untracked channel of {}: {}", new Object[]{exc.getClass().getSimpleName(), address, exc.getMessage()});
                }
                return false;
            }
            if (Nio2Acceptor.this.disposing.get()) {
                if (debugEnabled) {
                    Nio2Acceptor.this.log.debug("Caught {} for tracked channel of {} while disposing: {}", new Object[]{exc.getClass().getSimpleName(), address, exc.getMessage()});
                }
                return false;
            }
            if (!channel.isOpen()) {
                if (debugEnabled) {
                    Nio2Acceptor.this.log.debug("Channel is not open ({}), stopping acceptor for {}; msg={}", new Object[]{exc.getClass().getSimpleName(), address, exc.getMessage()});
                }
                return false;
            }
            Nio2Acceptor.this.debug("Caught {} while accepting incoming connection from {}: {}", exc.getClass().getSimpleName(), address, exc.getMessage(), exc);
            return true;
        }
    }
}

