/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci.search;

import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.resourcesearch.ResourceSearchClient;
import com.oracle.bmc.resourcesearch.model.SearchDetails;
import com.oracle.bmc.resourcesearch.model.StructuredSearchDetails;
import com.oracle.bmc.resourcesearch.requests.SearchResourcesRequest;
import com.oracle.bmc.resourcesearch.responses.SearchResourcesResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import oracle.dbtools.core.oci.OCIClient;
import oracle.dbtools.core.oci.OCIProfile;
import oracle.dbtools.core.oci.search.ResourceQuery;
import oracle.dbtools.core.oci.search.SearchResult;

public class OCISearchClient
extends OCIClient {
    private final ResourceSearchClient searchClient = (ResourceSearchClient)this.createClient(ResourceSearchClient.builder());

    public static Builder builder(OCIProfile profile) {
        return new Builder(profile);
    }

    public static OCISearchClient of(OCIProfile profile, String regionName) {
        Builder builder = OCISearchClient.builder(profile);
        if (regionName != null) {
            builder.region(regionName);
        }
        return builder.build();
    }

    private OCISearchClient(Builder builder) {
        super(builder);
    }

    public Collection<SearchResult> listResources(ResourceQuery query) {
        SearchResourcesResponse response;
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        StructuredSearchDetails searchDetails = StructuredSearchDetails.builder().matchingContextType(SearchDetails.MatchingContextType.None).query(query.getQuery()).build();
        SearchResourcesRequest request = SearchResourcesRequest.builder().searchDetails((SearchDetails)searchDetails).build();
        try {
            response = this.searchClient.searchResources(request);
        }
        catch (BmcException be) {
            throw OCISearchClient.wrap(be);
        }
        List items = response.getResourceSummaryCollection().getItems();
        results.addAll(items.stream().flatMap(p -> Stream.of(SearchResult.builder(p).build())).collect(Collectors.toList()));
        return results;
    }

    public static final class Builder
    extends OCIClient.Builder<Builder, OCISearchClient> {
        private Builder(OCIProfile profile) {
            super(profile);
        }

        @Override
        public OCISearchClient build() {
            return new OCISearchClient(this);
        }
    }
}

